
var Canvas = {
	_init:function(){
		var objCanvas = document.getElementById('canvas');
		musica = document.createElement('audio');		
		contexto = objCanvas.getContext("2d");
		if (Configuracion.njugadores==1){
			canvas.width  = window.innerWidth*0.8;
			$("#fonCanvas1").css("width","80%");
			$("#fonCanvas1").css("left","10%");
			$("#fonCanvas1").css("border","4px solid black");
			$("#gandalf").css("width","80%");
			$("#gandalf").css("left","10%");
			$("#gandalf").css("border","4px solid black");
			$("#canvas").css("left","10%");
		}else{
			canvas.width  = window.innerWidth*0.5;
		}
		canvas.height = window.innerHeight*0.80;
		Canvas.maxWidth = parseInt(objCanvas.width);
		Canvas.maxHeight = parseInt(objCanvas.height);		
		Canvas.mitad_x = parseInt(Canvas.maxWidth/2);
		Canvas.decimo_x = Configuracion.perspectiva ? parseInt(Canvas.maxWidth/10) :  parseInt(Canvas.maxWidth/8)  ;
		Canvas._rellenar();
	},
	_saxo:function(){
		contexto.fillStyle   = '#ecc85e';
		contexto.globalAlpha = 0.2; 
		contexto.beginPath();
		var padding_saxo = parseInt(  (Canvas.decimo_x *3) );
		var padding_saxo_bottom = Configuracion.perspectiva ? Configuracion.perspectivaDiferencia * 4 : 0;
		
		contexto.moveTo(Canvas.mitad_x - padding_saxo, 0);
		contexto.lineTo(Canvas.mitad_x + padding_saxo, 0);
		contexto.lineTo(Canvas.mitad_x + padding_saxo + padding_saxo_bottom, Canvas.maxHeight);
		contexto.lineTo(Canvas.mitad_x - padding_saxo - padding_saxo_bottom, Canvas.maxHeight);
		contexto.lineTo(Canvas.mitad_x - padding_saxo, 10);
		contexto.fill();
		contexto.closePath();
		contexto.globalAlpha = 1; 		
	},
	_rellenarLineas:function(){
		contexto.strokeStyle = '#000';			
		contexto.lineWidth = Configuracion.larguraLinea;		
		for(i=-2;i<=2;i++){
			x_linea_inicio = Canvas.mitad_x + ((i)*Canvas.decimo_x);			
			x_linea_fin = Configuracion.perspectiva ? x_linea_inicio + (i * Configuracion.perspectivaDiferencia) : x_linea_inicio;			
			contexto.beginPath();
			contexto.moveTo(x_linea_inicio, 0);
			contexto.lineTo(x_linea_fin, Canvas.maxHeight);
			contexto.stroke();
			contexto.closePath();			
		}	
	},
	_rellenarNotasEstaticas:function(){
		for(i=0;i<=4;i++){		
			var teclaPulsada = false;
			if(Juego.proximaNota.tempo>0){
				if(Juego.proximaNota.cores[i]) teclaPulsada = true;
			}
			var posicion_x = (i - 2) * Canvas.decimo_x + Canvas.mitad_x;
			if(Configuracion.perspectiva) posicion_x += (i - 2) * Configuracion.perspectivaDiferencia;
			contexto.fillStyle = hexas[i];
			contexto.lineWidth = teclaPulsada ? 5 : 2;		
			contexto.strokeStyle = '#000';			
			contexto.beginPath();
			contexto.arc(posicion_x, Canvas.maxHeight - 17, 18, 0, Math.PI * 2, true); 	
			contexto.fill();
			contexto.stroke();
			contexto.closePath();	
		}
		
		Juego.proximaNota.tempo--;
		if(Juego.proximaNota.tempo==0) Juego.proximaNota.cores = [];
	},
	_rellenarNotasDinamicas:function(){
		var dentroEspacio = true;
		var contNota = 0;
		var limite_maximo = tempo_musica_parcial + 2;
		var limite_minimo = tempo_musica_parcial - 0.1;
		while(dentroEspacio==true && Sifra.notasValidas.length > contNota){
			
			if(Sifra.notasValidas[contNota].tempo > limite_maximo){ 	
				dentroEspacio = false; 
			} else if(Sifra.notasValidas[contNota].tempo <  limite_minimo ) {
				Sifra.notasValidas.shift();
				Puntuacion.miss._ativar();
			} else {
				var diferenca = limite_maximo - Sifra.notasValidas[contNota].tempo;
				Canvas._notaDinamica( diferenca, Sifra.notasValidas[contNota].cores );
				contNota++;
			}
		}

	},
	_notaDinamica:function(direfenca,cores){
		
		var porcentageDiferencia = direfenca / 2;
		posicion_y = (Canvas.maxHeight - 17) * porcentageDiferencia;

		for(i=0;i<5;i++){
			if(cores[i]){
				var posicion_x = (i - 2) * Canvas.decimo_x + Canvas.mitad_x;
				if(Configuracion.perspectiva) posicion_x += (i - 2) * Configuracion.perspectivaDiferencia * porcentageDiferencia;
				contexto.fillStyle = hexas[i];
				contexto.lineWidth = 2;		
				contexto.strokeStyle = '#000';			
				contexto.beginPath();
				contexto.arc(posicion_x, posicion_y, 18, 0, Math.PI * 2, true); 
				contexto.fill();
				contexto.stroke();
				contexto.closePath();	
			}
		}
	},
	_comprobarColision:function(){
		if(Sifra.notasValidas.length==0) return Puntuacion.miss._ativar();
		
		var diferenca = tempo_musica_parcial - Sifra.notasValidas[0].tempo;
		if(diferenca > -0.13 && diferenca < 0.25){
			if(Juego.proximaNota.cores.join('') == Sifra.notasValidas[0].cores.join('')){
				Puntuacion.acertar._ativar(diferenca);	
				console.log("acertar1");
			} else {
				Puntuacion.errar._ativar();
					console.log("acertar2");
			}
		} else {
			Puntuacion.errar._ativar();
		}
	},
	
	
	_rellenar:function(){		
		if(Juego.play!=''){		
			tempo_musica_parcial = musica.currentTime;			
			if(tempo_musica_parcial>70) window.setTimeout(function(){ Puntuacion._final() },1500); 			
			contexto.clearRect(0,0,Canvas.maxWidth,Canvas.maxHeight);
			
			Canvas._saxo();
			Canvas._rellenarLineas();
			Canvas._rellenarNotasEstaticas();			
			Canvas._rellenarNotasDinamicas();	
			
			Puntuacion._mostrar();				
			Puntuacion.miss._mostrar();		
			Puntuacion.acertar._mostrar();		

			if(Juego.proximaNota.tempo==2){
				Canvas._comprobarColision();
			}				
						
		}
	}
}	

	var Canvas2 = {
		_init:function(){
			
			var objCanvas = document.getElementById('canvas2');
			musica = document.createElement('audio');
			
			contexto2 = objCanvas.getContext("2d");
			canvas2.width  = window.innerWidth*0.5;
			canvas2.height = window.innerHeight*0.8;
			Canvas2.maxWidth = parseInt(objCanvas.width);
			Canvas2.maxHeight = parseInt(objCanvas.height);
			
			Canvas2.mitad_x = parseInt(Canvas2.maxWidth/2);
			Canvas2.decimo_x = Configuracion.perspectiva ? parseInt(Canvas2.maxWidth/10) :  parseInt(Canvas2.maxWidth/8)  ;
			Canvas2._rellenar();
		},
		_saxo:function(){
			contexto2.fillStyle   = '#ecc85e';
			contexto2.globalAlpha = 0.2; 
			contexto2.beginPath();
			var padding_saxo = parseInt(  (Canvas.decimo_x *3) );
			var padding_saxo_bottom = Configuracion.perspectiva ? Configuracion.perspectivaDiferencia * 4 : 0;
			
			contexto2.moveTo(Canvas.mitad_x - padding_saxo, 0);
			contexto2.lineTo(Canvas.mitad_x + padding_saxo, 0);
			contexto2.lineTo(Canvas.mitad_x + padding_saxo + padding_saxo_bottom, Canvas.maxHeight);
			contexto2.lineTo(Canvas.mitad_x - padding_saxo - padding_saxo_bottom, Canvas.maxHeight);
			contexto2.lineTo(Canvas.mitad_x - padding_saxo, 10);
			contexto2.fill();
			contexto2.closePath();
			contexto2.globalAlpha = 1; 
			
		},
		_rellenarLineas:function(){
			contexto2.strokeStyle = '#000';			
			contexto2.lineWidth = Configuracion.larguraLinea;		
			for(i=-2;i<=2;i++){
				x_linea_inicio = Canvas2.mitad_x + ((i)*Canvas2.decimo_x);			
				x_linea_fin = Configuracion.perspectiva ? x_linea_inicio + (i * Configuracion.perspectivaDiferencia) : x_linea_inicio;			
				contexto2.beginPath();
				contexto2.moveTo(x_linea_inicio, 0);
				contexto2.lineTo(x_linea_fin, Canvas2.maxHeight);
				contexto2.stroke();
				contexto2.closePath();			
			}	
		},
		_rellenarNotasEstaticas:function(){
			for(i=0;i<=4;i++){		
				var teclaPulsada = false;
				if(Juego.proximaNota2.tempo>0){
					if(Juego.proximaNota2.cores[i]) teclaPulsada = true;
				}
				var posicion_x = (i - 2) * Canvas2.decimo_x + Canvas2.mitad_x;
				if(Configuracion.perspectiva) posicion_x += (i - 2) * Configuracion.perspectivaDiferencia;
				contexto2.fillStyle = hexas[i];
				contexto2.lineWidth = teclaPulsada ? 5 : 2;		
				contexto2.strokeStyle = '#000';			
				contexto2.beginPath();
				contexto2.arc(posicion_x, Canvas.maxHeight - 17, 18, 0, Math.PI * 2, true); 
				//contexto2.rect(posicion_x-20, Canvas2.maxHeight - 17-30, 40, 40);
				contexto2.fill();
				contexto2.stroke();
				contexto2.closePath();	
			}
			
			Juego.proximaNota2.tempo--;
			if(Juego.proximaNota2.tempo==0) Juego.proximaNota2.cores = [];
		},
		_rellenarNotasDinamicas:function(){
		

			var dentroEspacio = true;
			var contNota = 0;
			var limite_maximo = tempo_musica_parcial + 2;
			var limite_minimo = tempo_musica_parcial - 0.1; // quanto menos, mais pra baixo da tela a nota vai 
			while(dentroEspacio==true && Sifra.notasValidas.length > contNota){
			
				if(Sifra.notasValidas[contNota].tempo > limite_maximo){ 	
					dentroEspacio = false; // ignorando notas muito longes
				} else if(Sifra.notasValidas[contNota].tempo <  limite_minimo ) {
					Sifra.notasValidas.shift(); // apagando primeira nota
					Puntuacion2.miss._ativar();
				} else {
					var diferenca = limite_maximo - Sifra.notasValidas[contNota].tempo;
					Canvas2._notaDinamica( diferenca, Sifra.notasValidas[contNota].cores );
					contNota++;
				}
				
			}
			
			
		},
		_notaDinamica:function(direfenca,cores){
			
			var porcentageDiferencia = direfenca / 2;
			posicion_y = (Canvas2.maxHeight - 17) * porcentageDiferencia;
			for(i=0;i<5;i++){
				if(cores[i]){
					var posicion_x = (i - 2) * Canvas2.decimo_x + Canvas2.mitad_x;
					if(Configuracion.perspectiva) posicion_x += (i - 2) * Configuracion.perspectivaDiferencia * porcentageDiferencia;
					contexto2.fillStyle = hexas[i];
					contexto2.lineWidth = 2;		
					contexto2.strokeStyle = '#000';			
					contexto2.beginPath();
					contexto2.arc(posicion_x, posicion_y, 18, 0, Math.PI * 2, true); 
					//contexto2.rect(posicion_x-20,posicion_y-20, 40, 40);
					contexto2.fill();
					contexto2.stroke();
					contexto2.closePath();	
				}
			}
		},
		_comprobarColision:function(){
			if(Sifra.notasValidas.length==0) return Puntuacion2.miss._ativar();
			
			var diferenca = tempo_musica_parcial - Sifra.notasValidas[0].tempo;
			if(diferenca > -0.13 && diferenca < 0.25){
				//console.debug('acertou - diferenca = '+diferenca);
				if(Juego.proximaNota2.cores.join('') == Sifra.notasValidas[0].cores.join('')){
					Puntuacion2.acertar._ativar(diferenca);	
				} else {
					Puntuacion2.errar._ativar();
				}
			} else {
				//console.debug('errou - diferenca = '+diferenca);
				Puntuacion.errar._ativar();
			}
		},
		
		
		_rellenar:function(){
			

			if(Juego.play2!='' && Configuracion.njugadores==2){
			
				tempo_musica_parcial = musica.currentTime;
				
				if(tempo_musica_parcial>95.5) window.setTimeout(function(){ Puntuacion2._final() },1500); 
				
				contexto2.clearRect(0,0,Canvas2.maxWidth,Canvas2.maxHeight);
				
				Canvas2._saxo();
				Canvas2._rellenarLineas();
				Canvas2._rellenarNotasEstaticas();			
				Canvas2._rellenarNotasDinamicas();	
				
				Puntuacion2._mostrar();				
				Puntuacion2.miss._mostrar();		
				Puntuacion2.acertar._mostrar();		

				if(Juego.proximaNota2.tempo==2){ 
					Canvas2._comprobarColision();
				}												
			}
		}
	}	
