#version 120

uniform sampler2D texture;
uniform float time = 1.0;
uniform float fade = 0.08;

void main()
{
	vec2 coord=gl_TexCoord[0].xy;
	coord.x += sin(time)*0.2;
	coord.y += cos(time*0.8)*0.2;
	float x = (-1.0+2.5*coord.x);
	float y = (-1.0+2.0*coord.y);
	float u = sqrt(x*x + y*y);
	float v = atan(y, x);

	coord.x = cos(v+time)/u+sin(time)*0.2;
	coord.y = sin(v+time)/u+cos(time)*0.2;
	vec4 uv = texture2D(texture, coord + time*0.8);
	gl_FragColor = vec4(uv.r,uv.g,uv.b,uv.a-fade/u) * gl_Color;
}
