/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XColor
implements Pointer {
    public static final int SIZEOF;
    public static final int PIXEL;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int FLAGS;
    public static final int PAD;
    private final ByteBuffer struct;

    public XColor() {
        this(XColor.malloc());
    }

    public XColor(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setPixel(long pixel) {
        XColor.pixel(this.struct, pixel);
    }

    public void setRed(int red) {
        XColor.red(this.struct, red);
    }

    public void setGreen(int green) {
        XColor.green(this.struct, green);
    }

    public void setBlue(int blue) {
        XColor.blue(this.struct, blue);
    }

    public void setFlags(int flags) {
        XColor.flags(this.struct, flags);
    }

    public void setPad(int pad) {
        XColor.pad(this.struct, pad);
    }

    public long getPixel() {
        return XColor.pixel(this.struct);
    }

    public int getRed() {
        return XColor.red(this.struct);
    }

    public int getGreen() {
        return XColor.green(this.struct);
    }

    public int getBlue() {
        return XColor.blue(this.struct);
    }

    public int getFlags() {
        return XColor.flags(this.struct);
    }

    public int getPad() {
        return XColor.pad(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long pixel, int red, int green, int blue, int flags, int pad) {
        ByteBuffer xcolor = XColor.malloc();
        XColor.pixel(xcolor, pixel);
        XColor.red(xcolor, red);
        XColor.green(xcolor, green);
        XColor.blue(xcolor, blue);
        XColor.flags(xcolor, flags);
        XColor.pad(xcolor, pad);
        return xcolor;
    }

    public static void pixel(ByteBuffer xcolor, long pixel) {
        PointerBuffer.put(xcolor, xcolor.position() + PIXEL, pixel);
    }

    public static void red(ByteBuffer xcolor, int red) {
        xcolor.putShort(xcolor.position() + RED, (short)red);
    }

    public static void green(ByteBuffer xcolor, int green) {
        xcolor.putShort(xcolor.position() + GREEN, (short)green);
    }

    public static void blue(ByteBuffer xcolor, int blue) {
        xcolor.putShort(xcolor.position() + BLUE, (short)blue);
    }

    public static void flags(ByteBuffer xcolor, int flags) {
        xcolor.put(xcolor.position() + FLAGS, (byte)flags);
    }

    public static void pad(ByteBuffer xcolor, int pad) {
        xcolor.put(xcolor.position() + PAD, (byte)pad);
    }

    public static long pixel(ByteBuffer xcolor) {
        return PointerBuffer.get(xcolor, xcolor.position() + PIXEL);
    }

    public static int red(ByteBuffer xcolor) {
        return xcolor.getShort(xcolor.position() + RED) & 0xFFFF;
    }

    public static int green(ByteBuffer xcolor) {
        return xcolor.getShort(xcolor.position() + GREEN) & 0xFFFF;
    }

    public static int blue(ByteBuffer xcolor) {
        return xcolor.getShort(xcolor.position() + BLUE) & 0xFFFF;
    }

    public static int flags(ByteBuffer xcolor) {
        return xcolor.get(xcolor.position() + FLAGS);
    }

    public static int pad(ByteBuffer xcolor) {
        return xcolor.get(xcolor.position() + PAD);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = XColor.offsets(MemoryUtil.memAddress(offsets));
        PIXEL = offsets.get(0);
        RED = offsets.get(1);
        GREEN = offsets.get(2);
        BLUE = offsets.get(3);
        FLAGS = offsets.get(4);
        PAD = offsets.get(5);
    }
}

