/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XButtonEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int ROOT;
    public static final int SUBWINDOW;
    public static final int TIME;
    public static final int X;
    public static final int Y;
    public static final int X_ROOT;
    public static final int Y_ROOT;
    public static final int STATE;
    public static final int BUTTON;
    public static final int SAME_SCREEN;
    private final ByteBuffer struct;

    public XButtonEvent() {
        this(XButtonEvent.malloc());
    }

    public XButtonEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XButtonEvent.type(this.struct, type);
    }

    public void setSerial(long serial) {
        XButtonEvent.serial(this.struct, serial);
    }

    public void setSendEvent(int send_event) {
        XButtonEvent.send_event(this.struct, send_event);
    }

    public void setDisplay(long display) {
        XButtonEvent.display(this.struct, display);
    }

    public void setWindow(long window) {
        XButtonEvent.window(this.struct, window);
    }

    public void setRoot(long root) {
        XButtonEvent.root(this.struct, root);
    }

    public void setSubwindow(long subwindow) {
        XButtonEvent.subwindow(this.struct, subwindow);
    }

    public void setTime(long time) {
        XButtonEvent.time(this.struct, time);
    }

    public void setX(int x) {
        XButtonEvent.x(this.struct, x);
    }

    public void setY(int y) {
        XButtonEvent.y(this.struct, y);
    }

    public void setXRoot(int x_root) {
        XButtonEvent.x_root(this.struct, x_root);
    }

    public void setYRoot(int y_root) {
        XButtonEvent.y_root(this.struct, y_root);
    }

    public void setState(int state) {
        XButtonEvent.state(this.struct, state);
    }

    public void setButton(int button) {
        XButtonEvent.button(this.struct, button);
    }

    public void setSameScreen(int same_screen) {
        XButtonEvent.same_screen(this.struct, same_screen);
    }

    public int getType() {
        return XButtonEvent.type(this.struct);
    }

    public long getSerial() {
        return XButtonEvent.serial(this.struct);
    }

    public int getSendEvent() {
        return XButtonEvent.send_event(this.struct);
    }

    public long getDisplay() {
        return XButtonEvent.display(this.struct);
    }

    public long getWindow() {
        return XButtonEvent.window(this.struct);
    }

    public long getRoot() {
        return XButtonEvent.root(this.struct);
    }

    public long getSubwindow() {
        return XButtonEvent.subwindow(this.struct);
    }

    public long getTime() {
        return XButtonEvent.time(this.struct);
    }

    public int getX() {
        return XButtonEvent.x(this.struct);
    }

    public int getY() {
        return XButtonEvent.y(this.struct);
    }

    public int getXRoot() {
        return XButtonEvent.x_root(this.struct);
    }

    public int getYRoot() {
        return XButtonEvent.y_root(this.struct);
    }

    public int getState() {
        return XButtonEvent.state(this.struct);
    }

    public int getButton() {
        return XButtonEvent.button(this.struct);
    }

    public int getSameScreen() {
        return XButtonEvent.same_screen(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window, long root, long subwindow, long time, int x, int y, int x_root, int y_root, int state, int button, int same_screen) {
        ByteBuffer xbuttonevent = XButtonEvent.malloc();
        XButtonEvent.type(xbuttonevent, type);
        XButtonEvent.serial(xbuttonevent, serial);
        XButtonEvent.send_event(xbuttonevent, send_event);
        XButtonEvent.display(xbuttonevent, display);
        XButtonEvent.window(xbuttonevent, window);
        XButtonEvent.root(xbuttonevent, root);
        XButtonEvent.subwindow(xbuttonevent, subwindow);
        XButtonEvent.time(xbuttonevent, time);
        XButtonEvent.x(xbuttonevent, x);
        XButtonEvent.y(xbuttonevent, y);
        XButtonEvent.x_root(xbuttonevent, x_root);
        XButtonEvent.y_root(xbuttonevent, y_root);
        XButtonEvent.state(xbuttonevent, state);
        XButtonEvent.button(xbuttonevent, button);
        XButtonEvent.same_screen(xbuttonevent, same_screen);
        return xbuttonevent;
    }

    public static void type(ByteBuffer xbuttonevent, int type) {
        xbuttonevent.putInt(xbuttonevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xbuttonevent, long serial) {
        PointerBuffer.put(xbuttonevent, xbuttonevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xbuttonevent, int send_event) {
        xbuttonevent.putInt(xbuttonevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xbuttonevent, long display) {
        PointerBuffer.put(xbuttonevent, xbuttonevent.position() + DISPLAY, display);
    }

    public static void window(ByteBuffer xbuttonevent, long window) {
        PointerBuffer.put(xbuttonevent, xbuttonevent.position() + WINDOW, window);
    }

    public static void root(ByteBuffer xbuttonevent, long root) {
        PointerBuffer.put(xbuttonevent, xbuttonevent.position() + ROOT, root);
    }

    public static void subwindow(ByteBuffer xbuttonevent, long subwindow) {
        PointerBuffer.put(xbuttonevent, xbuttonevent.position() + SUBWINDOW, subwindow);
    }

    public static void time(ByteBuffer xbuttonevent, long time) {
        PointerBuffer.put(xbuttonevent, xbuttonevent.position() + TIME, time);
    }

    public static void x(ByteBuffer xbuttonevent, int x) {
        xbuttonevent.putInt(xbuttonevent.position() + X, x);
    }

    public static void y(ByteBuffer xbuttonevent, int y) {
        xbuttonevent.putInt(xbuttonevent.position() + Y, y);
    }

    public static void x_root(ByteBuffer xbuttonevent, int x_root) {
        xbuttonevent.putInt(xbuttonevent.position() + X_ROOT, x_root);
    }

    public static void y_root(ByteBuffer xbuttonevent, int y_root) {
        xbuttonevent.putInt(xbuttonevent.position() + Y_ROOT, y_root);
    }

    public static void state(ByteBuffer xbuttonevent, int state) {
        xbuttonevent.putInt(xbuttonevent.position() + STATE, state);
    }

    public static void button(ByteBuffer xbuttonevent, int button) {
        xbuttonevent.putInt(xbuttonevent.position() + BUTTON, button);
    }

    public static void same_screen(ByteBuffer xbuttonevent, int same_screen) {
        xbuttonevent.putInt(xbuttonevent.position() + SAME_SCREEN, same_screen);
    }

    public static int type(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xbuttonevent) {
        return PointerBuffer.get(xbuttonevent, xbuttonevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xbuttonevent) {
        return PointerBuffer.get(xbuttonevent, xbuttonevent.position() + DISPLAY);
    }

    public static long window(ByteBuffer xbuttonevent) {
        return PointerBuffer.get(xbuttonevent, xbuttonevent.position() + WINDOW);
    }

    public static long root(ByteBuffer xbuttonevent) {
        return PointerBuffer.get(xbuttonevent, xbuttonevent.position() + ROOT);
    }

    public static long subwindow(ByteBuffer xbuttonevent) {
        return PointerBuffer.get(xbuttonevent, xbuttonevent.position() + SUBWINDOW);
    }

    public static long time(ByteBuffer xbuttonevent) {
        return PointerBuffer.get(xbuttonevent, xbuttonevent.position() + TIME);
    }

    public static int x(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + X);
    }

    public static int y(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + Y);
    }

    public static int x_root(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + X_ROOT);
    }

    public static int y_root(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + Y_ROOT);
    }

    public static int state(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + STATE);
    }

    public static int button(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + BUTTON);
    }

    public static int same_screen(ByteBuffer xbuttonevent) {
        return xbuttonevent.getInt(xbuttonevent.position() + SAME_SCREEN);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(15);
        SIZEOF = XButtonEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        WINDOW = offsets.get(4);
        ROOT = offsets.get(5);
        SUBWINDOW = offsets.get(6);
        TIME = offsets.get(7);
        X = offsets.get(8);
        Y = offsets.get(9);
        X_ROOT = offsets.get(10);
        Y_ROOT = offsets.get(11);
        STATE = offsets.get(12);
        BUTTON = offsets.get(13);
        SAME_SCREEN = offsets.get(14);
    }
}

