/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.GLYPHMETRICSFLOAT;

public final class WGL {
    public static final int WGL_FONT_LINES = 0;
    public static final int WGL_FONT_POLYGONS = 1;
    public static final int WGL_SWAP_MAIN_PLANE = 1;
    public static final int WGL_SWAP_OVERLAY1 = 2;
    public static final int WGL_SWAP_OVERLAY2 = 4;
    public static final int WGL_SWAP_OVERLAY3 = 8;
    public static final int WGL_SWAP_OVERLAY4 = 16;
    public static final int WGL_SWAP_OVERLAY5 = 32;
    public static final int WGL_SWAP_OVERLAY6 = 64;
    public static final int WGL_SWAP_OVERLAY7 = 128;
    public static final int WGL_SWAP_OVERLAY8 = 256;
    public static final int WGL_SWAP_OVERLAY9 = 512;
    public static final int WGL_SWAP_OVERLAY10 = 1024;
    public static final int WGL_SWAP_OVERLAY11 = 2048;
    public static final int WGL_SWAP_OVERLAY12 = 4096;
    public static final int WGL_SWAP_OVERLAY13 = 8192;
    public static final int WGL_SWAP_OVERLAY14 = 16384;
    public static final int WGL_SWAP_OVERLAY15 = 32768;
    public static final int WGL_SWAP_UNDERLAY1 = 65536;
    public static final int WGL_SWAP_UNDERLAY2 = 131072;
    public static final int WGL_SWAP_UNDERLAY3 = 262144;
    public static final int WGL_SWAP_UNDERLAY4 = 524288;
    public static final int WGL_SWAP_UNDERLAY5 = 0x100000;
    public static final int WGL_SWAP_UNDERLAY6 = 0x200000;
    public static final int WGL_SWAP_UNDERLAY7 = 0x400000;
    public static final int WGL_SWAP_UNDERLAY8 = 0x800000;
    public static final int WGL_SWAP_UNDERLAY9 = 0x1000000;
    public static final int WGL_SWAP_UNDERLAY10 = 0x2000000;
    public static final int WGL_SWAP_UNDERLAY11 = 0x4000000;
    public static final int WGL_SWAP_UNDERLAY12 = 0x8000000;
    public static final int WGL_SWAP_UNDERLAY13 = 0x10000000;
    public static final int WGL_SWAP_UNDERLAY14 = 0x20000000;
    public static final int WGL_SWAP_UNDERLAY15 = 0x40000000;

    private WGL() {
    }

    public static native long nwglCreateContext(long var0);

    public static long wglCreateContext(long hdc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WGL.nwglCreateContext(hdc);
    }

    public static native long nwglCreateLayerContext(long var0, int var2);

    public static long wglCreateLayerContext(long hdc, int layerPlane) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WGL.nwglCreateLayerContext(hdc, layerPlane);
    }

    public static native int nwglCopyContext(long var0, long var2, int var4);

    public static int wglCopyContext(long src, long dst, int mask) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(src);
            Checks.checkPointer(dst);
        }
        return WGL.nwglCopyContext(src, dst, mask);
    }

    public static native int nwglDeleteContext(long var0);

    public static int wglDeleteContext(long context) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(context);
        }
        return WGL.nwglDeleteContext(context);
    }

    public static native long wglGetCurrentContext();

    public static native long wglGetCurrentDC();

    public static native long nwglGetProcAddress(long var0);

    public static long wglGetProcAddress(ByteBuffer proc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(proc);
        }
        return WGL.nwglGetProcAddress(MemoryUtil.memAddress(proc));
    }

    public static long wglGetProcAddress(CharSequence proc) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int procEncoded = __buffer.stringParamASCII(proc, true);
        return WGL.nwglGetProcAddress(__buffer.address(procEncoded));
    }

    public static native int wglMakeCurrent(long var0, long var2);

    public static native int nwglShareLists(long var0, long var2);

    public static int wglShareLists(long context1, long context2) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(context1);
            Checks.checkPointer(context2);
        }
        return WGL.nwglShareLists(context1, context2);
    }

    public static native int nwglUseFontBitmaps(long var0, int var2, int var3, int var4);

    public static int wglUseFontBitmaps(long hdc, int first, int count, int listBase) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
        }
        return WGL.nwglUseFontBitmaps(hdc, first, count, listBase);
    }

    public static native int nwglUseFontOutlines(long var0, int var2, int var3, int var4, float var5, float var6, int var7, long var8);

    public static int wglUseFontOutlines(long hdc, int first, int count, int listBase, float deviation, float extrusion, int format, ByteBuffer glyphMetrics) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(hdc);
            if (glyphMetrics != null) {
                Checks.checkBuffer((Buffer)glyphMetrics, count * GLYPHMETRICSFLOAT.SIZEOF * GLYPHMETRICSFLOAT.SIZEOF);
            }
        }
        return WGL.nwglUseFontOutlines(hdc, first, count, listBase, deviation, extrusion, format, MemoryUtil.memAddressSafe(glyphMetrics));
    }

    static {
        LWJGLUtil.initialize();
    }
}

