/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.WGL;
import org.lwjgl.opengl.WGLARBCreateContext;
import org.lwjgl.opengl.WGLARBMakeCurrentRead;
import org.lwjgl.system.windows.WindowsPlatform;

public class GLContextWindows
extends GLContext {
    private final long hglrc;

    public GLContextWindows(ContextCapabilities capabilities, long hglrc) {
        super(capabilities);
        this.hglrc = hglrc;
    }

    @Override
    public long getPointer() {
        return this.hglrc;
    }

    @Override
    protected void makeCurrentImpl(long target) {
        if (WGL.wglMakeCurrent(target, this.hglrc) == 0) {
            WindowsPlatform.windowsThrowException("Failed to make the OpenGL context current.");
        }
    }

    @Override
    protected void makeCurrentImpl(long targetDraw, long targetRead) {
        if (WGLARBMakeCurrentRead.wglMakeContextCurrentARB(targetDraw, targetRead, this.hglrc) == 0) {
            WindowsPlatform.windowsThrowException("Failed to make the OpenGL context current.");
        }
    }

    @Override
    public boolean isCurrent() {
        return WGL.wglGetCurrentContext() == this.hglrc;
    }

    public static GLContextWindows createFromCurrent() {
        long hglrc = WGL.wglGetCurrentContext();
        if (hglrc == 0L) {
            throw new IllegalStateException("No OpenGL context is current in the current thread.");
        }
        ContextCapabilities capabilities = GL.createCapabilities(false);
        return new GLContextWindows(capabilities, hglrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLContextWindows create(long hdc) {
        GLContextWindows context = GLContextWindows.createLegacy(hdc);
        try {
            GLContextWindows gLContextWindows = GLContextWindows.createARB(hdc);
            return gLContextWindows;
        }
        finally {
            context.destroy();
        }
    }

    private static GLContextWindows createLegacy(long hdc) {
        long hglrc = WGL.wglCreateContext(hdc);
        if (hglrc == 0L) {
            throw new RuntimeException("Failed to create OpenGL context.");
        }
        try {
            int result = WGL.wglMakeCurrent(hdc, hglrc);
            if (result == 0) {
                throw new RuntimeException("Failed to make the new OpenGL context current.");
            }
            return GLContextWindows.createFromCurrent();
        }
        catch (RuntimeException e) {
            WGL.wglDeleteContext(hglrc);
            throw e;
        }
    }

    private static GLContextWindows createARB(long hdc) {
        IntBuffer attribs = BufferUtils.createIntBuffer(16);
        attribs.put(8340);
        attribs.put(1);
        attribs.put(37158);
        attribs.put(2);
        attribs.put(0);
        attribs.flip();
        long hglrc = WGLARBCreateContext.wglCreateContextAttribsARB(hdc, 0L, attribs);
        if (hglrc == 0L) {
            throw new RuntimeException("Failed to create OpenGL context.");
        }
        try {
            int result = WGL.wglMakeCurrent(hdc, hglrc);
            if (result == 0) {
                throw new RuntimeException("Failed to make the new OpenGL context current.");
            }
            return GLContextWindows.createFromCurrent();
        }
        catch (RuntimeException e) {
            WGL.wglDeleteContext(hglrc);
            throw e;
        }
    }

    @Override
    protected void destroyImpl() {
        int result = WGL.wglDeleteContext(this.hglrc);
        if (result == 0) {
            throw new RuntimeException("Failed to delete OpenGL context.");
        }
    }
}

