/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public final class EXTBindableUniform {
    public static final int GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = 36322;
    public static final int GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = 36323;
    public static final int GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = 36324;
    public static final int GL_MAX_BINDABLE_UNIFORM_SIZE_EXT = 36333;
    public static final int GL_UNIFORM_BUFFER_BINDING_EXT = 36335;
    public static final int GL_UNIFORM_BUFFER_EXT = 36334;
    public final long UniformBufferEXT;
    public final long GetUniformBufferSizeEXT;
    public final long GetUniformOffsetEXT;

    public EXTBindableUniform(FunctionProvider provider) {
        this.UniformBufferEXT = provider.getFunctionAddress("glUniformBufferEXT");
        this.GetUniformBufferSizeEXT = provider.getFunctionAddress("glGetUniformBufferSizeEXT");
        this.GetUniformOffsetEXT = provider.getFunctionAddress("glGetUniformOffsetEXT");
    }

    public static EXTBindableUniform getInstance() {
        return GL.getCapabilities().__EXTBindableUniform;
    }

    static EXTBindableUniform create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_bindable_uniform")) {
            return null;
        }
        EXTBindableUniform funcs = new EXTBindableUniform(provider);
        boolean supported = Checks.checkFunctions(funcs.UniformBufferEXT, funcs.GetUniformBufferSizeEXT, funcs.GetUniformOffsetEXT);
        return GL.checkExtension("GL_EXT_bindable_uniform", funcs, supported);
    }

    public static native void nglUniformBufferEXT(int var0, int var1, int var2, long var3);

    public static void glUniformBufferEXT(int program, int location, int buffer) {
        long __functionAddress = EXTBindableUniform.getInstance().UniformBufferEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTBindableUniform.nglUniformBufferEXT(program, location, buffer, __functionAddress);
    }

    public static native int nglGetUniformBufferSizeEXT(int var0, int var1, long var2);

    public static int glGetUniformBufferSizeEXT(int program, int location) {
        long __functionAddress = EXTBindableUniform.getInstance().GetUniformBufferSizeEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return EXTBindableUniform.nglGetUniformBufferSizeEXT(program, location, __functionAddress);
    }

    public static native long nglGetUniformOffsetEXT(int var0, int var1, long var2);

    public static long glGetUniformOffsetEXT(int program, int location) {
        long __functionAddress = EXTBindableUniform.getInstance().GetUniformOffsetEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return EXTBindableUniform.nglGetUniformOffsetEXT(program, location, __functionAddress);
    }
}

