/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GLSLFunctions;
import game.Game;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import render.InputHandler;
import sound.Sound;

public class Aircraft {
    private Vector3d pos;
    private Vector3d forward = new Vector3d(0.0, 0.0, 1.0);
    private Vector3d up = new Vector3d(0.0, 1.0, 0.0);
    private double speed;
    private Game game;
    private float rollAcc = 0.0f;
    private float rollAccAcc = 0.05f;
    private float maxRollSpeed = 0.05f;
    private float rollDecay = 0.9f;
    private float pitchAcc = 0.0f;
    private float pitchAccAcc = 0.04f;
    private float maxPitchSpeed = 0.035f;
    private float pitchDecay = 0.9f;
    private float yawAcc = 0.0f;
    private float yawAccAcc = 0.04f;
    private float maxYawSpeed = 0.035f;
    private float yawDecay = 0.9f;
    private float maxSpeed = 2.0f;
    private Vector3f impulse = new Vector3f(0.0f, 0.0f, 0.0f);
    private float battery = 1.0f;
    private final float drainSec = 30.0f;
    private float drain = 5.5555557E-4f;
    private float light = 1.0f;
    private Sound sound;
    private int score = 0;
    private float shakeAmplitude = 0.0f;
    private float shakeDrain = 0.98f;
    private float shakeTick = 0.0f;
    private float nodeTakenTick = 0.0f;
    private Vector3f node;

    public Aircraft(Game game, Sound sound) {
        this.game = game;
        this.sound = sound;
        this.pos = new Vector3d(game.getTrack().getSpawn());
        this.node = game.getTrack().getNextNode();
    }

    public void updateSmallStep(float num) {
        this.pos.x += this.speed * this.forward.x / (double)num;
        this.pos.y += this.speed * this.forward.y / (double)num;
        this.pos.z += this.speed * this.forward.z / (double)num;
        this.pos.x += (double)(this.impulse.x / num);
        this.pos.y += (double)(this.impulse.y / num);
        this.pos.z += (double)(this.impulse.z / num);
    }

    public boolean update(float tick) {
        Vector3f vector3f = new Vector3f(this.pos);
        if (Game.distance(this.node, vector3f) <= 7.0f) {
            this.score = (int)((float)this.score + 1800.0f * this.drain * 100.0f);
            this.sound.play(Sound.POWER_UP);
            this.drain = (float)((double)this.drain * 1.1);
            this.battery = 1.0f;
            this.nodeTakenTick = tick;
            this.node = this.game.getTrack().getNextNode();
        }
        this.battery -= this.drain;
        this.light = 0.95f * this.light + 0.05f * this.battery;
        if (this.battery <= 0.0f) {
            return true;
        }
        if (InputHandler.down(263)) {
            this.rollLeft();
        } else if (InputHandler.down(262)) {
            this.rollRight();
        } else {
            this.decayRoll();
        }
        if (InputHandler.down(265)) {
            this.pitchForward();
        } else if (InputHandler.down(264)) {
            this.pitchBackward();
        } else {
            this.decayPitch();
        }
        if (InputHandler.down(65)) {
            this.yawLeft();
        } else if (InputHandler.down(68)) {
            this.yawRight();
        } else {
            this.decayYaw();
        }
        if (InputHandler.down(340)) {
            this.accelerate();
        }
        if (InputHandler.down(341)) {
            this.brake();
        }
        this.roll();
        this.pitch();
        this.yaw();
        this.impulse.scale(0.95f);
        this.shakeAmplitude *= this.shakeDrain;
        return false;
    }

    public void accelerate() {
        if (this.speed < (double)this.maxSpeed) {
            this.speed += (double)0.006f;
        }
    }

    public void brake() {
        this.speed *= 0.96;
    }

    public Vector3f getPos() {
        return new Vector3f(this.pos);
    }

    public Vector3f getForward() {
        return new Vector3f(this.forward);
    }

    public Vector3f getUp() {
        return new Vector3f(this.up);
    }

    public void yawLeft() {
        this.yawAcc += this.yawAccAcc;
    }

    public void yawRight() {
        this.yawAcc -= this.pitchAccAcc;
    }

    private void decayYaw() {
        this.yawAcc *= this.yawDecay;
    }

    public float getYawVel() {
        return this.maxYawSpeed * Math.signum(this.yawAcc) * GLSLFunctions.smoothstep(0.0f, 1.0f, Math.abs(this.yawAcc));
    }

    public void yaw() {
        float yawVel = this.getYawVel();
        if ((double)Math.abs(yawVel) < 1.0E-7) {
            return;
        }
        AxisAngle4d rot = new AxisAngle4d(this.up, yawVel);
        Matrix4d m = new Matrix4d();
        m.set(rot);
        m.transform(this.forward);
        this.yawAcc = GLSLFunctions.clamp(this.yawAcc, -1.0f, 1.0f);
    }

    public float getPitchVel() {
        return -this.maxPitchSpeed * Math.signum(this.pitchAcc) * GLSLFunctions.smoothstep(0.0f, 1.0f, Math.abs(this.pitchAcc));
    }

    public void pitch() {
        float pitchVel = this.getPitchVel();
        if ((double)Math.abs(pitchVel) < 1.0E-7) {
            return;
        }
        Vector3d right = new Vector3d();
        right.cross(this.forward, this.up);
        AxisAngle4d rot = new AxisAngle4d(right, pitchVel);
        Matrix4d m = new Matrix4d();
        m.set(rot);
        m.transform(this.up);
        m.transform(this.forward);
        this.pitchAcc = GLSLFunctions.clamp(this.pitchAcc, -1.0f, 1.0f);
    }

    public void pitchForward() {
        this.pitchAcc += this.pitchAccAcc;
    }

    public void pitchBackward() {
        this.pitchAcc -= this.pitchAccAcc;
    }

    private void decayPitch() {
        this.pitchAcc *= this.pitchDecay;
    }

    public float getRollVel() {
        return this.maxRollSpeed * Math.signum(this.rollAcc) * GLSLFunctions.smoothstep(0.0f, 1.0f, Math.abs(this.rollAcc));
    }

    public void roll() {
        float rotVel = this.getRollVel();
        if ((double)Math.abs(rotVel) < 1.0E-7) {
            return;
        }
        AxisAngle4d rot = new AxisAngle4d(this.forward, rotVel);
        Matrix4d m = new Matrix4d();
        m.set(rot);
        m.transform(this.up);
        this.rollAcc = GLSLFunctions.clamp(this.rollAcc, -1.0f, 1.0f);
    }

    private void decayRoll() {
        this.rollAcc *= this.rollDecay;
    }

    public void rollRight() {
        this.rollAcc += this.rollAccAcc;
    }

    public void rollLeft() {
        this.rollAcc -= this.rollAccAcc;
    }

    public void collide(Vector3f normal, float tick) {
        this.shakeAmplitude = (float)(3.0 * this.speed);
        this.shakeTick = tick;
        if (this.speed + (double)this.impulse.length() > 0.1) {
            this.sound.play(Sound.CLICK, Math.max(0.0, Math.min(1.0, this.speed + (double)this.impulse.length())));
        }
        Vector3f ref = GLSLFunctions.reflect(new Vector3f(this.forward), normal);
        ref.normalize();
        this.pos.x += (double)(-normal.x) * (this.speed + (double)this.impulse.x) * 1.1;
        this.pos.y += (double)(-normal.y) * (this.speed + (double)this.impulse.y) * 1.1;
        this.pos.z += (double)(-normal.z) * (this.speed + (double)this.impulse.z) * 1.1;
        ref.scale((float)(this.speed * 0.6));
        this.impulse = ref;
        this.speed = 0.0;
    }

    public float getSpeed() {
        return (float)this.speed;
    }

    public float getBattery() {
        return this.light;
    }

    public int getScore() {
        return this.score;
    }

    public float getShake() {
        return this.shakeAmplitude;
    }

    public float getShakeTick() {
        return this.shakeTick;
    }

    public float getNodeTakenTick() {
        return this.nodeTakenTick;
    }

    public Vector3f getNode() {
        return this.node;
    }
}

