/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class TRACKMOUSEEVENT
implements Pointer {
    public static final int SIZEOF;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int HWNDTRACK;
    public static final int HOVERTIME;
    private final ByteBuffer struct;

    public TRACKMOUSEEVENT() {
        this(TRACKMOUSEEVENT.malloc());
    }

    public TRACKMOUSEEVENT(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setSize(int size) {
        TRACKMOUSEEVENT.size(this.struct, size);
    }

    public void setFlags(int flags) {
        TRACKMOUSEEVENT.flags(this.struct, flags);
    }

    public void setHwndTrack(long hwndTrack) {
        TRACKMOUSEEVENT.hwndTrack(this.struct, hwndTrack);
    }

    public void setHoverTime(int hoverTime) {
        TRACKMOUSEEVENT.hoverTime(this.struct, hoverTime);
    }

    public int getSize() {
        return TRACKMOUSEEVENT.size(this.struct);
    }

    public int getFlags() {
        return TRACKMOUSEEVENT.flags(this.struct);
    }

    public long getHwndTrack() {
        return TRACKMOUSEEVENT.hwndTrack(this.struct);
    }

    public int getHoverTime() {
        return TRACKMOUSEEVENT.hoverTime(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int size, int flags, long hwndTrack, int hoverTime) {
        ByteBuffer trackmouseevent = TRACKMOUSEEVENT.malloc();
        TRACKMOUSEEVENT.size(trackmouseevent, size);
        TRACKMOUSEEVENT.flags(trackmouseevent, flags);
        TRACKMOUSEEVENT.hwndTrack(trackmouseevent, hwndTrack);
        TRACKMOUSEEVENT.hoverTime(trackmouseevent, hoverTime);
        return trackmouseevent;
    }

    public static void size(ByteBuffer trackmouseevent, int size) {
        trackmouseevent.putInt(trackmouseevent.position() + SIZE, size);
    }

    public static void flags(ByteBuffer trackmouseevent, int flags) {
        trackmouseevent.putInt(trackmouseevent.position() + FLAGS, flags);
    }

    public static void hwndTrack(ByteBuffer trackmouseevent, long hwndTrack) {
        PointerBuffer.put(trackmouseevent, trackmouseevent.position() + HWNDTRACK, hwndTrack);
    }

    public static void hoverTime(ByteBuffer trackmouseevent, int hoverTime) {
        trackmouseevent.putInt(trackmouseevent.position() + HOVERTIME, hoverTime);
    }

    public static int size(ByteBuffer trackmouseevent) {
        return trackmouseevent.getInt(trackmouseevent.position() + SIZE);
    }

    public static int flags(ByteBuffer trackmouseevent) {
        return trackmouseevent.getInt(trackmouseevent.position() + FLAGS);
    }

    public static long hwndTrack(ByteBuffer trackmouseevent) {
        return PointerBuffer.get(trackmouseevent, trackmouseevent.position() + HWNDTRACK);
    }

    public static int hoverTime(ByteBuffer trackmouseevent) {
        return trackmouseevent.getInt(trackmouseevent.position() + HOVERTIME);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = TRACKMOUSEEVENT.offsets(MemoryUtil.memAddress(offsets));
        SIZE = offsets.get(0);
        FLAGS = offsets.get(1);
        HWNDTRACK = offsets.get(2);
        HOVERTIME = offsets.get(3);
    }
}

