/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class POINTL
implements Pointer {
    public static final int SIZEOF;
    public static final int X;
    public static final int Y;
    private final ByteBuffer struct;

    public POINTL() {
        this(POINTL.malloc());
    }

    public POINTL(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setX(int x) {
        POINTL.x(this.struct, x);
    }

    public void setY(int y) {
        POINTL.y(this.struct, y);
    }

    public int getX() {
        return POINTL.x(this.struct);
    }

    public int getY() {
        return POINTL.y(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int x, int y) {
        ByteBuffer pointl = POINTL.malloc();
        POINTL.x(pointl, x);
        POINTL.y(pointl, y);
        return pointl;
    }

    public static void x(ByteBuffer pointl, int x) {
        pointl.putInt(pointl.position() + X, x);
    }

    public static void y(ByteBuffer pointl, int y) {
        pointl.putInt(pointl.position() + Y, y);
    }

    public static int x(ByteBuffer pointl) {
        return pointl.getInt(pointl.position() + X);
    }

    public static int y(ByteBuffer pointl) {
        return pointl.getInt(pointl.position() + Y);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = POINTL.offsets(MemoryUtil.memAddress(offsets));
        X = offsets.get(0);
        Y = offsets.get(1);
    }
}

