/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class ObjCMethodDescription
implements Pointer {
    public static final int SIZEOF;
    public static final int NAME;
    public static final int TYPES;
    private final ByteBuffer struct;

    public ObjCMethodDescription() {
        this(ObjCMethodDescription.malloc());
    }

    public ObjCMethodDescription(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setName(long name) {
        ObjCMethodDescription.name(this.struct, name);
    }

    public void setTypes(long types) {
        ObjCMethodDescription.types(this.struct, types);
    }

    public void setTypes(ByteBuffer types) {
        ObjCMethodDescription.types(this.struct, types);
    }

    public long getName() {
        return ObjCMethodDescription.name(this.struct);
    }

    public long getTypes() {
        return ObjCMethodDescription.types(this.struct);
    }

    public ByteBuffer getTypesBuffer() {
        return ObjCMethodDescription.typesBuffer(this.struct);
    }

    public String getTypesString() {
        return ObjCMethodDescription.typesString(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long name, ByteBuffer types) {
        ByteBuffer objc_method_description = ObjCMethodDescription.malloc();
        ObjCMethodDescription.name(objc_method_description, name);
        ObjCMethodDescription.types(objc_method_description, types);
        return objc_method_description;
    }

    public static void name(ByteBuffer objc_method_description, long name) {
        PointerBuffer.put(objc_method_description, objc_method_description.position() + NAME, name);
    }

    public static void types(ByteBuffer objc_method_description, long types) {
        PointerBuffer.put(objc_method_description, objc_method_description.position() + TYPES, types);
    }

    public static void types(ByteBuffer objc_method_description, ByteBuffer types) {
        if (LWJGLUtil.CHECKS && types != null) {
            Checks.checkNT1(types);
        }
        ObjCMethodDescription.types(objc_method_description, MemoryUtil.memAddressSafe(types));
    }

    public static long name(ByteBuffer objc_method_description) {
        return PointerBuffer.get(objc_method_description, objc_method_description.position() + NAME);
    }

    public static long types(ByteBuffer objc_method_description) {
        return PointerBuffer.get(objc_method_description, objc_method_description.position() + TYPES);
    }

    public static ByteBuffer typesBuffer(ByteBuffer objc_method_description) {
        return MemoryUtil.memByteBufferNT1(ObjCMethodDescription.types(objc_method_description));
    }

    public static String typesString(ByteBuffer objc_method_description) {
        return MemoryUtil.memDecodeUTF8(ObjCMethodDescription.types(objc_method_description));
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = ObjCMethodDescription.offsets(MemoryUtil.memAddress(offsets));
        NAME = offsets.get(0);
        TYPES = offsets.get(1);
    }
}

