/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XWMHints
implements Pointer {
    public static final int SIZEOF;
    public static final int FLAGS;
    public static final int INPUT;
    public static final int INITIAL_STATE;
    public static final int ICON_PIXMAP;
    public static final int ICON_WINDOW;
    public static final int ICON_X;
    public static final int ICON_Y;
    public static final int ICON_MASK;
    public static final int WINDOW_GROUP;
    private final ByteBuffer struct;

    public XWMHints() {
        this(XWMHints.malloc());
    }

    public XWMHints(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setFlags(long flags) {
        XWMHints.flags(this.struct, flags);
    }

    public void setInput(int input) {
        XWMHints.input(this.struct, input);
    }

    public void setInitialState(int initial_state) {
        XWMHints.initial_state(this.struct, initial_state);
    }

    public void setIconPixmap(long icon_pixmap) {
        XWMHints.icon_pixmap(this.struct, icon_pixmap);
    }

    public void setIconWindow(long icon_window) {
        XWMHints.icon_window(this.struct, icon_window);
    }

    public void setIconX(int icon_x) {
        XWMHints.icon_x(this.struct, icon_x);
    }

    public void setIconY(int icon_y) {
        XWMHints.icon_y(this.struct, icon_y);
    }

    public void setIconMask(long icon_mask) {
        XWMHints.icon_mask(this.struct, icon_mask);
    }

    public void setWindowGroup(long window_group) {
        XWMHints.window_group(this.struct, window_group);
    }

    public long getFlags() {
        return XWMHints.flags(this.struct);
    }

    public int getInput() {
        return XWMHints.input(this.struct);
    }

    public int getInitialState() {
        return XWMHints.initial_state(this.struct);
    }

    public long getIconPixmap() {
        return XWMHints.icon_pixmap(this.struct);
    }

    public long getIconWindow() {
        return XWMHints.icon_window(this.struct);
    }

    public int getIconX() {
        return XWMHints.icon_x(this.struct);
    }

    public int getIconY() {
        return XWMHints.icon_y(this.struct);
    }

    public long getIconMask() {
        return XWMHints.icon_mask(this.struct);
    }

    public long getWindowGroup() {
        return XWMHints.window_group(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long flags, int input, int initial_state, long icon_pixmap, long icon_window, int icon_x, int icon_y, long icon_mask, long window_group) {
        ByteBuffer xwmhints = XWMHints.malloc();
        XWMHints.flags(xwmhints, flags);
        XWMHints.input(xwmhints, input);
        XWMHints.initial_state(xwmhints, initial_state);
        XWMHints.icon_pixmap(xwmhints, icon_pixmap);
        XWMHints.icon_window(xwmhints, icon_window);
        XWMHints.icon_x(xwmhints, icon_x);
        XWMHints.icon_y(xwmhints, icon_y);
        XWMHints.icon_mask(xwmhints, icon_mask);
        XWMHints.window_group(xwmhints, window_group);
        return xwmhints;
    }

    public static void flags(ByteBuffer xwmhints, long flags) {
        PointerBuffer.put(xwmhints, xwmhints.position() + FLAGS, flags);
    }

    public static void input(ByteBuffer xwmhints, int input) {
        xwmhints.putInt(xwmhints.position() + INPUT, input);
    }

    public static void initial_state(ByteBuffer xwmhints, int initial_state) {
        xwmhints.putInt(xwmhints.position() + INITIAL_STATE, initial_state);
    }

    public static void icon_pixmap(ByteBuffer xwmhints, long icon_pixmap) {
        PointerBuffer.put(xwmhints, xwmhints.position() + ICON_PIXMAP, icon_pixmap);
    }

    public static void icon_window(ByteBuffer xwmhints, long icon_window) {
        PointerBuffer.put(xwmhints, xwmhints.position() + ICON_WINDOW, icon_window);
    }

    public static void icon_x(ByteBuffer xwmhints, int icon_x) {
        xwmhints.putInt(xwmhints.position() + ICON_X, icon_x);
    }

    public static void icon_y(ByteBuffer xwmhints, int icon_y) {
        xwmhints.putInt(xwmhints.position() + ICON_Y, icon_y);
    }

    public static void icon_mask(ByteBuffer xwmhints, long icon_mask) {
        PointerBuffer.put(xwmhints, xwmhints.position() + ICON_MASK, icon_mask);
    }

    public static void window_group(ByteBuffer xwmhints, long window_group) {
        PointerBuffer.put(xwmhints, xwmhints.position() + WINDOW_GROUP, window_group);
    }

    public static long flags(ByteBuffer xwmhints) {
        return PointerBuffer.get(xwmhints, xwmhints.position() + FLAGS);
    }

    public static int input(ByteBuffer xwmhints) {
        return xwmhints.getInt(xwmhints.position() + INPUT);
    }

    public static int initial_state(ByteBuffer xwmhints) {
        return xwmhints.getInt(xwmhints.position() + INITIAL_STATE);
    }

    public static long icon_pixmap(ByteBuffer xwmhints) {
        return PointerBuffer.get(xwmhints, xwmhints.position() + ICON_PIXMAP);
    }

    public static long icon_window(ByteBuffer xwmhints) {
        return PointerBuffer.get(xwmhints, xwmhints.position() + ICON_WINDOW);
    }

    public static int icon_x(ByteBuffer xwmhints) {
        return xwmhints.getInt(xwmhints.position() + ICON_X);
    }

    public static int icon_y(ByteBuffer xwmhints) {
        return xwmhints.getInt(xwmhints.position() + ICON_Y);
    }

    public static long icon_mask(ByteBuffer xwmhints) {
        return PointerBuffer.get(xwmhints, xwmhints.position() + ICON_MASK);
    }

    public static long window_group(ByteBuffer xwmhints) {
        return PointerBuffer.get(xwmhints, xwmhints.position() + WINDOW_GROUP);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(9);
        SIZEOF = XWMHints.offsets(MemoryUtil.memAddress(offsets));
        FLAGS = offsets.get(0);
        INPUT = offsets.get(1);
        INITIAL_STATE = offsets.get(2);
        ICON_PIXMAP = offsets.get(3);
        ICON_WINDOW = offsets.get(4);
        ICON_X = offsets.get(5);
        ICON_Y = offsets.get(6);
        ICON_MASK = offsets.get(7);
        WINDOW_GROUP = offsets.get(8);
    }
}

