/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XRRModeInfo;

public final class XRRScreenResources
implements Pointer {
    public static final int SIZEOF;
    public static final int TIMESTAMP;
    public static final int CONFIGTIMESTAMP;
    public static final int NCRTC;
    public static final int CRTCS;
    public static final int NOUTPUT;
    public static final int OUTPUTS;
    public static final int NMODE;
    public static final int MODES;
    private final ByteBuffer struct;

    public XRRScreenResources() {
        this(XRRScreenResources.malloc());
    }

    public XRRScreenResources(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setTimestamp(long timestamp) {
        XRRScreenResources.timestamp(this.struct, timestamp);
    }

    public void setConfigTimestamp(long configTimestamp) {
        XRRScreenResources.configTimestamp(this.struct, configTimestamp);
    }

    public void setNcrtc(int ncrtc) {
        XRRScreenResources.ncrtc(this.struct, ncrtc);
    }

    public void setCrtcs(long crtcs) {
        XRRScreenResources.crtcs(this.struct, crtcs);
    }

    public void setCrtcs(ByteBuffer crtcs) {
        XRRScreenResources.crtcs(this.struct, crtcs);
    }

    public void setNoutput(int noutput) {
        XRRScreenResources.noutput(this.struct, noutput);
    }

    public void setOutputs(long outputs) {
        XRRScreenResources.outputs(this.struct, outputs);
    }

    public void setOutputs(ByteBuffer outputs) {
        XRRScreenResources.outputs(this.struct, outputs);
    }

    public void setNmode(int nmode) {
        XRRScreenResources.nmode(this.struct, nmode);
    }

    public void setModes(long modes) {
        XRRScreenResources.modes(this.struct, modes);
    }

    public void setModes(ByteBuffer modes) {
        XRRScreenResources.modes(this.struct, modes);
    }

    public long getTimestamp() {
        return XRRScreenResources.timestamp(this.struct);
    }

    public long getConfigTimestamp() {
        return XRRScreenResources.configTimestamp(this.struct);
    }

    public int getNcrtc() {
        return XRRScreenResources.ncrtc(this.struct);
    }

    public long getCrtcs() {
        return XRRScreenResources.crtcs(this.struct);
    }

    public ByteBuffer getCrtcs(int byteLen) {
        return XRRScreenResources.crtcs(this.struct, byteLen);
    }

    public int getNoutput() {
        return XRRScreenResources.noutput(this.struct);
    }

    public long getOutputs() {
        return XRRScreenResources.outputs(this.struct);
    }

    public ByteBuffer getOutputs(int byteLen) {
        return XRRScreenResources.outputs(this.struct, byteLen);
    }

    public int getNmode() {
        return XRRScreenResources.nmode(this.struct);
    }

    public long getModes() {
        return XRRScreenResources.modes(this.struct);
    }

    public ByteBuffer getModesBuffer() {
        return XRRScreenResources.modesBuffer(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long timestamp, long configTimestamp, int ncrtc, ByteBuffer crtcs, int noutput, ByteBuffer outputs, int nmode, ByteBuffer modes) {
        ByteBuffer xrrscreenresources = XRRScreenResources.malloc();
        XRRScreenResources.timestamp(xrrscreenresources, timestamp);
        XRRScreenResources.configTimestamp(xrrscreenresources, configTimestamp);
        XRRScreenResources.ncrtc(xrrscreenresources, ncrtc);
        XRRScreenResources.crtcs(xrrscreenresources, crtcs);
        XRRScreenResources.noutput(xrrscreenresources, noutput);
        XRRScreenResources.outputs(xrrscreenresources, outputs);
        XRRScreenResources.nmode(xrrscreenresources, nmode);
        XRRScreenResources.modes(xrrscreenresources, modes);
        return xrrscreenresources;
    }

    public static void timestamp(ByteBuffer xrrscreenresources, long timestamp) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + TIMESTAMP, timestamp);
    }

    public static void configTimestamp(ByteBuffer xrrscreenresources, long configTimestamp) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + CONFIGTIMESTAMP, configTimestamp);
    }

    public static void ncrtc(ByteBuffer xrrscreenresources, int ncrtc) {
        xrrscreenresources.putInt(xrrscreenresources.position() + NCRTC, ncrtc);
    }

    public static void crtcs(ByteBuffer xrrscreenresources, long crtcs) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + CRTCS, crtcs);
    }

    public static void crtcs(ByteBuffer xrrscreenresources, ByteBuffer crtcs) {
        XRRScreenResources.crtcs(xrrscreenresources, MemoryUtil.memAddressSafe(crtcs));
    }

    public static void noutput(ByteBuffer xrrscreenresources, int noutput) {
        xrrscreenresources.putInt(xrrscreenresources.position() + NOUTPUT, noutput);
    }

    public static void outputs(ByteBuffer xrrscreenresources, long outputs) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + OUTPUTS, outputs);
    }

    public static void outputs(ByteBuffer xrrscreenresources, ByteBuffer outputs) {
        XRRScreenResources.outputs(xrrscreenresources, MemoryUtil.memAddressSafe(outputs));
    }

    public static void nmode(ByteBuffer xrrscreenresources, int nmode) {
        xrrscreenresources.putInt(xrrscreenresources.position() + NMODE, nmode);
    }

    public static void modes(ByteBuffer xrrscreenresources, long modes) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + MODES, modes);
    }

    public static void modes(ByteBuffer xrrscreenresources, ByteBuffer modes) {
        XRRScreenResources.modes(xrrscreenresources, MemoryUtil.memAddressSafe(modes));
    }

    public static long timestamp(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + TIMESTAMP);
    }

    public static long configTimestamp(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + CONFIGTIMESTAMP);
    }

    public static int ncrtc(ByteBuffer xrrscreenresources) {
        return xrrscreenresources.getInt(xrrscreenresources.position() + NCRTC);
    }

    public static long crtcs(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + CRTCS);
    }

    public static ByteBuffer crtcs(ByteBuffer xrrscreenresources, int byteLen) {
        return MemoryUtil.memByteBuffer(XRRScreenResources.crtcs(xrrscreenresources), byteLen);
    }

    public static int noutput(ByteBuffer xrrscreenresources) {
        return xrrscreenresources.getInt(xrrscreenresources.position() + NOUTPUT);
    }

    public static long outputs(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + OUTPUTS);
    }

    public static ByteBuffer outputs(ByteBuffer xrrscreenresources, int byteLen) {
        return MemoryUtil.memByteBuffer(XRRScreenResources.outputs(xrrscreenresources), byteLen);
    }

    public static int nmode(ByteBuffer xrrscreenresources) {
        return xrrscreenresources.getInt(xrrscreenresources.position() + NMODE);
    }

    public static long modes(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + MODES);
    }

    public static ByteBuffer modesBuffer(ByteBuffer xrrscreenresources) {
        return MemoryUtil.memByteBuffer(XRRScreenResources.modes(xrrscreenresources), XRRModeInfo.SIZEOF);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(8);
        SIZEOF = XRRScreenResources.offsets(MemoryUtil.memAddress(offsets));
        TIMESTAMP = offsets.get(0);
        CONFIGTIMESTAMP = offsets.get(1);
        NCRTC = offsets.get(2);
        CRTCS = offsets.get(3);
        NOUTPUT = offsets.get(4);
        OUTPUTS = offsets.get(5);
        NMODE = offsets.get(6);
        MODES = offsets.get(7);
    }
}

