/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XIButtonState;
import org.lwjgl.system.linux.XIModifierState;
import org.lwjgl.system.linux.XIValuatorState;

public final class XIDeviceEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EXTENSION;
    public static final int EVTYPE;
    public static final int TIME;
    public static final int DEVICEID;
    public static final int SOURCEID;
    public static final int DETAIL;
    public static final int ROOT;
    public static final int EVENT;
    public static final int CHILD;
    public static final int ROOT_X;
    public static final int ROOT_Y;
    public static final int EVENT_X;
    public static final int EVENT_Y;
    public static final int FLAGS;
    public static final int BUTTONS;
    public static final int VALUATORS;
    public static final int MODS;
    public static final int GROUP;
    private final ByteBuffer struct;

    public XIDeviceEvent() {
        this(XIDeviceEvent.malloc());
    }

    public XIDeviceEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XIDeviceEvent.type(this.struct, type);
    }

    public void setSerial(long serial) {
        XIDeviceEvent.serial(this.struct, serial);
    }

    public void setSendEvent(int send_event) {
        XIDeviceEvent.send_event(this.struct, send_event);
    }

    public void setDisplay(long display) {
        XIDeviceEvent.display(this.struct, display);
    }

    public void setExtension(int extension) {
        XIDeviceEvent.extension(this.struct, extension);
    }

    public void setEvtype(int evtype) {
        XIDeviceEvent.evtype(this.struct, evtype);
    }

    public void setTime(long time) {
        XIDeviceEvent.time(this.struct, time);
    }

    public void setDeviceid(int deviceid) {
        XIDeviceEvent.deviceid(this.struct, deviceid);
    }

    public void setSourceid(int sourceid) {
        XIDeviceEvent.sourceid(this.struct, sourceid);
    }

    public void setDetail(int detail) {
        XIDeviceEvent.detail(this.struct, detail);
    }

    public void setRoot(long root) {
        XIDeviceEvent.root(this.struct, root);
    }

    public void setEvent(long event) {
        XIDeviceEvent.event(this.struct, event);
    }

    public void setChild(long child) {
        XIDeviceEvent.child(this.struct, child);
    }

    public void setRootX(double root_x) {
        XIDeviceEvent.root_x(this.struct, root_x);
    }

    public void setRootY(double root_y) {
        XIDeviceEvent.root_y(this.struct, root_y);
    }

    public void setEventX(double event_x) {
        XIDeviceEvent.event_x(this.struct, event_x);
    }

    public void setEventY(double event_y) {
        XIDeviceEvent.event_y(this.struct, event_y);
    }

    public void setFlags(int flags) {
        XIDeviceEvent.flags(this.struct, flags);
    }

    public void setButtons(ByteBuffer buttons) {
        XIDeviceEvent.buttonsSet(this.struct, buttons);
    }

    public void setButtonsMaskLen(int mask_len) {
        XIDeviceEvent.buttonsMask_len(this.struct, mask_len);
    }

    public void setButtonsMask(long mask) {
        XIDeviceEvent.buttonsMask(this.struct, mask);
    }

    public void setButtonsMask(ByteBuffer mask) {
        XIDeviceEvent.buttonsMask(this.struct, mask);
    }

    public void setValuators(ByteBuffer valuators) {
        XIDeviceEvent.valuatorsSet(this.struct, valuators);
    }

    public void setValuatorsMaskLen(int mask_len) {
        XIDeviceEvent.valuatorsMask_len(this.struct, mask_len);
    }

    public void setValuatorsMask(long mask) {
        XIDeviceEvent.valuatorsMask(this.struct, mask);
    }

    public void setValuatorsMask(ByteBuffer mask) {
        XIDeviceEvent.valuatorsMask(this.struct, mask);
    }

    public void setValuatorsValues(long values) {
        XIDeviceEvent.valuatorsValues(this.struct, values);
    }

    public void setValuatorsValues(ByteBuffer values) {
        XIDeviceEvent.valuatorsValues(this.struct, values);
    }

    public void setMods(ByteBuffer mods) {
        XIDeviceEvent.modsSet(this.struct, mods);
    }

    public void setModsBase(int base) {
        XIDeviceEvent.modsBase(this.struct, base);
    }

    public void setModsLatched(int latched) {
        XIDeviceEvent.modsLatched(this.struct, latched);
    }

    public void setModsLocked(int locked) {
        XIDeviceEvent.modsLocked(this.struct, locked);
    }

    public void setModsEffective(int effective) {
        XIDeviceEvent.modsEffective(this.struct, effective);
    }

    public void setGroup(ByteBuffer group) {
        XIDeviceEvent.groupSet(this.struct, group);
    }

    public void setGroupBase(int base) {
        XIDeviceEvent.groupBase(this.struct, base);
    }

    public void setGroupLatched(int latched) {
        XIDeviceEvent.groupLatched(this.struct, latched);
    }

    public void setGroupLocked(int locked) {
        XIDeviceEvent.groupLocked(this.struct, locked);
    }

    public void setGroupEffective(int effective) {
        XIDeviceEvent.groupEffective(this.struct, effective);
    }

    public int getType() {
        return XIDeviceEvent.type(this.struct);
    }

    public long getSerial() {
        return XIDeviceEvent.serial(this.struct);
    }

    public int getSendEvent() {
        return XIDeviceEvent.send_event(this.struct);
    }

    public long getDisplay() {
        return XIDeviceEvent.display(this.struct);
    }

    public int getExtension() {
        return XIDeviceEvent.extension(this.struct);
    }

    public int getEvtype() {
        return XIDeviceEvent.evtype(this.struct);
    }

    public long getTime() {
        return XIDeviceEvent.time(this.struct);
    }

    public int getDeviceid() {
        return XIDeviceEvent.deviceid(this.struct);
    }

    public int getSourceid() {
        return XIDeviceEvent.sourceid(this.struct);
    }

    public int getDetail() {
        return XIDeviceEvent.detail(this.struct);
    }

    public long getRoot() {
        return XIDeviceEvent.root(this.struct);
    }

    public long getEvent() {
        return XIDeviceEvent.event(this.struct);
    }

    public long getChild() {
        return XIDeviceEvent.child(this.struct);
    }

    public double getRootX() {
        return XIDeviceEvent.root_x(this.struct);
    }

    public double getRootY() {
        return XIDeviceEvent.root_y(this.struct);
    }

    public double getEventX() {
        return XIDeviceEvent.event_x(this.struct);
    }

    public double getEventY() {
        return XIDeviceEvent.event_y(this.struct);
    }

    public int getFlags() {
        return XIDeviceEvent.flags(this.struct);
    }

    public void getButtons(ByteBuffer buttons) {
        XIDeviceEvent.buttonsGet(this.struct, buttons);
    }

    public int getButtonsMaskLen() {
        return XIDeviceEvent.buttonsMask_len(this.struct);
    }

    public long getButtonsMask() {
        return XIDeviceEvent.buttonsMask(this.struct);
    }

    public ByteBuffer getButtonsMask(int byteLen) {
        return XIDeviceEvent.buttonsMask(this.struct, byteLen);
    }

    public void getValuators(ByteBuffer valuators) {
        XIDeviceEvent.valuatorsGet(this.struct, valuators);
    }

    public int getValuatorsMaskLen() {
        return XIDeviceEvent.valuatorsMask_len(this.struct);
    }

    public long getValuatorsMask() {
        return XIDeviceEvent.valuatorsMask(this.struct);
    }

    public ByteBuffer getValuatorsMask(int byteLen) {
        return XIDeviceEvent.valuatorsMask(this.struct, byteLen);
    }

    public long getValuatorsValues() {
        return XIDeviceEvent.valuatorsValues(this.struct);
    }

    public ByteBuffer getValuatorsValues(int byteLen) {
        return XIDeviceEvent.valuatorsValues(this.struct, byteLen);
    }

    public void getMods(ByteBuffer mods) {
        XIDeviceEvent.modsGet(this.struct, mods);
    }

    public int getModsBase() {
        return XIDeviceEvent.modsBase(this.struct);
    }

    public int getModsLatched() {
        return XIDeviceEvent.modsLatched(this.struct);
    }

    public int getModsLocked() {
        return XIDeviceEvent.modsLocked(this.struct);
    }

    public int getModsEffective() {
        return XIDeviceEvent.modsEffective(this.struct);
    }

    public void getGroup(ByteBuffer group) {
        XIDeviceEvent.groupGet(this.struct, group);
    }

    public int getGroupBase() {
        return XIDeviceEvent.groupBase(this.struct);
    }

    public int getGroupLatched() {
        return XIDeviceEvent.groupLatched(this.struct);
    }

    public int getGroupLocked() {
        return XIDeviceEvent.groupLocked(this.struct);
    }

    public int getGroupEffective() {
        return XIDeviceEvent.groupEffective(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, int extension, int evtype, long time, int deviceid, int sourceid, int detail, long root, long event, long child, double root_x, double root_y, double event_x, double event_y, int flags, ByteBuffer buttons, ByteBuffer valuators, ByteBuffer mods, ByteBuffer group) {
        ByteBuffer xideviceevent = XIDeviceEvent.malloc();
        XIDeviceEvent.type(xideviceevent, type);
        XIDeviceEvent.serial(xideviceevent, serial);
        XIDeviceEvent.send_event(xideviceevent, send_event);
        XIDeviceEvent.display(xideviceevent, display);
        XIDeviceEvent.extension(xideviceevent, extension);
        XIDeviceEvent.evtype(xideviceevent, evtype);
        XIDeviceEvent.time(xideviceevent, time);
        XIDeviceEvent.deviceid(xideviceevent, deviceid);
        XIDeviceEvent.sourceid(xideviceevent, sourceid);
        XIDeviceEvent.detail(xideviceevent, detail);
        XIDeviceEvent.root(xideviceevent, root);
        XIDeviceEvent.event(xideviceevent, event);
        XIDeviceEvent.child(xideviceevent, child);
        XIDeviceEvent.root_x(xideviceevent, root_x);
        XIDeviceEvent.root_y(xideviceevent, root_y);
        XIDeviceEvent.event_x(xideviceevent, event_x);
        XIDeviceEvent.event_y(xideviceevent, event_y);
        XIDeviceEvent.flags(xideviceevent, flags);
        XIDeviceEvent.buttonsSet(xideviceevent, buttons);
        XIDeviceEvent.valuatorsSet(xideviceevent, valuators);
        XIDeviceEvent.modsSet(xideviceevent, mods);
        XIDeviceEvent.groupSet(xideviceevent, group);
        return xideviceevent;
    }

    public static void type(ByteBuffer xideviceevent, int type) {
        xideviceevent.putInt(xideviceevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xideviceevent, long serial) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xideviceevent, int send_event) {
        xideviceevent.putInt(xideviceevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xideviceevent, long display) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + DISPLAY, display);
    }

    public static void extension(ByteBuffer xideviceevent, int extension) {
        xideviceevent.putInt(xideviceevent.position() + EXTENSION, extension);
    }

    public static void evtype(ByteBuffer xideviceevent, int evtype) {
        xideviceevent.putInt(xideviceevent.position() + EVTYPE, evtype);
    }

    public static void time(ByteBuffer xideviceevent, long time) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + TIME, time);
    }

    public static void deviceid(ByteBuffer xideviceevent, int deviceid) {
        xideviceevent.putInt(xideviceevent.position() + DEVICEID, deviceid);
    }

    public static void sourceid(ByteBuffer xideviceevent, int sourceid) {
        xideviceevent.putInt(xideviceevent.position() + SOURCEID, sourceid);
    }

    public static void detail(ByteBuffer xideviceevent, int detail) {
        xideviceevent.putInt(xideviceevent.position() + DETAIL, detail);
    }

    public static void root(ByteBuffer xideviceevent, long root) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + ROOT, root);
    }

    public static void event(ByteBuffer xideviceevent, long event) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + EVENT, event);
    }

    public static void child(ByteBuffer xideviceevent, long child) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + CHILD, child);
    }

    public static void root_x(ByteBuffer xideviceevent, double root_x) {
        xideviceevent.putDouble(xideviceevent.position() + ROOT_X, root_x);
    }

    public static void root_y(ByteBuffer xideviceevent, double root_y) {
        xideviceevent.putDouble(xideviceevent.position() + ROOT_Y, root_y);
    }

    public static void event_x(ByteBuffer xideviceevent, double event_x) {
        xideviceevent.putDouble(xideviceevent.position() + EVENT_X, event_x);
    }

    public static void event_y(ByteBuffer xideviceevent, double event_y) {
        xideviceevent.putDouble(xideviceevent.position() + EVENT_Y, event_y);
    }

    public static void flags(ByteBuffer xideviceevent, int flags) {
        xideviceevent.putInt(xideviceevent.position() + FLAGS, flags);
    }

    public static void buttonsSet(ByteBuffer xideviceevent, ByteBuffer buttons) {
        if (buttons != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(buttons), MemoryUtil.memAddress(xideviceevent) + (long)BUTTONS, XIButtonState.SIZEOF);
        }
    }

    public static void buttonsMask_len(ByteBuffer xideviceevent, int mask_len) {
        xideviceevent.putInt(xideviceevent.position() + BUTTONS + XIButtonState.MASK_LEN, mask_len);
    }

    public static void buttonsMask(ByteBuffer xideviceevent, long mask) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + BUTTONS + XIButtonState.MASK, mask);
    }

    public static void buttonsMask(ByteBuffer xideviceevent, ByteBuffer mask) {
        XIDeviceEvent.buttonsMask(xideviceevent, MemoryUtil.memAddressSafe(mask));
    }

    public static void valuatorsSet(ByteBuffer xideviceevent, ByteBuffer valuators) {
        if (valuators != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(valuators), MemoryUtil.memAddress(xideviceevent) + (long)VALUATORS, XIValuatorState.SIZEOF);
        }
    }

    public static void valuatorsMask_len(ByteBuffer xideviceevent, int mask_len) {
        xideviceevent.putInt(xideviceevent.position() + VALUATORS + XIValuatorState.MASK_LEN, mask_len);
    }

    public static void valuatorsMask(ByteBuffer xideviceevent, long mask) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + VALUATORS + XIValuatorState.MASK, mask);
    }

    public static void valuatorsMask(ByteBuffer xideviceevent, ByteBuffer mask) {
        XIDeviceEvent.valuatorsMask(xideviceevent, MemoryUtil.memAddressSafe(mask));
    }

    public static void valuatorsValues(ByteBuffer xideviceevent, long values) {
        PointerBuffer.put(xideviceevent, xideviceevent.position() + VALUATORS + XIValuatorState.VALUES, values);
    }

    public static void valuatorsValues(ByteBuffer xideviceevent, ByteBuffer values) {
        XIDeviceEvent.valuatorsValues(xideviceevent, MemoryUtil.memAddressSafe(values));
    }

    public static void modsSet(ByteBuffer xideviceevent, ByteBuffer mods) {
        if (mods != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(mods), MemoryUtil.memAddress(xideviceevent) + (long)MODS, XIModifierState.SIZEOF);
        }
    }

    public static void modsBase(ByteBuffer xideviceevent, int base) {
        xideviceevent.putInt(xideviceevent.position() + MODS + XIModifierState.BASE, base);
    }

    public static void modsLatched(ByteBuffer xideviceevent, int latched) {
        xideviceevent.putInt(xideviceevent.position() + MODS + XIModifierState.LATCHED, latched);
    }

    public static void modsLocked(ByteBuffer xideviceevent, int locked) {
        xideviceevent.putInt(xideviceevent.position() + MODS + XIModifierState.LOCKED, locked);
    }

    public static void modsEffective(ByteBuffer xideviceevent, int effective) {
        xideviceevent.putInt(xideviceevent.position() + MODS + XIModifierState.EFFECTIVE, effective);
    }

    public static void groupSet(ByteBuffer xideviceevent, ByteBuffer group) {
        if (group != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(group), MemoryUtil.memAddress(xideviceevent) + (long)GROUP, XIModifierState.SIZEOF);
        }
    }

    public static void groupBase(ByteBuffer xideviceevent, int base) {
        xideviceevent.putInt(xideviceevent.position() + GROUP + XIModifierState.BASE, base);
    }

    public static void groupLatched(ByteBuffer xideviceevent, int latched) {
        xideviceevent.putInt(xideviceevent.position() + GROUP + XIModifierState.LATCHED, latched);
    }

    public static void groupLocked(ByteBuffer xideviceevent, int locked) {
        xideviceevent.putInt(xideviceevent.position() + GROUP + XIModifierState.LOCKED, locked);
    }

    public static void groupEffective(ByteBuffer xideviceevent, int effective) {
        xideviceevent.putInt(xideviceevent.position() + GROUP + XIModifierState.EFFECTIVE, effective);
    }

    public static int type(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + DISPLAY);
    }

    public static int extension(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + EXTENSION);
    }

    public static int evtype(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + EVTYPE);
    }

    public static long time(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + TIME);
    }

    public static int deviceid(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + DEVICEID);
    }

    public static int sourceid(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + SOURCEID);
    }

    public static int detail(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + DETAIL);
    }

    public static long root(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + ROOT);
    }

    public static long event(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + EVENT);
    }

    public static long child(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + CHILD);
    }

    public static double root_x(ByteBuffer xideviceevent) {
        return xideviceevent.getDouble(xideviceevent.position() + ROOT_X);
    }

    public static double root_y(ByteBuffer xideviceevent) {
        return xideviceevent.getDouble(xideviceevent.position() + ROOT_Y);
    }

    public static double event_x(ByteBuffer xideviceevent) {
        return xideviceevent.getDouble(xideviceevent.position() + EVENT_X);
    }

    public static double event_y(ByteBuffer xideviceevent) {
        return xideviceevent.getDouble(xideviceevent.position() + EVENT_Y);
    }

    public static int flags(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + FLAGS);
    }

    public static void buttonsGet(ByteBuffer xideviceevent, ByteBuffer buttons) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buttons, XIButtonState.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xideviceevent) + (long)BUTTONS, MemoryUtil.memAddress(buttons), XIButtonState.SIZEOF);
    }

    public static int buttonsMask_len(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + BUTTONS + XIButtonState.MASK_LEN);
    }

    public static long buttonsMask(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + BUTTONS + XIButtonState.MASK);
    }

    public static ByteBuffer buttonsMask(ByteBuffer xideviceevent, int byteLen) {
        return MemoryUtil.memByteBuffer(XIDeviceEvent.buttonsMask(xideviceevent), byteLen);
    }

    public static void valuatorsGet(ByteBuffer xideviceevent, ByteBuffer valuators) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)valuators, XIValuatorState.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xideviceevent) + (long)VALUATORS, MemoryUtil.memAddress(valuators), XIValuatorState.SIZEOF);
    }

    public static int valuatorsMask_len(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + VALUATORS + XIValuatorState.MASK_LEN);
    }

    public static long valuatorsMask(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + VALUATORS + XIValuatorState.MASK);
    }

    public static ByteBuffer valuatorsMask(ByteBuffer xideviceevent, int byteLen) {
        return MemoryUtil.memByteBuffer(XIDeviceEvent.valuatorsMask(xideviceevent), byteLen);
    }

    public static long valuatorsValues(ByteBuffer xideviceevent) {
        return PointerBuffer.get(xideviceevent, xideviceevent.position() + VALUATORS + XIValuatorState.VALUES);
    }

    public static ByteBuffer valuatorsValues(ByteBuffer xideviceevent, int byteLen) {
        return MemoryUtil.memByteBuffer(XIDeviceEvent.valuatorsValues(xideviceevent), byteLen);
    }

    public static void modsGet(ByteBuffer xideviceevent, ByteBuffer mods) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mods, XIModifierState.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xideviceevent) + (long)MODS, MemoryUtil.memAddress(mods), XIModifierState.SIZEOF);
    }

    public static int modsBase(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + MODS + XIModifierState.BASE);
    }

    public static int modsLatched(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + MODS + XIModifierState.LATCHED);
    }

    public static int modsLocked(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + MODS + XIModifierState.LOCKED);
    }

    public static int modsEffective(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + MODS + XIModifierState.EFFECTIVE);
    }

    public static void groupGet(ByteBuffer xideviceevent, ByteBuffer group) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)group, XIModifierState.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xideviceevent) + (long)GROUP, MemoryUtil.memAddress(group), XIModifierState.SIZEOF);
    }

    public static int groupBase(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + GROUP + XIModifierState.BASE);
    }

    public static int groupLatched(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + GROUP + XIModifierState.LATCHED);
    }

    public static int groupLocked(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + GROUP + XIModifierState.LOCKED);
    }

    public static int groupEffective(ByteBuffer xideviceevent) {
        return xideviceevent.getInt(xideviceevent.position() + GROUP + XIModifierState.EFFECTIVE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(22);
        SIZEOF = XIDeviceEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        EXTENSION = offsets.get(4);
        EVTYPE = offsets.get(5);
        TIME = offsets.get(6);
        DEVICEID = offsets.get(7);
        SOURCEID = offsets.get(8);
        DETAIL = offsets.get(9);
        ROOT = offsets.get(10);
        EVENT = offsets.get(11);
        CHILD = offsets.get(12);
        ROOT_X = offsets.get(13);
        ROOT_Y = offsets.get(14);
        EVENT_X = offsets.get(15);
        EVENT_Y = offsets.get(16);
        FLAGS = offsets.get(17);
        BUTTONS = offsets.get(18);
        VALUATORS = offsets.get(19);
        MODS = offsets.get(20);
        GROUP = offsets.get(21);
    }
}

