/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XGenericEventCookie
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EXTENSION;
    public static final int EVTYPE;
    public static final int COOKIE;
    public static final int DATA;
    private final ByteBuffer struct;

    public XGenericEventCookie() {
        this(XGenericEventCookie.malloc());
    }

    public XGenericEventCookie(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XGenericEventCookie.type(this.struct, type);
    }

    public void setSerial(long serial) {
        XGenericEventCookie.serial(this.struct, serial);
    }

    public void setSendEvent(int send_event) {
        XGenericEventCookie.send_event(this.struct, send_event);
    }

    public void setDisplay(long display) {
        XGenericEventCookie.display(this.struct, display);
    }

    public void setExtension(int extension) {
        XGenericEventCookie.extension(this.struct, extension);
    }

    public void setEvtype(int evtype) {
        XGenericEventCookie.evtype(this.struct, evtype);
    }

    public void setCookie(int cookie) {
        XGenericEventCookie.cookie(this.struct, cookie);
    }

    public void setData(long data) {
        XGenericEventCookie.data(this.struct, data);
    }

    public void setData(ByteBuffer data) {
        XGenericEventCookie.data(this.struct, data);
    }

    public int getType() {
        return XGenericEventCookie.type(this.struct);
    }

    public long getSerial() {
        return XGenericEventCookie.serial(this.struct);
    }

    public int getSendEvent() {
        return XGenericEventCookie.send_event(this.struct);
    }

    public long getDisplay() {
        return XGenericEventCookie.display(this.struct);
    }

    public int getExtension() {
        return XGenericEventCookie.extension(this.struct);
    }

    public int getEvtype() {
        return XGenericEventCookie.evtype(this.struct);
    }

    public int getCookie() {
        return XGenericEventCookie.cookie(this.struct);
    }

    public long getData() {
        return XGenericEventCookie.data(this.struct);
    }

    public ByteBuffer getData(int byteLen) {
        return XGenericEventCookie.data(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, int extension, int evtype, int cookie, ByteBuffer data) {
        ByteBuffer xgenericeventcookie = XGenericEventCookie.malloc();
        XGenericEventCookie.type(xgenericeventcookie, type);
        XGenericEventCookie.serial(xgenericeventcookie, serial);
        XGenericEventCookie.send_event(xgenericeventcookie, send_event);
        XGenericEventCookie.display(xgenericeventcookie, display);
        XGenericEventCookie.extension(xgenericeventcookie, extension);
        XGenericEventCookie.evtype(xgenericeventcookie, evtype);
        XGenericEventCookie.cookie(xgenericeventcookie, cookie);
        XGenericEventCookie.data(xgenericeventcookie, data);
        return xgenericeventcookie;
    }

    public static void type(ByteBuffer xgenericeventcookie, int type) {
        xgenericeventcookie.putInt(xgenericeventcookie.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xgenericeventcookie, long serial) {
        PointerBuffer.put(xgenericeventcookie, xgenericeventcookie.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xgenericeventcookie, int send_event) {
        xgenericeventcookie.putInt(xgenericeventcookie.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xgenericeventcookie, long display) {
        PointerBuffer.put(xgenericeventcookie, xgenericeventcookie.position() + DISPLAY, display);
    }

    public static void extension(ByteBuffer xgenericeventcookie, int extension) {
        xgenericeventcookie.putInt(xgenericeventcookie.position() + EXTENSION, extension);
    }

    public static void evtype(ByteBuffer xgenericeventcookie, int evtype) {
        xgenericeventcookie.putInt(xgenericeventcookie.position() + EVTYPE, evtype);
    }

    public static void cookie(ByteBuffer xgenericeventcookie, int cookie) {
        xgenericeventcookie.putInt(xgenericeventcookie.position() + COOKIE, cookie);
    }

    public static void data(ByteBuffer xgenericeventcookie, long data) {
        PointerBuffer.put(xgenericeventcookie, xgenericeventcookie.position() + DATA, data);
    }

    public static void data(ByteBuffer xgenericeventcookie, ByteBuffer data) {
        XGenericEventCookie.data(xgenericeventcookie, MemoryUtil.memAddressSafe(data));
    }

    public static int type(ByteBuffer xgenericeventcookie) {
        return xgenericeventcookie.getInt(xgenericeventcookie.position() + TYPE);
    }

    public static long serial(ByteBuffer xgenericeventcookie) {
        return PointerBuffer.get(xgenericeventcookie, xgenericeventcookie.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xgenericeventcookie) {
        return xgenericeventcookie.getInt(xgenericeventcookie.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xgenericeventcookie) {
        return PointerBuffer.get(xgenericeventcookie, xgenericeventcookie.position() + DISPLAY);
    }

    public static int extension(ByteBuffer xgenericeventcookie) {
        return xgenericeventcookie.getInt(xgenericeventcookie.position() + EXTENSION);
    }

    public static int evtype(ByteBuffer xgenericeventcookie) {
        return xgenericeventcookie.getInt(xgenericeventcookie.position() + EVTYPE);
    }

    public static int cookie(ByteBuffer xgenericeventcookie) {
        return xgenericeventcookie.getInt(xgenericeventcookie.position() + COOKIE);
    }

    public static long data(ByteBuffer xgenericeventcookie) {
        return PointerBuffer.get(xgenericeventcookie, xgenericeventcookie.position() + DATA);
    }

    public static ByteBuffer data(ByteBuffer xgenericeventcookie, int byteLen) {
        return MemoryUtil.memByteBuffer(XGenericEventCookie.data(xgenericeventcookie), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(8);
        SIZEOF = XGenericEventCookie.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        EXTENSION = offsets.get(4);
        EVTYPE = offsets.get(5);
        COOKIE = offsets.get(6);
        DATA = offsets.get(7);
    }
}

