/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class Fcntl {
    public static final int O_ACCMODE = 3;
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 256;
    public static final int O_EXCL = 512;
    public static final int O_NOCTTY = 1024;
    public static final int O_TRUNC = 4096;
    public static final int O_APPEND = 8192;
    public static final int O_NONBLOCK = 16384;
    public static final int O_DSYNC = 65536;
    public static final int FASYNC = 131072;
    public static final int O_DIRECT = 262144;
    public static final int O_LARGEFILE = 0x100000;
    public static final int O_DIRECTORY = 0x200000;
    public static final int O_NOFOLLOW = 0x400000;
    public static final int O_NOATIME = 0x1000000;
    public static final int O_CLOEXEC = 0x2000000;

    private Fcntl() {
    }

    public static native int nopen(long var0, int var2);

    public static int open(ByteBuffer pathname, int flags) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(pathname);
        }
        return Fcntl.nopen(MemoryUtil.memAddress(pathname), flags);
    }

    public static int open(CharSequence pathname, int flags) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pathnameEncoded = __buffer.stringParamASCII(pathname, true);
        return Fcntl.nopen(__buffer.address(pathnameEncoded), flags);
    }

    static {
        LWJGLUtil.initialize();
    }
}

