/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIClosure;
import org.lwjgl.system.libffi.LibFFIConstants;

public final class LibFFI {
    public static final short FFI_TYPE_VOID = 0;
    public static final short FFI_TYPE_INT = 1;
    public static final short FFI_TYPE_FLOAT = 2;
    public static final short FFI_TYPE_DOUBLE = 3;
    public static final short FFI_TYPE_LONGDOUBLE = LibFFIConstants.FFI_TYPE_DOUBLE();
    public static final short FFI_TYPE_UINT8 = 5;
    public static final short FFI_TYPE_SINT8 = 6;
    public static final short FFI_TYPE_UINT16 = 7;
    public static final short FFI_TYPE_SINT16 = 8;
    public static final short FFI_TYPE_UINT32 = 9;
    public static final short FFI_TYPE_SINT32 = 10;
    public static final short FFI_TYPE_UINT64 = 11;
    public static final short FFI_TYPE_SINT64 = 12;
    public static final short FFI_TYPE_STRUCT = 13;
    public static final short FFI_TYPE_POINTER = 14;
    public static final int FFI_SYSV = 1;
    public static final int FFI_STDCALL = 2;
    public static final int FFI_THISCALL = 3;
    public static final int FFI_FASTCALL = 4;
    public static final int FFI_MS_CDECL = 5;
    public static final int FFI_WIN64 = 1;
    public static final int FFI_UNIX64 = 2;
    public static final int FFI_DEFAULT_ABI = LibFFIConstants.FFI_DEFAULT_ABI();
    public static final int FFI_OK = 0;
    public static final int FFI_BAD_TYPEDEF = 1;
    public static final int FFI_BAD_ABI = 2;
    public static final long ffi_type_void = LibFFIConstants.ffi_type_void();
    public static final long ffi_type_uint8 = LibFFIConstants.ffi_type_uint8();
    public static final long ffi_type_sint8 = LibFFIConstants.ffi_type_sint8();
    public static final long ffi_type_uint16 = LibFFIConstants.ffi_type_uint16();
    public static final long ffi_type_sint16 = LibFFIConstants.ffi_type_sint16();
    public static final long ffi_type_uint32 = LibFFIConstants.ffi_type_uint32();
    public static final long ffi_type_sint32 = LibFFIConstants.ffi_type_sint32();
    public static final long ffi_type_uint64 = LibFFIConstants.ffi_type_uint64();
    public static final long ffi_type_sint64 = LibFFIConstants.ffi_type_sint64();
    public static final long ffi_type_uchar = LibFFIConstants.ffi_type_uchar();
    public static final long ffi_type_schar = LibFFIConstants.ffi_type_schar();
    public static final long ffi_type_sshort = LibFFIConstants.ffi_type_sshort();
    public static final long ffi_type_ushort = LibFFIConstants.ffi_type_ushort();
    public static final long ffi_type_uint = LibFFIConstants.ffi_type_uint();
    public static final long ffi_type_sint = LibFFIConstants.ffi_type_sint();
    public static final long ffi_type_ulong = LibFFIConstants.ffi_type_ulong();
    public static final long ffi_type_slong = LibFFIConstants.ffi_type_slong();
    public static final long ffi_type_float = LibFFIConstants.ffi_type_float();
    public static final long ffi_type_double = LibFFIConstants.ffi_type_double();
    public static final long ffi_type_longdouble = LibFFIConstants.ffi_type_longdouble();
    public static final long ffi_type_pointer = LibFFIConstants.ffi_type_pointer();

    private LibFFI() {
    }

    public static native int nffi_prep_cif(long var0, int var2, int var3, long var4, long var6);

    public static int ffi_prep_cif(ByteBuffer cif, int abi, int nargs, long rtype, ByteBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            if (atypes != null) {
                Checks.checkBuffer((Buffer)atypes, nargs << Pointer.POINTER_SHIFT);
            }
            Checks.checkPointer(rtype);
        }
        return LibFFI.nffi_prep_cif(MemoryUtil.memAddress(cif), abi, nargs, rtype, MemoryUtil.memAddressSafe(atypes));
    }

    public static int ffi_prep_cif(ByteBuffer cif, int abi, long rtype, PointerBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            Checks.checkPointer(rtype);
        }
        return LibFFI.nffi_prep_cif(MemoryUtil.memAddress(cif), abi, atypes == null ? 0 : atypes.remaining(), rtype, MemoryUtil.memAddressSafe(atypes));
    }

    public static native int nffi_prep_cif_var(long var0, int var2, int var3, int var4, long var5, long var7);

    public static int ffi_prep_cif_var(ByteBuffer cif, int abi, int nfixedargs, int ntotalargs, long rtype, ByteBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            Checks.checkBuffer((Buffer)atypes, ntotalargs << Pointer.POINTER_SHIFT);
            Checks.checkPointer(rtype);
        }
        return LibFFI.nffi_prep_cif_var(MemoryUtil.memAddress(cif), abi, nfixedargs, ntotalargs, rtype, MemoryUtil.memAddress(atypes));
    }

    public static int ffi_prep_cif_var(ByteBuffer cif, int abi, int nfixedargs, long rtype, PointerBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            Checks.checkPointer(rtype);
        }
        return LibFFI.nffi_prep_cif_var(MemoryUtil.memAddress(cif), abi, nfixedargs, atypes.remaining(), rtype, MemoryUtil.memAddress(atypes));
    }

    public static native void nffi_call(long var0, long var2, long var4, long var6);

    public static void ffi_call(ByteBuffer cif, long fn, ByteBuffer rvalue, ByteBuffer avalue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            Checks.checkPointer(fn);
        }
        LibFFI.nffi_call(MemoryUtil.memAddress(cif), fn, MemoryUtil.memAddressSafe(rvalue), MemoryUtil.memAddressSafe(avalue));
    }

    public static void ffi_call(ByteBuffer cif, long fn, ByteBuffer rvalue, PointerBuffer avalue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            Checks.checkPointer(fn);
        }
        LibFFI.nffi_call(MemoryUtil.memAddress(cif), fn, MemoryUtil.memAddressSafe(rvalue), MemoryUtil.memAddressSafe(avalue));
    }

    public static native long nffi_closure_alloc(long var0, long var2);

    public static ByteBuffer ffi_closure_alloc(long size, ByteBuffer code) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)code, 1 << Pointer.POINTER_SHIFT);
        }
        long __result = LibFFI.nffi_closure_alloc(size, MemoryUtil.memAddress(code));
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static ByteBuffer ffi_closure_alloc(long size, PointerBuffer code) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(code, 1);
        }
        long __result = LibFFI.nffi_closure_alloc(size, MemoryUtil.memAddress(code));
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static native void nffi_closure_free(long var0);

    public static void ffi_closure_free(ByteBuffer writable) {
        LibFFI.nffi_closure_free(MemoryUtil.memAddress(writable));
    }

    public static native int nffi_prep_closure_loc(long var0, long var2, long var4, long var6, long var8);

    public static int ffi_prep_closure_loc(ByteBuffer closure, ByteBuffer cif, long fun, long user_data, long codeloc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)closure, FFIClosure.SIZEOF);
            Checks.checkBuffer((Buffer)cif, FFICIF.SIZEOF);
            Checks.checkPointer(fun);
            Checks.checkPointer(codeloc);
        }
        return LibFFI.nffi_prep_closure_loc(MemoryUtil.memAddress(closure), MemoryUtil.memAddress(cif), fun, user_data, codeloc);
    }

    static {
        LWJGLUtil.initialize();
    }
}

