/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBDebugOutput {
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 33346;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_ARB = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 33347;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_ARB = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_ARB = 33349;
    public static final int GL_DEBUG_SOURCE_API_ARB = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_ARB = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_ARB = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_ARB = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_ARB = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_ARB = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_ARB = 33361;
    public static final int GL_DEBUG_SEVERITY_HIGH_ARB = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_ARB = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_ARB = 37192;
    public final long DebugMessageControlARB;
    public final long DebugMessageInsertARB;
    public final long DebugMessageCallbackARB;
    public final long GetDebugMessageLogARB;

    public ARBDebugOutput(FunctionProvider provider) {
        this.DebugMessageControlARB = provider.getFunctionAddress("glDebugMessageControlARB");
        this.DebugMessageInsertARB = provider.getFunctionAddress("glDebugMessageInsertARB");
        this.DebugMessageCallbackARB = provider.getFunctionAddress("glDebugMessageCallbackARB");
        this.GetDebugMessageLogARB = provider.getFunctionAddress("glGetDebugMessageLogARB");
    }

    public static ARBDebugOutput getInstance() {
        return GL.getCapabilities().__ARBDebugOutput;
    }

    static ARBDebugOutput create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_debug_output")) {
            return null;
        }
        ARBDebugOutput funcs = new ARBDebugOutput(provider);
        boolean supported = Checks.checkFunctions(funcs.DebugMessageControlARB, funcs.DebugMessageInsertARB, funcs.DebugMessageCallbackARB, funcs.GetDebugMessageLogARB);
        return GL.checkExtension("GL_ARB_debug_output", funcs, supported);
    }

    public static native void nglDebugMessageControlARB(int var0, int var1, int var2, int var3, long var4, boolean var6, long var7);

    public static void nglDebugMessageControlARB(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = ARBDebugOutput.getInstance().DebugMessageControlARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, count, ids, enabled, __functionAddress);
    }

    public static void glDebugMessageControlARB(int source, int type, int severity, int count, ByteBuffer ids, boolean enabled) {
        ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, count, MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageControlARB(int source, int type, int severity, int count, IntBuffer ids, boolean enabled) {
        ARBDebugOutput.nglDebugMessageControlARB(source, type, severity, count, MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static native void nglDebugMessageInsertARB(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void nglDebugMessageInsertARB(int source, int type, int id, int severity, int length, long buf) {
        long __functionAddress = ARBDebugOutput.getInstance().DebugMessageInsertARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, length, buf, __functionAddress);
    }

    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, int length, ByteBuffer buf) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buf, length);
        }
        ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, length, MemoryUtil.memAddress(buf));
    }

    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, ByteBuffer buf) {
        ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static void glDebugMessageInsertARB(int source, int type, int id, int severity, CharSequence buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufEncoded = __buffer.stringParamUTF8(buf, false);
        int bufEncodedLen = __buffer.getOffset() - bufEncoded;
        ARBDebugOutput.nglDebugMessageInsertARB(source, type, id, severity, bufEncodedLen, __buffer.address(bufEncoded));
    }

    public static native void nglDebugMessageCallbackARB(long var0, long var2, long var4);

    public static void glDebugMessageCallbackARB(GLDebugMessageARBCallback callback, long userParam) {
        long __functionAddress = ARBDebugOutput.getInstance().DebugMessageCallbackARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBDebugOutput.nglDebugMessageCallbackARB(callback == null ? 0L : callback.getPointer(), userParam, __functionAddress);
    }

    public static native int nglGetDebugMessageLogARB(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    public static int nglGetDebugMessageLogARB(int count, int bufSize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = ARBDebugOutput.getInstance().GetDebugMessageLogARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBDebugOutput.nglGetDebugMessageLogARB(count, bufSize, sources, types, ids, severities, lengths, messageLog, __functionAddress);
    }

    public static int glGetDebugMessageLogARB(int count, int bufSize, ByteBuffer sources, ByteBuffer types, ByteBuffer ids, ByteBuffer severities, ByteBuffer lengths, ByteBuffer messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufSize);
            }
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count << 2);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return ARBDebugOutput.nglGetDebugMessageLogARB(count, bufSize, MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLogARB(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return ARBDebugOutput.nglGetDebugMessageLogARB(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static GLDebugMessageARBCallback GLDebugMessageARBCallback(final GLDebugMessageARBCallback.SAM sam) {
        return new GLDebugMessageARBCallback(){

            @Override
            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                sam.invoke(source, type, id, severity, length, message, userParam);
            }
        };
    }
}

