/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.util.HashSet;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.Info;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.PointerWrapper;

public class CLDevice
extends PointerWrapper {
    private final CLCapabilities capabilities;

    public CLDevice(long cl_device_id, CLPlatform platform) {
        this(cl_device_id, platform.getCapabilities());
        if (LWJGLUtil.DEBUG && Info.clGetDeviceInfoPointer(cl_device_id, 4145) != platform.getPointer()) {
            throw new IllegalArgumentException("The specified device does not belong to the specified platform.");
        }
    }

    public CLDevice(long cl_device_id, CLCapabilities platformCapabilities) {
        super(cl_device_id);
        this.capabilities = CLDevice.createCapabilities(cl_device_id, platformCapabilities);
    }

    public CLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public static CLCapabilities createCapabilities(long cl_device_id, CLCapabilities platformCapabilities) {
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        String extensionsString = Info.clGetDeviceInfoStringASCII(cl_device_id, 4144);
        CL.addExtensions(extensionsString, supportedExtensions);
        APIUtil.APIVersion version = APIUtil.apiParseVersion(Info.clGetDeviceInfoStringASCII(cl_device_id, 4143), "OpenCL");
        CL.addCLVersions(version.major, version.minor, supportedExtensions);
        return new CLCapabilities(version.major, version.minor, supportedExtensions, platformCapabilities);
    }
}

