/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;

public class Sound {
    public static final SoundFile MUSIC = new SoundFile("music.wav", 1.0);
    private SoundFile currentMusic;
    private double soundVolume;
    private double musicVolume;
    private Clip musicClip;

    public Sound() {
        double volume;
        this.soundVolume = volume = 1.0;
        this.musicVolume = volume;
        this.setMusic(MUSIC);
    }

    public Clip play(SoundFile sound) {
        return this.play(sound, this.soundVolume);
    }

    public Clip play(SoundFile sound, double volume) {
        try {
            Clip clip = (Clip)AudioSystem.getLine(sound.info);
            clip.open(sound.af, sound.audio, 0, sound.size);
            FloatControl volumeControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            volumeControl.setValue((float)(20.0 * Math.log10(volume * sound.volume * this.soundVolume)));
            clip.start();
            return clip;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setMusic(SoundFile music) {
        if (this.currentMusic == music) {
            return;
        }
        if (this.musicClip != null) {
            this.musicClip.stop();
        }
        this.currentMusic = music;
        try {
            this.musicClip = (Clip)AudioSystem.getLine(music.info);
            this.musicClip.open(music.af, music.audio, 0, music.size);
            this.musicClip.loop(-1);
            FloatControl volume = (FloatControl)this.musicClip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.musicVolume * music.volume)));
            this.musicClip.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopMusic() {
        this.currentMusic = null;
        this.musicClip.stop();
    }
}

