#ifndef _COMPILED_SONG_H_
#define _COMPILED_SONG_H_

#include <stddef.h>

#include "types.hpp"
#include "instrument_data.hpp"
#include "bus_data.hpp"
#include "tracker_data_static.hpp"

static const int num_buses = 9;
const BusData buses[] = {
  { // 0 synth 1
    0.350000f, // delay_time_l
    0.400000f, // delay_time_r
    0.500000f, // delay_dry_wet_balance
    0.500000f, // delay_feedback
    0.400000f, // comp_threshold
    0.990000f, // comp_attack
    1.001000f, // comp_release
    0.500000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 1 noecho
    0.100000f, // delay_time_l
    0.100000f, // delay_time_r
    0.500000f, // delay_dry_wet_balance
    0.000000f, // delay_feedback
    0.500000f, // comp_threshold
    0.990000f, // comp_attack
    1.001000f, // comp_release
    0.500000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 2 plim left
    0.500000f, // delay_time_l
    0.650000f, // delay_time_r
    0.500000f, // delay_dry_wet_balance
    0.500000f, // delay_feedback
    0.500000f, // comp_threshold
    0.990000f, // comp_attack
    1.001000f, // comp_release
    0.200000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 3 plim right
    0.500000f, // delay_time_l
    0.650000f, // delay_time_r
    0.500000f, // delay_dry_wet_balance
    0.500000f, // delay_feedback
    0.500000f, // comp_threshold
    0.990000f, // comp_attack
    1.001000f, // comp_release
    0.800000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 4 pad
    0.215000f, // delay_time_l
    0.270000f, // delay_time_r
    0.800000f, // delay_dry_wet_balance
    0.800000f, // delay_feedback
    0.500000f, // comp_threshold
    0.995000f, // comp_attack
    1.000100f, // comp_release
    0.500000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 5 lead
    0.150000f, // delay_time_l
    0.210000f, // delay_time_r
    0.400000f, // delay_dry_wet_balance
    0.500000f, // delay_feedback
    0.800000f, // comp_threshold
    0.900000f, // comp_attack
    1.001000f, // comp_release
    0.500000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 6 wide echo
    0.019000f, // delay_time_l
    0.021000f, // delay_time_r
    0.700000f, // delay_dry_wet_balance
    0.750000f, // delay_feedback
    0.900000f, // comp_threshold
    0.990000f, // comp_attack
    1.010000f, // comp_release
    0.500000f, // bus_pan
    1.000000f, // bus_gain
    8, // bus_out_dest
  },
  { // 7 bass + bd
    0.430000f, // delay_time_l
    0.340000f, // delay_time_r
    0.000000f, // delay_dry_wet_balance
    0.300000f, // delay_feedback
    0.500000f, // comp_threshold
    0.990000f, // comp_attack
    1.000500f, // comp_release
    0.500000f, // bus_pan
    1.100000f, // bus_gain
    8, // bus_out_dest
  },
  { // 8 master
    0.430000f, // delay_time_l
    0.340000f, // delay_time_r
    0.100000f, // delay_dry_wet_balance
    0.300000f, // delay_feedback
    0.600000f, // comp_threshold
    0.987000f, // comp_attack
    1.000800f, // comp_release
    0.500000f, // bus_pan
    1.150000f, // bus_gain
    -1, // bus_out_dest
  },
};

static const int num_instruments = 9;
const InstrumentData instruments[] = {
  { // saw.patch
   4, // num_oscs
   { 0.99399, 1.0, 1.0071, 0.5 }, // osc_pitches
   { 0, 0, 0, 0 }, // osc_shape
   0.500000f, // filter_cutoff
   0.999700f, // filter_decay
   0.800000f, // filter_feedback
   1.000000f, // amp_init
   1.000000f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    0.300000f, // gain
    0 // out_bus
  },
  { // bd2.patch
   1, // num_oscs
   { 1.0 }, // osc_pitches
   { 0 }, // osc_shape
   0.040000f, // filter_cutoff
   0.986093f, // filter_decay
   0.050000f, // filter_feedback
   1.000000f, // amp_init
   0.999980f, // amp_decay
   1.000000f, // pitch
   0.988068f, // pitch_decay
   0.050000f, // pitch_min
    2.560000f, // gain
    7 // out_bus
  },
  { // blip.patch
   1, // num_oscs
   { 1.0 }, // osc_pitches
   { 3 }, // osc_shape
   0.700000f, // filter_cutoff
   0.980189f, // filter_decay
   0.200000f, // filter_feedback
   1.000000f, // amp_init
   0.998002f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    0.665000f, // gain
    2 // out_bus
  },
  { // hh1.patch
   1, // num_oscs
   { 1.0 }, // osc_pitches
   { 2 }, // osc_shape
   0.900000f, // filter_cutoff
   1.000000f, // filter_decay
   0.950000f, // filter_feedback
   1.000000f, // amp_init
   0.941680f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    1.050000f, // gain
    1 // out_bus
  },
  { // pad1.patch
   2, // num_oscs
   { 1.0, 2.007 }, // osc_pitches
   { 0, 0 }, // osc_shape
   0.001000f, // filter_cutoff
   1.000220f, // filter_decay
   0.500000f, // filter_feedback
   0.100000f, // amp_init
   1.002002f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    0.350000f, // gain
    4 // out_bus
  },
  { // sd1.patch
   1, // num_oscs
   { 1.0 }, // osc_pitches
   { 2 }, // osc_shape
   0.500000f, // filter_cutoff
   0.999980f, // filter_decay
   0.980000f, // filter_feedback
   1.000000f, // amp_init
   0.996008f, // amp_decay
   2.000000f, // pitch
   0.986093f, // pitch_decay
   0.050000f, // pitch_min
    0.800000f, // gain
    6 // out_bus
  },
  { // bass2.patch
   4, // num_oscs
   { 0.5, 1.005, 1.493, 0.5 }, // osc_pitches
   { 0, 0, 0, 0 }, // osc_shape
   0.300000f, // filter_cutoff
   0.990047f, // filter_decay
   0.500000f, // filter_feedback
   1.000000f, // amp_init
   0.999400f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    0.450000f, // gain
    7 // out_bus
  },
  { // blip.patch
   1, // num_oscs
   { 1.0 }, // osc_pitches
   { 3 }, // osc_shape
   0.700000f, // filter_cutoff
   0.980189f, // filter_decay
   0.200000f, // filter_feedback
   1.000000f, // amp_init
   0.998002f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    0.665000f, // gain
    3 // out_bus
  },
  { // ding.patch
   4, // num_oscs
   { 1.0, 1.004, 1.996, 2.006 }, // osc_pitches
   { 0, 0, 0, 0 }, // osc_shape
   0.660000f, // filter_cutoff
   0.999800f, // filter_decay
   0.660000f, // filter_feedback
   1.000000f, // amp_init
   0.999800f, // amp_decay
   1.000000f, // pitch
   1.000000f, // pitch_decay
   1.000000f, // pitch_min
    0.590000f, // gain
    5 // out_bus
  },
};

static const int num_patterns = 15;
TrackerPattern patterns[] = {
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 10, 5, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 3, 6, 0, 1, 128 },
          { 7, 6, 0, 1, 128 },
          { 0, 7, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 2, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 2, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 8, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { 9, 5, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { 9, 5, 0, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 9, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 0, 1, 32 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 5, 5, 8, 1, 255 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 7, 5, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 0, 1, 64 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 1, 16 },
          { 7, 6, 0, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 5, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 7, 4, 0, 1, 16 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 3, 5, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 4, 0, 1, 64 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 2, 5, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 4, 0, 1, 112 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { 2, 6, 0, 1, 16 },
          { 7, 6, 0, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 10, 4, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 0, 1, 48 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 4, 0, 1, 80 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 5, 4, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 9, 4, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 5, 4, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 4, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 5, 8, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 9, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 16 },
          { 3, 4, 0, 0, 0 },
          { 0, 0, 4, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 6, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 7, 5, 0, 1, 255 },
          { 5, 5, 0, 1, 255 },
          { 7, 5, 0, 1, 255 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 7, 6, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 4, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 53 },
          { -1, 0, 0, 1, 192 },
          { -1, 0, 0, 1, 192 },
          { -1, 0, 0, 1, 192 },
          { 5, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 19 },
          { -1, 0, 0, 1, 144 },
          { -1, 0, 0, 1, 144 },
          { -1, 0, 0, 1, 144 },
          { 9, 6, 7, 1, 48 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 66 },
          { -1, 0, 0, 1, 96 },
          { -1, 0, 0, 1, 96 },
          { -1, 0, 0, 1, 96 },
          { 0, 7, 7, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 5, 4, 0, 0 },
          { 7, 5, 4, 0, 0 },
          { 2, 6, 4, 0, 0 },
          { 0, 3, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 9, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 1, 80 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 4, 2, 1, 128 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 160 },
          { 10, 4, 4, 1, 255 },
          { 0, 0, 0, 0, 0 },
          { 3, 5, 8, 1, 255 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 4, 0, 1, 255 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 8, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 8, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 5, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 1, 112 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 5, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 8, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 3, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 9, 5, 8, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 8, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 5, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 5, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 5, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 5, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 8, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 8, 0, 0 },
          { 5, 6, 7, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 9, 6, 7, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 160 },
          { 10, 4, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 8, 0, 0 },
          { 10, 4, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 3, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 3, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 3, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 3, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 8, 0, 0 },
          { 0, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 112 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 8, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 112 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 8, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 8, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 8, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 5, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 4, 0, 0 },
          { 2, 6, 8, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 7, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 7, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 7, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 7, 4, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 5, 7, 1, 32 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 7, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 8, 0, 0 },
          { 10, 5, 7, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 5, 7, 1, 32 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 8, 0, 0 },
          { 7, 5, 7, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 0, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 3, 6, 0, 1, 255 },
          { 7, 6, 0, 1, 255 },
          { 0, 7, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 2, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 2, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 8, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { 9, 5, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { 9, 5, 0, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 9, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 8, 1, 160 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 0, 5, 0, 0 },
          { 0, 3, 0, 1, 64 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 96 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 64 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 32 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 16 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 3, 6, 0, 1, 64 },
          { 7, 6, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { -1, 0, 8, 0, 0 },
          { 3, 7, 0, 1, 128 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 8, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 2, 7, 0, 1, 224 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 7, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 1, 255 },
          { -1, 0, 2, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 3, 0, 1, 255 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 2, 7, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 3, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 9, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 7, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 5, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 3, 0, 0, 0 },
          { 7, 5, 2, 1, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 7, 1, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 3, 0, 0, 0 },
          { 10, 5, 7, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 4, 0, 0 },
          { -1, 0, 4, 0, 0 },
          { 10, 5, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { 0, 6, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 5, 6, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 1, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 4, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 5, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 2, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 3, 3, 0, 1, 64 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 10, 5, 2, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 2, 7, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 2, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { 10, 5, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 16 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 2, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 10, 5, 2, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 3, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 2, 1, 144 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 2, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 10, 2, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 1, 240 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 5, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 1, 16 },
          { 10, 5, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 9, 6, 0, 0, 0 },
          { 0, 3, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 48 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 48 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 48 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 48 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 7, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 1, 5 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 1, 1 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 1, 16 },
          { 10, 5, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { 10, 5, 2, 1, 32 },
          { 7, 6, 0, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 7, 3, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 2, 1, 32 },
          { 9, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 7, 2, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 7, 1, 8 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 8 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 6, 7, 1, 8 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 7, 1, 4 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 1, 224 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 2 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 1 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 2, 7, 7, 1, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 7, 3, 6, 1, 240 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 1, 16 },
          { 0, 6, 0, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 8, 3, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 6, 4, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
 { // TrackerPattern
   { // TrackerPattern.rows
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 1, 16 },
          { 0, 0, 4, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 2, 6, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 0, 6, 4, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 2, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 3, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 2, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 0, 5, 0, 1, 255 },
          { 5, 5, 0, 1, 255 },
          { 7, 5, 0, 1, 255 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 7, 1, 64 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 96 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 7, 1, 128 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 7, 1, 160 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { 4, 6, 0, 0, 0 },
          { 7, 6, 0, 0, 0 },
          { 0, 7, 0, 0, 0 },
          { 0, 5, 2, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 2, 1, 32 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 0, 4, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 5, 2, 1, 64 },
          { -1, 0, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 0, 0 },
          { 0, 6, 0, 0, 0 },
          { 3, 6, 0, 0, 0 },
          { 10, 6, 0, 0, 0 },
          { 0, 6, 2, 1, 96 },
          { 0, 4, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 8, 3, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 6, 2, 1, 128 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 10, 6, 2, 1, 160 },
          { -1, 0, 7, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 5, 7, 1, 16 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 5, 5, 7, 1, 32 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 8, 3, 6, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 6, 7, 1, 64 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 1, 5 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 192 },
          { 5, 6, 7, 1, 96 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { 10, 3, 6, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 1, 67 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 144 },
          { 9, 6, 7, 1, 48 },
          { -1, 0, 5, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { 10, 3, 6, 1, 114 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 1, 96 },
          { 0, 7, 7, 1, 16 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
     { // TrackerRow
       { // TrackerRow.cells
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { -1, 0, 0, 0, 0 },
          { 7, 5, 1, 0, 0 },
          { 0, 4, 3, 0, 0 },
          { -1, 0, 0, 0, 0 },
       },
     },
   }
 },
};

int order[] = {
  10, 8, 3, 9, 0, 6, 1, 1, 2, 14, 4, 5, 7, 7, 11, 13, 12, -1
};

#endif // _COMPILED_SONG_H_
