/*var Joki = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setBloom(2);
    this.setDoF();

    this.scene.fog = new THREE.Fog(0x808080, this.near, this.far);

    this.texture = TDEMO.TEXTURES.getTextures().laakkeet;

    this.putki = this.createScene(this.texture);
    this.scene.add(this.putki);
};

Joki.prototype = PartBase.prototype.inheritance();

Joki.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.texture.offset.y -= delta*0.25;
    this.texture.offset.y %= 1;

    this.texture.offset.x += delta*0.5;
    this.texture.offset.x %= 4;

    this.texture.needsUpdate = true;
};

Joki.prototype.createScene = function(map){
    var geometry = new THREE.CylinderGeometry(20, 20, 800, 124, 50, true);
    var material = new THREE.MeshBasicMaterial({
        map : map,
        side : THREE.BackSide
    });

    var putki = new THREE.Mesh(geometry, material);
    putki.rotation.x = Math.PI/2;

    return putki;
}
*/

var Joki = function(){
    PartBase.call(this);

    //POSTPROCESSING
    //this.setEdgeDetection();
    this.setBloom(1);
    this.setDoF();
    //this.scene.fog = new THREE.Fog(0xf0f0f0, this.near, this.far);

    //VIDEO TEXTURE
    this.video = document.getElementById( 'joki' );
    this.texture = new THREE.VideoTexture(this.video);
    this.texture.minFilter = THREE.LinearFilter;
    this.texture.magFilter = THREE.LinearFilter;
    this.texture.format = THREE.RGBFormat;

    //GEOMETRY
    var geometry = new THREE.PlaneGeometry(800, 450);
    var material = new THREE.MeshBasicMaterial({
        map : this.texture,
        color : 0xffffff
    });

    var display = new THREE.Mesh(geometry, material);
    this.scene.add(display);
    //console.log(display.position.x + " " + display.position.y + " "+ display.position.z);
};

Joki.prototype = PartBase.prototype.inheritance();

Joki.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    this.video.currentTime = 0;
    this.video.play();
    //console.log("jokivideo!");
};

Joki.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.video.pause();
};
