var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.frame = 0;
			this.scene = new THREE.Scene();

			var hlight = new THREE.HemisphereLight( 0xdfe1fc, 0x000000, .5 );
			hlight.position.y = 100;
			this.scene.add( hlight );

			this.light = new THREE.PointLight( 0xffffff, 1, 0 );
			this.light.position.set(0, 10, -20)
			this.scene.add(this.light);

			this.axishelper = new THREE.AxisHelper(5);
			this.scene.add(this.axishelper);

			this.raymarchplane = new THREE.RaymarchingPlane();
			this.scene.add(this.raymarchplane);

			for(var i = 0; i < 20; i++) {
				var rock = makeRock(.05, 1, 100);
				Math.seedrandom(150 + i);
				rock.position.set( Math.random() * 2 - 1, Math.random() * 2 - 1, Math.random() * 2 - 1 );
				this.scene.add(rock);
			}


			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(45, 16/9, .01, 10);
			this.camera.position.z = -2;
			this.camera.position.y = .3;
			this.camera.lookAt(new THREE.Vector3(0, 0, 0));

			this.controls = new THREE.OrbitControls( this.camera );
			this.controls.addEventListener('change',render);

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);

			this.composer.addPass(final_pass);

		},

		render: function(time, percent) 
		{
			this.camera.position.x = getVal("camx");
			this.camera.position.y = getVal("camy");
			this.camera.position.z = getVal("camz");
			this.camera.lookAt(this.raymarchplane.position);
			
			this.raymarchplane.animate(percent);
			this.raymarchplane.lookAt(this.camera.position);		

			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

