var Scene = (function() {
	var lerp = function(s, e, p) {
		return s - ((s - e) * p);
	}

	return {
		id: getIdForLastLoadedScript(),
		load: function()
		{
			this.scene = new THREE.Scene();
/*
			var ambient = new THREE.AmbientLight( 0xffffff );
			ambient.color.setHSL( 0.1, 0.3, 0.2 );
			this.scene.add( ambient );

			var dirLight = new THREE.DirectionalLight( 0xffffff, 0.125 );
			dirLight.position.set( 0, 10, -20 ).normalize();
			dirLight.color.setHSL( 0.1, 0.7, 0.7 );
			this.scene.add( dirLight );

			var light = new THREE.PointLight( 0xffffff, 1.5, 4500 );
			light.color.setHSL( 0.55, 0.9, 0.5 );
			light.position.set( -10, 10, -10 );
			this.scene.add( light );
*/
			/*
			this.axishelper = new THREE.AxisHelper(5);
			this.scene.add(this.axishelper);
			*/

			/*
			var light = new THREE.HemisphereLight( 0xffffff, 0x000000, .5 );
			light.position.y = 100;
			this.scene.add( light );
			*/

			this.light2 = new THREE.PointLight(0xffffff, 1, 150);
			//this.light2.castShadow = true;
			this.light2.position.set(50,100,50);
			this.scene.add(this.light2);

			// Maybe this is better than mocking around with emissive colors and shit?
			this.dirLight1 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight2 = new THREE.DirectionalLight(0xffffff, 0.4);
			this.dirLight1.position.set(1,1,1);
			this.dirLight2.position.set(-1,0,0);
			this.dirLight3 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight4 = new THREE.DirectionalLight(0xffffff, 0.1);
			this.dirLight3.position.set(0,0,1);
			this.dirLight4.position.set(0,0,-1);
			this.scene.add(this.dirLight1);
			this.scene.add(this.dirLight2);
			this.scene.add(this.dirLight3);
			this.scene.add(this.dirLight4);

			// Cave with tunnels
			this.cave = new THREE.Cave(100);
			this.scene.add(this.cave);


			this.raymarch = new THREE.RaymarchingPlane();
			this.scene.add(this.raymarch);

			this.matBlack = new THREE.MeshBasicMaterial({ color: 0x000000 });
/*
			var fitteanalbanan = new THREE.Mesh(
				new THREE.BoxGeometry(20,20,20),
				new THREE.MeshLambertMaterial(
				{
					color: new THREE.Color(Math.random(),Math.random(),Math.random())
				})
			);
			fitteanalbanan.rotation.set(Math.random(),Math.random(),Math.random());
			this.scene.add(fitteanalbanan);
*/


			// Do the rendering shit
			this.composer = new THREE.EffectComposer(renderer);

			this.camera = new THREE.PerspectiveCamera(55, 16/9, 1, 4000);
			this.camera.position.x = 150;
			this.camera.position.y = 75;

			//this.controls = new THREE.OrbitControls( this.camera );
			//this.controls.addEventListener('change',render);
			
			// SSAO Depth
			this.depthShader = THREE.ShaderLib[ "depthRGBA" ];
			this.depthUniforms = THREE.UniformsUtils.clone( this.depthShader.uniforms );

			this.depthMaterial = new THREE.ShaderMaterial({
				fragmentShader: this.depthShader.fragmentShader,
				vertexShader: this.depthShader.vertexShader,
				uniforms: this.depthUniforms
			});
			this.depthMaterial.blending = THREE.NoBlending;

			this.depthTarget = new THREE.WebGLRenderTarget( wWidth, wHeight, {
				minFilter: THREE.NearestFilter,
				magFilter: THREE.NearestFilter,
				format: THREE.RGBAFormat
			});

			this.renderPass = new THREE.RenderPass(this.scene, this.camera);
			this.composer.addPass(this.renderPass);


			this.SSAOPass = new THREE.ShaderPass( THREE.SSAOShader );
			this.SSAOPass.uniforms[ 'tDepth' ].value = this.depthTarget;
			this.SSAOPass.uniforms[ 'size' ].value.set( wWidth * 0.5, wHeight * 0.5 );
			this.SSAOPass.uniforms[ 'cameraNear' ].value = this.camera.near;
			this.SSAOPass.uniforms[ 'cameraFar' ].value = this.camera.far;
			this.SSAOPass.uniforms[ 'aoClamp' ].value = 0.5;
			this.SSAOPass.enabled = true;
			this.composer.addPass( this.SSAOPass );

			this.composer.addPass(final_pass);
		},

		render: function(time, percent) 
		{
			this.raymarch.animate(percent);

			//this.controls.update();

			/*this.camera.position.x = getVal("camx");
			this.camera.position.y = getVal("camy");
			this.camera.position.z = getVal("camz");
			this.camera.lookAt(new THREE.Vector3(getVal("cam2x"), getVal("cam2y"), getVal("cam2z")));
			*/

			this.cave.controlCamera(this.camera);

			this.raymarch.lookAt(this.camera.position);		

			this.scene.overrideMaterial = this.depthMaterial;
			this.raymarch.visible = false;
			renderer.render( this.scene, this.camera, this.depthTarget );

			this.raymarch.visible = true;
			this.scene.overrideMaterial = null;
			this.composer.render();
		}
	};
})();

var scenes = scenes || [];
scenes[Scene.id] = Scene;

