/**
 * Busk aka Tree
 * staalebk
 */
var pigStatueCache = null;

THREE.PigStatue = function (options) {

	options = options || {};


	this.nearEnough = function(x, y)
	{
		if (x >= y-0.001 && x <= y+0.001)
			return true;
		return false;
	}

	THREE.Object3D.call( this );
	this.type = 'PigStatue';

	if(pigStatueCache === null) {
		var loader = new THREE.JSONLoader();
		pigStatueCache = loader.parse(THREE.PigStatue.meshData);
	}

	geometry = pigStatueCache.geometry;
	this.orig = [];
	this.newpos = [];
	this.perlinorder = [];

	// Start by finding the lowest point on the pig and basing y=0 of that.
	var yMin = 0;
	for (var i=0; i<geometry.vertices.length; i++)
	{
		if (geometry.vertices[i].y < yMin)
		{
			yMin = geometry.vertices[i].y;
		}
		this.perlinorder.push( (noise.perlin3(geometry.vertices[i].x/50,geometry.vertices[i].y/50,geometry.vertices[i].z/50)+1)/2 * 0.7 );
	}
	geometry.applyMatrix(new THREE.Matrix4().makeTranslation(0,yMin*-1,0));
	// Center the pig around the z axis 0
	var zMin = 0;
	var zMax = 0;
	var yMax = 0;
	for (var i=0; i<geometry.vertices.length;i++)
	{
		this.orig.push(geometry.vertices[i].clone());
		if (geometry.vertices[i].z > zMax)
			zMax = geometry.vertices[i].z;
		if (geometry.vertices[i].z < zMin)
			zMin = geometry.vertices[i].z;
		if (geometry.vertices[i].y > yMax)
			yMax = geometry.vertices[i].y;
	}
	var pigLength = zMax - zMin;
	geometry.applyMatrix(new THREE.Matrix4().makeTranslation(0,0,pigLength/2-zMax));

	for (var i=0; i<this.orig.length; i++)
	{
		this.newpos.push(this.orig[i].clone());
	}

	var center = new THREE.Vector3(0,yMax/2,0);
	var radius = 120;
	var angles = [];


	var boxMinX = -55;
	var boxMaxX = 55;
	var boxMinY = 0;
	var boxMaxY = 90;
	var boxMinZ = -70;
	var boxMaxZ = 60;


	this.pigInflator = function (point, radius)
	{
		for (var i=0; i<geometry.vertices.length; i++)
		{
			var v = this.newpos[i];

			var dist = point.distanceTo(v);
			if (dist <= radius)
			{

				var angle = new THREE.Vector3().subVectors(v, point).normalize();

				var sphereX = point.x + angle.x * radius;
				var sphereY = point.y + angle.y * radius;
				var sphereZ = point.z + angle.z * radius;

				if (sphereZ > boxMaxZ)
				{

				}


				var x = sphereX > 0 ? Math.min(sphereX, boxMaxX) : Math.max(sphereX, boxMinX);
				var y = sphereY > 0 ? Math.min(sphereY, boxMaxY) : Math.max(sphereY, boxMinY);
				var z = sphereZ > 0 ? Math.min(sphereZ, boxMaxZ) : Math.max(sphereZ, boxMinZ);

				this.newpos[i].x = x;
				this.newpos[i].y = y;
				this.newpos[i].z = z;

			}
		}
	}

	/*this.pigInflator(new THREE.Vector3(0,45,30),20);
	this.pigInflator(new THREE.Vector3(0,45,20),30);
	this.pigInflator(new THREE.Vector3(0,45,20),50);
	this.pigInflator(new THREE.Vector3(0,45,-20),80);*/

	//this.pigInflator(new THREE.Vector3(0,50,0),200);



	// Move all vertexes close to their closes wall.
	for (var i=0; i<this.newpos.length; i++)
	{
		v = this.newpos[i];

		var distx = v.x > 0 ? boxMaxX - v.x : v.x - boxMinX;
		var disty = v.y > 50 ? boxMaxY - v.y : v.y - boxMinY;
		var distz = v.z > 0 ? boxMaxZ - v.z : v.z - boxMinZ;

		var min = Math.min(distx, disty, distz);
		if (this.nearEnough(min, distx))
		{
			v.x = v.x > 0 ? boxMaxX : boxMinX;
		} else if (this.nearEnough(min, disty))
		{
			v.y = v.y > 50 ? boxMaxY : boxMinY;
		} else
		{
			v.z = v.z > 0 ? boxMaxZ : boxMinZ;
		}
	}


	this.pigInflator(new THREE.Vector3(0,50,40),150);
	this.pigInflator(new THREE.Vector3(0,50,-40),150);
	

	//this.pigInflator(new THREE.Vector3(0,45,-40),80);

	//this.pigInflator(new THREE.Vector3(boxMaxX-30, boxMaxY-30, boxMaxZ-30),60);


	//this.pigInflator(new THREE.Vector3(0,45,0),50);

	//this.pigInflator(new THREE.Vector3(0,0,30),40);

	/*for (var i=0; i<geometry.vertices.length; i++)
	{
		var v = geometry.vertices[i];
		
		center.set( (Math.random()-0.5)*2*10,50+(Math.random()-0.5)*2*10,(Math.random()-0.5)*2*10 );

		// Find distance to center of cave.
		var dist = center.distanceTo(v);
		//if (dist <= radius)
		//{
			var angle = new THREE.Vector3().subVectors(v, center).normalize();


			var sphereX = center.x + angle.x * radius;
			var sphereY = center.y + angle.y * radius;
			var sphereZ = center.z + angle.z * radius;

			var x = sphereX > 0 ? Math.min(sphereX, boxMaxX) : Math.max(sphereX, boxMinX);
			var y = sphereY > 0 ? Math.min(sphereY, boxMaxY) : Math.max(sphereY, boxMinY);
			var z = sphereZ > 0 ? Math.min(sphereZ, boxMaxZ) : Math.max(sphereZ, boxMinZ);

			this.newpos[i].x = x;
			this.newpos[i].y = y;
			this.newpos[i].z = z;


		//}
	}*/

	geometry.computeFaceNormals();
	geometry.computeVertexNormals();

	this.constructMesh(pigStatueCache.geometry, pigStatueCache.materials, options);


	this.helper = new THREE.Mesh(new THREE.BoxGeometry(1,1,1), new THREE.MeshBasicMaterial({color:0xff0000}));
	//this.add(this.helper);

	this.helperOuter = new THREE.Mesh(new THREE.SphereGeometry(150,10,10), new THREE.MeshBasicMaterial({color: 0x00ff00, wireframe:true}));
	this.helperInner = new THREE.Mesh(new THREE.SphereGeometry(100,10,10), new THREE.MeshBasicMaterial({color: 0x00ff00, wireframe:true}));
	//this.add(this.helperOuter);
	//this.add(this.helperInner);


	this.animate = function (n)
	{
		var geometry = this.mesh.geometry;

		for (var i=0; i<geometry.vertices.length; i++)
		{
			/*if (n>1)
			{
				geometry.vertices[i] = this.newpos[i];	
			} else
			{
				geometry.vertices[i] = this.orig[i];
			}*/
			//geometry.vertices[i] = this.orig[i].lerp(this.newpos[i], n);

			/*var p = new THREE.Vector3(geometry.vertices[i].x,geometry.vertices[i].y,geometry.vertices[i].z);
			p.lerpVectors(this.orig[i], this.newpos[i], n);
			geometry.vertices[i] = p;*/

			var vertexN = segmentTransition(this.perlinorder[i], this.perlinorder[i] + 0.3, n);


			var deg = getVal('var2');

			//var point = new THREE.Vector3(Math.sin(deg)*140, 70, Math.cos(deg)*140);

			var point = new THREE.Vector3(getVal('var3'), getVal('var4'), getVal('var5'));

			this.helper.position.set(point.x, point.y, point.z);
			this.helperOuter.position.set(point.x, point.y, point.z);
			this.helperInner.position.set(point.x, point.y, point.z);

			var radiusOuter = 150;
			var radiusInner = 100;

			var dist = point.distanceTo(this.newpos[i]);


			if (dist > radiusOuter)
			{
				var circleN = 0;
			}
			else if (dist < radiusInner)
			{
				var circleN = 1;
			} else if (dist < radiusOuter)
			{
				var circleN = (radiusOuter - dist)/(radiusOuter - radiusInner);
			}

			/*if (i == 0)
				console.log(circleN);
			*/

			vertexN = Math.min((1-circleN), vertexN);

			vertexN = easeOne('easeInOutQuad', vertexN);

			var p = this.orig[i].clone();
			p.lerp(this.newpos[i], vertexN);

			var noiseAmount = getVal('var1');
			var noiseTime = getVal('var2')/10;

			p.x += noise.perlin3(p.x+noiseTime, p.y+noiseTime, p.z+noiseTime) * noiseAmount;
			p.y += noise.perlin3(p.x+noiseTime+10, p.y+noiseTime+10, p.z+noiseTime+10) * noiseAmount;
			p.z += noise.perlin3(p.x+noiseTime+10, p.y+noiseTime+20, p.z+noiseTime+20) * noiseAmount;

			geometry.vertices[i].set(p.x, p.y, p.z);

		}

		geometry.computeFaceNormals();
		geometry.computeVertexNormals();
		geometry.normalsNeedUpdate = true;
		geometry.verticesNeedUpdate = true;
	}
};

THREE.PigStatue.prototype = Object.create( THREE.Object3D.prototype);
THREE.PigStatue.prototype.constructor = THREE.Pig;

THREE.PigStatue.prototype.constructMesh = function(geometry, materials, options) {
	
	var material = new THREE.MeshLambertMaterial({
		color: 0xA0A09F,
		shading: THREE.FlatShading,
		wireframe:false
	});
	var mesh = new THREE.Mesh( geometry, material );

	//mesh.scale.x = mesh.scale.y = mesh.scale.z = 0.1;
	//mesh.rotation.y = Math.PI;
	mesh.castShadow = true;
	mesh.receiveShadow = true;

	this.mesh = mesh;
	this.add( mesh );
};

THREE.PigStatue.prototype.computeBoundingBox = function() {
	this.mesh.geometry.computeBoundingBox();
	return this.mesh.geometry.boundingBox;
};

THREE.PigStatue.prototype.getBoundingBox = function() {
	return this.mesh.geometry.boundingBox;
}

THREE.PigStatue.meshData = 
{

"metadata":
{
"sourceFile": "low_gris.max",
"generatedBy": "3ds max ThreeJSExporter",
"formatVersion": 3.1,
"vertices": 186,
"normals": 186,
"colors": 0,
"uvs": 276,
"triangles": 368,
"materials": 3
},

"materials": [
{
"DbgIndex" : 0,
"DbgName"  : "Pig skin",
"colorDiffuse"  : [0.7882, 0.4078, 0.3294],
"colorAmbient"  : [0.6000, 0.6000, 0.6000],
"colorSpecular"  : [0.9412, 0.6588, 0.6588],
"transparency"  : 1.0,
"specularCoef"  : 0.0,
"vertexColors" : false
},

{
"DbgIndex" : 1,
"DbgName"  : "Eye center",
"colorDiffuse"  : [0.0000, 0.0000, 0.0000],
"colorAmbient"  : [0.0000, 0.0000, 0.0000],
"colorSpecular"  : [0.9000, 0.9000, 0.9000],
"transparency"  : 1.0,
"specularCoef"  : 10.0,
"vertexColors" : false
},

{
"DbgIndex" : 2,
"DbgName"  : "Eye ball",
"colorDiffuse"  : [1.0000, 1.0000, 1.0000],
"colorAmbient"  : [1.0000, 1.0000, 1.0000],
"colorSpecular"  : [0.9000, 0.9000, 0.9000],
"transparency"  : 1.0,
"specularCoef"  : 10.0,
"vertexColors" : false
}

],

"vertices": [-13.9726,-18.1342,-47.8993,-22.5018,-6.39475,-47.8993,-22.5018,8.11594,-47.8993,-13.9726,19.8553,-47.8993,-22.5018,-29.8736,-27.927,-36.3023,-10.8788,-27.927,-36.3023,12.6,-27.927,-22.5017,31.5947,-27.927,-22.5018,-29.8735,12.3435,-36.3023,-10.8788,12.3435,-36.3022,12.6,12.3435,-22.5017,31.5947,12.3435,-13.9726,-18.1341,32.3158,-22.5018,-6.39474,32.3158,-22.5018,8.11595,32.3158,-13.9726,19.8553,32.3158,-40.8057,-41.6443,29.7116,-28.4286,-41.6443,23.4358,-23.7482,-41.6443,39.328,-30.7601,-41.6443,42.8834,-28.0008,-41.6443,-58.2532,-21.8393,-41.6443,-53.3785,-29.566,-41.6443,-38.7281,-40.4419,-41.6443,-47.3327,-4.53015,-7.3611,37.4957,-8.21969,-2.28289,37.4957,-8.21968,3.99414,37.4957,-4.53014,8.68744,37.4957,-4.55508,6.81705,45.1632,-7.29152,3.05067,45.1632,-7.29153,-1.60484,45.1632,-4.55509,-5.37123,45.1632,-5.97144,8.76317,46.8124,-9.58268,3.08971,46.8124,-9.58269,-1.57008,46.8124,-5.94949,-5.26949,46.8076,-5.63099,8.29048,49.2712,-9.03217,3.1081,49.2711,-9.03218,-1.56343,49.2712,-5.61431,-5.31642,49.2683,-8.16047,13.2181,35.5042,-13.1011,5.40293,35.7253,-13.4585,-3.79114,35.5957,-7.90142,-9.42225,35.9456,-14.0268,17.947,34.1047,-20.5834,8.92259,34.1047,-13.6891,6.93288,36.6051,-9.78699,13.1052,36.4305,-14.1607,15.6769,36.198,-18.0508,9.76831,36.4357,-14.3198,8.67937,37.1915,-11.3812,13.3214,36.986,-29.1207,10.2666,22.7367,-18.0633,25.4858,22.7367,-29.006,39.8782,19.551,-33.0839,37.6453,19.551,-31.3148,36.8504,22.8802,-27.9516,38.6052,22.8802,-27.7834,15.0456,22.6666,-20.2115,25.4673,22.6629,-28.4504,36.3984,22.7844,-29.5005,35.8506,22.7763,-27.3803,15.0974,15.8839,-20.9693,23.9214,15.879,-28.6589,34.1236,15.9931,-28.9386,33.9777,15.9824,-5.27346,-6.2785,24.7651,-10.0743,-10.049,22.2953,-5.9758,-1.04695,49.2773,-5.9758,2.56609,49.2772,-2.43837,-1.04831,49.2859,-2.43837,2.40266,49.2858,-6.22313,2.8487,39.9213,-6.22313,-1.31699,39.9214,-2.1457,-1.31857,39.9313,-2.1457,2.66033,39.9312,-22.5018,-29.8735,-7.96362,-36.3023,-10.8788,-7.96362,-36.3022,12.6,-7.96362,-22.5017,31.5947,-7.96363,-0.0906634,-11.4765,22.2789,-0.0906702,0.860578,-55.528,-0.0906695,-18.9236,-47.8992,13.7913,-18.1342,-47.8993,22.3204,-6.39475,-47.8993,22.3204,8.11594,-47.8993,13.7912,19.8553,-47.8993,-0.0906695,24.3394,-47.8993,-0.0906678,-33.4343,-27.927,22.3204,-29.8736,-27.927,21.6579,-41.6443,-53.3785,29.3847,-41.6443,-38.7282,40.2606,-41.6443,-47.3327,27.8194,-41.6443,-58.2532,36.1209,-10.8788,-27.927,36.1209,12.6,-27.927,22.3204,31.5947,-27.927,-0.0906678,38.8501,-27.927,-0.090666,-33.4343,-7.96362,22.3205,-29.8735,-7.96362,36.1209,-10.8788,-7.96363,36.1209,12.6,-7.96363,22.3204,31.5947,-7.96363,-0.090666,38.8501,-7.96363,-0.0906643,-33.4342,12.3435,-0.0906625,-18.9236,32.3158,13.7913,-18.1341,32.3158,22.3205,-29.8735,12.3435,28.2473,-41.6443,23.4358,23.5668,-41.6443,39.328,30.5788,-41.6443,42.8834,40.6244,-41.6443,29.7115,36.1209,-10.8788,12.3435,22.3204,-6.39474,32.3158,22.3204,8.11595,32.3158,28.9394,10.2666,22.7367,36.1209,12.6,12.3435,32.9025,37.6453,19.551,31.1335,36.8504,22.8801,27.7703,38.6052,22.8801,28.8246,39.8782,19.551,22.3204,31.5947,12.3435,17.882,25.4858,22.7367,13.7913,19.8553,32.3158,-0.0906625,24.3394,32.3158,-0.0906643,38.8501,12.3435,5.09213,-6.2785,24.7651,9.89298,-10.049,22.2953,-0.0906632,-5.9311,24.9443,8.03836,-2.28289,37.4957,13.2771,-3.79114,35.5957,7.7201,-9.42225,35.9456,4.34883,-7.3611,37.4957,8.03836,3.99414,37.4957,12.9198,5.40293,35.7253,11.1999,13.3214,36.986,13.9794,15.6769,36.198,17.8695,9.76831,36.4357,14.1384,8.67937,37.1915,-0.0906621,8.81775,37.4957,-0.0906623,16.6995,35.2852,7.97914,13.2181,35.5042,4.34881,8.68744,37.4957,-0.090661,-5.0694,49.1952,-0.090661,0.715998,49.298,5.43299,-5.31642,49.2683,2.25705,-1.04831,49.2859,5.79448,-1.04695,49.2773,8.85086,-1.56343,49.2712,5.79448,2.56609,49.2772,8.85085,3.1081,49.2711,2.25705,2.40266,49.2858,5.44966,8.29048,49.2712,-0.090661,8.7107,49.2719,4.37376,6.81705,45.1632,-0.0906614,6.80038,45.1632,7.1102,3.05067,45.1632,7.1102,-1.60484,45.1632,4.37377,-5.37123,45.1632,-0.0906621,-7.52416,37.5437,-0.0906614,-5.08292,45.1159,5.79012,8.76317,46.8124,-0.0906613,9.4725,46.8133,9.40136,3.08971,46.8124,9.40136,-1.57008,46.8124,5.76817,-5.26949,46.8076,-0.0906613,-5.0657,46.7262,-0.0906622,-10.9872,36.0431,20.4021,8.92259,34.1047,13.8455,17.947,34.1047,13.5077,6.93288,36.6051,9.60567,13.1052,36.4305,27.1989,15.0974,15.8839,20.788,23.9214,15.879,28.4775,34.1236,15.9931,28.7573,33.9777,15.9824,20.0302,25.4673,22.6629,27.602,15.0456,22.6666,28.2691,36.3984,22.7844,29.3192,35.8506,22.7763,-0.0906622,-11.0101,35.523,-0.0906621,-7.46235,37.0723,6.04181,-1.31699,39.9214,1.96438,-1.31857,39.9313,1.96438,2.66033,39.9312,6.04181,2.8487,39.9213],

"normals": [-0.0204547,-0.359702,-0.932843,-0.260861,-0.189527,-0.946589,-0.322241,0.0,-0.946658,-0.260861,0.189527,-0.946589,-0.0484453,-0.851916,-0.521432,-0.822702,4.42309e-007,-0.568473,-0.822702,3.91252e-007,-0.568473,-0.665579,0.483573,-0.568473,-0.131712,-0.828998,0.543521,-0.822702,6.90143e-007,0.568473,-0.822702,4.8872e-007,0.568473,-0.252924,0.783016,0.568257,-0.131712,-0.828998,0.543521,-0.822702,6.90143e-007,0.568473,-0.822702,6.90143e-007,0.568473,-0.252924,0.783016,0.568257,-2.22258e-007,-1.0,1.69507e-007,-2.22258e-007,-1.0,1.69507e-007,0.0,-1.0,2.08849e-007,-2.22258e-007,-1.0,1.69507e-007,-1.80274e-007,-1.0,-5.5469e-007,-1.80274e-007,-1.0,-5.5469e-007,0.0,-1.0,3.14246e-007,-1.80274e-007,-1.0,-5.5469e-007,-0.296263,-0.215246,0.930536,-0.27747,-0.215643,0.93622,-0.340956,2.07207e-007,0.940079,-0.113489,0.32219,0.939848,-0.0285075,0.971139,0.236805,-0.774884,0.60916,0.168757,-0.992753,6.0332e-007,0.120174,-0.800077,-0.581289,0.148255,0.002419,0.647535,-0.762032,-0.534069,0.388024,-0.751137,-0.584207,4.78696e-007,-0.811605,-0.678422,-0.492902,-0.544786,-0.00559837,-0.000557498,0.999984,-0.00198968,2.00602e-005,0.999998,-0.00160841,-0.00224032,0.999996,0.014026,-0.017766,0.999744,-0.113489,0.32219,0.939848,-0.340955,8.1179e-007,0.94008,-0.27747,-0.215643,0.93622,-0.27747,-0.215643,0.93622,-0.692951,0.50346,0.516088,-0.692951,0.503459,0.516089,-0.420521,-0.568322,0.707228,0.489136,-0.285917,0.824013,-0.156467,0.142332,0.977374,-0.156467,0.142332,0.977374,-0.156467,0.142332,0.977374,-0.156466,0.142332,0.977374,-0.822702,3.34901e-007,0.568473,-0.252924,0.783016,0.568257,-0.416129,0.79755,0.436751,-0.435567,0.795449,0.421359,-0.416129,0.79755,0.436751,-0.416129,0.79755,0.436751,-0.0320361,0.0236299,0.999207,-0.0345529,0.0251045,0.999088,-0.0331117,-0.0358746,0.998808,0.0277903,-0.0532616,0.998194,0.00793372,-0.00520596,0.999955,0.00793372,-0.00520596,0.999955,0.00793372,-0.00520596,0.999955,-0.0341972,-0.00803393,0.999383,-0.0678794,-0.484763,0.872008,-0.0678794,-0.484763,0.872008,-0.00241969,-0.00230901,0.999994,-0.00198968,2.00602e-005,0.999998,-0.00474892,-0.000575784,0.999989,-0.00559837,-0.000557498,0.999984,-0.0024272,1.24635e-005,0.999997,-0.00241935,2.0146e-005,0.999997,-0.0024272,1.24635e-005,0.999997,-0.0024272,1.24635e-005,0.999997,-0.156913,-0.987612,2.0371e-007,-0.809017,-0.587785,2.38828e-007,-1.0,6.49896e-007,1.91085e-007,-0.809016,0.587786,1.54591e-007,-0.0678794,-0.484763,0.872008,-0.0204547,-0.359702,-0.932843,-0.0204547,-0.359702,-0.932843,0.0204545,-0.359702,-0.932843,0.260861,-0.189527,-0.946589,0.322241,0.0,-0.946658,0.260861,0.189527,-0.946589,-0.0993228,0.307489,-0.946354,-0.127489,-0.802415,-0.582989,0.127489,-0.802415,-0.582989,0.0,-1.0,3.14246e-007,0.0,-1.0,3.14246e-007,0.0,-1.0,3.14246e-007,1.80274e-007,-1.0,-5.54691e-007,0.822702,4.42309e-007,-0.568473,0.822702,4.42309e-007,-0.568473,0.665579,0.483573,-0.568473,-0.252832,0.782732,-0.568688,-0.156913,-0.987612,2.0371e-007,0.156913,-0.987612,1.73726e-007,0.809017,-0.587785,0.0,1.0,6.49896e-007,-1.91085e-007,0.809016,0.587786,0.0,-0.308,0.951386,-1.54782e-007,-0.131712,-0.828998,0.543521,-0.0459571,-0.808162,0.587164,0.0459573,-0.808162,0.587164,0.131712,-0.828998,0.543521,0.0,-1.0,2.08849e-007,0.0,-1.0,2.08849e-007,0.0,-1.0,2.08849e-007,2.22258e-007,-1.0,1.69507e-007,0.822702,4.93365e-007,0.568473,0.822702,6.90143e-007,0.568473,0.822702,3.90718e-007,0.568473,0.822702,4.93365e-007,0.568473,0.822702,4.93365e-007,0.568473,0.435567,0.795449,0.421359,0.435567,0.795449,0.421359,0.416129,0.79755,0.436751,0.435567,0.795449,0.421359,0.253364,0.78262,0.568606,0.252924,0.783016,0.568257,0.252924,0.783016,0.568257,-0.252924,0.783016,0.568257,-0.253364,0.78262,0.568606,0.00212953,-0.433211,0.90129,0.0678795,-0.484763,0.872008,-0.0021292,-0.433211,0.90129,0.296263,-0.215247,0.930536,0.277471,-0.215643,0.93622,0.296263,-0.215247,0.930536,0.296263,-0.215247,0.930536,0.340956,2.07207e-007,0.940079,0.340956,2.07207e-007,0.940079,0.156466,0.142332,0.977374,0.156466,0.142332,0.977374,0.156466,0.142332,0.977374,0.156466,0.142332,0.977374,-0.00792682,0.270036,0.962818,-0.113489,0.32219,0.939848,0.11349,0.322191,0.939847,0.00792682,0.270036,0.962818,0.014026,-0.017766,0.999744,0.014026,-0.017766,0.999744,-0.014026,-0.017766,0.999744,0.00241969,-0.00230901,0.999994,0.00160841,-0.00224032,0.999996,0.0016084,-0.00224032,0.999996,0.00198968,2.00602e-005,0.999998,0.0019903,1.96e-005,0.999998,0.00559837,-0.000557498,0.999984,0.00559837,-0.000557498,0.999984,-0.00037358,0.00326419,0.999995,-0.00361035,0.96708,0.254447,0.00361035,0.96708,0.254447,0.80112,0.582049,0.139378,0.992753,8.13456e-007,0.120174,0.800077,-0.581289,0.148254,-0.0382447,-0.951064,0.306618,-0.0382447,-0.951064,0.306618,0.0631239,0.524362,-0.849152,-0.0631239,0.524362,-0.849152,0.50019,0.318379,-0.805261,0.584207,5.9782e-007,-0.811604,0.510707,-0.500656,-0.698943,0.0645536,-0.997857,0.0106721,-0.0960291,-0.423141,0.900961,0.692951,0.50346,0.516088,0.692951,0.50346,0.516088,0.420521,-0.568323,0.707228,-0.489135,-0.285916,0.824014,0.0341972,-0.00803393,0.999383,-0.00793359,-0.00520597,0.999955,0.0341972,-0.00803393,0.999383,0.0341972,-0.00803393,0.999383,0.0320352,0.0236293,0.999207,0.0320352,0.0236293,0.999207,0.0340107,-0.0367301,0.998746,-0.0169509,-0.0471866,0.998742,1.0,2.04913e-007,0.0,1.0,1.56035e-006,0.0,0.00241935,2.0146e-005,0.999997,0.00241935,2.0146e-005,0.999997,0.0024272,1.24636e-005,0.999997,0.00241935,2.0146e-005,0.999997],

"colors": [],

"uvs": [[0.5,1.0,0.6,1.0,0.7,1.0,0.8,1.0,0.9,1.0,0.5,0.8,0.6,0.8,0.7,0.8,0.8,0.8,0.9,0.8,1.0,0.8,0.5,0.6,0.6,0.6,0.7,0.6,0.8,0.6,0.9,0.6,1.0,0.6,0.5,0.4,0.6,0.4,0.7,0.4,0.8,0.4,0.9,0.4,1.0,0.4,0.5,0.2,0.6,0.2,0.7,0.2,0.8,0.2,0.9,0.2,1.0,0.2,0.6,0.0,0.7,0.0,0.8,0.0,0.7,0.4,0.6,0.4,0.6,0.2,0.7,0.2,0.7,0.8,0.6,0.8,0.6,0.6,0.7,0.6,0.932083,0.0641666,0.5,0.0747068,0.532083,0.0641666,0.6,0.0641666,0.632083,0.0641666,0.7,0.0641666,0.732083,0.0641666,0.8,0.0641666,0.832083,0.0641666,0.9,0.0641666,0.932083,0.0641666,0.832083,0.0641666,0.9,0.0641666,0.732083,0.0641666,0.8,0.0641666,0.632083,0.0641666,0.7,0.0641666,0.532083,0.0641666,0.6,0.0641666,0.5,0.0747068,0.932083,0.0641666,0.832083,0.0641666,0.9,0.0641666,0.732083,0.0641666,0.8,0.0641666,0.632083,0.0641666,0.7,0.0641666,0.532083,0.0641666,0.6,0.0641666,0.5,0.0747068,0.9,0.0,0.5,0.0,0.932083,0.0641666,0.832083,0.0641666,0.9,0.0641666,0.732083,0.0641666,0.8,0.0641666,0.632083,0.0641666,0.7,0.0641666,0.532083,0.0641666,0.6,0.0641666,0.5,0.0747068,0.961067,0.122133,0.858195,0.11639,0.9,0.11639,0.755296,0.110593,0.8,0.110593,0.656996,0.113991,0.7,0.113991,0.556332,0.112664,0.6,0.112664,0.5,0.117843,0.9,0.2,0.8,0.2,0.8,0.110593,0.858195,0.11639,0.9,0.2,0.8,0.2,0.8,0.110593,0.858195,0.11639,0.8,0.295923,0.9,0.295923,0.9,0.4,0.8,0.4,0.8,0.295923,0.9,0.295923,0.8,0.295923,0.9,0.295923,0.9,0.295923,0.8,0.295923,0.8,0.295923,0.9,0.295923,0.9,0.295923,0.8,0.295923,0.532083,0.0641666,0.556332,0.112664,0.624814,0.0496275,0.7,0.0496275,0.724814,0.0496275,0.8,0.0496275,0.614565,0.0291292,0.7,0.0291292,0.714565,0.0291293,0.8,0.0291293,0.724814,0.0496275,0.7,0.0496275,0.7,0.0291292,0.714565,0.0291293,1.0,0.500854,0.5,0.500854,0.6,0.500854,0.7,0.500854,0.8,0.500854,0.9,0.500854,0.504273,0.11745,0.504411,0.0732577,0.5,0.117843,0.5,0.0747068,0.5,1.0,0.5,0.8,0.6,0.8,0.6,1.0,0.7,0.8,0.7,1.0,0.8,0.8,0.8,1.0,0.9,0.8,0.9,1.0,1.0,0.8,0.5,0.6,0.6,0.6,0.6,0.8,0.6,0.6,0.7,0.6,0.7,0.8,0.7,0.6,0.8,0.6,0.9,0.6,1.0,0.6,0.5,0.500854,0.6,0.500854,0.7,0.500854,0.8,0.500854,0.9,0.500854,1.0,0.500854,0.5,0.4,0.5,0.2,0.6,0.2,0.6,0.4,0.6,0.4,0.6,0.2,0.7,0.2,0.7,0.4,0.7,0.4,0.7,0.2,0.8,0.2,0.8,0.295923,0.8,0.4,0.8,0.4,0.8,0.295923,0.9,0.295923,0.9,0.4,0.9,0.4,0.9,0.295923,0.9,0.2,1.0,0.2,1.0,0.4,0.532083,0.0641666,0.556332,0.112664,0.504273,0.11745,0.504411,0.0732577,0.632083,0.0641666,0.656996,0.113991,0.6,0.112664,0.6,0.0641666,0.732083,0.0641666,0.755296,0.110593,0.7,0.113991,0.7,0.0641666,0.858195,0.11639,0.9,0.2,0.8,0.2,0.8,0.110593,0.932083,0.0641666,0.961067,0.122133,0.9,0.11639,0.9,0.0641666,0.5,0.0747068,0.5,0.0,0.532083,0.0641666,0.6,0.0641666,0.6,0.0,0.614565,0.0291292,0.624814,0.0496275,0.632083,0.0641666,0.7,0.0641666,0.7,0.0496275,0.724814,0.0496275,0.732083,0.0641666,0.8,0.0641666,0.8,0.0496275,0.8,0.0291293,0.8,0.0,0.832083,0.0641666,0.9,0.0641666,0.9,0.0,0.932083,0.0641666,0.9,0.0641666,0.932083,0.0641666,0.832083,0.0641666,0.8,0.0641666,0.8,0.0641666,0.832083,0.0641666,0.7,0.0641666,0.732083,0.0641666,0.6,0.0641666,0.632083,0.0641666,0.532083,0.0641666,0.5,0.0747068,0.5,0.0747068,0.532083,0.0641666,0.9,0.0641666,0.932083,0.0641666,0.8,0.0641666,0.832083,0.0641666,0.7,0.0641666,0.732083,0.0641666,0.6,0.0641666,0.632083,0.0641666,0.5,0.0747068,0.532083,0.0641666,0.8,0.110593,0.858195,0.11639,0.556332,0.112664,0.5,0.117843,0.8,0.2,0.9,0.2,0.8,0.110593,0.858195,0.11639,0.8,0.295923,0.9,0.295923,0.9,0.295923,0.8,0.295923,0.9,0.295923,0.8,0.295923,0.9,0.295923,0.8,0.295923,0.5,0.117843,0.5,0.0747068,0.7,0.0496275,0.7,0.0291292,0.714565,0.0291293,0.724814,0.0496275,0.7,0.0291292,0.7,0.0,0.714565,0.0291293]],

"faces": [42,81,82,0,0,0,5,6,81,82,0,42,81,0,1,0,1,6,7,81,0,1,42,81,1,2,0,2,7,8,81,1,2,42,81,2,3,0,3,8,9,81,2,3,42,81,3,87,0,4,9,10,81,3,87,42,4,0,82,0,12,6,5,4,0,82,42,82,88,4,0,5,11,12,82,88,4,42,23,20,21,0,39,36,37,23,20,21,42,21,22,23,0,37,38,39,21,22,23,42,6,2,1,0,14,8,7,6,2,1,42,1,5,6,0,7,13,14,1,5,6,42,7,3,2,0,15,9,8,7,3,2,42,2,6,7,0,8,14,15,2,6,7,42,97,87,3,0,16,10,9,97,87,3,42,3,7,97,0,9,15,16,3,7,97,42,98,76,4,0,129,130,12,98,76,4,42,4,88,98,0,12,11,129,4,88,98,42,76,77,5,0,130,131,13,76,77,5,42,5,4,76,0,13,12,130,5,4,76,42,77,78,6,0,131,132,14,77,78,6,42,6,5,77,0,14,13,131,6,5,77,42,78,79,7,0,132,133,15,78,79,7,42,7,6,78,0,15,14,132,7,6,78,42,79,103,97,0,133,128,16,79,103,97,42,97,7,79,0,16,15,133,97,7,79,42,12,8,104,0,24,18,17,12,8,104,42,104,105,12,0,17,23,24,104,105,12,42,19,16,17,0,35,32,33,19,16,17,42,17,18,19,0,33,34,35,17,18,19,42,9,13,14,0,19,25,26,9,13,14,42,9,14,52,0,19,26,100,9,14,52,42,9,52,10,0,19,100,20,9,52,10,42,56,57,54,0,104,105,102,56,57,54,42,54,55,56,0,102,103,104,54,55,56,42,53,15,124,0,101,27,28,53,15,124,42,11,53,124,0,21,101,28,11,53,124,42,11,124,125,0,21,28,22,11,124,125,42,66,67,80,0,114,115,134,66,67,80,42,80,128,66,0,134,135,114,80,128,66,42,25,42,43,0,44,87,90,25,42,43,42,43,24,25,0,90,43,44,43,24,25,42,41,42,25,0,85,88,45,41,42,25,42,25,26,41,0,45,46,85,25,26,41,42,48,49,50,1,96,97,98,48,49,50,42,50,51,48,1,98,99,96,50,51,48,42,140,40,27,0,82,84,49,140,40,27,42,27,139,140,0,49,40,82,27,139,140,42,9,8,17,0,19,18,33,9,8,17,42,17,16,9,0,33,32,19,17,16,9,42,8,12,18,0,18,24,34,8,12,18,42,18,17,8,0,34,33,18,18,17,8,42,12,13,19,0,24,25,35,12,13,19,42,19,18,12,0,35,34,24,19,18,12,42,13,9,16,0,25,19,32,13,9,16,42,16,19,13,0,32,35,25,16,19,13,42,1,0,21,0,7,6,37,1,0,21,42,21,20,1,0,37,36,7,21,20,1,42,0,4,22,0,6,12,38,0,4,22,42,22,21,0,0,38,37,6,22,21,0,42,4,5,23,0,12,13,39,4,5,23,42,23,22,4,0,39,38,12,23,22,4,42,5,1,20,0,13,7,36,5,1,20,42,20,23,5,0,36,39,13,20,23,5,42,143,144,39,0,81,71,79,143,144,39,42,39,144,70,0,80,29,120,39,144,70,42,39,70,68,0,80,120,116,39,70,68,42,39,68,38,0,80,116,77,39,68,38,42,68,69,37,0,117,118,75,68,69,37,42,37,38,68,0,75,78,117,37,38,68,42,71,144,36,0,123,31,73,71,144,36,42,69,71,36,0,119,123,73,69,71,36,42,37,69,36,0,76,119,73,37,69,36,42,36,144,153,0,74,70,72,36,144,153,42,139,27,28,0,40,49,52,139,27,28,42,28,155,139,0,52,50,40,28,155,139,42,27,26,29,0,48,47,54,27,26,29,42,29,28,27,0,54,51,48,29,28,27,42,26,25,30,0,46,45,56,26,25,30,42,30,29,26,0,56,53,46,30,29,26,42,25,24,31,0,44,43,58,25,24,31,42,31,30,25,0,58,55,44,31,30,25,42,24,159,160,0,42,41,59,24,159,160,42,160,31,24,0,59,57,42,160,31,24,42,155,28,32,0,50,52,62,155,28,32,42,32,162,155,0,62,60,50,32,162,155,42,28,29,33,0,51,54,64,28,29,33,42,33,32,28,0,64,61,51,33,32,28,42,29,30,34,0,53,56,66,29,30,34,42,34,33,29,0,66,63,53,34,33,29,42,30,31,35,0,55,58,68,30,31,35,42,35,34,30,0,68,65,55,35,34,30,42,31,160,166,0,57,59,69,31,160,166,42,166,35,31,0,69,67,57,166,35,31,42,162,32,36,0,60,62,74,162,32,36,42,36,153,162,0,74,72,60,36,153,162,42,32,33,37,0,61,64,76,32,33,37,42,37,36,32,0,76,73,61,37,36,32,42,33,34,38,0,63,66,78,33,34,38,42,38,37,33,0,78,75,63,38,37,33,42,34,35,39,0,65,68,80,34,35,39,42,39,38,34,0,80,77,65,39,38,34,42,35,166,143,0,67,69,81,35,166,143,42,143,39,35,0,81,79,67,143,39,35,42,124,15,40,0,28,27,84,124,15,40,42,40,140,124,0,84,82,28,40,140,124,42,26,27,40,0,47,48,83,26,27,40,42,40,41,26,0,83,86,47,40,41,26,42,14,13,42,0,26,25,88,14,13,42,42,42,41,14,0,88,85,26,42,41,14,42,42,13,12,0,87,25,24,42,13,12,42,12,43,42,0,24,90,87,12,43,42,42,43,12,105,0,89,24,23,43,12,105,42,105,167,43,0,23,91,89,105,167,43,42,15,14,45,2,27,26,93,15,14,45,42,45,44,15,2,93,92,27,45,44,15,42,14,41,46,2,26,85,94,14,41,46,42,46,45,14,2,94,93,26,46,45,14,42,41,40,47,2,86,83,95,41,40,47,42,47,46,41,2,95,94,86,47,46,41,42,40,15,44,2,84,27,92,40,15,44,42,44,47,40,2,92,95,84,44,47,40,42,44,45,49,2,92,93,97,44,45,49,42,49,48,44,2,97,96,92,49,48,44,42,45,46,50,2,93,94,98,45,46,50,42,50,49,45,2,98,97,93,50,49,45,42,46,47,51,2,94,95,99,46,47,51,42,51,50,46,2,99,98,94,51,50,46,42,47,44,48,2,95,92,96,47,44,48,42,48,51,47,2,96,99,95,48,51,47,42,14,15,53,0,26,27,101,14,15,53,42,53,52,14,0,101,100,26,53,52,14,42,11,10,55,0,21,20,103,11,10,55,42,55,54,11,0,103,102,21,55,54,11,42,10,52,56,0,20,100,104,10,52,56,42,56,55,10,0,104,103,20,56,55,10,42,62,63,64,0,110,111,112,62,63,64,42,64,65,62,0,112,113,110,64,65,62,42,53,11,54,0,101,21,102,53,11,54,42,54,57,53,0,102,105,101,54,57,53,42,52,53,59,0,100,101,107,52,53,59,42,59,58,52,0,107,106,100,59,58,52,42,53,57,60,0,101,105,108,53,57,60,42,60,59,53,0,108,107,101,60,59,53,42,57,56,61,0,105,104,109,57,56,61,42,61,60,57,0,109,108,105,61,60,57,42,56,52,58,0,104,100,106,56,52,58,42,58,61,56,0,106,109,104,58,61,56,42,58,59,63,0,106,107,111,58,59,63,42,63,62,58,0,111,110,106,63,62,58,42,59,60,64,0,107,108,112,59,60,64,42,64,63,59,0,112,111,107,64,63,59,42,60,61,65,0,108,109,113,60,61,65,42,65,64,60,0,113,112,108,65,64,60,42,61,58,62,0,109,106,110,61,58,62,42,62,65,61,0,110,113,109,62,65,61,42,24,43,67,0,43,90,115,24,43,67,42,67,66,24,0,115,114,43,67,66,24,42,167,180,80,0,91,136,134,167,180,80,42,167,80,67,0,91,134,115,167,80,67,42,43,167,67,0,89,91,115,43,167,67,42,159,24,66,0,41,42,114,159,24,66,42,159,66,128,0,41,114,135,159,66,128,42,159,128,181,0,41,135,137,159,128,181,42,74,75,72,0,126,127,124,74,75,72,42,72,73,74,0,124,125,126,72,73,74,42,70,144,71,0,121,30,122,70,144,71,42,69,68,73,0,118,117,125,69,68,73,42,73,72,69,0,125,124,118,73,72,69,42,68,70,74,0,116,120,126,68,70,74,42,74,73,68,0,126,125,116,74,73,68,42,70,71,75,0,121,122,127,70,71,75,42,75,74,70,0,127,126,121,75,74,70,42,71,69,72,0,123,119,124,71,69,72,42,72,75,71,0,124,127,123,72,75,71,42,104,8,76,0,17,18,130,104,8,76,42,76,98,104,0,130,129,17,76,98,104,42,8,9,77,0,18,19,131,8,9,77,42,77,76,8,0,131,130,18,77,76,8,42,9,10,78,0,19,20,132,9,10,78,42,78,77,9,0,132,131,19,78,77,9,42,10,11,79,0,20,21,133,10,11,79,42,79,78,10,0,133,132,20,79,78,10,42,11,125,103,0,21,22,128,11,125,103,42,103,79,11,0,128,133,21,103,79,11,42,81,83,82,0,138,140,139,81,83,82,42,81,84,83,0,141,142,140,81,84,83,42,81,85,84,0,143,144,142,81,85,84,42,81,86,85,0,145,146,144,81,86,85,42,81,87,86,0,147,148,146,81,87,86,42,89,88,82,0,150,149,139,89,88,82,42,82,83,89,0,139,140,150,82,83,89,42,92,91,90,0,153,152,151,92,91,90,42,90,93,92,0,151,154,153,90,93,92,42,95,94,84,0,156,155,142,95,94,84,42,84,85,95,0,142,144,156,84,85,95,42,96,95,85,0,157,156,144,96,95,85,42,85,86,96,0,144,146,157,85,86,96,42,97,96,86,0,158,157,146,97,96,86,42,86,87,97,0,146,148,158,86,87,97,42,98,88,89,0,159,149,150,98,88,89,42,89,99,98,0,150,160,159,89,99,98,42,99,89,94,0,160,150,155,99,89,94,42,94,100,99,0,155,161,160,94,100,99,42,100,94,95,0,161,155,156,100,94,95,42,95,101,100,0,156,162,161,95,101,100,42,101,95,96,0,162,156,157,101,95,96,42,96,102,101,0,157,163,162,96,102,101,42,102,96,97,0,163,157,158,102,96,97,42,97,103,102,0,158,164,163,97,103,102,42,106,105,104,0,167,166,165,106,105,104,42,104,107,106,0,165,168,167,104,107,106,42,110,109,108,0,171,170,169,110,109,108,42,108,111,110,0,169,172,171,108,111,110,42,112,116,115,0,173,177,176,112,116,115,42,112,115,114,0,173,176,175,112,115,114,42,112,114,113,0,173,175,174,112,114,113,42,118,117,120,0,179,178,181,118,117,120,42,120,119,118,0,181,180,179,120,119,118,42,121,125,124,0,182,186,185,121,125,124,42,124,123,122,0,185,184,183,124,123,122,42,121,124,122,0,182,185,183,121,124,122,42,126,128,80,0,187,190,189,126,128,80,42,80,127,126,0,189,188,187,80,127,126,42,129,132,131,0,191,194,193,129,132,131,42,131,130,129,0,193,192,191,131,130,129,42,134,133,129,0,196,195,198,134,133,129,42,129,130,134,0,198,197,196,129,130,134,42,136,135,138,1,200,199,202,136,135,138,42,138,137,136,1,202,201,200,138,137,136,42,140,139,142,0,204,203,206,140,139,142,42,142,141,140,0,206,205,204,142,141,140,42,112,111,108,0,173,172,169,112,111,108,42,108,107,112,0,169,168,173,108,107,112,42,107,108,109,0,168,169,170,107,108,109,42,109,106,107,0,170,167,168,109,106,107,42,106,109,110,0,167,170,171,106,109,110,42,110,113,106,0,171,174,167,110,113,106,42,113,110,111,0,174,171,172,113,110,111,42,111,112,113,0,172,173,174,111,112,113,42,84,93,90,0,142,154,151,84,93,90,42,90,83,84,0,151,140,142,90,83,84,42,83,90,91,0,140,151,152,83,90,91,42,91,89,83,0,152,150,140,91,89,83,42,89,91,92,0,150,152,153,89,91,92,42,92,94,89,0,153,155,150,92,94,89,42,94,92,93,0,155,153,154,94,92,93,42,93,84,94,0,154,142,155,93,84,94,42,143,145,144,0,207,209,208,143,145,144,42,145,148,147,0,210,214,213,145,148,147,42,145,147,146,0,210,213,212,145,147,146,42,145,146,144,0,210,212,211,145,146,144,42,147,148,150,0,216,215,218,147,148,150,42,150,149,147,0,218,217,216,150,149,147,42,152,144,151,0,223,222,221,152,144,151,42,152,151,149,0,223,221,220,152,151,149,42,150,152,149,0,219,223,220,150,152,149,42,152,153,144,0,224,226,225,152,153,144,42,139,155,154,0,203,228,227,139,155,154,42,154,142,139,0,227,206,203,154,142,139,42,142,154,156,0,229,232,231,142,154,156,42,156,133,142,0,231,230,229,156,133,142,42,133,156,157,0,195,234,233,133,156,157,42,157,129,133,0,233,198,195,157,129,133,42,129,157,158,0,191,236,235,129,157,158,42,158,132,129,0,235,194,191,158,132,129,42,132,158,160,0,237,240,239,132,158,160,42,160,159,132,0,239,238,237,160,159,132,42,155,162,161,0,228,242,241,155,162,161,42,161,154,155,0,241,227,228,161,154,155,42,154,161,163,0,232,244,243,154,161,163,42,163,156,154,0,243,231,232,163,156,154,42,156,163,164,0,234,246,245,156,163,164,42,164,157,156,0,245,233,234,164,157,156,42,157,164,165,0,236,248,247,157,164,165,42,165,158,157,0,247,235,236,165,158,157,42,158,165,166,0,240,250,249,158,165,166,42,166,160,158,0,249,239,240,166,160,158,42,162,153,152,0,242,226,224,162,153,152,42,152,161,162,0,224,241,242,152,161,162,42,161,152,150,0,244,223,219,161,152,150,42,150,163,161,0,219,243,244,150,163,161,42,163,150,148,0,246,218,215,163,150,148,42,148,164,163,0,215,245,246,148,164,163,42,164,148,145,0,248,214,210,164,148,145,42,145,165,164,0,210,247,248,145,165,164,42,165,145,143,0,250,209,207,165,145,143,42,143,166,165,0,207,249,250,143,166,165,42,124,140,141,0,185,204,205,124,140,141,42,141,123,124,0,205,184,185,141,123,124,42,133,134,141,0,230,251,252,133,134,141,42,141,142,133,0,252,229,230,141,142,133,42,114,134,130,0,175,196,197,114,134,130,42,130,113,114,0,197,174,175,130,113,114,42,130,131,106,0,192,193,167,130,131,106,42,106,113,130,0,167,174,192,106,113,130,42,131,167,105,0,253,254,166,131,167,105,42,105,106,131,0,166,167,253,105,106,131,42,123,169,168,2,184,256,255,123,169,168,42,168,114,123,2,255,175,184,168,114,123,42,114,168,170,2,175,255,257,114,168,170,42,170,134,114,2,257,196,175,170,134,114,42,134,170,171,2,251,257,258,134,170,171,42,171,141,134,2,258,252,251,171,141,134,42,141,171,169,2,205,258,256,141,171,169,42,169,123,141,2,256,184,205,169,123,141,42,169,136,137,2,256,200,201,169,136,137,42,137,168,169,2,201,255,256,137,168,169,42,168,137,138,2,255,201,202,168,137,138,42,138,170,168,2,202,257,255,138,170,168,42,170,138,135,2,257,202,199,170,138,135,42,135,171,170,2,199,258,257,135,171,170,42,171,135,136,2,258,199,200,171,135,136,42,136,169,171,2,200,256,258,136,169,171,42,114,115,122,0,175,176,183,114,115,122,42,122,123,114,0,183,184,175,122,123,114,42,121,120,117,0,182,181,178,121,120,117,42,117,116,121,0,178,177,182,117,116,121,42,116,117,118,0,177,178,179,116,117,118,42,118,115,116,0,179,176,177,118,115,116,42,172,175,174,0,259,262,261,172,175,174,42,174,173,172,0,261,260,259,174,173,172,42,122,119,120,0,183,180,181,122,119,120,42,120,121,122,0,181,182,183,120,121,122,42,115,177,176,0,176,264,263,115,177,176,42,176,122,115,0,263,183,176,176,122,115,42,122,176,178,0,183,263,265,122,176,178,42,178,119,122,0,265,180,183,178,119,122,42,119,178,179,0,180,265,266,119,178,179,42,179,118,119,0,266,179,180,179,118,119,42,118,179,177,0,179,266,264,118,179,177,42,177,115,118,0,264,176,179,177,115,118,42,177,172,173,0,264,259,260,177,172,173,42,173,176,177,0,260,263,264,173,176,177,42,176,173,174,0,263,260,261,176,173,174,42,174,178,176,0,261,265,263,174,178,176,42,178,174,175,0,265,261,262,178,174,175,42,175,179,178,0,262,266,265,175,179,178,42,179,175,172,0,266,262,259,179,175,172,42,172,177,179,0,259,264,266,172,177,179,42,132,126,127,0,194,187,188,132,126,127,42,127,131,132,0,188,193,194,127,131,132,42,80,180,167,0,189,267,254,80,180,167,42,127,80,167,0,188,189,254,127,80,167,42,131,127,167,0,253,188,254,131,127,167,42,159,181,128,0,238,268,190,159,181,128,42,159,128,126,0,238,190,187,159,128,126,42,159,126,132,0,238,187,237,159,126,132,42,183,182,185,0,270,269,272,183,182,185,42,185,184,183,0,272,271,270,185,184,183,42,146,151,144,0,273,275,274,146,151,144,42,149,185,182,0,217,272,269,149,185,182,42,182,147,149,0,269,216,217,182,147,149,42,147,182,183,0,213,269,270,147,182,183,42,183,146,147,0,270,212,213,183,146,147,42,146,183,184,0,273,270,271,146,183,184,42,184,151,146,0,271,275,273,184,151,146,42,151,184,185,0,221,271,272,151,184,185,42,185,149,151,0,272,220,221,185,149,151,42,104,98,99,0,165,159,160,104,98,99,42,99,107,104,0,160,168,165,99,107,104,42,107,99,100,0,168,160,161,107,99,100,42,100,112,107,0,161,173,168,100,112,107,42,112,100,101,0,173,161,162,112,100,101,42,101,116,112,0,162,177,173,101,116,112,42,116,101,102,0,177,162,163,116,101,102,42,102,121,116,0,163,182,177,102,121,116,42,121,102,103,0,182,163,164,121,102,103,42,103,125,121,0,164,186,182,103,125,121]

};