'use strict';

THREE.Hand = function (options) {

	options = options || {};

	THREE.Object3D.call( this );
	this.type = 'Hand';

	tex.flare = load_texture(texture_dir+'flare.png','Particle Flare');

	var $this = this;

	var loader = new THREE.JSONLoader();
	loader.load( 'models/hand.js', function ( geometry, materials ) {

		var material = new THREE.ShaderMaterial({
			uniforms: {
				texture: { type: 't', value: tex.flare },
				t: { type: "f", value: 1.0 },
				e: { type: "f", value: 1.0 },
			},
			vertexShader: THREE.ShaderChunk['particleVertex'],
			fragmentShader: THREE.ShaderChunk['particleFragment'],
			transparent: true,
			blending: THREE.AdditiveBlending
		});
/*

		var material = new THREE.PointCloudMaterial({ 
			size: 1, 
			map: tex.flare,
			transparent: true,
			blending: THREE.AdditiveBlending
		});
*/
		$this.mesh = new THREE.PointCloud( geometry, material );

		$this.mesh.scale.set(100, 100, 100);
		$this.add($this.mesh);
	});
};

THREE.Hand.prototype = Object.create( THREE.Object3D.prototype);
THREE.Hand.prototype.constructor = THREE.Hand;

THREE.Hand.prototype.animate = function(t, e) {
	this.mesh.material.uniforms.t.value = t;
	this.mesh.material.uniforms.e.value = e;
};