function _launchpad()
{
	this.launchpads = [];

	this.getScene = function(i) {
		return this.launchpads[i].scene;
	};

	this.add = function(scene, func, index)
	{
		if(typeof(index) === "undefined") {
			this.launchpads.push(
				{
					scene: scene,
					func: func
				}
			);	
		} else {
			this.launchpads[index] = {
				scene: scene,
				func: func
			};
		}	
	};

	this.launch = function(i)
	{
		i = Math.floor(i);

		if (i < this.launchpads.length)
		{
			var percent = getVal("percent");
			if(isNaN(percent)) {
				return;
			}
			if(typeof(this.launchpads[i]) !== "undefined") {
				this.launchpads[i].func.apply(this.launchpads[i].scene, [row / ROW_RATE, percent]);	
			}
			
		}
	}

	this.size = function() {
		return this.launchpads.length;
	}
}