.pc =$0801 "Basic Upstart Program"
:BasicUpstart($4000)

.var music = LoadSid("Actually_intro.sid")

.pc = $4000 "kezGYuk"

	sei
	lda #$7f
	sta $dc0d
	lda #$81
	sta $d01a
	lda #<i_irq
	sta $0314
	lda #>i_irq
	sta $0315
	
	// eredeti:    lda #$b9   //raster kezdo
	lda #$31
	sta $d012
	lda #$1b
	sta $d011

	lda #$00
	jsr $1000
	
	cli
	


//qblogo kirakas

	ldx #00

qbl1:	lda qblogo,x

	cmp #$20
	beq qbltov1
	sta $0400+7*40,x
	lda #$01
	sta $d800+7*40,x

qbltov1:

	inx
	bne qbl1


	ldx #00

qbl2:	lda qblogo+256,x

	cmp #$20
	beq qbltov2
	sta $0400+256+7*40,x
	lda #$01
	sta $d800+256+7*40,x


qbltov2:

	inx
	cpx #$90
	bne qbl2



iii:	lda intro    // ameddig az intro nem futott le, itt megallunk
	cmp #$00
	bne iii

	

	lda #$18
    	sta $d018	//char rom 2000 tol!  15 az alap

// keptorles:
	lda #147
	jsr $ffd2

//twister charset nullazas
	lda #$00
	ldx #$00
nu:	sta $5000,x
	sta $5100,x
	sta $5200,x
	sta $5300,x
	sta $5400,x
	sta $5500,x
	sta $5600,x
	sta $5700,x
	inx
	bne nu
	
//kepre kirakjuk a twister karaktereit meg kiszinezzuk
	ldy #$00
ujr1:	lda kep,y
	sta $0400,y

	lda kep+255,y
	sta $0400+255,y

	lda kep+255*2,y
	sta $0400+255*2,y

	lda kep+255*3,y
	sta $0400+255*3,y


	lda szin,y
	sta $d800,y

	lda szin+255,y
	sta $d800+255,y

	lda szin+255*2,y
	sta $d800+255*2,y

	lda szin+255*3,y
	sta $d800+255*3,y

	iny
	cpy #$ff
	bne ujr1


	

	


// szinek belovese----------------------------

	lda #$01
	sta $d020
	sta $d021


	
	lda #$0b
	sta $d022

	lda #$0c
	sta $d023

// spriteok belovese **************************

	lda #$ff
	sta $d015  //bekapcs
	sta $d01d  //szethuz vizszintesen
	sta $d017  //szethuz fuggolegesen
	
	lda #$40
	sta $d010  // 7-est atrakjuk jobbra
	




	ldx #$c0  //no*64 = $3000-tol minta

	ldy #$00
spri:	txa
	sta $07f8,y
	inx
	iny
	cpy #$08
	bne spri
	


	lda #$17	// pos x
	sta $d000
	lda #$47
	sta $d002
	lda #$77
	sta $d004
	lda #$a7
	sta $d006
	lda #$d7
	sta $d008
	lda #$07
	sta $d00a
	lda #$37
	sta $d00c




	
	lda #$b3	//pos y
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d




	lda #$00	// szinek
	sta $d027
	sta $d028
	sta $d029
	sta $d02a
	sta $d02b
	sta $d02c
	sta $d02d






twister:


//******************************* elso charset *******************************

	ldx #$00
kezd:	



	txa
	adc futo
	tay
	lda wave1,y
	//clc
	adc wave1,x
	tay
	

	lda nyolcvan,y  //$80al osztas :)  128
	tay


	lda $5000,y
	sta $2000,x

	lda $5080,y
	sta $2080,x

	lda $5100,y
	sta $2100,x

	lda $5180,y
	sta $2180,x

	lda $5200,y
	sta $2200,x

	lda $5280,y
	sta $2280,x

	lda $5300,y
	sta $2300,x

	lda $5380,y
	sta $2380,x

	lda $5400,y
	sta $2400,x

	lda $5480,y
	sta $2480,x

	lda $5500,y
	sta $2500,x

	lda $5580,y
	sta $2580,x

	lda $5600,y
	sta $2600,x

	lda $5680,y
	sta $2680,x

	lda $5700,y
	sta $2700,x

	lda $5780,y
	sta $2780,x
	

	inx
	cpx #$80
	bne kezd




//******************************* masodik charset *******************************
	ldx #$00
kezd2:	



	txa
	adc #$80
	adc futo

	tay
	lda wave1,y
	//clc
	adc wave1+$80,x
	tay
	

	lda nyolcvan,y  //$80al osztas :)  128
	tay


	lda $5000,y
	sta $2800,x

	lda $5080,y
	sta $2880,x

	lda $5100,y
	sta $2900,x

	lda $5180,y
	sta $2980,x

	lda $5200,y
	sta $2a00,x

	lda $5280,y
	sta $2a80,x

	lda $5300,y
	sta $2b00,x

	lda $5380,y
	sta $2b80,x

	lda $5400,y
	sta $2c00,x

	lda $5480,y
	sta $2c80,x

	lda $5500,y
	sta $2d00,x

	lda $5580,y
	sta $2d80,x

	lda $5600,y
	sta $2e00,x

	lda $5680,y
	sta $2e80,x

	lda $5700,y
	sta $2f00,x

	lda $5780,y
	sta $2f80,x
	

	inx
	cpx #$48
	bne kezd2

	




	lda futo
	clc
nov:	adc #$03 //8d
	sta futo   //  ezzzzzzzzzzzzzzzzzzzzzzzzzzt vissszaaa hogy fussson :)

	//inc nov+1


	

vege2:	jmp twister
//	rts











//----------------------------------------------------------
//                     Kozepso Resz / Charsetvalto  III
//----------------------------------------------------------
irq:  	
	inc $d019
	
nop
nop
nop
nop

	lda #$1a	//charsetvalt $2800-ra
	sta $d018






	sei
	lda #<irq2
	sta $0314
	lda #>irq2
	sta $0315
	
	lda #$fa   //raster kezdo
	sta $d012
	cli

	
	lda #$08
	ora #$10
	sta $d016


	jsr $1006


	jmp $ea31



//----------------------------------------------------------
//                     Also resz - AlsoFelso border IV
//----------------------------------------------------------
irq2:
	inc $d019

	nop
	nop
	nop
	nop
	nop
	nop

	
	lda #$00
	sta $d020
	sta $d021

	lda #$18	//charsetvalt $2000-ra
	sta $d018	


	sei
	lda #<irq3
	sta $0314
	lda #>irq3
	sta $0315
	
	lda #$32   //raster kezdo
	sta $d012
	cli

	// ********************
	// ** DnP Logo swing **
	// ********************

	ldx #$c8	//sprite adatok 3200tol
	stx $07f8
	inx
	stx $07f9
	inx
	stx $07fa
	inx
	stx $07fb
	inx
	stx $07fc
	inx
	stx $07fd

	inx
	stx $07fe
	inx
	stx $07ff


	





	
	lda #$30
	sta $d01d  //szethuz vizszintesen
	sta $d017  //szethuz fuggolegesen

	lda #$ff
	sta $d010	//atrakjuk jobbra mind


	lda #$00
	sta $d027
	sta $d028
	sta $d029
	sta $d02a

	lda #$04	//cinkes keret
	sta $d02b
	lda #$0d
	sta $d02c

	lda #$0c	//arnyek
	sta $d02d
	sta $d02e


	

	lda #$37+0  //Y
	sta $d001
	sta $d003

	sta $d00d	//arnyek Y
	
	lda #$4c+0
	sta $d005	
	sta $d007

	sta $d00f	//arnyek Y


	


	lda #$20+16	//X
	sta $d000
	sta $d004


	lda #$38+16
	sta $d002
	sta $d006

	
	//festett cucc
	lda #$27+16
	sta $d008
	lda #$38+0
	sta $d009

	lda #$29+16
	sta $d00a
	lda #$35+0
	sta $d00b

	//arnyek x
	lda #$2f+16
	sta $d00c
	sta $d00e
	
	


		

	jmp $ea31


//----------------------------------------------------------
//                     Felso Resz  I
//----------------------------------------------------------
irq3:
	inc $d019

	nop
	nop
	nop
	nop
	nop
	nop


	inc $d020
	inc $d021


	
	

	sei
	lda #<irq4
	sta $0314
	lda #>irq4
	sta $0315
	
	lda #$80   //raster kezdo
	sta $d012
	cli




	jmp $ea31

//----------------------------------------------------------
//                     Kozeps Resz II
//----------------------------------------------------------

irq4:
	inc $d019
	

	sei
	lda #<irq
	sta $0314
	lda #>irq
	sta $0315
	
	lda #$b2   //raster kezdo
	sta $d012
	cli

// **********************
// *** Sprite Scrolll ***
// **********************
	
	ldx #$c0   //elso 7 sprite visszarakasa (ezek a logoban is vannak fent)
	stx $07f8
	inx
	stx $07f9
	inx
	stx $07fa
	inx
	stx $07fb
	inx
	stx $07fc
	inx
	stx $07fd
	inx
	stx $07fe

	lda #$40
	sta $d010  // 7-est atrakjuk jobbra



	lda #$00
	sta $d01c
	lda #$7f
	sta $d01d  //szethuz vizszintesen
	sta $d017  //szethuz fuggolegesen
	



	ldx flashc	//villogassal szinkronizalva a pattogas
	lda spsin,x
	
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d

	inc sinpos


	ldx #$00
	ldy #$00
	

sppos:	
	dec sinx,x
	dec sinx,x
	
	lda sinx,x
	sta $d000,y

	inx
	iny
	iny

	cpx #$07
	bne sppos

	ldx flashc
	lda spcolor,x
	sta $d027
	sta $d028
	sta $d029
	sta $d02a
	sta $d02b
	sta $d02c
	sta $d02d





	inc sptol
	lda sptol
	cmp #$08
	bne nincs

	lda #$00
	sta sptol

	ldy #$00
	ldx #$00	// sprite x Reset
spres:	lda sinx+8,x
	sta sinx,x
	sta $d000,y
	inx
	iny
	iny

	cpx #$08
	bne spres


	jsr sprcopy

nincs:





//villogtassunk twistert:)

	inc flashc
	lda flashc
	cmp #$5a
	bne vill1
	
	jsr flashblack
	jmp fine4

vill1:
	cmp #$60
	bne fine4

	jsr flashblue
	lda #$00
	sta flashc



fine4:




	


	jmp $ea31





// sprite masolas*******
sprcopy:

	

	ldx #$00
copy:
	
	lda $3001,x
	sta $3000,x

	lda $3002,x
	sta $3001,x

	lda $3040,x
	sta $3002,x



	lda $3041,x
	sta $3040,x

	lda $3042,x
	sta $3041,x

	lda $3080,x
	sta $3042,x



	lda $3081,x
	sta $3080,x

	lda $3082,x
	sta $3081,x

	lda $30c0,x
	sta $3082,x



	lda $30c1,x
	sta $30c0,x

	lda $30c2,x
	sta $30c1,x

	lda $3100,x
	sta $30c2,x



	lda $3101,x
	sta $3100,x

	lda $3102,x
	sta $3101,x

	lda $3140,x
	sta $3102,x



	lda $3141,x
	sta $3140,x

	lda $3142,x
	sta $3141,x

	lda $3180,x
	sta $3142,x



	lda $3181,x
	sta $3180,x

	lda $3182,x
	sta $3181,x

	lda $31c0,x
	sta $3182,x







	inx
	inx
	inx

	cpx #$3c
	beq charcopy

	jmp copy


charcopy:
	clc
	inc txtpos
	bne olvas
	inc olvas+5
	lda olvas+5
	cmp #$68
	bne olvas
	lda #$65
	sta olvas+5
	
olvas:	ldx txtpos
	lda $6500,x
	
	asl
	asl
	asl

	tax
	
	ldy #$00
cop:	
	lda charset,x
	sta $31c6,y
	inx
	iny
	iny
	iny
	cpy #$18
	bne cop

fine:

	
// adunk egy sort a twisternek

	ldx twkirako
	cmp #$7c
	beq fine2	

	ldy #$00

ki2:	lda $6800,x
	sta $5000,x
	lda $6880,x
	sta $5080,x
	lda $6900,x
	sta $5100,x
	lda $6980,x
	sta $5180,x
	lda $6a00,x
	sta $5200,x
	lda $6a80,x
	sta $5280,x
	lda $6b00,x
	sta $5300,x
	lda $6b80,x
	sta $5380,x
	lda $6c00,x
	sta $5400,x
	lda $6c80,x
	sta $5480,x
	lda $6d00,x
	sta $5500,x
	lda $6d80,x
	sta $5580,x
	lda $6e00,x
	sta $5600,x
	lda $6e80,x
	sta $5680,x
	lda $6f00,x
	sta $5700,x
	lda $6f80,x
	sta $5780,x

	iny
	inx
	cpy #$04
	bne ki2



	cpx #$80
	bne fine2
	ldx #$7c

fine2:	stx twkirako	

// *********************
// ** Twister cserelo **
// *********************
	inc twcsere
	bne fine3
	


	lda tw_id  	//melyik efekt?
	asl		// id*16
	asl
	asl
	asl
	tax

	ldy #00
masol1:	lda byteok,x
	sta ki2+2,y
	inx

	tya
	adc #$06
	tay

	cpy #$60
	bne masol1

	lda #$00		//twisterkirako nullazasa
	sta twkirako

	inc tw_id
	lda tw_id
	cmp #$02
	bne fine3
	lda #$00
	sta tw_id






fine3:


	rts






// **************************
// ****    INTRO ************
// **************************

i_irq:  	
	inc $d019


	ldx #$0e
i_l1:	dex
	bne i_l1

// Rastercsik kirakasa

	ldx #$00

i_vis1:	lda i_szin,x
	sta $d020
	sta $d021

	ldy varakozas,x
i_vis:	dey
	bne i_vis

	inx
i_atir:	cpx #$01
	bne i_vis1


// vissza az eredeti keretszin

	lda keret
	sta $d020
	lda #$06
	sta $d021



	inc db2
	inc db
	

	lda db
	cmp #$c9
	bne i_tov
	lda #$c8
	sta db
	ldy #$01
	sty fade_on

i_tov:
	sta i_atir+1
	
	ldy db2
	ldx #$00
i_iro:	lda elem,x
	sta i_szin-8,y
	inx
	iny
	cpx #$08
	bne i_iro

// a szinfutot leallitjuk a raster utan 8 pixellel
	lda db2
	cmp #$d0
	bne i_tov2
	lda #$cf
	sta db2

i_tov2:



// ha vegigert a feher sav, hatteret lefeketitjuk
	lda fade_on
	cmp #$01
	bne i_vege
	
	ldx count
	lda fade,x
	sta keret

	lda betu,x	//betuket is elfadeljuk a fenebe
	ldy #$00
i_vis2:	sta $d800,y
	sta $d900,y
	sta $da00,y
	sta $db00,y
	iny
	bne i_vis2
	
	

	inx
	stx count
	cpx #$09
	bne i_vege
	lda #$00
	sta intro
	//ldx #$08
	//stx count

	sei
	lda #<irq
	sta $0314
	lda #>irq
	sta $0315
	
	lda #$b9   // foprogi raster kezdo
	sta $d012
	lda #$1b
	sta $d011
	cli
	
	




i_vege:	
	jmp $ea31




// **********************
// ****  FLASH-BLack ****
// **********************
flashblue:

	lda #$08
	
	ldx #$00
fl1:	
	sta $d800+12,x
	sta $d800+40+12,x
	sta $d800+80+12,x
	sta $d800+120+12,x
	sta $d800+160+12,x
	sta $d800+200+12,x
	sta $d800+240+12,x
	sta $d800+280+12,x
	sta $d800+320+12,x
	sta $d800+360+12,x

	sta $d800+400+12,x
	sta $d800+440+12,x
	sta $d800+480+12,x
	sta $d800+520+12,x
	sta $d800+560+12,x
	sta $d800+600+12,x
	sta $d800+640+12,x
	sta $d800+680+12,x
	sta $d800+720+12,x
	sta $d800+760+12,x

	sta $d800+800+12,x
	sta $d800+840+12,x
	sta $d800+880+12,x
	sta $d800+920+12,x
	sta $d800+960+12,x

	inx
	cpx #$10
	bne fl1

	lda #$0b
	sta $d022

	lda #$0c
	sta $d023
	
	rts

// **********************
// ****  FLASH-gold  ****
// **********************
flashblack:

	lda #$0a   //08
	
	ldx #$00
fl2:	
	sta $d800+12,x
	sta $d800+40+12,x
	sta $d800+80+12,x
	sta $d800+120+12,x
	sta $d800+160+12,x
	sta $d800+200+12,x
	sta $d800+240+12,x
	sta $d800+280+12,x
	sta $d800+320+12,x
	sta $d800+360+12,x

	sta $d800+400+12,x
	sta $d800+440+12,x
	sta $d800+480+12,x
	sta $d800+520+12,x
	sta $d800+560+12,x
	sta $d800+600+12,x
	sta $d800+640+12,x
	sta $d800+680+12,x
	sta $d800+720+12,x
	sta $d800+760+12,x

	sta $d800+800+12,x
	sta $d800+840+12,x
	sta $d800+880+12,x
	sta $d800+920+12,x
	sta $d800+960+12,x

	inx
	cpx #$10
	bne fl2

	lda #$08   //0b
	sta $d022

	lda #$07   //0c
	sta $d023
	
	rts








.pc =$3fff "twister futo"
futo: .byte 0

.pc =$3ffe "spite eltolas"
sptol: .byte 0

.pc =$3ffd "txtpos"
txtpos: .byte 0

.pc =$3ffc "sinpos"
sinpos: .byte 0



.pc =$3ff1 "count"
count: .byte 0


.pc =$3ff2 "db"
db: .byte 1


.pc =$3ff3 "db2"
db2: .byte 1


.pc =$3ff4 "keret"
keret: .byte 14

.pc =$3ff5 "fade_on"
fade_on: .byte 0


.pc =$3ff6 "twkirako"
twkirako: .byte 0


.pc =$3ff7 "intro"
intro: .byte 1


.pc =$3ff8 "twcsere"
twcsere: .byte 0


.pc =$3ff9 "tw_id"
tw_id: .byte 1


.pc =$3ffa "flashCounter"
flashc: .byte 0





.pc =$6500 "scroller text"
rizsa:
.text"                                hello and welcome to the new fullscreen twister from the one and only"
.text" dnp at the brand new qb party\        after thirty years of laziness i finally made a real intro for"
.text" your pleasure  [   i hope you like it      do not forget to vote for me if u want to bring some joy " 
.text"to my ugly face [     thx to the facebook group retro game dev for supporting me with useful tipps]  "
.text" it was a great time to create this eyecandy from nothing]   i used an excel macro to convert all the"
.text" gfx from bmp to kickassembler format  [ it is a bit weird but it works anyway]          so after all"
.text" enjoy the party          dnprulz^gmail]com                         are you still there              "  //700
.text"                                ]the end]           dnp off  "

//    01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890
//              1         2         3         4         5         6         7         8         9         10


//  [ = smiley
//  \ = !
//  ] = .
//  ^ = @





.pc=music.location "Music"
.fill music.size, music.getData(i)







// kepernyo
.pc = $5800 "kepernyo"
kep: 
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,16,32,48,64,80,96,112,128,144,160,176,192,208,224,240,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,1,17,33,49,65,81,97,113,129,145,161,177,193,209,225,241,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,2,18,34,50,66,82,98,114,130,146,162,178,194,210,226,242,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,3,19,35,51,67,83,99,115,131,147,163,179,195,211,227,243,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,4,20,36,52,68,84,100,116,132,148,164,180,196,212,228,244,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,5,21,37,53,69,85,101,117,133,149,165,181,197,213,229,245,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,6,22,38,54,70,86,102,118,134,150,166,182,198,214,230,246,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,7,23,39,55,71,87,103,119,135,151,167,183,199,215,231,247,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,8,24,40,56,72,88,104,120,136,152,168,184,200,216,232,248,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,9,25,41,57,73,89,105,121,137,153,169,185,201,217,233,249,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,10,26,42,58,74,90,106,122,138,154,170,186,202,218,234,250,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,11,27,43,59,75,91,107,123,139,155,171,187,203,219,235,251,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,12,28,44,60,76,92,108,124,140,156,172,188,204,220,236,252,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,13,29,45,61,77,93,109,125,141,157,173,189,205,221,237,253,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,14,30,46,62,78,94,110,126,142,158,174,190,206,222,238,254,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,15,31,47,63,79,95,111,127,143,159,175,191,207,223,239,255,0,0,0,0,0,0,0,0,0,0,0,0

.byte 9,9,9,9,9,9,9,9,9,9,9,9,0,16,32,48,64,80,96,112,128,144,160,176,192,208,224,240,9,9,9,9,9,9,9,9,9,9,9,9
.byte 9,9,9,9,9,9,9,9,9,9,9,9,1,17,33,49,65,81,97,113,129,145,161,177,193,209,225,241,9,9,9,9,9,9,9,9,9,9,9,9
.byte 9,9,9,9,9,9,9,9,9,9,9,9,2,18,34,50,66,82,98,114,130,146,162,178,194,210,226,242,9,9,9,9,9,9,9,9,9,9,9,9

.byte 0,0,0,0,0,0,0,0,0,0,0,0,3,19,35,51,67,83,99,115,131,147,163,179,195,211,227,243,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,4,20,36,52,68,84,100,116,132,148,164,180,196,212,228,244,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,5,21,37,53,69,85,101,117,133,149,165,181,197,213,229,245,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,6,22,38,54,70,86,102,118,134,150,166,182,198,214,230,246,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,7,23,39,55,71,87,103,119,135,151,167,183,199,215,231,247,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,8,24,40,56,72,88,104,120,136,152,168,184,200,216,232,248,0,0,0,0,0,0,0,0,0,0,0,0







.pc = $5c00 "kepernyo szinek"
szin:



.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1

.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1

.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1

.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1

.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
.byte 1,1,1,1,1,1,1,1,1,1,1,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,1,1,1,1,1,1,1,1,1,1,1,1
																																				
																																						
																																						




.pc = $5000 "MultiTwisterAlap"
multitwsiter:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,3,3,3,11,11,7,7,15,15,13,47,13,31,13,31,13,63,29,63,29,55,61,55,181,55,181,55,117,53,181,181,85,181,117,181,85,181,85,181,85,181,150,181,86,53,150,53,150,53,22,53,22,53,22,21,6,21,14,21,14,29,14,5,5,5,5,11,9,3,9,3,1,1,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,2,0,1,3,3,3,11,7,15,15,31,15,31,31,63,63,63,127,127,255,255,255,255,255,255,223,255,253,255,221,255,221,247,221,127,221,247,221,119,221,119,213,119,93,119,85,119,85,119,85,117,85,85,85,117,85,85,85,85,85,85,101,85,86,85,102,85,86,85,102,85,102,89,102,85,102,89,102,149,102,153,102,153,102,153,106,153,102,153,106,153,102,153,106,153,102,89,106,89,102,89,234,89,90,89,90,57,150,57,22,54,14,21,14,5,5,11,9,3,1,3,0,1,0,0,0
.byte 122,250,250,246,246,254,253,254,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,255,253,255,221,255,221,247,221,127,221,119,221,119,221,119,213,119,93,119,85,119,85,87,85,117,85,85,85,85,85,85,85,85,85,85,101,85,86,85,102,85,102,89,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,106,153,166,153,170,153,170,153,170,153,170,169,170,154,170,170,170,154,170,170,170,154,170,170,170,154,170,170,170,154,170,170,170,154,106,106,234,218,234,218,90
.byte 170,170,170,170,170,170,170,138,170,170,170,106,90,232,218,216,250,246,246,246,253,253,255,253,255,255,255,223,255,255,255,221,255,221,247,221,127,221,119,221,119,221,119,213,119,93,119,85,119,85,87,85,117,85,85,85,85,85,85,101,85,85,85,101,85,86,85,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,106,153,170,153,170,153,170,169,170,154,170,170,170,154,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
.byte 170,168,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,138,170,138,170,74,106,104,82,232,250,212,246,214,245,254,245,221,127,221,119,221,127,221,119,213,119,93,119,85,119,85,87,85,119,85,87,85,85,85,85,85,85,85,85,101,85,86,85,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,170,153,170,153,170,153,170,169,170,154,170,170,170,170,170,170,170,170,170,170,138,170,168,170,136,170,168,170,136,170,168,162,136,170,136,162,136,170,168,170,136,170,168,170,136
.byte 34,136,162,136,170,136,162,136,170,168,170,136,170,170,170,170,170,170,170,170,154,170,170,170,154,170,169,170,153,170,41,10,41,138,169,74,98,96,82,88,88,212,118,214,117,213,117,213,117,93,119,85,119,85,87,85,117,85,85,85,85,85,85,101,85,86,85,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,154,170,170,170,170,170,170,138,170,168,170,136,170,136,162,136,170,136,162,128,34,136,34,128,34,128,34,128,32,128,34,128,32,136,162,128
.byte 0,0,0,0,32,128,32,128,34,136,162,136,170,136,170,136,170,168,170,170,170,170,170,170,154,170,170,170,154,170,153,170,153,166,153,170,153,166,153,170,153,166,41,6,41,138,137,66,98,96,82,88,88,84,86,86,117,85,85,85,85,85,85,85,85,85,85,101,85,102,85,102,149,102,153,102,149,102,153,102,153,166,153,170,153,166,153,170,153,170,169,170,154,170,170,170,170,170,170,138,170,168,170,136,170,136,162,136,34,136,34,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,128,32,136,34,136,170,136,162,136,170,168,170,170,170,170,170,170,154,170,170,170,154,170,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,89,166,25,38,41,6,9,138,129,66,98,96,80,104,84,84,86,102,85,86,85,102,85,102,85,102,149,102,153,102,149,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,170,170,170,170,170,170,170,138,170,136,170,136,42,136,34,0,34,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,34,136,34,136,170,136,170,136,170,168,170,170,170,170,170,170,154,170,170,170,154,170,153,170,153,166,153,106,153,102,153,102,153,102,89,102,85,102,85,102,85,86,85,101,85,101,149,165,21,38,37,6,137,137,97,66,146,88,88,100,86,102,89,102,149,102,153,102,153,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,170,170,170,170,170,170,170,138,170,136,34,136,42,8,34,0,34,0,2,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,34,8,34,136,42,136,162,136,170,168,170,138,170,170,170,170,170,170,170,170,154,170,169,170,153,170,153,170,153,166,153,106,153,102,153,102,149,102,89,102,85,102,85,102,85,86,85,85,85,85,85,85,85,85,87,85,85,85,151,37,21,5,5,137,137,65,98,96,144,104,152,100,154,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,170,170,170,170,170,170,170,138,170,136,170,136,42,8,34,8,34,8,2,0,34,0,2,0
.byte 34,8,34,0,34,8,34,0,34,8,34,0,34,8,34,8,42,136,34,136,42,136,170,136,170,168,170,138,170,170,170,170,170,170,170,170,154,170,169,170,153,170,153,170,153,166,153,106,153,102,153,102,153,102,89,102,85,102,89,102,85,86,85,101,85,85,85,85,85,85,85,85,117,85,87,85,119,85,119,85,119,93,119,85,119,157,23,37,39,5,43,137,169,138,162,160,154,168,154,168,154,170,154,170,154,170,169,170,170,170,170,170,170,170,170,138,170,170,170,138,170,136,42,136,42,136,34,8
.byte 170,170,170,138,170,136,170,138,42,136,170,138,42,136,170,138,170,168,170,138,170,170,170,138,170,170,170,170,170,170,170,170,170,170,170,170,154,170,169,170,153,170,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,89,102,85,102,85,102,85,86,85,101,85,85,85,85,117,85,85,85,117,85,119,85,119,93,119,213,119,221,119,221,127,221,119,221,127,93,127,93,191,157,151,167,39,165,171,137,169,138,161,138,170,168,170,168,154,170,170,170,170,170,170,170,170,170,170,138,170,170,170,138
.byte 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,169,170,154,170,169,170,153,170,153,170,153,170,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,89,102,85,102,85,102,85,86,85,101,85,85,85,85,85,85,85,85,117,85,87,85,119,85,119,213,119,221,119,221,119,221,119,221,127,221,247,221,255,253,255,223,255,255,255,255,255,255,127,95,127,159,159,175,159,167,167,135,171,169,169,138,170,170,170,170,170,170,170,170
.byte 173,172,167,165,171,169,171,169,153,170,170,170,154,170,169,170,153,170,169,170,153,170,169,170,153,170,169,170,153,170,169,170,153,170,153,170,153,166,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,153,102,149,102,85,102,85,86,85,101,85,85,85,101,85,85,85,85,117,85,87,85,119,85,87,85,119,93,119,85,119,93,119,213,119,221,119,221,127,221,247,221,255,253,255,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,127,191,159,191,175,159,172
.byte 0,0,0,0,0,64,64,192,96,192,80,64,112,80,176,152,180,148,148,164,149,172,149,165,151,165,155,169,155,165,153,170,153,166,153,170,153,166,153,102,153,102,153,102,149,102,153,102,149,102,153,102,149,102,85,102,85,86,85,101,85,85,85,101,85,85,85,85,85,85,85,85,117,85,87,85,119,85,119,85,119,93,119,213,119,221,119,221,127,221,119,221,127,221,255,223,255,255,255,223,255,255,255,255,255,253,253,252,254,252,252,244,248,248,240,240,240,192,208,192,192,64,64,128,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,64,64,64,80,192,80,192,112,80,80,80,112,88,112,88,120,84,120,84,116,84,116,84,116,92,86,92,94,92,94,92,126,92,93,92,125,92,93,92,126,92,126,92,126,92,116,92,124,124,116,84,116,116,120,248,120,248,240,240,240,208,240,192,208,192,224,192,192,192,64,64,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
														
														
//hullamok
.pc =$6000 "waveZ"

wave1:
.byte 131, 134, 137, 141, 144, 147, 151, 154, 158, 162, 165, 169, 173, 176, 180, 184, 188, 191, 195, 199
.byte 202, 206, 210, 213, 217, 220, 223, 226, 229, 232, 235, 238, 240, 243, 245, 247, 249, 250, 252, 253
.byte 254, 255, 255, 255, 255, 255, 255, 254, 253, 251, 250, 248, 245, 243, 240, 237, 233, 229, 225, 221
.byte 217, 212, 207, 201, 196, 190, 184, 178, 171, 165, 158, 151, 144, 137, 130, 123, 116, 109, 102, 95
.byte 88, 81, 75, 68, 62, 56, 50, 44, 39, 33, 29, 24, 20, 16, 12, 9, 7, 4, 3, 1
.byte 0, 0, 0, 0, 1, 2, 3, 5, 8, 11, 14, 18, 22, 26, 31, 36, 41, 47, 53, 59
.byte 65, 72, 79, 86, 93, 100, 107, 114, 121, 128, 136, 143, 150, 157, 163, 170, 177, 183, 189, 195
.byte 201, 206, 212, 216, 221, 226, 230, 234, 237, 240, 243, 246, 248, 250, 252, 253, 254, 255, 255, 255
.byte 255, 255, 254, 254, 252, 251, 250, 248, 246, 244, 241, 239, 236, 234, 231, 228, 225, 221, 218, 215
.byte 211, 208, 204, 201, 197, 194, 190, 187, 183, 180, 176, 173, 169, 166, 163, 159, 156, 153, 150, 147
.byte 144, 141, 139, 136, 133, 131, 128, 126, 124, 122, 120, 118, 116, 114, 113, 111, 110, 108, 107, 106
.byte 105, 104, 103, 102, 101, 101, 100, 100, 100, 99, 99, 99, 99, 100, 100, 100, 101, 101, 102, 103
.byte 104, 105, 106, 107, 108, 110, 111, 113, 114, 116, 118, 120, 122, 124, 127, 129
.byte 131, 134, 137, 141, 144, 147, 151, 154, 158, 162, 165, 169, 173, 176, 180, 184, 188, 191, 195, 199
.byte 202, 206, 210, 213, 217, 220, 223, 226, 229, 232, 235, 238, 240, 243, 245, 247, 249, 250, 252, 253
.byte 254, 255, 255, 255, 255, 255, 255, 254, 253, 251, 250, 248, 245, 243, 240, 237, 233, 229, 225, 221
.byte 217, 212, 207, 201, 196, 190, 184, 178, 171, 165, 158, 151, 144, 137, 130, 123, 116, 109, 102, 95
.byte 88, 81, 75, 68, 62, 56, 50, 44, 39, 33, 29, 24, 20, 16, 12, 9, 7, 4, 3, 1
.byte 0, 0, 0, 0, 1, 2, 3, 5, 8, 11, 14, 18, 22, 26, 31, 36, 41, 47, 53, 59
.byte 65, 72, 79, 86, 93, 100, 107, 114, 121, 128, 136, 143, 150, 157, 163, 170, 177, 183, 189, 195
.byte 201, 206, 212, 216, 221, 226, 230, 234, 237, 240, 243, 246, 248, 250, 252, 253, 254, 255, 255, 255
.byte 255, 255, 254, 254, 252, 251, 250, 248, 246, 244, 241, 239, 236, 234, 231, 228, 225, 221, 218, 215
.byte 211, 208, 204, 201, 197, 194, 190, 187, 183, 180, 176, 173, 169, 166, 163, 159, 156, 153, 150, 147
.byte 144, 141, 139, 136, 133, 131, 128, 126, 124, 122, 120, 118, 116, 114, 113, 111, 110, 108, 107, 106
.byte 105, 104, 103, 102, 101, 101, 100, 100, 100, 99, 99, 99, 99, 100, 100, 100, 101, 101, 102, 103
.byte 104, 105, 106, 107, 108, 110, 111, 113, 114, 116, 118, 120, 122, 124, 127, 129
							
						
							

//charset
.pc =$4800 "charset"
charset:
.byte 0,0,0,0,0,0,0,0
.byte 0,0,62,66,66,62,0,0
.byte 64,64,124,66,66,124,0,0
.byte 0,0,62,64,64,62,0,0
.byte 2,2,62,66,66,62,0,0
.byte 0,0,62,68,72,62,0,0
.byte 0,0,62,64,120,64,64,64
.byte 0,0,60,66,62,2,2,60
.byte 64,64,124,66,66,66,0,0
.byte 16,0,16,16,16,16,0,0
.byte 0,0,4,4,4,4,68,56
.byte 64,66,66,68,120,70,0,0
.byte 0,32,32,32,32,56,0,0
.byte 0,0,54,73,65,65,0,0
.byte 0,0,60,66,66,66,0,0
.byte 0,0,60,66,66,60,0,0
.byte 0,0,124,66,66,124,64,64
.byte 0,0,60,66,66,62,2,2
.byte 0,0,44,48,32,32,0,0
.byte 8,16,60,2,66,60,0,0
.byte 32,32,120,32,34,28,0,0
.byte 0,0,66,66,66,60,0,0
.byte 0,0,66,66,36,24,0,0
.byte 0,0,65,65,73,54,0,0
.byte 0,0,66,66,60,66,0,0
.byte 0,0,66,66,66,62,2,28
.byte 0,0,124,8,16,62,0,0
.byte 60,66,129,165,129,153,66,60
.byte 16,16,16,16,16,0,16,0
.byte 0,0,0,0,0,0,16,0
.byte 60,66,153,165,158,64,62,0
.byte 0,234,138,238,162,226,0,0





//spr pattog
.pc =$4900 "sinus"
spsin:
.byte 200,199,198,197,196,195,194,193,192,191,191,190,189,188,188,187,186,186,186,185,185,185,185,185,185,185,185,185,185,186,186,186,187,188,188,189,190,191,191,192,193,194,195,196,197,198,199,200,199,198,196,195,194,193,192,191,191,190,189,188,187,187,186,186,185,185,184,184,184,184,184,184,184,184,184,184,184,185,185,186,186,187,188,189,189,190,191,192,193,194,195,196,197,198,199,200



//sprite X koord
.pc =$49e0 "sin X"
sinx:
.byte $0f,$3f,$6f,$9f,$cf,$ff,$2f,$47
.byte $0f,$3f,$6f,$9f,$cf,$ff,$2f,$47



//spr szin 
.pc =$4a00 "sprite szin"
spcolor:
.byte 3,3,3,14,14,14,6,6
.byte 6,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0


.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,6
.byte 6,6,14,14,14,3,3,3
.byte 1,1,1,1,1,1,1,1






.pc =$6400 "nyolcvan"
nyolcvan:
.byte 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127														










.pc = $7800 "twister2"
twist2:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,1,1,3,1,3,11,11,7,7,5,7,13,7,13,45,13,21,13,21,46,21,38,21,22,21,22,53,22,25,150,53,150,25,154,26,150,26,154,26,154,26,170,26,26,26,170,26,22,26,42,26,38,26,38,22,38,38,6,22,6,37,6,37,6,9,10,9,10,9,9,1,10,1,2,1,2,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 2,0,1,1,3,3,3,11,7,15,15,15,31,31,31,31,63,191,191,125,127,253,247,221,255,221,247,213,247,213,119,213,117,85,85,85,85,86,85,102,85,102,89,106,153,102,153,106,153,170,169,170,154,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106,106,106,106,106,90,106,90,106,154,154,26,42,26,38,38,6,37,6,9,9,9,10,1,2,1,0,2,0
.byte 90,234,218,234,250,218,250,214,246,254,245,254,253,253,255,221,255,223,247,221,119,221,119,213,119,93,119,85,119,85,87,85,85,85,87,101,85,85,85,101,149,101,153,101,149,165,153,165,153,165,153,169,153,165,169,169,153,169,169,169,153,169,169,169,153,169,169,169,153,169,169,169,153,169,169,170,169,170,169,170,169,170,169,170,169,170,169,170,170,170,169,170,170,170,169,170,170,170,170,170,170,170,170,138,170,170,170,138,170,170,170,138,170,170,170,138,170,168,170,168,170,168,170,104,106,104,106,104
.byte 170,138,162,138,170,136,162,136,170,168,170,168,170,168,170,104,90,106,90,234,250,218,250,214,118,254,125,221,118,116,116,116,120,120,112,208,112,208,80,192,80,224,96,192,96,64,64,64,96,64,64,64,64,64,128,64,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,64,128,64,64,64,96,64,96,64,96,64,96,64,80,96,80,96,144,144,144,152,152,152,154,170,151,167,155,169,155,169,169,169,153,170,169,170,169,170,169,170,169,170,169,170,170,170,170,138,170,170,170,138
.byte 169,169,169,169,169,170,169,170,170,170,42,138,42,10,42,138,42,136,162,128,162,128,162,128,160,168,170,168,106,104,90,170,154,26,26,6,38,6,9,9,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,3,11,7,7,15,31,31,63,127,127,255,255,255,255,255,255,255,255,255,255,255,255,255,127,127,127,127,191,95,191,159,159,175,159,175,151,167,151,167,171,169
.byte 0,128,128,64,96,64,96,96,144,152,144,152,148,164,166,166,149,165,169,169,169,170,169,138,42,10,42,10,42,10,2,128,2,128,162,128,160,160,160,168,168,104,106,104,90,154,26,42,22,6,5,6,9,9,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,7,7,15,31,31,63,191,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,253,252,254,244,244,248,240,208,208,192,224,192,64,64,128,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,64,96,64,96,96,144,152,152,164,150,164,165,169,153,169,169,170,42,42,42,10,42,10,2,2,2,128,130,128,160,128,160,160,168,168,106,104,90,106,154,154,26,38,37,6,37,14,29,29,63,125,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,253,252,252,244,240,240,240,208,224,192,64,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,64,64,80,96,144,152,152,164,150,164,153,170,169,170,41,42,41,10,42,10,2,2,2,0,2,128,160,128,160,128,160,168,170,168,154,106,106,234,218,218,249,218,245,246,245,254,253,253,255,253,253,252,252,244,248,240,208,192,224,192,64,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,3,3,7,7,15,15,31,63,63,127,127,255,127,127,127,159,159,175,159,175,167,165,155,169,169,170,42,42,41,10,42,10,2,2,2,0,2,128,160,128,160,128,160,168,170,168,154,168,106,106,26,26,26,38,37,6,9,9,1,2,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,11,7,7,47,15,31,31,63,127,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,253,252,124,116,176,80,144,152,152,164,150,166,169,169,41,42,41,10,42,10,2,2,2,0,2,128,160,128,160,128,160,168,170,168,154,104,106,106,90,90,154,154,22,38,37,6,5,9,1,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 2,0,1,1,3,11,11,7,15,15,47,15,63,63,191,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,254,252,244,244,240,208,208,192,64,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,64,96,64,80,144,144,168,148,164,165,166,169,169,41,10,42,10,10,10,2,0,2,128,162,128,160,128,160,168,162,168,170,168,170,106,90,106,90,106,154,154,26,38,22,6,37,6,9,9,1,1,1,0,2,0
.byte 90,234,218,234,218,218,249,218,245,246,245,246,253,254,253,253,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,253,253,252,244,244,240,208,208,192,224,64,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,64,96,96,144,160,152,164,150,164,165,166,169,170,41,10,42,10,42,10,2,130,34,136,162,128,162,168,162,136,170,168,170,168,170,168,170,106,90,106,90,106
.byte 170,168,170,168,170,168,170,168,170,170,170,170,154,170,170,170,154,170,154,106,90,106,106,234,90,234,217,234,102,166,37,6,37,6,37,6,5,6,9,9,9,9,1,9,1,1,1,2,1,2,1,2,1,2,1,2,2,2,2,0,1,0,2,0,2,0,1,0,1,2,1,2,1,2,1,2,1,1,1,1,3,1,3,9,11,9,11,9,7,5,7,5,47,13,47,13,31,29,31,157,127,125,191,157,159,173,151,167,151,165,171,169,169,170,170,138,42,138,42,138,42,138,162,138,170,136,162,136
.byte 169,170,169,169,169,170,169,138,170,170,170,138,170,170,170,138,170,170,170,138,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,154,170,170,170,154,170,170,106,154,106,106,106,90,106,106,106,90,106,106,106,90,106,106,106,90,106,106,106,90,106,90,106,90,106,90,106,90,102,89,106,89,102,89,102,89,102,89,102,85,86,85,102,85,86,85,85,117,85,87,85,119,85,119,213,119,221,119,221,255,221,255,223,255,255,127,127,191,159,191,159,159,175,167,167,151,167,171,169
.byte 0,0,128,128,128,64,96,64,80,96,144,160,152,152,152,164,150,164,166,166,165,166,169,169,169,169,169,170,169,170,169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,169,170,153,170,169,170,153,166,153,102,149,102,153,101,149,101,85,101,85,85,87,85,119,93,119,87,119,95,119,223,127,223,255,221,253,252,254,252,252,244,244,248,240,240,240,192,208,192,192,192,64,64,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,64,64,64,96,64,96,64,96,96,144,96,144,160,144,152,144,152,152,152,152,168,148,164,152,164,148,164,150,164,150,164,150,164,150,164,150,164,150,164,150,164,150,164,150,164,150,164,150,100,148,84,148,84,180,84,120,88,120,84,112,80,112,80,112,208,208,208,208,192,208,192,192,192,64,64,64,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
														


.pc = $6800 "twister1"
twist1:
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,3,3,3,11,11,7,7,15,15,13,47,13,31,13,31,13,63,29,63,29,55,61,55,181,55,181,55,117,53,181,181,85,181,117,181,85,181,85,181,85,181,150,181,86,53,150,53,150,53,22,53,22,53,22,21,6,21,14,21,14,29,14,5,5,5,5,11,9,3,9,3,1,1,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,2,0,1,3,3,3,11,7,15,15,31,15,31,31,63,63,63,127,127,255,255,255,255,255,255,223,255,253,255,221,255,221,247,221,127,221,247,221,119,221,119,213,119,93,119,85,119,85,119,85,117,85,85,85,117,85,85,85,85,85,85,101,85,86,85,102,85,86,85,102,85,102,89,102,85,102,89,102,149,102,153,102,153,102,153,106,153,102,153,106,153,102,153,106,153,102,89,106,89,102,89,234,89,90,89,90,57,150,57,22,54,14,21,14,5,5,11,9,3,1,3,0,1,0,0,0
.byte 122,250,250,246,246,254,253,254,255,253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,255,253,255,221,255,221,247,221,127,221,119,221,119,221,119,213,119,93,119,85,119,85,87,85,117,85,85,85,85,85,85,85,85,85,85,101,85,86,85,102,85,102,89,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,106,153,166,153,170,153,170,153,170,153,170,169,170,154,170,170,170,154,170,170,170,154,170,170,170,154,170,170,170,154,170,170,170,154,106,106,234,218,234,218,90
.byte 170,170,170,170,170,170,170,138,170,170,170,106,90,232,218,216,250,246,246,246,253,253,255,253,255,255,255,223,255,255,255,221,255,221,247,221,127,221,119,221,119,221,119,213,119,93,119,85,119,85,87,85,117,85,85,85,85,85,85,101,85,85,85,101,85,86,85,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,106,153,170,153,170,153,170,169,170,154,170,170,170,154,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170
.byte 170,168,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,138,170,138,170,74,106,104,82,232,250,212,246,214,245,254,245,221,127,221,119,221,127,221,119,213,119,93,119,85,119,85,87,85,119,85,87,85,85,85,85,85,85,85,85,101,85,86,85,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,170,153,170,153,170,153,170,169,170,154,170,170,170,170,170,170,170,170,170,170,138,170,168,170,136,170,168,170,136,170,168,162,136,170,136,162,136,170,168,170,136,170,168,170,136
.byte 34,136,162,136,170,136,162,136,170,168,170,136,170,170,170,170,170,170,170,170,154,170,170,170,154,170,169,170,153,170,41,10,41,138,169,74,98,96,82,88,88,212,118,214,117,213,117,213,117,93,119,85,119,85,87,85,117,85,85,85,85,85,85,101,85,86,85,102,85,102,89,102,149,102,153,102,153,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,154,170,170,170,170,170,170,138,170,168,170,136,170,136,162,136,170,136,162,128,34,136,34,128,34,128,34,128,32,128,34,128,32,136,162,128
.byte 0,0,0,0,32,128,32,128,34,136,162,136,170,136,170,136,170,168,170,170,170,170,170,170,154,170,170,170,154,170,153,170,153,166,153,170,153,166,153,170,153,166,41,6,41,138,137,66,98,96,82,88,88,84,86,86,117,85,85,85,85,85,85,85,85,85,85,101,85,102,85,102,149,102,153,102,149,102,153,102,153,166,153,170,153,166,153,170,153,170,169,170,154,170,170,170,170,170,170,138,170,168,170,136,170,136,162,136,34,136,34,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,128,32,136,34,136,170,136,162,136,170,168,170,170,170,170,170,170,154,170,170,170,154,170,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,89,166,25,38,41,6,9,138,129,66,98,96,80,104,84,84,86,102,85,86,85,102,85,102,85,102,149,102,153,102,149,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,170,170,170,170,170,170,170,138,170,136,170,136,42,136,34,0,34,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,34,136,34,136,170,136,170,136,170,168,170,170,170,170,170,170,154,170,170,170,154,170,153,170,153,166,153,106,153,102,153,102,153,102,89,102,85,102,85,102,85,86,85,101,85,101,149,165,21,38,37,6,137,137,97,66,146,88,88,100,86,102,89,102,149,102,153,102,153,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,170,170,170,170,170,170,170,138,170,136,34,136,42,8,34,0,34,0,2,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,34,8,34,136,42,136,162,136,170,168,170,138,170,170,170,170,170,170,170,170,154,170,169,170,153,170,153,170,153,166,153,106,153,102,153,102,149,102,89,102,85,102,85,102,85,86,85,85,85,85,85,85,85,85,87,85,85,85,151,37,21,5,5,137,137,65,98,96,144,104,152,100,154,102,153,106,153,166,153,170,153,170,169,170,153,170,169,170,170,170,170,170,170,170,170,138,170,136,170,136,42,8,34,8,34,8,2,0,34,0,2,0
.byte 34,8,34,0,34,8,34,0,34,8,34,0,34,8,34,8,42,136,34,136,42,136,170,136,170,168,170,138,170,170,170,170,170,170,170,170,154,170,169,170,153,170,153,170,153,166,153,106,153,102,153,102,153,102,89,102,85,102,89,102,85,86,85,101,85,85,85,85,85,85,85,85,117,85,87,85,119,85,119,85,119,93,119,85,119,157,23,37,39,5,43,137,169,138,162,160,154,168,154,168,154,170,154,170,154,170,169,170,170,170,170,170,170,170,170,138,170,170,170,138,170,136,42,136,42,136,34,8
.byte 170,170,170,138,170,136,170,138,42,136,170,138,42,136,170,138,170,168,170,138,170,170,170,138,170,170,170,170,170,170,170,170,170,170,170,170,154,170,169,170,153,170,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,89,102,85,102,85,102,85,86,85,101,85,85,85,85,117,85,85,85,117,85,119,85,119,93,119,213,119,221,119,221,127,221,119,221,127,93,127,93,191,157,151,167,39,165,171,137,169,138,161,138,170,168,170,168,154,170,170,170,170,170,170,170,170,170,170,138,170,170,170,138
.byte 170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,169,170,154,170,169,170,153,170,153,170,153,170,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,89,102,85,102,85,102,85,86,85,101,85,85,85,85,85,85,85,85,117,85,87,85,119,85,119,213,119,221,119,221,119,221,119,221,127,221,247,221,255,253,255,223,255,255,255,255,255,255,127,95,127,159,159,175,159,167,167,135,171,169,169,138,170,170,170,170,170,170,170,170
.byte 173,172,167,165,171,169,171,169,153,170,170,170,154,170,169,170,153,170,169,170,153,170,169,170,153,170,169,170,153,170,169,170,153,170,153,170,153,166,153,170,153,166,153,106,153,102,153,102,153,102,153,102,149,102,153,102,149,102,85,102,85,86,85,101,85,85,85,101,85,85,85,85,117,85,87,85,119,85,87,85,119,93,119,85,119,93,119,213,119,221,119,221,127,221,247,221,255,253,255,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,127,191,159,191,175,159,172
.byte 0,0,0,0,0,64,64,192,96,192,80,64,112,80,176,152,180,148,148,164,149,172,149,165,151,165,155,169,155,165,153,170,153,166,153,170,153,166,153,102,153,102,153,102,149,102,153,102,149,102,153,102,149,102,85,102,85,86,85,101,85,85,85,101,85,85,85,85,85,85,85,85,117,85,87,85,119,85,119,85,119,93,119,213,119,221,119,221,127,221,119,221,127,221,255,223,255,255,255,223,255,255,255,255,255,253,253,252,254,252,252,244,248,248,240,240,240,192,208,192,192,64,64,128,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,128,64,64,64,80,192,80,192,112,80,80,80,112,88,112,88,120,84,120,84,116,84,116,84,116,92,86,92,94,92,94,92,126,92,93,92,125,92,93,92,126,92,126,92,126,92,116,92,124,124,116,84,116,116,120,248,120,248,240,240,240,208,240,192,208,192,224,192,192,192,64,64,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0





.pc =$7010 "i_szin"
i_szin: 
.byte 1,0,1,0,1,0,1,0,2,0,2,0,2,0,2,0,1,0,1,0,1,0,1,0,2,0,2,0,2,0,2,0,1,0,1,0,1,0,1,0
.byte 2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1
.byte 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
.byte 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0
.byte 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0

.pc =$7100 "var"
varakozas: 
.byte 1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8
.byte 1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,8,1,8,8,8,8,8,8,9


.pc =$7200 "byteok"
byteok: 
.byte $68,$68,$69,$69,$6a,$6a,$6b,$6b,$6c,$6c,$6d,$6d,$6e,$6e,$6f,$6f
.byte $78,$78,$79,$79,$7a,$7a,$7b,$7b,$7c,$7c,$7d,$7d,$7e,$7e,$7f,$7f

.pc =$3200 "Dnp_Logo_Sprite"
dnplogosprite:
.byte $00,$00,$07,$00,$00,$04,$00,$00,$05,$00,$00,$05,$00,$00,$05,$00
.byte $07,$ff,$00,$04,$00,$00,$05,$ff,$00,$05,$ff,$00,$05,$ff,$00,$05
.byte $ff,$00,$05,$ff,$00,$1f,$ff,$00,$60,$00,$00,$8f,$ff,$01,$3f,$ff
.byte $01,$7f,$ff,$02,$7f,$ff,$02,$ff,$ff,$02,$ff,$ff,$02,$fc,$00,$00

.byte $fe,$00,$00,$02,$00,$00,$fa,$00,$00,$fa,$00,$00,$fa,$00,$00,$ff
.byte $80,$00,$00,$60,$00,$ff,$10,$00,$ff,$c8,$00,$ff,$e8,$00,$ff,$e4
.byte $00,$ff,$f4,$00,$ff,$f4,$00,$03,$f4,$00,$fb,$f4,$00,$fb,$f4,$00
.byte $fb,$f4,$00,$fb,$f4,$00,$fb,$f4,$00,$fb,$f4,$00,$03,$f4,$00,$00

.byte $02,$fd,$ff,$02,$fd,$ff,$02,$fd,$ff,$02,$fd,$ff,$02,$fd,$ff,$02
.byte $fd,$ff,$02,$fc,$00,$02,$ff,$ff,$02,$ff,$ff,$02,$7f,$ff,$01,$7f
.byte $ff,$01,$3f,$ff,$00,$8f,$ff,$00,$60,$00,$00,$1f,$ff,$00,$05,$fa
.byte $00,$05,$fa,$00,$05,$fa,$00,$04,$02,$00,$07,$fe,$00,$00,$00,$00

.byte $ff,$f4,$00,$ff,$f4,$00,$ff,$e4,$00,$ff,$e8,$00,$ff,$c8,$00,$ff
.byte $10,$00,$00,$60,$00,$ff,$80,$00,$fa,$00,$00,$fa,$00,$00,$fa,$00
.byte $00,$fa,$00,$00,$fa,$00,$00,$02,$00,$00,$fe,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

//lila zold sprite hatter
.byte $01,$e0,$00,$01,$00,$00,$1f,$f8,$00,$10,$0c,$00,$10,$00,$00,$10
.byte $00,$00,$7f,$e0,$00,$c0,$00,$00,$80,$00,$00,$9e,$00,$00,$90,$00
.byte $00,$90,$00,$00,$90,$00,$00,$90,$00,$00,$80,$00,$00,$80,$00,$00
.byte $00,$00,$00,$10,$00,$00,$10,$00,$00,$10,$00,$00,$00,$00,$00,$04

.byte $00,$00,$00,$00,$20,$00,$00,$20,$00,$00,$20,$00,$00,$00,$00,$00
.byte $04,$00,$00,$04,$00,$00,$24,$00,$00,$24,$00,$00,$24,$00,$00,$24
.byte $00,$03,$e4,$00,$00,$04,$00,$00,$0c,$00,$1f,$f8,$00,$00,$20,$00
.byte $00,$20,$00,$c0,$20,$00,$7f,$e0,$00,$02,$00,$00,$1e,$00,$00,$05

//arnyek
.byte $00,$00,$00,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00
.byte $00,$20,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$00,$00
.byte $00,$00,$00,$01,$00,$00,$01,$00,$00,$01,$00,$00,$01,$00,$00,$01
.byte $00,$00,$01,$00,$00,$01,$00,$00,$01,$00,$00,$01,$00,$00,$01,$02

.byte $00,$00,$01,$00,$00,$01,$00,$00,$01,$00,$00,$03,$00,$00,$02,$00
.byte $00,$06,$00,$00,$0c,$00,$00,$38,$00,$00,$e0,$00,$00,$80,$00,$00
.byte $80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$ff,$80
.byte $00,$80,$00,$00,$80,$00,$00,$80,$00,$00,$80,$00,$ff,$80,$00,$02




.pc =$7300 "elem"
elem: .byte 1,1,1,1,1,1,15,12
.pc =$7310 "fade"
fade: .byte 3,7,1,7,3,14,6,0
.pc =$7320 "betu"
betu: .byte 6,0,0,6,14,3,1,1,1,1


.pc =$7400 "qb2015"
qblogo:
.byte 32,32,32,32,32,32,32,32,32,32,112,64,64,64,64,64,64,64,110,32,112,64,64,110,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,66,32,32,112,64,110,32,32,66,32,66,32,32,66,50,48,49,53,32,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,66,32,32,66,32,66,32,32,66,32,66,32,32,66,112,64,64,64,110,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,66,32,32,66,32,66,32,32,66,32,66,32,32,66,109,110,32,32,66,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,66,32,32,66,32,66,32,32,66,32,66,32,32,66,32,66,32,32,66,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,66,32,32,66,32,66,32,32,66,32,66,32,32,66,32,66,32,32,66,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,66,32,32,109,110,66,32,32,66,32,66,32,32,66,32,66,32,32,66,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,109,64,64,64,125,66,32,32,66,32,66,32,32,66,32,66,32,32,66,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,66,32,32,66,32,66,32,32,109,64,125,32,32,66,32,32,32,32,32,32,32,32,32,32,32															
.byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,109,64,64,125,32,109,64,64,64,64,64,64,64,125,32,32,32,32,32,32,32,32,32,32,32															


