#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time),sin(time));


mat3 rotY(in float a){
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
mat3 rotX(in float a){
    return mat3( 1.0, 0.0, 0.0,
                 0.0, cos(a), sin(a),
                0.0, -sin(a), cos(a)
                );
}
mat3 rotZ(in float a){
    return mat3( 
                cos(a), sin(a), 0.0,
                -sin(a), cos(a), 0.0,
                0.0,0.0,1.0
                );
}
mat2 rotate(float Angle){
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}

float smin( float a, float b, float k ){
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}


float pallo(vec3 pos){
	return length(pos-vec3(-33.0,-1.0,-7.0))-6.0;	
}

float sdTorus( vec3 p, float i){
  	vec2 t=vec2(p.x*0.38+1.4,0.064+0.001*p.z);
  	vec2 q = vec2(length(p.xz)-t.x,p.y);
  	return length(q)-t.y;
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float scene(vec3 pos){
	float tulos=0.8;
    
    tulos = min(tulos, distance(
        texture2D(iChannel0, pos.xz*0.0812423*0.07+time*0.1+vec2(-time*0.1,0.0)).r*.8-1.7,
        pos.y+.86));

    
    tulos = min(tulos,pallo(pos));
	return tulos*.6;
}
float march(vec3 cam, vec3 dir){
	float matka=0.0;
	for (int i=0;i<44;i++){

		vec3 kohta=0.55*matka*dir+cam;
		kohta *= rotX(kohta.z*0.1+sin(time)*4.0);
		float etaisyys= scene(kohta);
		matka+=etaisyys;
	}
	return sqrt(matka);
}

void main(void){
	vec2 uv = gl_FragCoord.xy / iResolution.xy*2.0-1.0;
	uv.y*=iResolution.y/iResolution.x;
	
	vec3 cam=vec3(15.4,2.6,-4.);
	
	vec3 dir=normalize(vec3(uv,1.0));
	dir *= rotX(0.1*sin(time*4.0)-0.3);
	dir *= rotY(time*0.5);
	dir *= (cos(uv.x)+cos(uv.y));
    
    
	vec2 q = vec2( sin(0.5*uv.x),sin(0.5*uv.y) );
    float a = atan(q.y,q.x);
    float r = sqrt(dot(q,q));
    dir.z *= 5.5*( sqrt(r*r+0.2));		
	dir.z -= .1;
    
    
    dir.yzx*=rotY(1.9);
    dir.zyx*=rotY(1.4);
    dir.yxz*=rotY(-3.);
    
	vec3 color=1.-0.24*vec3(march( cam, dir));

	float vignette = 44. / (26.225 + 0.4*dot(uv, uv));
    
	gl_FragColor = texture2D(u_texture,uv)*0.001  +  vec4( vec3(0.826, 0.73, 0.63) - color*vignette, 1.0);
}