#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time*2.),sin(time*2.));

struct polygon{
	vec2 A, B, C;
};
float roundBox(vec2 coord, vec2 pos, vec2 b ){
  return length(max(abs(coord-pos)-b,0.0));
}
float box(vec2 coord, vec2 pos, vec2 size){
	if((coord.x<(pos.x+size.x)) &&
	   (coord.x>(pos.x-size.x)) &&
	   (coord.y<(pos.y+size.y)) && 
	   (coord.y>(pos.y-size.y)) ) 
		return 1.0;
	return 0.0;
}
mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
	return rotation;
}
float sun(vec2 coord, vec2 pos, float size){
	if(length(coord-pos)<size)
		return 1.0;
	return 0.0;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float sign(vec2 p1, vec2 p2, vec2 p3){
  return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
}

int PointInTriangle(vec2 pt, vec2 v1, vec2 v2, vec2 v3){
	int b1, b2, b3;

	if(sign(pt, v1, v2) < 0.0) b1=1;
	if(sign(pt, v2, v3) < 0.0) b2=1;
	if(sign(pt, v3, v1) < 0.0) b3=1;
	if((b1 == b2) && (b2 == b3))
		return 1;
	return 0;
}

int PointInTriangle(vec2 pt, polygon X){
	int b1, b2, b3;

	if(sign(pt, X.A, X.B) < 0.0) b1=1;
	if(sign(pt, X.B, X.C) < 0.0) b2=1;
	if(sign(pt, X.C, X.A) < 0.0) b3=1;
	if((b1 == b2) && (b2 == b3))
		return 1;
	return 0;
}


void main(void)
{
	vec4 tulos=vec4(vec3(0.),1.0);
	vec4 lopullinentulos=vec4(1.0);
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
	float aspectCorrection = (iResolution.x/iResolution.y);
	vec2 coordinate_entered = 2.0 * uv - 1.0;
	for(float rgbare=0.0; rgbare<2.0; rgbare++){
		vec2 coord = vec2(aspectCorrection*0.5,1.0) *coordinate_entered;
		coord*=rotate(time*2.);
		coord/=pow(time*2.,time*3.);
		coord.x*=1.0+rgbare*0.009;
		for(float i=0.; i<15.; i++){
		if(roundBox(coord,vec2(i/(150.*pow(i,i))),vec2(0.3)/(pow(i,i)*4.))<0.2/(pow(i,i)*4.))
		   tulos.rgb=vec3(mod(i,2.));
		}
		if(rgbare==0.0)
			lopullinentulos.r=tulos.r;
		if(rgbare==1.0)
			lopullinentulos.gb=tulos.gb;
	}
	vec2 c = vec2(aspectCorrection,1.0) *coordinate_entered;
	gl_FragColor = max(time-2.0,0.0)*0.6 + texture2D(u_texture,uv)*0.001  + vec4(1.0,1.0,1.0,2.0)-lopullinentulos-rand(c*time*2.)*0.03;
}