precision lowp float;
uniform sampler2D mixerTex;
uniform float iGlobalTime;
uniform vec2 iResolution;
vec2 iMouse = vec2(sin(iGlobalTime*0.1),0.7);
struct polygon{
    vec2 A, B, C;
};
float roundBox(vec2 coord, vec2 pos, vec2 b ){
  return length(max(abs(coord-pos)-b,0.0));
}
float box(vec2 coord, vec2 pos, vec2 size){
    if((coord.x<(pos.x+size.x)) &&
       (coord.x>(pos.x-size.x)) &&
       (coord.y<(pos.y+size.y)) && 
       (coord.y>(pos.y-size.y)) ) 
        return 1.0;
    return 0.0;
}
float sun(vec2 coord, vec2 pos, float size){
    if(length(coord-pos)<size)
        return 1.0;
    return 0.0;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float sign(vec2 p1, vec2 p2, vec2 p3){
  return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
}

mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float sdCapsule( vec2 p, vec2 a, vec2 b, float r ){
    vec2 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return min(floor(length( pa - ba*h ) - r),0.);
}


float smin( float a, float b, float k ){
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
mat3 rotY(in float a) {
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float sdBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

float sdCapsule( vec3 p, vec3 a, vec3 b, float r ){
    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float sdPlane( vec3 p, vec4 n )
{
  return dot(p,n.xyz) + n.w;
}


float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus82( vec3 p, vec2 t ){
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float palkki(in vec3 p){
    
    float finalDistance = 10000000.;
    
    finalDistance = min(finalDistance, udRoundBox( p-vec3(0.0), vec3(2.0,11. ,2.0) , 0.1) );
    vec3 p2 = p;
    vec3 p3 = p;
    vec3 p4 = p;
    
    p3.zyx *= rotY(3.14145*0.5);
    p3.yxz *= rotY(3.14145*0.25);
    p.zyx *= rotY(3.14145*0.5);
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(2.0,0.0,0.0)), vec3(0.2,1.0,1.0) , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(2.0,0.0,0.0)), vec3(0.4,0.8,0.8) , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p-vec3(2.0,-0.8,0.0)), vec3(0.4,1.0,0.8) , 0.1 ) );
    return finalDistance;
}
void objectGroup0(in vec3 p, out vec3 color, out float reflectiveValue, out float finalDistance){
    
    float dist1 = 1e9;
    dist1= min(dist1,sdBox( p-vec3(0.,sin(length(p.xz)/2.)/4.+sin(rand(floor(p.xz))*3.141*2.6+iGlobalTime/2.)/3.,0.), vec3(444.,1.,444.) ));
    
    finalDistance = dist1;
}
void objectGroup1(in vec3 p, out vec3 color, out float reflectiveValue, out float finalDistance){
    
    color = vec3(1.2, 1.0, 0.8);
    float dist3 = 111111111111.;
    for(float i=0.0; i<3.0; i++){
        float r_0 = rand(vec2(i*i));
        float r_1 = sin(i*53535.);
        vec3 bubble_pos = vec3(sin(r_0+i*r_1+iGlobalTime)*0.5, sin(i+iGlobalTime)*0.5+1.5, sin(r_1+i*i+r_0*iGlobalTime)*0.5 );
        dist3 = smin(dist3,sdSphere(p-bubble_pos*2.7,1.2+sin(i+iGlobalTime)/12.), 6.);
    }
    vec3 p2 = vec3(p.x,p.y,abs(p.z/2.));
    if(p2.z>1.6)
    dist3 = min(dist3,palkki(p2-vec3(0.,3.0,5.0)));

    finalDistance = min(finalDistance,dist3);
 
    reflectiveValue = 0.2;
}

float calculateDistance(in vec3 p, out vec3 color, out float reflectiveValue) {
    float finalDistance = 10000000.;
    
    objectGroup0(p,color,reflectiveValue,finalDistance);
    
    objectGroup1(p,color,reflectiveValue,finalDistance);
    
    
    return finalDistance;
}


float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource){
    vec3 ro = rayPosition + normalVector*0.01;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.01;
    float k = 1.6;
    float res = 1.0;
    for( int i=0; i<28; i++ )
    {
        vec3 C;
        float dummy;
        float h = calculateDistance(ro + rd*t, C, dummy);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.001 && length(ro + rd*t)>10.8) break;
    }
    return clamp(res,0.01,9.0);
}
vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
    const float epsilon = 0.005;
    
    vec3 rayPosition = rayStartPosition;

    vec3 normalVector;
    float dist = 0.0;
    vec3 returnColor = vec3(0.0);
    vec3 finalColor = vec3(0.0);
    vec3 lightSource = vec3(-12.,6.+iGlobalTime/3.,0.) ;
    float reflectiveValue = 1.0;
    float reflectionNow = 1.0;
    float finalLight = 1.0;
    
    float possibleFogLight = 1.0;
    
    for(float k=0.; k<2.; k++) {
        for(float i=0.; i<33.; i++) {
            vec3 color;
            float stepable = calculateDistance(rayPosition, color, reflectiveValue);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            
           
            if( length(rayPosition)>10.){


                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(rayDirection, lightDir);
                returnColor+=min(max( pow(directLight,33.1) * vec3(1.7,1.1,.9) * 0.4, 0.01),1.);
            
                
                
                
                return returnColor;
            }
            if( abs(stepable) <= epsilon){
                vec3 C;
                float dummy = 0.0;
                normalVector = vec3(    calculateDistance(rayPosition+vec3(epsilon,0,0),C,dummy)-calculateDistance(rayPosition+vec3(-epsilon,0,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C,dummy)-calculateDistance(rayPosition+vec3(0,-epsilon,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C,dummy)-calculateDistance(rayPosition+vec3(0,0,-epsilon),C,dummy));
                normalVector = normalize(normalVector);
                float light = traceToLight(rayPosition, normalVector, lightSource);
                finalLight = min(finalLight, light);
                float lightDistance = distance(rayStartPosition,lightSource);
                
                finalColor = color * vec3(dot(normalVector, -rayDirection));
                
                
                vec3 lightDir = (lightSource-rayPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(normalVector, lightDir);
                reflectionNow = max(reflectionNow,reflectiveValue);
                
                
                returnColor += ( vec3(finalLight*max(1.5*directLight*vec3(1.7,1.1,0.9),0.01)) / (k*4.8/reflectionNow + 1.0)) * finalColor;
  
                    
                break;
                
            }
        }
        dist = 0.01;
        rayStartPosition = rayPosition + normalVector;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
    } 
    vec3 lightDir = (lightSource-rayStartPosition);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    returnColor+=min(max( pow(directLight,33.1) * vec3(1.7,1.1,.9) * 0.08, 0.01),1.);
               
    return returnColor;
}
vec3 piip() {
    vec3 cameraPosition = vec3( 4., 4.+iGlobalTime/6., -10.+iGlobalTime/4.);
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    
    float aspect = iResolution.x / iResolution.y;
        vec3 direction = normalize(vec3(.5 * uv * vec2(aspect, 1.0), 1. ));
        direction.yxz *= rotY(-0.16-iGlobalTime/42.);
        cameraPosition *= rotY(-3.141/2. + iGlobalTime/26.);
        direction *= rotY(-3.141/2. - iGlobalTime/18.);
        direction.zxy *= rotY(1./(1.+iGlobalTime/16.));
        return tracer(cameraPosition, direction);
}











void main(){
    
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
        gl_FragColor = vec4(piip(),1.);
}