/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class HmacCore
implements Cloneable {
    private final MessageDigest md;
    private final byte[] k_ipad;
    private final byte[] k_opad;
    private boolean first;
    private final int blockLen;

    HmacCore(MessageDigest messageDigest, int n) {
        this.md = messageDigest;
        this.blockLen = n;
        this.k_ipad = new byte[this.blockLen];
        this.k_opad = new byte[this.blockLen];
        this.first = true;
    }

    HmacCore(String string, int n) throws NoSuchAlgorithmException {
        this(MessageDigest.getInstance(string), n);
    }

    private HmacCore(HmacCore hmacCore) throws CloneNotSupportedException {
        this.md = (MessageDigest)hmacCore.md.clone();
        this.blockLen = hmacCore.blockLen;
        this.k_ipad = (byte[])hmacCore.k_ipad.clone();
        this.k_opad = (byte[])hmacCore.k_opad.clone();
        this.first = hmacCore.first;
    }

    int getDigestLength() {
        return this.md.getDigestLength();
    }

    void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Missing key data");
        }
        if (byArray.length > this.blockLen) {
            byte[] byArray2 = this.md.digest(byArray);
            Arrays.fill(byArray, (byte)0);
            byArray = byArray2;
        }
        for (int i = 0; i < this.blockLen; ++i) {
            byte by = i < byArray.length ? byArray[i] : (byte)0;
            this.k_ipad[i] = (byte)(by ^ 0x36);
            this.k_opad[i] = (byte)(by ^ 0x5C);
        }
        Arrays.fill(byArray, (byte)0);
        byArray = null;
        this.reset();
    }

    void update(byte by) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(by);
    }

    void update(byte[] byArray, int n, int n2) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(byArray, n, n2);
    }

    void update(ByteBuffer byteBuffer) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(byteBuffer);
    }

    byte[] doFinal() {
        if (this.first) {
            this.md.update(this.k_ipad);
        } else {
            this.first = true;
        }
        try {
            byte[] byArray = this.md.digest();
            this.md.update(this.k_opad);
            this.md.update(byArray);
            this.md.digest(byArray, 0, byArray.length);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    void reset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new HmacCore(this);
    }

    public static final class HmacSHA512
    extends MacSpi
    implements Cloneable {
        private final HmacCore core;

        public HmacSHA512() throws NoSuchAlgorithmException {
            this.core = new HmacCore("SHA-512", 128);
        }

        private HmacSHA512(HmacSHA512 hmacSHA512) throws CloneNotSupportedException {
            this.core = (HmacCore)hmacSHA512.core.clone();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.core.update(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA512(this);
        }
    }

    public static final class HmacSHA384
    extends MacSpi
    implements Cloneable {
        private final HmacCore core;

        public HmacSHA384() throws NoSuchAlgorithmException {
            this.core = new HmacCore("SHA-384", 128);
        }

        private HmacSHA384(HmacSHA384 hmacSHA384) throws CloneNotSupportedException {
            this.core = (HmacCore)hmacSHA384.core.clone();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.core.update(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA384(this);
        }
    }

    public static final class HmacSHA256
    extends MacSpi
    implements Cloneable {
        private final HmacCore core;

        public HmacSHA256() throws NoSuchAlgorithmException {
            this.core = new HmacCore("SHA-256", 64);
        }

        private HmacSHA256(HmacSHA256 hmacSHA256) throws CloneNotSupportedException {
            this.core = (HmacCore)hmacSHA256.core.clone();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.core.update(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA256(this);
        }
    }
}

