/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.util.calendar.ZoneInfo;

public class ZoneInfoFile {
    public static final byte[] JAVAZI_LABEL = new byte[]{106, 97, 118, 97, 122, 105, 0};
    private static final int JAVAZI_LABEL_LENGTH = JAVAZI_LABEL.length;
    public static final byte JAVAZI_VERSION = 1;
    public static final byte TAG_RawOffset = 1;
    public static final byte TAG_LastDSTSaving = 2;
    public static final byte TAG_CRC32 = 3;
    public static final byte TAG_Transition = 4;
    public static final byte TAG_Offset = 5;
    public static final byte TAG_SimpleTimeZone = 6;
    public static final byte TAG_GMTOffsetWillChange = 7;
    public static final String JAVAZM_FILE_NAME = "ZoneInfoMappings";
    public static final byte[] JAVAZM_LABEL = new byte[]{106, 97, 118, 97, 122, 109, 0};
    private static final int JAVAZM_LABEL_LENGTH = JAVAZM_LABEL.length;
    public static final byte JAVAZM_VERSION = 1;
    public static final byte TAG_ZoneIDs = 64;
    public static final byte TAG_RawOffsets = 65;
    public static final byte TAG_RawOffsetIndices = 66;
    public static final byte TAG_ZoneAliases = 67;
    public static final byte TAG_TZDataVersion = 68;
    public static final byte TAG_ExcludedZones = 69;
    private static Map<String, ZoneInfo> zoneInfoObjects = null;
    private static final ZoneInfo GMT = new ZoneInfo("GMT", 0);
    private static final String ziDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "zi";
            try {
                string = FileSystems.getDefault().getPath(string, new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
    });
    private static volatile SoftReference<List<String>> zoneIDs = null;
    private static volatile SoftReference<List<String>> excludedIDs = null;
    private static volatile boolean hasNoExcludeList = false;
    private static volatile SoftReference<byte[]> rawOffsetIndices = null;
    private static volatile SoftReference<int[]> rawOffsets = null;
    private static volatile SoftReference<byte[]> zoneInfoMappings = null;

    public static String getFileName(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace('/', File.separatorChar);
    }

    public static ZoneInfo getCustomTimeZone(String string, int n) {
        String string2 = ZoneInfoFile.toCustomID(n);
        ZoneInfo zoneInfo = ZoneInfoFile.getFromCache(string2);
        if (zoneInfo == null) {
            zoneInfo = new ZoneInfo(string2, n);
            zoneInfo = ZoneInfoFile.addToCache(string2, zoneInfo);
            if (!string2.equals(string)) {
                zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
            }
        }
        return (ZoneInfo)zoneInfo.clone();
    }

    public static String toCustomID(int n) {
        char c;
        int n2 = n / 60000;
        if (n2 >= 0) {
            c = '+';
        } else {
            c = '-';
            n2 = -n2;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        char[] cArray = new char[]{'G', 'M', 'T', c, '0', '0', ':', '0', '0'};
        if (n3 >= 10) {
            cArray[4] = (char)(cArray[4] + n3 / 10);
        }
        cArray[5] = (char)(cArray[5] + n3 % 10);
        if (n4 != 0) {
            cArray[7] = (char)(cArray[7] + n4 / 10);
            cArray[8] = (char)(cArray[8] + n4 % 10);
        }
        return new String(cArray);
    }

    public static ZoneInfo getZoneInfo(String string) {
        if ("GMT".equals(string)) {
            return (ZoneInfo)GMT.clone();
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getFromCache(string);
        if (zoneInfo == null) {
            Map<String, String> map = ZoneInfo.getCachedAliasTable();
            if (map != null && map.get(string) != null) {
                return null;
            }
            zoneInfo = ZoneInfoFile.createZoneInfo(string);
            if (zoneInfo == null) {
                return null;
            }
            zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
        }
        return (ZoneInfo)zoneInfo.clone();
    }

    static synchronized ZoneInfo getFromCache(String string) {
        if (zoneInfoObjects == null) {
            return null;
        }
        return zoneInfoObjects.get(string);
    }

    static synchronized ZoneInfo addToCache(String string, ZoneInfo zoneInfo) {
        if (zoneInfoObjects == null) {
            zoneInfoObjects = new HashMap<String, ZoneInfo>();
        } else {
            ZoneInfo zoneInfo2 = zoneInfoObjects.get(string);
            if (zoneInfo2 != null) {
                return zoneInfo2;
            }
        }
        zoneInfoObjects.put(string, zoneInfo);
        return zoneInfo;
    }

    private static ZoneInfo createZoneInfo(String string) {
        byte[] byArray = ZoneInfoFile.readZoneInfoFile(ZoneInfoFile.getFileName(string));
        if (byArray == null) {
            return null;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        long[] lArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        try {
            for (n = 0; n < JAVAZI_LABEL.length; ++n) {
                if (byArray[n] == JAVAZI_LABEL[n]) continue;
                System.err.println("ZoneInfo: wrong magic number: " + string);
                return null;
            }
            if (byArray[n++] > 1) {
                System.err.println("ZoneInfo: incompatible version (" + byArray[n - 1] + "): " + string);
                return null;
            }
            block12: while (n < n2) {
                int n6;
                byte by = byArray[n++];
                if (n2 >= n + (n6 = ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF))) {
                    switch (by) {
                        case 3: {
                            int n7 = byArray[n++] & 0xFF;
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n5 = n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            break;
                        }
                        case 2: {
                            int n7 = (short)(byArray[n++] & 0xFF);
                            n7 = (short)((n7 << 8) + (byArray[n++] & 0xFF));
                            n4 = n7 * 1000;
                            break;
                        }
                        case 1: {
                            int n7 = byArray[n++] & 0xFF;
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            n3 = n7 = (n7 << 8) + (byArray[n++] & 0xFF);
                            break;
                        }
                        case 4: {
                            int n8;
                            int n7 = n6 / 8;
                            lArray = new long[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                long l = byArray[n++] & 0xFF;
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                l = (l << 8) + (long)(byArray[n++] & 0xFF);
                                lArray[n8] = l = (l << 8) + (long)(byArray[n++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 5: {
                            int n8;
                            int n7 = n6 / 4;
                            nArray = new int[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                int n9 = byArray[n++] & 0xFF;
                                n9 = (n9 << 8) + (byArray[n++] & 0xFF);
                                n9 = (n9 << 8) + (byArray[n++] & 0xFF);
                                nArray[n8] = n9 = (n9 << 8) + (byArray[n++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 6: {
                            int n8;
                            if (n6 != 32 && n6 != 40) {
                                System.err.println("ZoneInfo: wrong SimpleTimeZone parameter size");
                                return null;
                            }
                            int n7 = n6 / 4;
                            nArray2 = new int[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                int n10 = byArray[n++] & 0xFF;
                                n10 = (n10 << 8) + (byArray[n++] & 0xFF);
                                n10 = (n10 << 8) + (byArray[n++] & 0xFF);
                                nArray2[n8] = n10 = (n10 << 8) + (byArray[n++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 7: {
                            if (n6 != 1) {
                                System.err.println("ZoneInfo: wrong byte length for TAG_GMTOffsetWillChange");
                            }
                            bl = byArray[n++] == 1;
                            break;
                        }
                        default: {
                            System.err.println("ZoneInfo: unknown tag < " + by + ">. ignored.");
                            n += n6;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("ZoneInfo: corrupted zoneinfo file: " + string);
            return null;
        }
        if (n != n2) {
            System.err.println("ZoneInfo: wrong file size: " + string);
            return null;
        }
        return new ZoneInfo(string, n3, n4, n5, lArray, nArray, nArray2, bl);
    }

    static List<String> getZoneIDs() {
        List<String> list;
        block8: {
            list = null;
            SoftReference<List<String>> softReference = zoneIDs;
            if (softReference != null && (list = softReference.get()) != null) {
                return list;
            }
            byte[] byArray = null;
            byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 64: {
                            int n3 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            list = new ArrayList<String>(n3);
                            for (int j = 0; j < n3; ++j) {
                                byte by2 = byArray[i++];
                                list.add(new String(byArray, i, (int)by2, "UTF-8"));
                                i += by2;
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        zoneIDs = new SoftReference<List<String>>(list);
        return list;
    }

    static Map<String, String> getZoneAliases() {
        HashMap<String, String> hashMap;
        block7: {
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            hashMap = null;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 67: {
                            int n3 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            hashMap = new HashMap<String, String>(n3);
                            for (int j = 0; j < n3; ++j) {
                                byte by2 = byArray[i++];
                                String string = new String(byArray, i, (int)by2, "UTF-8");
                                i += by2;
                                by2 = byArray[i++];
                                String string2 = new String(byArray, i, (int)by2, "UTF-8");
                                i += by2;
                                hashMap.put(string, string2);
                            }
                            break block7;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        return hashMap;
    }

    static List<String> getExcludedZones() {
        List<String> list;
        block11: {
            if (hasNoExcludeList) {
                return null;
            }
            list = null;
            SoftReference<List<String>> softReference = excludedIDs;
            if (softReference != null && (list = softReference.get()) != null) {
                return list;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 69: {
                            int n3 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            list = new ArrayList<String>();
                            for (int j = 0; j < n3; ++j) {
                                byte by2 = byArray[i++];
                                String string = new String(byArray, i, (int)by2, "UTF-8");
                                i += by2;
                                list.add(string);
                            }
                            break block11;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        if (list != null) {
            excludedIDs = new SoftReference<List<String>>(list);
        } else {
            hasNoExcludeList = true;
        }
        return list;
    }

    static byte[] getRawOffsetIndices() {
        byte[] byArray;
        block8: {
            byArray = null;
            SoftReference<byte[]> softReference = rawOffsetIndices;
            if (softReference != null && (byArray = softReference.get()) != null) {
                return byArray;
            }
            byte[] byArray2 = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray2.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray2[i++];
                    n2 = ((byArray2[i++] & 0xFF) << 8) + (byArray2[i++] & 0xFF);
                    switch (by) {
                        case 66: {
                            byArray = new byte[n2];
                            for (int j = 0; j < n2; ++j) {
                                byArray[j] = byArray2[i++];
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsetIndices = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    static int[] getRawOffsets() {
        int[] nArray;
        block8: {
            nArray = null;
            SoftReference<int[]> softReference = rawOffsets;
            if (softReference != null && (nArray = softReference.get()) != null) {
                return nArray;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n = byArray.length;
            try {
                int n2;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n; i += n2) {
                    byte by = byArray[i++];
                    n2 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 65: {
                            int n3 = n2 / 4;
                            nArray = new int[n3];
                            for (int j = 0; j < n3; ++j) {
                                int n4 = byArray[i++] & 0xFF;
                                n4 = (n4 << 8) + (byArray[i++] & 0xFF);
                                n4 = (n4 << 8) + (byArray[i++] & 0xFF);
                                nArray[j] = n4 = (n4 << 8) + (byArray[i++] & 0xFF);
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsets = new SoftReference<int[]>(nArray);
        return nArray;
    }

    private static byte[] getZoneInfoMappings() {
        int n;
        byte[] byArray;
        SoftReference<byte[]> softReference = zoneInfoMappings;
        if (softReference != null && (byArray = softReference.get()) != null) {
            return byArray;
        }
        byArray = ZoneInfoFile.readZoneInfoFile(JAVAZM_FILE_NAME);
        if (byArray == null) {
            return null;
        }
        for (n = 0; n < JAVAZM_LABEL.length; ++n) {
            if (byArray[n] == JAVAZM_LABEL[n]) continue;
            System.err.println("ZoneInfo: wrong magic number: ZoneInfoMappings");
            return null;
        }
        if (byArray[n++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n - 1] + "): " + JAVAZM_FILE_NAME);
            return null;
        }
        zoneInfoMappings = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    private static byte[] readZoneInfoFile(final String string) {
        byte[] byArray;
        block3: {
            if (string.indexOf("..") >= 0) {
                return null;
            }
            byArray = null;
            try {
                byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        File file = new File(ziDir, string);
                        byte[] byArray = null;
                        int n = (int)file.length();
                        if (n > 0) {
                            byArray = new byte[n];
                            try (FileInputStream fileInputStream = new FileInputStream(file);){
                                if (fileInputStream.read(byArray) != n) {
                                    throw new IOException("read error on " + string);
                                }
                            }
                        }
                        return byArray;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof FileNotFoundException && !JAVAZM_FILE_NAME.equals(string)) break block3;
                System.err.println("ZoneInfo: " + exception.getMessage());
            }
        }
        return byArray;
    }
}

