/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.Controller;
import ddf.minim.Playable;
import ddf.minim.spi.AudioRecording;

public class AudioSnippet
extends Controller
implements Playable {
    private AudioRecording recording;

    public AudioSnippet(AudioRecording audioRecording) {
        super(audioRecording.getControls());
        audioRecording.open();
        this.recording = audioRecording;
    }

    @Override
    public void play() {
        this.recording.play();
    }

    @Override
    public void play(int n) {
        this.cue(n);
        this.play();
    }

    @Override
    public void pause() {
        this.recording.pause();
    }

    @Override
    public void rewind() {
        this.cue(0);
    }

    @Override
    public void loop() {
        this.recording.loop(-1);
    }

    @Override
    public void loop(int n) {
        this.recording.loop(n);
    }

    @Override
    public int loopCount() {
        return this.recording.getLoopCount();
    }

    @Override
    public int length() {
        return this.recording.getMillisecondLength();
    }

    @Override
    public int position() {
        return this.recording.getMillisecondPosition();
    }

    @Override
    public void cue(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this.length()) {
            n = this.length();
        }
        this.recording.setMillisecondPosition(n);
    }

    @Override
    public void skip(int n) {
        int n2 = this.position() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.length()) {
            n2 = this.length();
        }
        this.recording.setMillisecondPosition(n2);
    }

    @Override
    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    @Override
    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    public void close() {
        this.recording.close();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    @Override
    public void setLoopPoints(int n, int n2) {
        this.recording.setLoopPoints(n, n2);
    }
}

