/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.FontTexture;
import processing.opengl.FrameBuffer;
import processing.opengl.LinePath;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PJOGL;
import processing.opengl.PShader;
import processing.opengl.Texture;

public class PGraphicsOpenGL
extends PGraphics {
    public PGL pgl;
    protected PGraphicsOpenGL currentPG;
    protected WeakHashMap<PFont, FontTexture> fontMap;
    public boolean initialized;
    protected static final int FLUSH_CONTINUOUSLY = 0;
    protected static final int FLUSH_WHEN_FULL = 1;
    protected static final int IMMEDIATE = 0;
    protected static final int RETAINED = 1;
    protected int flushMode = 1;
    public int glPolyVertex;
    public int glPolyColor;
    public int glPolyNormal;
    public int glPolyTexcoord;
    public int glPolyAmbient;
    public int glPolySpecular;
    public int glPolyEmissive;
    public int glPolyShininess;
    public int glPolyIndex;
    protected boolean polyBuffersCreated = false;
    protected int polyBuffersContext;
    public int glLineVertex;
    public int glLineColor;
    public int glLineAttrib;
    public int glLineIndex;
    protected boolean lineBuffersCreated = false;
    protected int lineBuffersContext;
    public int glPointVertex;
    public int glPointColor;
    public int glPointAttrib;
    public int glPointIndex;
    protected boolean pointBuffersCreated = false;
    protected int pointBuffersContext;
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    protected static boolean glParamsRead = false;
    public static boolean npotTexSupported;
    public static boolean autoMipmapGenSupported;
    public static boolean fboMultisampleSupported;
    public static boolean packedDepthStencilSupported;
    public static boolean anisoSamplingSupported;
    public static boolean blendEqSupported;
    public static int maxTextureSize;
    public static int maxSamples;
    public static float maxAnisoAmount;
    public static int depthBits;
    public static int stencilBits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    public static String OPENGL_EXTENSIONS;
    public static String GLSL_VERSION;
    protected static HashMap<GLResource, Boolean> glTextureObjects;
    protected static HashMap<GLResource, Boolean> glVertexBuffers;
    protected static HashMap<GLResource, Boolean> glFrameBuffers;
    protected static HashMap<GLResource, Boolean> glRenderBuffers;
    protected static HashMap<GLResource, Boolean> glslPrograms;
    protected static HashMap<GLResource, Boolean> glslVertexShaders;
    protected static HashMap<GLResource, Boolean> glslFragmentShaders;
    protected static URL defColorShaderVertURL;
    protected static URL defTextureShaderVertURL;
    protected static URL defLightShaderVertURL;
    protected static URL defTexlightShaderVertURL;
    protected static URL defColorShaderFragURL;
    protected static URL defTextureShaderFragURL;
    protected static URL defLineShaderVertURL;
    protected static URL defLineShaderFragURL;
    protected static URL defPointShaderVertURL;
    protected static URL defPointShaderFragURL;
    protected static URL maskShaderFragURL;
    protected PShader defColorShader;
    protected PShader defTextureShader;
    protected PShader defLightShader;
    protected PShader defTexlightShader;
    protected PShader defLineShader;
    protected PShader defPointShader;
    protected PShader maskShader;
    protected PShader polyShader;
    protected PShader lineShader;
    protected PShader pointShader;
    protected InGeometry inGeo;
    protected TessGeometry tessGeo;
    protected TexCache texCache;
    protected static Tessellator tessellator;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    protected float cameraEyeX;
    protected float cameraEyeY;
    protected float cameraEyeZ;
    protected boolean manipulatingCamera;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projmodelview;
    protected float[] glProjection;
    protected float[] glModelview;
    protected float[] glProjmodelview;
    protected float[] glNormal;
    protected static PMatrix3D identity;
    protected boolean matricesAllocated = false;
    protected boolean sized;
    protected static final int MATRIX_STACK_DEPTH = 32;
    protected int modelviewStackDepth;
    protected int projectionStackDepth;
    protected float[][] modelviewStack = new float[32][16];
    protected float[][] modelviewInvStack = new float[32][16];
    protected float[][] cameraStack = new float[32][16];
    protected float[][] cameraInvStack = new float[32][16];
    protected float[][] projectionStack = new float[32][16];
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[] lightPosition;
    public float[] lightNormal;
    public float[] lightAmbient;
    public float[] lightDiffuse;
    public float[] lightSpecular;
    public float[] lightFalloffCoefficients;
    public float[] lightSpotParameters;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    protected boolean lightsAllocated = false;
    protected int textureWrap = 0;
    protected int textureSampling = 5;
    protected boolean clip = false;
    protected int[] clipRect = new int[4];
    FontTexture textTex;
    protected static final int FB_STACK_DEPTH = 16;
    protected int fbStackDepth;
    protected FrameBuffer[] fbStack;
    protected FrameBuffer drawFramebuffer;
    protected FrameBuffer readFramebuffer;
    protected FrameBuffer currentFramebuffer;
    protected FrameBuffer offscreenFramebuffer;
    protected FrameBuffer multisampleFramebuffer;
    protected boolean offscreenMultisample;
    protected boolean pixOpChangedFB;
    protected Texture texture;
    protected Texture ptexture;
    protected IntBuffer pixelBuffer;
    protected int[] nativePixels;
    protected IntBuffer nativePixelBuffer;
    protected Texture filterTexture;
    protected PImage filterImage;
    protected boolean setgetPixels;
    protected boolean drawing = false;
    protected boolean restoreSurface = false;
    protected boolean smoothDisabled = false;
    protected int smoothCallCount = 0;
    protected int lastSmoothCall = -10;
    protected int lastBlendMode = -1;
    protected static final int OP_NONE = 0;
    protected static final int OP_READ = 1;
    protected static final int OP_WRITE = 2;
    protected int pixelsOp = 0;
    protected IntBuffer viewport;
    protected boolean clearColorBuffer;
    protected boolean clearColorBuffer0;
    protected boolean openContour = false;
    protected boolean breakShape = false;
    protected boolean defaultEdges = false;
    protected static final int EDGE_MIDDLE = 0;
    protected static final int EDGE_START = 1;
    protected static final int EDGE_STOP = 2;
    protected static final int EDGE_SINGLE = 3;
    protected static final int EDGE_CLOSE = -1;
    protected static final int MIN_POINT_ACCURACY = 20;
    protected static final int MAX_POINT_ACCURACY = 200;
    protected static final float POINT_ACCURACY_FACTOR = 10.0f;
    protected static final float[][] QUAD_POINT_SIGNS;
    protected static IntBuffer intBuffer;
    protected static FloatBuffer floatBuffer;
    static final String OPENGL_THREAD_ERROR = "Cannot run the OpenGL renderer outside the main thread, change your code\nso the drawing calls are all inside the main thread, \nor use the default renderer instead.";
    static final String BLEND_DRIVER_ERROR = "blendMode(%1$s) is not supported by this hardware (or driver)";
    static final String BLEND_RENDERER_ERROR = "blendMode(%1$s) is not supported by this renderer";
    static final String ALREADY_BEGAN_CONTOUR_ERROR = "Already called beginContour()";
    static final String NO_BEGIN_CONTOUR_ERROR = "Need to call beginContour() first";
    static final String UNSUPPORTED_SMOOTH_LEVEL_ERROR = "Smooth level %1$s is not available. Using %2$s instead";
    static final String UNSUPPORTED_SMOOTH_ERROR = "Smooth is not supported by this hardware (or driver)";
    static final String TOO_MANY_SMOOTH_CALLS_ERROR = "The smooth/noSmooth functions are being called too often.\nThis results in screen flickering, so they will be disabled\nfor the rest of the sketch's execution";
    static final String UNSUPPORTED_SHAPE_FORMAT_ERROR = "Unsupported shape format";
    static final String MISSING_UV_TEXCOORDS_ERROR = "No uv texture coordinates supplied with vertex() call";
    static final String INVALID_FILTER_SHADER_ERROR = "Your shader cannot be used as a filter because is of type POINT or LINES";
    static final String INCONSISTENT_SHADER_TYPES = "The vertex and fragment shaders have different types";
    static final String WRONG_SHADER_TYPE_ERROR = "shader() called with a wrong shader";
    static final String SHADER_NEED_LIGHT_ATTRIBS = "The provided shader needs light attributes (ambient, diffuse, etc.), but the current scene is unlit, so the default shader will be used instead";
    static final String MISSING_FRAGMENT_SHADER = "The fragment shader is missing, cannot create shader object";
    static final String MISSING_VERTEX_SHADER = "The vertex shader is missing, cannot create shader object";
    static final String UNKNOWN_SHADER_KIND_ERROR = "Unknown shader kind";
    static final String NO_TEXLIGHT_SHADER_ERROR = "Your shader needs to be of TEXLIGHT type to render this geometry properly, using default shader instead.";
    static final String NO_LIGHT_SHADER_ERROR = "Your shader needs to be of LIGHT type to render this geometry properly, using default shader instead.";
    static final String NO_TEXTURE_SHADER_ERROR = "Your shader needs to be of TEXTURE type to render this geometry properly, using default shader instead.";
    static final String NO_COLOR_SHADER_ERROR = "Your shader needs to be of COLOR type to render this geometry properly, using default shader instead.";
    static final String TOO_LONG_STROKE_PATH_ERROR = "Stroke path is too long, some bevel triangles won't be added";
    static final String TESSELLATION_ERROR = "Tessellation Error: %1$s";
    Triangle[] sortedPolyTriangles = null;
    int sortedTriangleCount = 0;

    static {
        glTextureObjects = new HashMap();
        glVertexBuffers = new HashMap();
        glFrameBuffers = new HashMap();
        glRenderBuffers = new HashMap();
        glslPrograms = new HashMap();
        glslVertexShaders = new HashMap();
        glslFragmentShaders = new HashMap();
        defColorShaderVertURL = PGraphicsOpenGL.class.getResource("ColorVert.glsl");
        defTextureShaderVertURL = PGraphicsOpenGL.class.getResource("TextureVert.glsl");
        defLightShaderVertURL = PGraphicsOpenGL.class.getResource("LightVert.glsl");
        defTexlightShaderVertURL = PGraphicsOpenGL.class.getResource("TexlightVert.glsl");
        defColorShaderFragURL = PGraphicsOpenGL.class.getResource("ColorFrag.glsl");
        defTextureShaderFragURL = PGraphicsOpenGL.class.getResource("TextureFrag.glsl");
        defLineShaderVertURL = PGraphicsOpenGL.class.getResource("LineVert.glsl");
        defLineShaderFragURL = PGraphicsOpenGL.class.getResource("LineFrag.glsl");
        defPointShaderVertURL = PGraphicsOpenGL.class.getResource("PointVert.glsl");
        defPointShaderFragURL = PGraphicsOpenGL.class.getResource("PointFrag.glsl");
        maskShaderFragURL = PGraphicsOpenGL.class.getResource("MaskFrag.glsl");
        identity = new PMatrix3D();
        QUAD_POINT_SIGNS = new float[][]{{-1.0f, 1.0f}, {-1.0f, -1.0f}, {1.0f, -1.0f}, {1.0f, 1.0f}};
    }

    public PGraphicsOpenGL() {
        this.pgl = this.createPGL(this);
        if (tessellator == null) {
            tessellator = new Tessellator();
        }
        if (intBuffer == null) {
            intBuffer = PGL.allocateIntBuffer(2);
            floatBuffer = PGL.allocateFloatBuffer(2);
        }
        this.viewport = PGL.allocateIntBuffer(4);
        this.inGeo = PGraphicsOpenGL.newInGeometry(this, 0);
        this.tessGeo = PGraphicsOpenGL.newTessGeometry(this, 0);
        this.texCache = PGraphicsOpenGL.newTexCache(this);
        this.initialized = false;
    }

    @Override
    public void setPrimary(boolean primary) {
        super.setPrimary(primary);
        this.pgl.setPrimary(primary);
        this.format = 2;
        if (primary) {
            this.fbStack = new FrameBuffer[16];
            this.fontMap = new WeakHashMap();
        }
    }

    @Override
    public void setFrameRate(float frameRate) {
        this.pgl.setFps(frameRate);
    }

    @Override
    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.allocate();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.sized = true;
    }

    @Override
    protected void allocate() {
        super.allocate();
        if (!this.matricesAllocated) {
            this.projection = new PMatrix3D();
            this.camera = new PMatrix3D();
            this.cameraInv = new PMatrix3D();
            this.modelview = new PMatrix3D();
            this.modelviewInv = new PMatrix3D();
            this.projmodelview = new PMatrix3D();
            this.matricesAllocated = true;
        }
        if (!this.lightsAllocated) {
            this.lightType = new int[PGL.MAX_LIGHTS];
            this.lightPosition = new float[4 * PGL.MAX_LIGHTS];
            this.lightNormal = new float[3 * PGL.MAX_LIGHTS];
            this.lightAmbient = new float[3 * PGL.MAX_LIGHTS];
            this.lightDiffuse = new float[3 * PGL.MAX_LIGHTS];
            this.lightSpecular = new float[3 * PGL.MAX_LIGHTS];
            this.lightFalloffCoefficients = new float[3 * PGL.MAX_LIGHTS];
            this.lightSpotParameters = new float[2 * PGL.MAX_LIGHTS];
            this.currentLightSpecular = new float[3];
            this.lightsAllocated = true;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.primarySurface) {
            this.pgl.swapBuffers();
        }
        this.finalizePolyBuffers();
        this.finalizeLineBuffers();
        this.finalizePointBuffers();
        this.deleteSurfaceTextures();
        if (this.primarySurface) {
            this.deleteDefaultShaders();
        } else {
            if (this.offscreenFramebuffer != null) {
                this.offscreenFramebuffer.dispose();
            }
            if (this.multisampleFramebuffer != null) {
                this.multisampleFramebuffer.dispose();
            }
        }
        PGraphicsOpenGL.deleteFinalizedGLResources(this.pgl);
        if (this.primarySurface) {
            this.pgl.deleteSurface();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.finalizePolyBuffers();
            this.finalizeLineBuffers();
            this.finalizePointBuffers();
            this.deleteSurfaceTextures();
            if (!this.primarySurface) {
                if (this.offscreenFramebuffer != null) {
                    this.offscreenFramebuffer.dispose();
                    this.offscreenFramebuffer = null;
                }
                if (this.multisampleFramebuffer != null) {
                    this.multisampleFramebuffer.dispose();
                    this.multisampleFramebuffer = null;
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void setFlushMode(int mode) {
        this.flushMode = mode;
    }

    @Override
    public void setCache(PImage image, Object storage) {
        this.getPrimaryPG().cacheMap.put(image, storage);
    }

    @Override
    public Object getCache(PImage image) {
        return this.getPrimaryPG().cacheMap.get(image);
    }

    @Override
    public void removeCache(PImage image) {
        this.getPrimaryPG().cacheMap.remove(image);
    }

    protected void setFontTexture(PFont font, FontTexture fontTexture) {
        this.getPrimaryPG().fontMap.put(font, fontTexture);
    }

    protected FontTexture getFontTexture(PFont font) {
        return this.getPrimaryPG().fontMap.get(font);
    }

    protected void removeFontTexture(PFont font) {
        this.getPrimaryPG().fontMap.remove(font);
    }

    protected static int createTextureObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedTextureObjects(pgl);
        pgl.genTextures(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glTextureObjects.containsKey(res)) {
            glTextureObjects.put(res, false);
        }
        return id;
    }

    protected static void deleteTextureObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteTextures(1, intBuffer);
            }
            glTextureObjects.remove(res);
        }
    }

    protected static void deleteAllTextureObjects(PGL pgl) {
        for (GLResource res : glTextureObjects.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteTextures(1, intBuffer);
        }
        glTextureObjects.clear();
    }

    protected static synchronized void finalizeTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            glTextureObjects.put(res, true);
        }
    }

    protected static void deleteFinalizedTextureObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glTextureObjects.keySet()) {
            if (!glTextureObjects.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteTextures(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glTextureObjects.remove(res);
        }
    }

    protected static void removeTextureObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glTextureObjects.containsKey(res)) {
            glTextureObjects.remove(res);
        }
    }

    protected static int createVertexBufferObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedVertexBufferObjects(pgl);
        pgl.genBuffers(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glVertexBuffers.containsKey(res)) {
            glVertexBuffers.put(res, false);
        }
        return id;
    }

    protected static void deleteVertexBufferObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteBuffers(1, intBuffer);
            }
            glVertexBuffers.remove(res);
        }
    }

    protected static void deleteAllVertexBufferObjects(PGL pgl) {
        for (GLResource res : glVertexBuffers.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteBuffers(1, intBuffer);
        }
        glVertexBuffers.clear();
    }

    protected static synchronized void finalizeVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            glVertexBuffers.put(res, true);
        }
    }

    protected static void deleteFinalizedVertexBufferObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glVertexBuffers.keySet()) {
            if (!glVertexBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteBuffers(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glVertexBuffers.remove(res);
        }
    }

    protected static void removeVertexBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glVertexBuffers.containsKey(res)) {
            glVertexBuffers.remove(res);
        }
    }

    protected static int createFrameBufferObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedFrameBufferObjects(pgl);
        pgl.genFramebuffers(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glFrameBuffers.containsKey(res)) {
            glFrameBuffers.put(res, false);
        }
        return id;
    }

    protected static void deleteFrameBufferObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteFramebuffers(1, intBuffer);
            }
            glFrameBuffers.remove(res);
        }
    }

    protected static void deleteAllFrameBufferObjects(PGL pgl) {
        for (GLResource res : glFrameBuffers.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteFramebuffers(1, intBuffer);
        }
        glFrameBuffers.clear();
    }

    protected static synchronized void finalizeFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            glFrameBuffers.put(res, true);
        }
    }

    protected static void deleteFinalizedFrameBufferObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glFrameBuffers.keySet()) {
            if (!glFrameBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteFramebuffers(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glFrameBuffers.remove(res);
        }
    }

    protected static void removeFrameBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glFrameBuffers.containsKey(res)) {
            glFrameBuffers.remove(res);
        }
    }

    protected static int createRenderBufferObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedRenderBufferObjects(pgl);
        pgl.genRenderbuffers(1, intBuffer);
        int id = intBuffer.get(0);
        GLResource res = new GLResource(id, context);
        if (!glRenderBuffers.containsKey(res)) {
            glRenderBuffers.put(res, false);
        }
        return id;
    }

    protected static void deleteRenderBufferObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            intBuffer.put(0, id);
            if (pgl.threadIsCurrent()) {
                pgl.deleteRenderbuffers(1, intBuffer);
            }
            glRenderBuffers.remove(res);
        }
    }

    protected static void deleteAllRenderBufferObjects(PGL pgl) {
        for (GLResource res : glRenderBuffers.keySet()) {
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteRenderbuffers(1, intBuffer);
        }
        glRenderBuffers.clear();
    }

    protected static synchronized void finalizeRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            glRenderBuffers.put(res, true);
        }
    }

    protected static void deleteFinalizedRenderBufferObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glRenderBuffers.keySet()) {
            if (!glRenderBuffers.get(res).booleanValue()) continue;
            finalized.add(res);
            intBuffer.put(0, res.id);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteRenderbuffers(1, intBuffer);
        }
        for (GLResource res : finalized) {
            glRenderBuffers.remove(res);
        }
    }

    protected static void removeRenderBufferObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glRenderBuffers.containsKey(res)) {
            glRenderBuffers.remove(res);
        }
    }

    protected static int createGLSLProgramObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedGLSLProgramObjects(pgl);
        int id = pgl.createProgram();
        GLResource res = new GLResource(id, context);
        if (!glslPrograms.containsKey(res)) {
            glslPrograms.put(res, false);
        }
        return id;
    }

    protected static void deleteGLSLProgramObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            if (pgl.threadIsCurrent()) {
                pgl.deleteProgram(res.id);
            }
            glslPrograms.remove(res);
        }
    }

    protected static void deleteAllGLSLProgramObjects(PGL pgl) {
        for (GLResource res : glslPrograms.keySet()) {
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteProgram(res.id);
        }
        glslPrograms.clear();
    }

    protected static synchronized void finalizeGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            glslPrograms.put(res, true);
        }
    }

    protected static void deleteFinalizedGLSLProgramObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslPrograms.keySet()) {
            if (!glslPrograms.get(res).booleanValue()) continue;
            finalized.add(res);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteProgram(res.id);
        }
        for (GLResource res : finalized) {
            glslPrograms.remove(res);
        }
    }

    protected static void removeGLSLProgramObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslPrograms.containsKey(res)) {
            glslPrograms.remove(res);
        }
    }

    protected static int createGLSLVertShaderObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedGLSLVertShaderObjects(pgl);
        int id = pgl.createShader(PGL.VERTEX_SHADER);
        GLResource res = new GLResource(id, context);
        if (!glslVertexShaders.containsKey(res)) {
            glslVertexShaders.put(res, false);
        }
        return id;
    }

    protected static void deleteGLSLVertShaderObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            if (pgl.threadIsCurrent()) {
                pgl.deleteShader(res.id);
            }
            glslVertexShaders.remove(res);
        }
    }

    protected static void deleteAllGLSLVertShaderObjects(PGL pgl) {
        for (GLResource res : glslVertexShaders.keySet()) {
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        glslVertexShaders.clear();
    }

    protected static synchronized void finalizeGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            glslVertexShaders.put(res, true);
        }
    }

    protected static void deleteFinalizedGLSLVertShaderObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslVertexShaders.keySet()) {
            if (!glslVertexShaders.get(res).booleanValue()) continue;
            finalized.add(res);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        for (GLResource res : finalized) {
            glslVertexShaders.remove(res);
        }
    }

    protected static void removeGLSLVertShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslVertexShaders.containsKey(res)) {
            glslVertexShaders.remove(res);
        }
    }

    protected static int createGLSLFragShaderObject(int context, PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedGLSLFragShaderObjects(pgl);
        int id = pgl.createShader(PGL.FRAGMENT_SHADER);
        GLResource res = new GLResource(id, context);
        if (!glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.put(res, false);
        }
        return id;
    }

    protected static void deleteGLSLFragShaderObject(int id, int context, PGL pgl) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            if (pgl.threadIsCurrent()) {
                pgl.deleteShader(res.id);
            }
            glslFragmentShaders.remove(res);
        }
    }

    protected static void deleteAllGLSLFragShaderObjects(PGL pgl) {
        for (GLResource res : glslFragmentShaders.keySet()) {
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        glslFragmentShaders.clear();
    }

    protected static synchronized void finalizeGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.put(res, true);
        }
    }

    protected static void deleteFinalizedGLSLFragShaderObjects(PGL pgl) {
        HashSet<GLResource> finalized = new HashSet<GLResource>();
        for (GLResource res : glslFragmentShaders.keySet()) {
            if (!glslFragmentShaders.get(res).booleanValue()) continue;
            finalized.add(res);
            if (!pgl.threadIsCurrent()) continue;
            pgl.deleteShader(res.id);
        }
        for (GLResource res : finalized) {
            glslFragmentShaders.remove(res);
        }
    }

    protected static void removeGLSLFragShaderObject(int id, int context) {
        GLResource res = new GLResource(id, context);
        if (glslFragmentShaders.containsKey(res)) {
            glslFragmentShaders.remove(res);
        }
    }

    protected static void deleteFinalizedGLResources(PGL pgl) {
        PGraphicsOpenGL.deleteFinalizedTextureObjects(pgl);
        PGraphicsOpenGL.deleteFinalizedVertexBufferObjects(pgl);
        PGraphicsOpenGL.deleteFinalizedFrameBufferObjects(pgl);
        PGraphicsOpenGL.deleteFinalizedRenderBufferObjects(pgl);
        PGraphicsOpenGL.deleteFinalizedGLSLProgramObjects(pgl);
        PGraphicsOpenGL.deleteFinalizedGLSLVertShaderObjects(pgl);
        PGraphicsOpenGL.deleteFinalizedGLSLFragShaderObjects(pgl);
    }

    protected void pushFramebuffer() {
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        if (ppg.fbStackDepth == 16) {
            throw new RuntimeException("Too many pushFramebuffer calls");
        }
        ppg.fbStack[ppg.fbStackDepth] = ppg.currentFramebuffer;
        ++ppg.fbStackDepth;
    }

    protected void setFramebuffer(FrameBuffer fbo) {
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        if (ppg.currentFramebuffer != fbo) {
            ppg.currentFramebuffer = fbo;
            if (ppg.currentFramebuffer != null) {
                ppg.currentFramebuffer.bind();
            }
        }
    }

    protected void popFramebuffer() {
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        if (ppg.fbStackDepth == 0) {
            throw new RuntimeException("popFramebuffer call is unbalanced.");
        }
        --ppg.fbStackDepth;
        FrameBuffer fbo = ppg.fbStack[ppg.fbStackDepth];
        if (ppg.currentFramebuffer != fbo) {
            ppg.currentFramebuffer.finish();
            ppg.currentFramebuffer = fbo;
            if (ppg.currentFramebuffer != null) {
                ppg.currentFramebuffer.bind();
            }
        }
    }

    protected FrameBuffer getCurrentFB() {
        return this.getPrimaryPG().currentFramebuffer;
    }

    protected void createPolyBuffers() {
        if (!this.polyBuffersCreated || this.polyBuffersContextIsOutdated()) {
            this.polyBuffersContext = this.pgl.getCurrentContext();
            int sizef = 256 * PGL.SIZEOF_FLOAT;
            int sizei = 256 * PGL.SIZEOF_INT;
            int sizex = 512 * PGL.SIZEOF_INDEX;
            this.glPolyVertex = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyVertex);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * sizef, null, PGL.STATIC_DRAW);
            this.glPolyColor = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyColor);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, null, PGL.STATIC_DRAW);
            this.glPolyNormal = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyNormal);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * sizef, null, PGL.STATIC_DRAW);
            this.glPolyTexcoord = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyTexcoord);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * sizef, null, PGL.STATIC_DRAW);
            this.glPolyAmbient = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyAmbient);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, null, PGL.STATIC_DRAW);
            this.glPolySpecular = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolySpecular);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, null, PGL.STATIC_DRAW);
            this.glPolyEmissive = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyEmissive);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, null, PGL.STATIC_DRAW);
            this.glPolyShininess = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyShininess);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizef, null, PGL.STATIC_DRAW);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
            this.glPolyIndex = PGraphicsOpenGL.createVertexBufferObject(this.polyBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glPolyIndex);
            this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, sizex, null, PGL.STATIC_DRAW);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
            this.polyBuffersCreated = true;
        }
    }

    protected void updatePolyBuffers(boolean lit, boolean tex, boolean needNormals, boolean needTexCoords) {
        this.createPolyBuffers();
        int size = this.tessGeo.polyVertexCount;
        int sizef = size * PGL.SIZEOF_FLOAT;
        int sizei = size * PGL.SIZEOF_INT;
        this.tessGeo.updatePolyVerticesBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyVertex);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * sizef, this.tessGeo.polyVerticesBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePolyColorsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyColor);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, this.tessGeo.polyColorsBuffer, PGL.STATIC_DRAW);
        if (lit) {
            this.tessGeo.updatePolyAmbientBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyAmbient);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, this.tessGeo.polyAmbientBuffer, PGL.STATIC_DRAW);
            this.tessGeo.updatePolySpecularBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolySpecular);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, this.tessGeo.polySpecularBuffer, PGL.STATIC_DRAW);
            this.tessGeo.updatePolyEmissiveBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyEmissive);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, this.tessGeo.polyEmissiveBuffer, PGL.STATIC_DRAW);
            this.tessGeo.updatePolyShininessBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyShininess);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizef, this.tessGeo.polyShininessBuffer, PGL.STATIC_DRAW);
        }
        if (lit || needNormals) {
            this.tessGeo.updatePolyNormalsBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyNormal);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * sizef, this.tessGeo.polyNormalsBuffer, PGL.STATIC_DRAW);
        }
        if (tex || needTexCoords) {
            this.tessGeo.updatePolyTexCoordsBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPolyTexcoord);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * sizef, this.tessGeo.polyTexCoordsBuffer, PGL.STATIC_DRAW);
        }
        this.tessGeo.updatePolyIndicesBuffer();
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glPolyIndex);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.polyIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.polyIndicesBuffer, PGL.STATIC_DRAW);
    }

    protected void unbindPolyBuffers() {
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean polyBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.polyBuffersContext);
    }

    protected void finalizePolyBuffers() {
        if (this.glPolyVertex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyVertex, this.polyBuffersContext);
            this.glPolyVertex = 0;
        }
        if (this.glPolyColor != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyColor, this.polyBuffersContext);
            this.glPolyColor = 0;
        }
        if (this.glPolyNormal != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyNormal, this.polyBuffersContext);
            this.glPolyNormal = 0;
        }
        if (this.glPolyTexcoord != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyTexcoord, this.polyBuffersContext);
            this.glPolyTexcoord = 0;
        }
        if (this.glPolyAmbient != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyAmbient, this.polyBuffersContext);
            this.glPolyAmbient = 0;
        }
        if (this.glPolySpecular != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolySpecular, this.polyBuffersContext);
            this.glPolySpecular = 0;
        }
        if (this.glPolyEmissive != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyEmissive, this.polyBuffersContext);
            this.glPolyEmissive = 0;
        }
        if (this.glPolyShininess != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyShininess, this.polyBuffersContext);
            this.glPolyShininess = 0;
        }
        if (this.glPolyIndex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPolyIndex, this.polyBuffersContext);
            this.glPolyIndex = 0;
        }
        this.polyBuffersCreated = false;
    }

    protected void createLineBuffers() {
        if (!this.lineBuffersCreated || this.lineBufferContextIsOutdated()) {
            this.lineBuffersContext = this.pgl.getCurrentContext();
            int sizef = 256 * PGL.SIZEOF_FLOAT;
            int sizei = 256 * PGL.SIZEOF_INT;
            int sizex = 512 * PGL.SIZEOF_INDEX;
            this.glLineVertex = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineVertex);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * sizef, null, PGL.STATIC_DRAW);
            this.glLineColor = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineColor);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, null, PGL.STATIC_DRAW);
            this.glLineAttrib = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineAttrib);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * sizef, null, PGL.STATIC_DRAW);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
            this.glLineIndex = PGraphicsOpenGL.createVertexBufferObject(this.lineBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glLineIndex);
            this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, sizex, null, PGL.STATIC_DRAW);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
            this.lineBuffersCreated = true;
        }
    }

    protected void updateLineBuffers() {
        this.createLineBuffers();
        int size = this.tessGeo.lineVertexCount;
        int sizef = size * PGL.SIZEOF_FLOAT;
        int sizei = size * PGL.SIZEOF_INT;
        this.tessGeo.updateLineVerticesBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineVertex);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * sizef, this.tessGeo.lineVerticesBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updateLineColorsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineColor);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, this.tessGeo.lineColorsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updateLineDirectionsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glLineAttrib);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * sizef, this.tessGeo.lineDirectionsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updateLineIndicesBuffer();
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glLineIndex);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.lineIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.lineIndicesBuffer, PGL.STATIC_DRAW);
    }

    protected void unbindLineBuffers() {
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean lineBufferContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.lineBuffersContext);
    }

    protected void finalizeLineBuffers() {
        if (this.glLineVertex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineVertex, this.lineBuffersContext);
            this.glLineVertex = 0;
        }
        if (this.glLineColor != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineColor, this.lineBuffersContext);
            this.glLineColor = 0;
        }
        if (this.glLineAttrib != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineAttrib, this.lineBuffersContext);
            this.glLineAttrib = 0;
        }
        if (this.glLineIndex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glLineIndex, this.lineBuffersContext);
            this.glLineIndex = 0;
        }
        this.lineBuffersCreated = false;
    }

    protected void createPointBuffers() {
        if (!this.pointBuffersCreated || this.pointBuffersContextIsOutdated()) {
            this.pointBuffersContext = this.pgl.getCurrentContext();
            int sizef = 256 * PGL.SIZEOF_FLOAT;
            int sizei = 256 * PGL.SIZEOF_INT;
            int sizex = 512 * PGL.SIZEOF_INDEX;
            this.glPointVertex = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointVertex);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * sizef, null, PGL.STATIC_DRAW);
            this.glPointColor = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointColor);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, null, PGL.STATIC_DRAW);
            this.glPointAttrib = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointAttrib);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * sizef, null, PGL.STATIC_DRAW);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
            this.glPointIndex = PGraphicsOpenGL.createVertexBufferObject(this.pointBuffersContext, this.pgl);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glPointIndex);
            this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, sizex, null, PGL.STATIC_DRAW);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
            this.pointBuffersCreated = true;
        }
    }

    protected void updatePointBuffers() {
        this.createPointBuffers();
        int size = this.tessGeo.pointVertexCount;
        int sizef = size * PGL.SIZEOF_FLOAT;
        int sizei = size * PGL.SIZEOF_INT;
        this.tessGeo.updatePointVerticesBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointVertex);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * sizef, this.tessGeo.pointVerticesBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePointColorsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointColor);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, sizei, this.tessGeo.pointColorsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePointOffsetsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.glPointAttrib);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * sizef, this.tessGeo.pointOffsetsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePointIndicesBuffer();
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.glPointIndex);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.pointIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.pointIndicesBuffer, PGL.STATIC_DRAW);
    }

    protected void unbindPointBuffers() {
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean pointBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.pointBuffersContext);
    }

    protected void finalizePointBuffers() {
        if (this.glPointVertex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointVertex, this.pointBuffersContext);
            this.glPointVertex = 0;
        }
        if (this.glPointColor != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointColor, this.pointBuffersContext);
            this.glPointColor = 0;
        }
        if (this.glPointAttrib != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointAttrib, this.pointBuffersContext);
            this.glPointAttrib = 0;
        }
        if (this.glPointIndex != 0) {
            PGraphicsOpenGL.finalizeVertexBufferObject(this.glPointIndex, this.pointBuffersContext);
            this.glPointIndex = 0;
        }
        this.pointBuffersCreated = false;
    }

    @Override
    public void requestFocus() {
        this.pgl.requestFocus();
    }

    @Override
    public boolean canDraw() {
        return this.pgl.canDraw();
    }

    @Override
    public void requestDraw() {
        if (this.primarySurface) {
            if (this.initialized) {
                if (this.sized) {
                    this.pgl.reinitSurface();
                }
                if (this.parent.canDraw()) {
                    this.pgl.requestDraw();
                }
            } else {
                this.initPrimary();
            }
        }
    }

    @Override
    public void beginDraw() {
        if (this.primarySurface) {
            this.setCurrentPG(this);
        } else {
            this.pgl.getGL(this.getPrimaryPGL());
            this.getPrimaryPG().setCurrentPG(this);
        }
        this.report("top beginDraw()");
        if (!this.checkGLThread()) {
            return;
        }
        if (this.drawing) {
            return;
        }
        if (!this.primarySurface && this.getPrimaryPG().texCache.containsTexture(this)) {
            this.getPrimaryPG().flush();
        }
        if (!glParamsRead) {
            this.getGLParameters();
        }
        this.setViewport();
        if (this.primarySurface) {
            this.beginOnscreenDraw();
        } else {
            this.beginOffscreenDraw();
        }
        this.setDrawDefaults();
        this.drawing = true;
        this.report("bot beginDraw()");
    }

    @Override
    public void endDraw() {
        this.report("top endDraw()");
        if (!this.drawing) {
            return;
        }
        this.flush();
        if (PGL.SAVE_SURFACE_TO_PIXELS_HACK && (!this.getPrimaryPG().initialized || this.parent.frameCount == 0)) {
            this.saveSurfaceToPixels();
            this.restoreSurface = true;
        }
        if (this.primarySurface) {
            this.endOnscreenDraw();
        } else {
            this.endOffscreenDraw();
        }
        if (this.primarySurface) {
            this.setCurrentPG(null);
        } else {
            this.getPrimaryPG().setCurrentPG(this.getPrimaryPG());
        }
        this.drawing = false;
        this.report("bot endDraw()");
    }

    protected PGL createPGL(PGraphicsOpenGL pg) {
        return new PJOGL(pg);
    }

    protected PGraphicsOpenGL getPrimaryPG() {
        if (this.primarySurface) {
            return this;
        }
        return (PGraphicsOpenGL)this.parent.g;
    }

    protected void setCurrentPG(PGraphicsOpenGL pg) {
        this.currentPG = pg;
    }

    protected PGraphicsOpenGL getCurrentPG() {
        return this.currentPG;
    }

    protected PGL getPrimaryPGL() {
        if (this.primarySurface) {
            return this.pgl;
        }
        return ((PGraphicsOpenGL)this.parent.g).pgl;
    }

    @Override
    public PGL beginPGL() {
        this.flush();
        this.pgl.beginGL();
        return this.pgl;
    }

    @Override
    public void endPGL() {
        this.pgl.endGL();
        this.restoreGL();
    }

    public void updateProjmodelview() {
        this.projmodelview.set(this.projection);
        this.projmodelview.apply(this.modelview);
    }

    protected void restartPGL() {
        this.initialized = false;
    }

    protected void restoreGL() {
        this.blendMode(this.blendMode);
        if (this.hints[2]) {
            this.pgl.disable(PGL.DEPTH_TEST);
        } else {
            this.pgl.enable(PGL.DEPTH_TEST);
        }
        this.pgl.depthFunc(PGL.LEQUAL);
        if (this.quality < 2) {
            this.pgl.disable(PGL.MULTISAMPLE);
        } else {
            this.pgl.enable(PGL.MULTISAMPLE);
            this.pgl.disable(PGL.POLYGON_SMOOTH);
        }
        this.pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
        if (this.clip) {
            this.pgl.enable(PGL.SCISSOR_TEST);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(PGL.SCISSOR_TEST);
        }
        this.pgl.frontFace(PGL.CW);
        this.pgl.disable(PGL.CULL_FACE);
        this.pgl.activeTexture(PGL.TEXTURE0);
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        FrameBuffer fb = this.getCurrentFB();
        if (fb != null) {
            fb.bind();
            this.pgl.drawBuffer(fb.getDefaultDrawBuffer());
        }
    }

    protected void beginBindFramebuffer(int target, int framebuffer) {
    }

    protected void endBindFramebuffer(int target, int framebuffer) {
        FrameBuffer fb = this.getCurrentFB();
        if (framebuffer == 0 && fb != null && fb.glFbo != 0) {
            fb.bind();
        }
    }

    protected void beginReadPixels() {
        this.beginPixelsOp(1);
    }

    protected void endReadPixels() {
        this.endPixelsOp();
    }

    protected void beginPixelsOp(int op) {
        FrameBuffer pixfb = null;
        if (this.primarySurface) {
            if (op == 1) {
                if (this.pgl.isFBOBacked() && this.pgl.isMultisampled()) {
                    this.pgl.syncBackTexture();
                    pixfb = this.readFramebuffer;
                } else {
                    pixfb = this.drawFramebuffer;
                }
            } else if (op == 2) {
                pixfb = this.drawFramebuffer;
            }
        } else if (op == 1) {
            if (this.offscreenMultisample) {
                this.multisampleFramebuffer.copyColor(this.offscreenFramebuffer);
            }
            pixfb = this.offscreenFramebuffer;
        } else if (op == 2) {
            FrameBuffer frameBuffer = pixfb = this.offscreenMultisample ? this.multisampleFramebuffer : this.offscreenFramebuffer;
        }
        if (pixfb != this.getCurrentFB()) {
            this.pushFramebuffer();
            this.setFramebuffer(pixfb);
            this.pixOpChangedFB = true;
        }
        if (op == 1) {
            this.pgl.readBuffer(this.getCurrentFB().getDefaultDrawBuffer());
        } else if (op == 2) {
            this.pgl.drawBuffer(this.getCurrentFB().getDefaultDrawBuffer());
        }
        this.pixelsOp = op;
    }

    protected void endPixelsOp() {
        if (this.pixOpChangedFB) {
            this.popFramebuffer();
            this.pixOpChangedFB = false;
        }
        this.pgl.readBuffer(this.getCurrentFB().getDefaultReadBuffer());
        this.pgl.drawBuffer(this.getCurrentFB().getDefaultDrawBuffer());
        this.pixelsOp = 0;
    }

    protected void updateGLProjection() {
        if (this.glProjection == null) {
            this.glProjection = new float[16];
        }
        this.glProjection[0] = this.projection.m00;
        this.glProjection[1] = this.projection.m10;
        this.glProjection[2] = this.projection.m20;
        this.glProjection[3] = this.projection.m30;
        this.glProjection[4] = this.projection.m01;
        this.glProjection[5] = this.projection.m11;
        this.glProjection[6] = this.projection.m21;
        this.glProjection[7] = this.projection.m31;
        this.glProjection[8] = this.projection.m02;
        this.glProjection[9] = this.projection.m12;
        this.glProjection[10] = this.projection.m22;
        this.glProjection[11] = this.projection.m32;
        this.glProjection[12] = this.projection.m03;
        this.glProjection[13] = this.projection.m13;
        this.glProjection[14] = this.projection.m23;
        this.glProjection[15] = this.projection.m33;
    }

    protected void updateGLModelview() {
        if (this.glModelview == null) {
            this.glModelview = new float[16];
        }
        this.glModelview[0] = this.modelview.m00;
        this.glModelview[1] = this.modelview.m10;
        this.glModelview[2] = this.modelview.m20;
        this.glModelview[3] = this.modelview.m30;
        this.glModelview[4] = this.modelview.m01;
        this.glModelview[5] = this.modelview.m11;
        this.glModelview[6] = this.modelview.m21;
        this.glModelview[7] = this.modelview.m31;
        this.glModelview[8] = this.modelview.m02;
        this.glModelview[9] = this.modelview.m12;
        this.glModelview[10] = this.modelview.m22;
        this.glModelview[11] = this.modelview.m32;
        this.glModelview[12] = this.modelview.m03;
        this.glModelview[13] = this.modelview.m13;
        this.glModelview[14] = this.modelview.m23;
        this.glModelview[15] = this.modelview.m33;
    }

    protected void updateGLProjmodelview() {
        if (this.glProjmodelview == null) {
            this.glProjmodelview = new float[16];
        }
        this.glProjmodelview[0] = this.projmodelview.m00;
        this.glProjmodelview[1] = this.projmodelview.m10;
        this.glProjmodelview[2] = this.projmodelview.m20;
        this.glProjmodelview[3] = this.projmodelview.m30;
        this.glProjmodelview[4] = this.projmodelview.m01;
        this.glProjmodelview[5] = this.projmodelview.m11;
        this.glProjmodelview[6] = this.projmodelview.m21;
        this.glProjmodelview[7] = this.projmodelview.m31;
        this.glProjmodelview[8] = this.projmodelview.m02;
        this.glProjmodelview[9] = this.projmodelview.m12;
        this.glProjmodelview[10] = this.projmodelview.m22;
        this.glProjmodelview[11] = this.projmodelview.m32;
        this.glProjmodelview[12] = this.projmodelview.m03;
        this.glProjmodelview[13] = this.projmodelview.m13;
        this.glProjmodelview[14] = this.projmodelview.m23;
        this.glProjmodelview[15] = this.projmodelview.m33;
    }

    protected void updateGLNormal() {
        if (this.glNormal == null) {
            this.glNormal = new float[9];
        }
        this.glNormal[0] = this.modelviewInv.m00;
        this.glNormal[1] = this.modelviewInv.m01;
        this.glNormal[2] = this.modelviewInv.m02;
        this.glNormal[3] = this.modelviewInv.m10;
        this.glNormal[4] = this.modelviewInv.m11;
        this.glNormal[5] = this.modelviewInv.m12;
        this.glNormal[6] = this.modelviewInv.m20;
        this.glNormal[7] = this.modelviewInv.m21;
        this.glNormal[8] = this.modelviewInv.m22;
    }

    @Override
    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.clearColorBuffer = false;
        this.textureMode(2);
        this.ambient(255);
        this.specular(125);
        this.emissive(0);
        this.shininess(1.0f);
        this.setAmbient = false;
    }

    @Override
    public void hint(int which) {
        boolean oldValue = this.hints[PApplet.abs(which)];
        super.hint(which);
        boolean newValue = this.hints[PApplet.abs(which)];
        if (oldValue == newValue) {
            return;
        }
        if (which == 2) {
            this.flush();
            this.pgl.disable(PGL.DEPTH_TEST);
        } else if (which == -2) {
            this.flush();
            this.pgl.enable(PGL.DEPTH_TEST);
        } else if (which == 5) {
            this.flush();
            this.pgl.depthMask(false);
        } else if (which == -5) {
            this.flush();
            this.pgl.depthMask(true);
        } else if (which == -6) {
            this.flush();
            this.setFlushMode(1);
        } else if (which == 6) {
            if (this.is2D()) {
                PGraphics.showWarning("Optimized strokes can only be disabled in 3D");
            } else {
                this.flush();
                this.setFlushMode(0);
            }
        } else if (which == -7) {
            if (this.tessGeo.lineVertexCount > 0 && this.tessGeo.lineIndexCount > 0) {
                this.flush();
            }
        } else if (which == 7 && this.tessGeo.lineVertexCount > 0 && this.tessGeo.lineIndexCount > 0) {
            this.flush();
        }
    }

    protected boolean getHint(int which) {
        if (which > 0) {
            return this.hints[which];
        }
        return !this.hints[-which];
    }

    @Override
    public void beginShape(int kind) {
        this.shape = kind;
        this.inGeo.clear();
        this.curveVertexCount = 0;
        this.breakShape = false;
        this.defaultEdges = true;
        super.noTexture();
        this.normalMode = 0;
    }

    @Override
    public void endShape(int mode) {
        this.tessellate(mode);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    protected void endShape(int[] indices) {
        if (this.shape != 8 && this.shape != 9) {
            throw new RuntimeException("Indices and edges can only be set for TRIANGLE shapes");
        }
        this.tessellate(indices);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    @Override
    public void textureWrap(int wrap) {
        this.textureWrap = wrap;
    }

    public void textureSampling(int sampling) {
        this.textureSampling = sampling;
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphics.showWarning(ALREADY_BEGAN_CONTOUR_ERROR);
            return;
        }
        this.openContour = true;
        this.breakShape = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphics.showWarning(NO_BEGIN_CONTOUR_ERROR);
            return;
        }
        this.openContour = false;
    }

    @Override
    public void vertex(float x, float y) {
        this.vertexImpl(x, y, 0.0f, 0.0f, 0.0f);
        if (this.textureImage != null) {
            PGraphics.showWarning(MISSING_UV_TEXCOORDS_ERROR);
        }
    }

    @Override
    public void vertex(float x, float y, float u, float v) {
        this.vertexImpl(x, y, 0.0f, u, v);
    }

    @Override
    public void vertex(float x, float y, float z) {
        this.vertexImpl(x, y, z, 0.0f, 0.0f);
        if (this.textureImage != null) {
            PGraphics.showWarning(MISSING_UV_TEXCOORDS_ERROR);
        }
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        this.vertexImpl(x, y, z, u, v);
    }

    protected void vertexImpl(float x, float y, float z, float u, float v) {
        boolean textured = this.textureImage != null;
        int fcolor = 0;
        if (this.fill || textured) {
            fcolor = !textured ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        int scolor = 0;
        float sweight = 0.0f;
        if (this.stroke) {
            scolor = this.strokeColor;
            sweight = this.strokeWeight;
        }
        if (textured && this.textureMode == 2) {
            u /= (float)this.textureImage.width;
            v /= (float)this.textureImage.height;
        }
        this.inGeo.addVertex(x, y, z, fcolor, this.normalX, this.normalY, this.normalZ, u, v, scolor, sweight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, 0, this.vertexBreak());
    }

    protected boolean vertexBreak() {
        if (this.breakShape) {
            this.breakShape = false;
            return true;
        }
        return false;
    }

    @Override
    protected void clipImpl(float x1, float y1, float x2, float y2) {
        this.flush();
        this.pgl.enable(PGL.SCISSOR_TEST);
        float h = y2 - y1;
        this.clipRect[0] = (int)x1;
        this.clipRect[1] = (int)((float)this.height - y1 - h);
        this.clipRect[2] = (int)(x2 - x1);
        this.clipRect[3] = (int)h;
        this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        this.clip = true;
    }

    @Override
    public void noClip() {
        if (this.clip) {
            this.flush();
            this.pgl.disable(PGL.SCISSOR_TEST);
            this.clip = false;
        }
    }

    protected void tessellate(int mode) {
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setTexCache(this.texCache, this.textureImage);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setRenderer(this);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.shape == 3) {
            tessellator.tessellatePoints();
        } else if (this.shape == 5) {
            tessellator.tessellateLines();
        } else if (this.shape == 50) {
            tessellator.tessellateLineStrip();
        } else if (this.shape == 51) {
            tessellator.tessellateLineLoop();
        } else if (this.shape == 8 || this.shape == 9) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTrianglesEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTrianglesNormals();
            }
            tessellator.tessellateTriangles();
        } else if (this.shape == 11) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleFanEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleFanNormals();
            }
            tessellator.tessellateTriangleFan();
        } else if (this.shape == 10) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleStripNormals();
            }
            tessellator.tessellateTriangleStrip();
        } else if (this.shape == 16 || this.shape == 17) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadsEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadsNormals();
            }
            tessellator.tessellateQuads();
        } else if (this.shape == 18) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadStripNormals();
            }
            tessellator.tessellateQuadStrip();
        } else if (this.shape == 20) {
            tessellator.tessellatePolygon(false, mode == 2, this.normalMode == 0);
        }
    }

    protected void tessellate(int[] indices) {
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.stroke && this.defaultEdges) {
            this.inGeo.addTrianglesEdges();
        }
        if (this.normalMode == 0) {
            this.inGeo.calcTrianglesNormals();
        }
        tessellator.tessellateTriangles(indices);
    }

    @Override
    public void flush() {
        boolean hasPixels;
        boolean hasPolys = this.tessGeo.polyVertexCount > 0 && this.tessGeo.polyIndexCount > 0;
        boolean hasLines = this.tessGeo.lineVertexCount > 0 && this.tessGeo.lineIndexCount > 0;
        boolean hasPoints = this.tessGeo.pointVertexCount > 0 && this.tessGeo.pointIndexCount > 0;
        boolean bl = hasPixels = this.modified && this.pixels != null;
        if (hasPixels) {
            this.flushPixels();
        }
        if (hasPoints || hasLines || hasPolys) {
            PMatrix3D modelview0 = null;
            PMatrix3D modelviewInv0 = null;
            if (this.flushMode == 1) {
                modelview0 = this.modelview;
                modelviewInv0 = this.modelviewInv;
                this.modelview = this.modelviewInv = identity;
                this.projmodelview.set(this.projection);
            }
            if (hasPolys) {
                this.flushPolys();
                if (this.raw != null) {
                    this.rawPolys();
                }
            }
            if (this.is3D()) {
                if (hasLines) {
                    this.flushLines();
                    if (this.raw != null) {
                        this.rawLines();
                    }
                }
                if (hasPoints) {
                    this.flushPoints();
                    if (this.raw != null) {
                        this.rawPoints();
                    }
                }
            }
            if (this.flushMode == 1) {
                this.modelview = modelview0;
                this.modelviewInv = modelviewInv0;
                this.updateProjmodelview();
            }
        }
        this.tessGeo.clear();
        this.texCache.clear();
        this.setgetPixels = false;
    }

    protected void flushPixels() {
        this.drawPixels(this.mx1, this.my1, this.mx2 - this.mx1, this.my2 - this.my1);
        this.modified = false;
    }

    protected void flushPolys() {
        boolean customShader = this.polyShader != null;
        boolean needNormals = customShader ? this.polyShader.accessNormals() : false;
        boolean needTexCoords = customShader ? this.polyShader.accessTexCoords() : false;
        this.updatePolyBuffers(this.lights, this.texCache.hasTextures, needNormals, needTexCoords);
        int i = 0;
        while (i < this.texCache.size) {
            Texture tex = this.texCache.getTexture(i);
            PShader shader = this.getPolyShader(this.lights, tex != null);
            shader.bind();
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            int n = first;
            while (n <= last) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                shader.setVertexAttribute(this.glPolyVertex, 4, PGL.FLOAT, 0, 4 * voffset * PGL.SIZEOF_FLOAT);
                shader.setColorAttribute(this.glPolyColor, 4, PGL.UNSIGNED_BYTE, 0, 4 * voffset * PGL.SIZEOF_BYTE);
                if (this.lights) {
                    shader.setNormalAttribute(this.glPolyNormal, 3, PGL.FLOAT, 0, 3 * voffset * PGL.SIZEOF_FLOAT);
                    shader.setAmbientAttribute(this.glPolyAmbient, 4, PGL.UNSIGNED_BYTE, 0, 4 * voffset * PGL.SIZEOF_BYTE);
                    shader.setSpecularAttribute(this.glPolySpecular, 4, PGL.UNSIGNED_BYTE, 0, 4 * voffset * PGL.SIZEOF_BYTE);
                    shader.setEmissiveAttribute(this.glPolyEmissive, 4, PGL.UNSIGNED_BYTE, 0, 4 * voffset * PGL.SIZEOF_BYTE);
                    shader.setShininessAttribute(this.glPolyShininess, 1, PGL.FLOAT, 0, voffset * PGL.SIZEOF_FLOAT);
                }
                if (this.lights || needNormals) {
                    shader.setNormalAttribute(this.glPolyNormal, 3, PGL.FLOAT, 0, 3 * voffset * PGL.SIZEOF_FLOAT);
                }
                if (tex != null || needTexCoords) {
                    shader.setTexcoordAttribute(this.glPolyTexcoord, 2, PGL.FLOAT, 0, 2 * voffset * PGL.SIZEOF_FLOAT);
                    shader.setTexture(tex);
                }
                shader.draw(this.glPolyIndex, icount, ioffset);
                ++n;
            }
            shader.unbind();
            ++i;
        }
        this.unbindPolyBuffers();
    }

    void sortTriangles() {
        if (this.sortedPolyTriangles == null) {
            this.sortedPolyTriangles = new Triangle[512];
        }
        float[] vertices = this.tessGeo.polyVertices;
        short[] indices = this.tessGeo.polyIndices;
        float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] src2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] pt2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.sortedTriangleCount = 0;
        int i = 0;
        while (i < this.texCache.size) {
            PImage textureImage = this.texCache.getTextureImage(i);
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            int n = first;
            while (n <= last) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                int tr = ioffset / 3;
                while (tr < (ioffset + icount) / 3) {
                    Triangle tri;
                    if (this.sortedPolyTriangles.length == this.sortedTriangleCount) {
                        int newSize = this.sortedTriangleCount << 1;
                        Triangle[] temp = new Triangle[newSize];
                        PApplet.arrayCopy(this.sortedPolyTriangles, 0, temp, 0, newSize);
                        this.sortedPolyTriangles = temp;
                    }
                    int i0 = voffset + indices[3 * tr + 0];
                    int i1 = voffset + indices[3 * tr + 1];
                    int i2 = voffset + indices[3 * tr + 2];
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                    PApplet.arrayCopy(vertices, 4 * i2, src2, 0, 4);
                    this.modelview.mult(src0, pt0);
                    this.modelview.mult(src1, pt1);
                    this.modelview.mult(src2, pt2);
                    float[] pos = new float[]{(pt0[0] + pt1[0] + pt2[0]) / 3.0f, (pt0[1] + pt1[1] + pt2[1]) / 3.0f, (pt0[2] + pt1[2] + pt2[2]) / 3.0f};
                    float d = PApplet.dist(0.0f, 0.0f, 0.0f, pos[0], pos[1], pos[2]);
                    this.sortedPolyTriangles[this.sortedTriangleCount] = tri = new Triangle(i0, i1, i2, textureImage, d);
                    ++this.sortedTriangleCount;
                    ++tr;
                }
                ++n;
            }
            ++i;
        }
        this.quickSortTris(0, this.sortedTriangleCount - 1);
    }

    private void quickSortTris(int leftI, int rightI) {
        if (leftI < rightI) {
            int pivotIndex = (leftI + rightI) / 2;
            int newPivotIndex = this.partition(leftI, rightI, pivotIndex);
            this.quickSortTris(leftI, newPivotIndex - 1);
            this.quickSortTris(newPivotIndex + 1, rightI);
        }
    }

    private int partition(int leftIndex, int rightIndex, int pivotIndex) {
        float pivotVal = this.sortedPolyTriangles[pivotIndex].dist;
        this.swapTris(pivotIndex, rightIndex);
        int storeIndex = leftIndex;
        int i = leftIndex;
        while (i < rightIndex) {
            if (this.sortedPolyTriangles[i].dist > pivotVal) {
                this.swapTris(i, storeIndex);
                ++storeIndex;
            }
            ++i;
        }
        this.swapTris(rightIndex, storeIndex);
        return storeIndex;
    }

    private void swapTris(int a, int b) {
        Triangle tmp = this.sortedPolyTriangles[a];
        this.sortedPolyTriangles[a] = this.sortedPolyTriangles[b];
        this.sortedPolyTriangles[b] = tmp;
    }

    void rawPolys() {
        this.raw.colorMode(1);
        this.raw.noStroke();
        this.raw.beginShape(9);
        float[] vertices = this.tessGeo.polyVertices;
        int[] color = this.tessGeo.polyColors;
        float[] uv = this.tessGeo.polyTexCoords;
        short[] indices = this.tessGeo.polyIndices;
        int i = 0;
        while (i < this.texCache.size) {
            PImage textureImage = this.texCache.getTextureImage(i);
            int first = this.texCache.firstCache[i];
            int last = this.texCache.lastCache[i];
            IndexCache cache = this.tessGeo.polyIndexCache;
            int n = first;
            while (n <= last) {
                int ioffset = n == first ? this.texCache.firstIndex[i] : cache.indexOffset[n];
                int icount = n == last ? this.texCache.lastIndex[i] - ioffset + 1 : cache.indexOffset[n] + cache.indexCount[n] - ioffset;
                int voffset = cache.vertexOffset[n];
                int tr = ioffset / 3;
                while (tr < (ioffset + icount) / 3) {
                    float sy2;
                    float sx2;
                    float sy1;
                    int i0 = voffset + indices[3 * tr + 0];
                    int i1 = voffset + indices[3 * tr + 1];
                    int i2 = voffset + indices[3 * tr + 2];
                    float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    int argb2 = PGL.nativeToJavaARGB(color[i2]);
                    if (this.flushMode == 0) {
                        float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i2, src2, 0, 4);
                        this.modelview.mult(src0, pt0);
                        this.modelview.mult(src1, pt1);
                        this.modelview.mult(src2, pt2);
                    } else {
                        PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, pt1, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i2, pt2, 0, 4);
                    }
                    if (textureImage != null) {
                        this.raw.texture(textureImage);
                        if (this.raw.is3D()) {
                            this.raw.fill(argb0);
                            this.raw.vertex(pt0[0], pt0[1], pt0[2], uv[2 * i0 + 0], uv[2 * i0 + 1]);
                            this.raw.fill(argb1);
                            this.raw.vertex(pt1[0], pt1[1], pt1[2], uv[2 * i1 + 0], uv[2 * i1 + 1]);
                            this.raw.fill(argb2);
                            this.raw.vertex(pt2[0], pt2[1], pt2[2], uv[2 * i2 + 0], uv[2 * i2 + 1]);
                        } else if (this.raw.is2D()) {
                            float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                            float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                            float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                            sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                            sx2 = this.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                            sy2 = this.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                            this.raw.fill(argb0);
                            this.raw.vertex(sx0, sy0, uv[2 * i0 + 0], uv[2 * i0 + 1]);
                            this.raw.fill(argb1);
                            this.raw.vertex(sx1, sy1, uv[2 * i1 + 0], uv[2 * i1 + 1]);
                            this.raw.fill(argb1);
                            this.raw.vertex(sx2, sy2, uv[2 * i2 + 0], uv[2 * i2 + 1]);
                        }
                    } else if (this.raw.is3D()) {
                        this.raw.fill(argb0);
                        this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                        this.raw.fill(argb1);
                        this.raw.vertex(pt1[0], pt1[1], pt1[2]);
                        this.raw.fill(argb2);
                        this.raw.vertex(pt2[0], pt2[1], pt2[2]);
                    } else if (this.raw.is2D()) {
                        float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        sx2 = this.screenXImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        sy2 = this.screenYImpl(pt2[0], pt2[1], pt2[2], pt2[3]);
                        this.raw.fill(argb0);
                        this.raw.vertex(sx0, sy0);
                        this.raw.fill(argb1);
                        this.raw.vertex(sx1, sy1);
                        this.raw.fill(argb2);
                        this.raw.vertex(sx2, sy2);
                    }
                    ++tr;
                }
                ++n;
            }
            ++i;
        }
        this.raw.endShape();
    }

    protected void flushLines() {
        this.updateLineBuffers();
        PShader shader = this.getLineShader();
        shader.bind();
        IndexCache cache = this.tessGeo.lineIndexCache;
        int n = 0;
        while (n < cache.size) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.glLineVertex, 4, PGL.FLOAT, 0, 4 * voffset * PGL.SIZEOF_FLOAT);
            shader.setColorAttribute(this.glLineColor, 4, PGL.UNSIGNED_BYTE, 0, 4 * voffset * PGL.SIZEOF_BYTE);
            shader.setLineAttribute(this.glLineAttrib, 4, PGL.FLOAT, 0, 4 * voffset * PGL.SIZEOF_FLOAT);
            shader.draw(this.glLineIndex, icount, ioffset);
            ++n;
        }
        shader.unbind();
        this.unbindLineBuffers();
    }

    void rawLines() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.strokeJoin(this.strokeJoin);
        this.raw.beginShape(5);
        float[] vertices = this.tessGeo.lineVertices;
        int[] color = this.tessGeo.lineColors;
        float[] attribs = this.tessGeo.lineDirections;
        short[] indices = this.tessGeo.lineIndices;
        IndexCache cache = this.tessGeo.lineIndexCache;
        int n = 0;
        while (n < cache.size) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            int ln = ioffset / 6;
            while (ln < (ioffset + icount) / 6) {
                int i0 = voffset + indices[6 * ln + 0];
                int i1 = voffset + indices[6 * ln + 5];
                float sw0 = 2.0f * attribs[4 * i0 + 3];
                float sw1 = 2.0f * attribs[4 * i1 + 3];
                if (!PGraphicsOpenGL.zero(sw0)) {
                    float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] pt1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int argb0 = PGL.nativeToJavaARGB(color[i0]);
                    int argb1 = PGL.nativeToJavaARGB(color[i1]);
                    if (this.flushMode == 0) {
                        float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] src1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, src1, 0, 4);
                        this.modelview.mult(src0, pt0);
                        this.modelview.mult(src1, pt1);
                    } else {
                        PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                        PApplet.arrayCopy(vertices, 4 * i1, pt1, 0, 4);
                    }
                    if (this.raw.is3D()) {
                        this.raw.strokeWeight(sw0);
                        this.raw.stroke(argb0);
                        this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                        this.raw.strokeWeight(sw1);
                        this.raw.stroke(argb1);
                        this.raw.vertex(pt1[0], pt1[1], pt1[2]);
                    } else if (this.raw.is2D()) {
                        float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                        float sx1 = this.screenXImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        float sy1 = this.screenYImpl(pt1[0], pt1[1], pt1[2], pt1[3]);
                        this.raw.strokeWeight(sw0);
                        this.raw.stroke(argb0);
                        this.raw.vertex(sx0, sy0);
                        this.raw.strokeWeight(sw1);
                        this.raw.stroke(argb1);
                        this.raw.vertex(sx1, sy1);
                    }
                }
                ++ln;
            }
            ++n;
        }
        this.raw.endShape();
    }

    protected void flushPoints() {
        this.updatePointBuffers();
        PShader shader = this.getPointShader();
        shader.bind();
        IndexCache cache = this.tessGeo.pointIndexCache;
        int n = 0;
        while (n < cache.size) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            shader.setVertexAttribute(this.glPointVertex, 4, PGL.FLOAT, 0, 4 * voffset * PGL.SIZEOF_FLOAT);
            shader.setColorAttribute(this.glPointColor, 4, PGL.UNSIGNED_BYTE, 0, 4 * voffset * PGL.SIZEOF_BYTE);
            shader.setPointAttribute(this.glPointAttrib, 2, PGL.FLOAT, 0, 2 * voffset * PGL.SIZEOF_FLOAT);
            shader.draw(this.glPointIndex, icount, ioffset);
            ++n;
        }
        shader.unbind();
        this.unbindPointBuffers();
    }

    void rawPoints() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.beginShape(3);
        float[] vertices = this.tessGeo.pointVertices;
        int[] color = this.tessGeo.pointColors;
        float[] attribs = this.tessGeo.pointOffsets;
        short[] indices = this.tessGeo.pointIndices;
        IndexCache cache = this.tessGeo.pointIndexCache;
        int n = 0;
        while (n < cache.size) {
            int ioffset = cache.indexOffset[n];
            int icount = cache.indexCount[n];
            int voffset = cache.vertexOffset[n];
            int pt = ioffset;
            while (pt < (ioffset + icount) / 3) {
                int perim;
                float weight;
                float size = attribs[2 * pt + 2];
                if (0.0f < size) {
                    weight = size / 0.5f;
                    perim = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * weight / 10.0f))) + 1;
                } else {
                    weight = -size / 0.5f;
                    perim = 5;
                }
                int i0 = voffset + indices[3 * pt];
                int argb0 = PGL.nativeToJavaARGB(color[i0]);
                float[] pt0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                if (this.flushMode == 0) {
                    float[] src0 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(vertices, 4 * i0, src0, 0, 4);
                    this.modelview.mult(src0, pt0);
                } else {
                    PApplet.arrayCopy(vertices, 4 * i0, pt0, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(weight);
                    this.raw.stroke(argb0);
                    this.raw.vertex(pt0[0], pt0[1], pt0[2]);
                } else if (this.raw.is2D()) {
                    float sx0 = this.screenXImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    float sy0 = this.screenYImpl(pt0[0], pt0[1], pt0[2], pt0[3]);
                    this.raw.strokeWeight(weight);
                    this.raw.stroke(argb0);
                    this.raw.vertex(sx0, sy0);
                }
                pt += perim;
            }
            ++n;
        }
        this.raw.endShape();
    }

    @Override
    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierVertexImpl(x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f);
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.bezierVertexImpl(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    protected void bezierVertexImpl(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4, this.vertexBreak());
    }

    @Override
    public void quadraticVertex(float cx, float cy, float x3, float y3) {
        this.quadraticVertexImpl(cx, cy, 0.0f, x3, y3, 0.0f);
    }

    @Override
    public void quadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.quadraticVertexImpl(cx, cy, cz, x3, y3, z3);
    }

    protected void quadraticVertexImpl(float cx, float cy, float cz, float x3, float y3, float z3) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(cx, cy, cz, x3, y3, z3, this.vertexBreak());
    }

    @Override
    public void curveVertex(float x, float y) {
        this.curveVertexImpl(x, y, 0.0f);
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        this.curveVertexImpl(x, y, z);
    }

    protected void curveVertexImpl(float x, float y, float z) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(x, y, z, this.vertexBreak());
    }

    @Override
    public void point(float x, float y) {
        this.pointImpl(x, y, 0.0f);
    }

    @Override
    public void point(float x, float y, float z) {
        this.pointImpl(x, y, z);
    }

    protected void pointImpl(float x, float y, float z) {
        this.beginShape(3);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(x, y, z, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void line(float x1, float y1, float x2, float y2) {
        this.lineImpl(x1, y1, 0.0f, x2, y2, 0.0f);
    }

    @Override
    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.lineImpl(x1, y1, z1, x2, y2, z2);
    }

    protected void lineImpl(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.beginShape(5);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(x1, y1, z1, x2, y2, z2, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(x1, y1, 0.0f, x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f, this.stroke);
        this.endShape();
    }

    @Override
    protected void rectImpl(float x1, float y1, float x2, float y2, float tl, float tr, float br, float bl) {
        this.beginShape(20);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(x1, y1, x2, y2, tl, tr, br, bl, this.stroke);
        this.endShape(2);
    }

    @Override
    public void ellipseImpl(float a, float b, float c, float d) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(a, b, c, d, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addArc(x, y, w, h, start, stop, this.fill, this.stroke, mode);
        this.endShape();
    }

    @Override
    public void box(float w, float h, float d) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(w, h, d, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void sphere(float r) {
        if (this.sphereDetailU < 3 || this.sphereDetailV < 2) {
            this.sphereDetail(30);
        }
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] indices = this.inGeo.addSphere(r, this.sphereDetailU, this.sphereDetailV, this.fill, this.stroke);
        this.endShape(indices);
    }

    @Override
    public void smooth() {
        if (this.quality < 2) {
            this.smooth(2);
        } else {
            this.smooth(this.quality);
        }
    }

    @Override
    public void smooth(int level) {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = true;
        if (maxSamples < level) {
            if (maxSamples > 0) {
                PGraphics.showWarning(UNSUPPORTED_SMOOTH_LEVEL_ERROR, level, maxSamples);
            } else {
                PGraphics.showWarning(UNSUPPORTED_SMOOTH_ERROR);
            }
            level = maxSamples;
        }
        if (this.quality != level) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning(TOO_MANY_SMOOTH_CALLS_ERROR);
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = level;
            if (this.quality == 1) {
                this.quality = 0;
            }
            this.restartPGL();
        }
    }

    @Override
    public void noSmooth() {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = false;
        if (1 < this.quality) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning(TOO_MANY_SMOOTH_CALLS_ERROR);
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = 0;
            this.restartPGL();
        }
    }

    @Override
    protected void shape(PShape shape, float x, float y, float z) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - shape.getWidth() / 2.0f, y - shape.getHeight() / 2.0f, z - shape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(x, y, z);
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    protected void shape(PShape shape, float x, float y, float z, float c, float d, float e) {
        if (shape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - c / 2.0f, y - d / 2.0f, z - e / 2.0f);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(x, y, z);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(x, y, z);
                this.scale((c -= x) / shape.getWidth(), (d -= y) / shape.getHeight(), (e -= z) / shape.getDepth());
            }
            shape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    public PShape loadShape(String filename) {
        String ext = PApplet.getExtension(filename);
        if (PGraphics2D.isSupportedExtension(ext)) {
            return PGraphics2D.loadShapeImpl(this, filename, ext);
        }
        if (PGraphics3D.isSupportedExtension(ext)) {
            return PGraphics3D.loadShapeImpl(this, filename, ext);
        }
        PGraphics.showWarning(UNSUPPORTED_SHAPE_FORMAT_ERROR);
        return null;
    }

    @Override
    protected boolean textModeCheck(int mode) {
        return mode == 4 || mode == 5 && PGL.SHAPE_TEXT_SUPPORTED;
    }

    @Override
    public float textAscent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        Object font = this.textFont.getNative();
        float ascent = 0.0f;
        if (font != null) {
            ascent = this.pgl.getFontAscent(font);
        }
        if (ascent == 0.0f) {
            ascent = super.textAscent();
        }
        return ascent;
    }

    @Override
    public float textDescent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        Object font = this.textFont.getNative();
        float descent = 0.0f;
        if (font != null) {
            descent = this.pgl.getFontDescent(font);
        }
        if (descent == 0.0f) {
            descent = super.textDescent();
        }
        return descent;
    }

    @Override
    protected float textWidthImpl(char[] buffer, int start, int stop) {
        Object font = this.textFont.getNative();
        float twidth = 0.0f;
        if (font != null) {
            twidth = this.pgl.getTextWidth(font, buffer, start, stop);
        }
        if (twidth == 0.0f) {
            twidth = super.textWidthImpl(buffer, start, stop);
        }
        return twidth;
    }

    @Override
    public void textSize(float size) {
        Object font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", size);
        }
        if ((font = this.textFont.getNative()) != null) {
            Object dfont = this.pgl.getDerivedFont(font, size);
            this.textFont.setNative(dfont);
        }
        super.textSize(size);
    }

    @Override
    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        if (this.textMode == 4) {
            this.textTex = this.getFontTexture(this.textFont);
            if (this.textTex == null || this.textTex.contextIsOutdated()) {
                this.textTex = new FontTexture(this, this.textFont, this.is3D());
                this.setFontTexture(this.textFont, this.textTex);
            }
            this.textTex.begin();
            int savedTextureMode = this.textureMode;
            boolean savedStroke = this.stroke;
            float savedNormalX = this.normalX;
            float savedNormalY = this.normalY;
            float savedNormalZ = this.normalZ;
            boolean savedTint = this.tint;
            int savedTintColor = this.tintColor;
            int savedBlendMode = this.blendMode;
            this.textureMode = 1;
            this.stroke = false;
            this.normalX = 0.0f;
            this.normalY = 0.0f;
            this.normalZ = 1.0f;
            this.tint = true;
            this.tintColor = this.fillColor;
            this.blendMode(1);
            super.textLineImpl(buffer, start, stop, x, y);
            this.textureMode = savedTextureMode;
            this.stroke = savedStroke;
            this.normalX = savedNormalX;
            this.normalY = savedNormalY;
            this.normalZ = savedNormalZ;
            this.tint = savedTint;
            this.tintColor = savedTintColor;
            this.blendMode(savedBlendMode);
            this.textTex.end();
        } else if (this.textMode == 5) {
            super.textLineImpl(buffer, start, stop, x, y);
        }
    }

    @Override
    protected void textCharImpl(char ch, float x, float y) {
        PFont.Glyph glyph = this.textFont.getGlyph(ch);
        if (glyph != null) {
            if (this.textMode == 4) {
                FontTexture.TextureInfo tinfo = this.textTex.getTexInfo(glyph);
                if (tinfo == null) {
                    tinfo = this.textTex.addToTexture(this, glyph);
                }
                float high = (float)glyph.height / (float)this.textFont.getSize();
                float bwidth = (float)glyph.width / (float)this.textFont.getSize();
                float lextent = (float)glyph.leftExtent / (float)this.textFont.getSize();
                float textent = (float)glyph.topExtent / (float)this.textFont.getSize();
                float x1 = x + lextent * this.textSize;
                float y1 = y - textent * this.textSize;
                float x2 = x1 + bwidth * this.textSize;
                float y2 = y1 + high * this.textSize;
                this.textCharModelImpl(tinfo, x1, y1, x2, y2);
            } else if (this.textMode == 5) {
                this.textCharShapeImpl(ch, x, y);
            }
        }
    }

    protected void textCharModelImpl(FontTexture.TextureInfo info, float x0, float y0, float x1, float y1) {
        if (this.textTex.currentTex != info.texIndex) {
            this.textTex.setTexture(info.texIndex);
        }
        this.beginShape(17);
        this.texture(this.textTex.getCurrentTexture());
        this.vertex(x0, y0, info.u0, info.v0);
        this.vertex(x1, y0, info.u1, info.v0);
        this.vertex(x1, y1, info.u1, info.v1);
        this.vertex(x0, y1, info.u0, info.v1);
        this.endShape();
    }

    protected void textCharShapeImpl(char ch, float x, float y) {
        boolean strokeSaved = this.stroke;
        this.stroke = false;
        PGL.FontOutline outline = this.pgl.createFontOutline(ch, this.textFont.getNative());
        float[] textPoints = new float[6];
        float lastX = 0.0f;
        float lastY = 0.0f;
        boolean open = false;
        this.beginShape();
        while (!outline.isDone()) {
            float t;
            int i;
            int type = outline.currentSegment(textPoints);
            if (!open) {
                this.beginContour();
                open = true;
            }
            if (type == PGL.SEG_MOVETO || type == PGL.SEG_LINETO) {
                this.vertex(x + textPoints[0], y + textPoints[1]);
                lastX = textPoints[0];
                lastY = textPoints[1];
            } else if (type == PGL.SEG_QUADTO) {
                i = 1;
                while (i < this.bezierDetail) {
                    t = (float)i / (float)this.bezierDetail;
                    this.vertex(x + this.bezierPoint(lastX, lastX + (float)((double)((textPoints[0] - lastX) * 2.0f) / 3.0), textPoints[2] + (float)((double)((textPoints[0] - textPoints[2]) * 2.0f) / 3.0), textPoints[2], t), y + this.bezierPoint(lastY, lastY + (float)((double)((textPoints[1] - lastY) * 2.0f) / 3.0), textPoints[3] + (float)((double)((textPoints[1] - textPoints[3]) * 2.0f) / 3.0), textPoints[3], t));
                    ++i;
                }
                lastX = textPoints[2];
                lastY = textPoints[3];
            } else if (type == PGL.SEG_CUBICTO) {
                i = 1;
                while (i < this.bezierDetail) {
                    t = (float)i / (float)this.bezierDetail;
                    this.vertex(x + this.bezierPoint(lastX, textPoints[0], textPoints[2], textPoints[4], t), y + this.bezierPoint(lastY, textPoints[1], textPoints[3], textPoints[5], t));
                    ++i;
                }
                lastX = textPoints[4];
                lastY = textPoints[5];
            } else if (type == PGL.SEG_CLOSE) {
                this.endContour();
                open = false;
            }
            outline.next();
        }
        this.endShape();
        this.stroke = strokeSaved;
    }

    @Override
    public void pushMatrix() {
        if (this.modelviewStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.modelview.get(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.get(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.get(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.get(this.cameraInvStack[this.modelviewStackDepth]);
        ++this.modelviewStackDepth;
    }

    @Override
    public void popMatrix() {
        if (this.modelviewStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.modelviewStackDepth;
        this.modelview.set(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.set(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.set(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.set(this.cameraInvStack[this.modelviewStackDepth]);
        this.updateProjmodelview();
    }

    @Override
    public void translate(float tx, float ty) {
        this.translateImpl(tx, ty, 0.0f);
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        this.translateImpl(tx, ty, tz);
    }

    protected void translateImpl(float tx, float ty, float tz) {
        this.modelview.translate(tx, ty, tz);
        PGraphicsOpenGL.invTranslate(this.modelviewInv, tx, ty, tz);
        this.projmodelview.translate(tx, ty, tz);
    }

    protected static void invTranslate(PMatrix3D matrix, float tx, float ty, float tz) {
        matrix.preApply(1.0f, 0.0f, 0.0f, -tx, 0.0f, 1.0f, 0.0f, -ty, 0.0f, 0.0f, 1.0f, -tz, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float angle) {
        this.rotateImpl(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotateX(float angle) {
        this.rotateImpl(angle, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateY(float angle) {
        this.rotateImpl(angle, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void rotateZ(float angle) {
        this.rotateImpl(angle, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float angle, float v0, float v1, float v2) {
        this.rotateImpl(angle, v0, v1, v2);
    }

    protected void rotateImpl(float angle, float v0, float v1, float v2) {
        float norm2 = v0 * v0 + v1 * v1 + v2 * v2;
        if (PGraphicsOpenGL.zero(norm2)) {
            return;
        }
        if (PGraphicsOpenGL.diff(norm2, 1.0f)) {
            float norm = PApplet.sqrt(norm2);
            v0 /= norm;
            v1 /= norm;
            v2 /= norm;
        }
        this.modelview.rotate(angle, v0, v1, v2);
        PGraphicsOpenGL.invRotate(this.modelviewInv, angle, v0, v1, v2);
        this.updateProjmodelview();
    }

    private static void invRotate(PMatrix3D matrix, float angle, float v0, float v1, float v2) {
        float c = PApplet.cos(-angle);
        float s = PApplet.sin(-angle);
        float t = 1.0f - c;
        matrix.preApply(t * v0 * v0 + c, t * v0 * v1 - s * v2, t * v0 * v2 + s * v1, 0.0f, t * v0 * v1 + s * v2, t * v1 * v1 + c, t * v1 * v2 - s * v0, 0.0f, t * v0 * v2 - s * v1, t * v1 * v2 + s * v0, t * v2 * v2 + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void scale(float s) {
        this.scaleImpl(s, s, s);
    }

    @Override
    public void scale(float sx, float sy) {
        this.scaleImpl(sx, sy, 1.0f);
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        this.scaleImpl(sx, sy, sz);
    }

    protected void scaleImpl(float sx, float sy, float sz) {
        this.modelview.scale(sx, sy, sz);
        PGraphicsOpenGL.invScale(this.modelviewInv, sx, sy, sz);
        this.projmodelview.scale(sx, sy, sz);
    }

    protected static void invScale(PMatrix3D matrix, float x, float y, float z) {
        matrix.preApply(1.0f / x, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearX(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrixImpl(1.0f, t, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearY(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrixImpl(1.0f, 0.0f, 0.0f, 0.0f, t, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void resetMatrix() {
        this.modelview.reset();
        this.modelviewInv.reset();
        this.projmodelview.set(this.projection);
        this.camera.reset();
        this.cameraInv.reset();
    }

    @Override
    public void applyMatrix(PMatrix2D source) {
        this.applyMatrixImpl(source.m00, source.m01, 0.0f, source.m02, source.m10, source.m11, 0.0f, source.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.applyMatrixImpl(n00, n01, 0.0f, n02, n10, n11, 0.0f, n12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(PMatrix3D source) {
        this.applyMatrixImpl(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.applyMatrixImpl(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void applyMatrixImpl(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.modelview.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.projmodelview.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void begin2D() {
    }

    protected void end2D() {
    }

    @Override
    public PMatrix getMatrix() {
        return this.modelview.get();
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D target) {
        if (target == null) {
            target = new PMatrix3D();
        }
        target.set(this.modelview);
        return target;
    }

    @Override
    public void setMatrix(PMatrix2D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    @Override
    public void setMatrix(PMatrix3D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    @Override
    public void printMatrix() {
        this.modelview.print();
    }

    public void pushProjection() {
        if (this.projectionStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.projection.get(this.projectionStack[this.projectionStackDepth]);
        ++this.projectionStackDepth;
    }

    public void popProjection() {
        this.flush();
        if (this.projectionStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.projectionStackDepth;
        this.projection.set(this.projectionStack[this.projectionStackDepth]);
        this.updateProjmodelview();
    }

    public void resetProjection() {
        this.flush();
        this.projection.reset();
        this.updateProjmodelview();
    }

    public void applyProjection(PMatrix3D mat) {
        this.flush();
        this.projection.apply(mat);
        this.updateProjmodelview();
    }

    public void applyProjection(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.flush();
        this.projection.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.updateProjmodelview();
    }

    public void setProjection(PMatrix3D mat) {
        this.flush();
        this.projection.set(mat);
        this.updateProjmodelview();
    }

    protected boolean orthoProjection() {
        return PGraphicsOpenGL.zero(this.projection.m01) && PGraphicsOpenGL.zero(this.projection.m02) && PGraphicsOpenGL.zero(this.projection.m10) && PGraphicsOpenGL.zero(this.projection.m12) && PGraphicsOpenGL.zero(this.projection.m20) && PGraphicsOpenGL.zero(this.projection.m21) && PGraphicsOpenGL.zero(this.projection.m30) && PGraphicsOpenGL.zero(this.projection.m31) && PGraphicsOpenGL.zero(this.projection.m32) && PGraphicsOpenGL.same(this.projection.m33, 1.0f);
    }

    protected boolean nonOrthoProjection() {
        return PGraphicsOpenGL.nonZero(this.projection.m01) || PGraphicsOpenGL.nonZero(this.projection.m02) || PGraphicsOpenGL.nonZero(this.projection.m10) || PGraphicsOpenGL.nonZero(this.projection.m12) || PGraphicsOpenGL.nonZero(this.projection.m20) || PGraphicsOpenGL.nonZero(this.projection.m21) || PGraphicsOpenGL.nonZero(this.projection.m30) || PGraphicsOpenGL.nonZero(this.projection.m31) || PGraphicsOpenGL.nonZero(this.projection.m32) || PGraphicsOpenGL.diff(this.projection.m33, 1.0f);
    }

    protected static boolean same(float a, float b) {
        return Math.abs(a - b) < PGL.FLOAT_EPS;
    }

    protected static boolean diff(float a, float b) {
        return PGL.FLOAT_EPS <= Math.abs(a - b);
    }

    protected static boolean zero(float a) {
        return Math.abs(a) < PGL.FLOAT_EPS;
    }

    protected static boolean nonZero(float a) {
        return PGL.FLOAT_EPS <= Math.abs(a);
    }

    @Override
    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
    }

    @Override
    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.manipulatingCamera = false;
    }

    @Override
    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float z0 = eyeX - centerX;
        float z1 = eyeY - centerY;
        float z2 = eyeZ - centerZ;
        float mag = PApplet.sqrt(z0 * z0 + z1 * z1 + z2 * z2);
        if (PGraphicsOpenGL.nonZero(mag)) {
            z0 /= mag;
            z1 /= mag;
            z2 /= mag;
        }
        this.cameraEyeX = eyeX;
        this.cameraEyeY = eyeY;
        this.cameraEyeZ = eyeZ;
        float y0 = upX;
        float y1 = upY;
        float y2 = upZ;
        float x0 = y1 * z2 - y2 * z1;
        float x1 = -y0 * z2 + y2 * z0;
        float x2 = y0 * z1 - y1 * z0;
        y0 = z1 * x2 - z2 * x1;
        y1 = -z0 * x2 + z2 * x0;
        y2 = z0 * x1 - z1 * x0;
        mag = PApplet.sqrt(x0 * x0 + x1 * x1 + x2 * x2);
        if (PGraphicsOpenGL.nonZero(mag)) {
            x0 /= mag;
            x1 /= mag;
            x2 /= mag;
        }
        if (PGraphicsOpenGL.nonZero(mag = PApplet.sqrt(y0 * y0 + y1 * y1 + y2 * y2))) {
            y0 /= mag;
            y1 /= mag;
            y2 /= mag;
        }
        this.modelview.set(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float tx = -eyeX;
        float ty = -eyeY;
        float tz = -eyeZ;
        this.modelview.translate(tx, ty, tz);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    @Override
    public void printCamera() {
        this.camera.print();
    }

    protected void defaultCamera() {
        this.camera();
    }

    @Override
    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, 0.0f, this.cameraEyeZ * 10.0f);
    }

    @Override
    public void ortho(float left, float right, float bottom, float top) {
        this.ortho(left, right, bottom, top, 0.0f, this.cameraEyeZ * 10.0f);
    }

    @Override
    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        float w = right - left;
        float h = top - bottom;
        float d = far - near;
        left -= this.cameraEyeX;
        right -= this.cameraEyeX;
        bottom -= this.cameraEyeY;
        top -= this.cameraEyeY;
        this.flush();
        float x = 2.0f / w;
        float y = 2.0f / h;
        float z = -2.0f / d;
        float tx = -(right + left) / w;
        float ty = -(top + bottom) / h;
        float tz = -(far + near) / d;
        this.projection.set(x, 0.0f, 0.0f, tx, 0.0f, -y, 0.0f, ty, 0.0f, 0.0f, z, tz, 0.0f, 0.0f, 0.0f, 1.0f);
        this.updateProjmodelview();
    }

    @Override
    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    @Override
    public void perspective(float fov, float aspect, float zNear, float zFar) {
        float ymax = zNear * (float)Math.tan(fov / 2.0f);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustum(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    @Override
    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        this.flush();
        float n2 = 2.0f * znear;
        float w = right - left;
        float h = top - bottom;
        float d = zfar - znear;
        this.projection.set(n2 / w, 0.0f, (right + left) / w, 0.0f, 0.0f, -n2 / h, (top + bottom) / h, 0.0f, 0.0f, 0.0f, -(zfar + znear) / d, -(n2 * zfar) / d, 0.0f, 0.0f, -1.0f, 0.0f);
        this.updateProjmodelview();
    }

    @Override
    public void printProjection() {
        this.projection.print();
    }

    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    public float screenX(float x, float y) {
        return this.screenXImpl(x, y, 0.0f);
    }

    @Override
    public float screenY(float x, float y) {
        return this.screenYImpl(x, y, 0.0f);
    }

    @Override
    public float screenX(float x, float y, float z) {
        return this.screenXImpl(x, y, z);
    }

    @Override
    public float screenY(float x, float y, float z) {
        return this.screenYImpl(x, y, z);
    }

    @Override
    public float screenZ(float x, float y, float z) {
        return this.screenZImpl(x, y, z);
    }

    protected float screenXImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenXImpl(ax, ay, az, aw);
    }

    protected float screenXImpl(float x, float y, float z, float w) {
        float ox = this.projection.m00 * x + this.projection.m01 * y + this.projection.m02 * z + this.projection.m03 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            ox /= ow;
        }
        float sx = (float)this.width * (1.0f + ox) / 2.0f;
        return sx;
    }

    protected float screenYImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenYImpl(ax, ay, az, aw);
    }

    protected float screenYImpl(float x, float y, float z, float w) {
        float oy = this.projection.m10 * x + this.projection.m11 * y + this.projection.m12 * z + this.projection.m13 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            oy /= ow;
        }
        float sy = (float)this.height * (1.0f + oy) / 2.0f;
        sy = (float)this.height - sy;
        return sy;
    }

    protected float screenZImpl(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        return this.screenZImpl(ax, ay, az, aw);
    }

    protected float screenZImpl(float x, float y, float z, float w) {
        float oz = this.projection.m20 * x + this.projection.m21 * y + this.projection.m22 * z + this.projection.m23 * w;
        float ow = this.projection.m30 * x + this.projection.m31 * y + this.projection.m32 * z + this.projection.m33 * w;
        if (PGraphicsOpenGL.nonZero(ow)) {
            oz /= ow;
        }
        float sz = (oz + 1.0f) / 2.0f;
        return sz;
    }

    @Override
    public float modelX(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float ox = this.cameraInv.m00 * ax + this.cameraInv.m01 * ay + this.cameraInv.m02 * az + this.cameraInv.m03 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? ox / ow : ox;
    }

    @Override
    public float modelY(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oy = this.cameraInv.m10 * ax + this.cameraInv.m11 * ay + this.cameraInv.m12 * az + this.cameraInv.m13 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? oy / ow : oy;
    }

    @Override
    public float modelZ(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oz = this.cameraInv.m20 * ax + this.cameraInv.m21 * ay + this.cameraInv.m22 * az + this.cameraInv.m23 * aw;
        float ow = this.cameraInv.m30 * ax + this.cameraInv.m31 * ay + this.cameraInv.m32 * az + this.cameraInv.m33 * aw;
        return PGraphicsOpenGL.nonZero(ow) ? oz / ow : oz;
    }

    @Override
    public void popStyle() {
        boolean savedSetAmbient = this.setAmbient;
        super.popStyle();
        if (!savedSetAmbient) {
            this.setAmbient = false;
        }
    }

    @Override
    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    @Override
    public void strokeJoin(int join) {
        this.strokeJoin = join;
    }

    @Override
    public void strokeCap(int cap) {
        this.strokeCap = cap;
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        if (!this.setAmbient) {
            this.ambientFromCalc();
            this.setAmbient = false;
        }
    }

    @Override
    public void lights() {
        this.enableLighting();
        this.lightCount = 0;
        int colorModeSaved = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = colorModeSaved;
    }

    @Override
    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    @Override
    public void ambientLight(float r, float g, float b) {
        this.ambientLight(r, g, b, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 0;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.lightAmbient(this.lightCount, r, g, b);
        this.noLightDiffuse(this.lightCount);
        this.noLightSpecular(this.lightCount);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void directionalLight(float r, float g, float b, float dx, float dy, float dz) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 1;
        this.lightPosition(this.lightCount, 0.0f, 0.0f, 0.0f, true);
        this.lightNormal(this.lightCount, dx, dy, dz);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.noLightFalloff(this.lightCount);
        ++this.lightCount;
    }

    @Override
    public void pointLight(float r, float g, float b, float x, float y, float z) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 2;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void spotLight(float r, float g, float b, float x, float y, float z, float dx, float dy, float dz, float angle, float concentration) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 3;
        this.lightPosition(this.lightCount, x, y, z, false);
        this.lightNormal(this.lightCount, dx, dy, dz);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, r, g, b);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.lightSpot(this.lightCount, angle, concentration);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void lightFalloff(float constant, float linear, float quadratic) {
        this.currentLightFalloffConstant = constant;
        this.currentLightFalloffLinear = linear;
        this.currentLightFalloffQuadratic = quadratic;
    }

    @Override
    public void lightSpecular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
    }

    protected void enableLighting() {
        if (!this.lights) {
            this.flush();
            this.lights = true;
        }
    }

    protected void disableLighting() {
        if (this.lights) {
            this.flush();
            this.lights = false;
        }
    }

    protected void lightPosition(int num, float x, float y, float z, boolean dir) {
        this.lightPosition[4 * num + 0] = x * this.modelview.m00 + y * this.modelview.m01 + z * this.modelview.m02 + this.modelview.m03;
        this.lightPosition[4 * num + 1] = x * this.modelview.m10 + y * this.modelview.m11 + z * this.modelview.m12 + this.modelview.m13;
        this.lightPosition[4 * num + 2] = x * this.modelview.m20 + y * this.modelview.m21 + z * this.modelview.m22 + this.modelview.m23;
        this.lightPosition[4 * num + 3] = dir ? 1 : 0;
    }

    protected void lightNormal(int num, float dx, float dy, float dz) {
        float nx = dx * this.modelviewInv.m00 + dy * this.modelviewInv.m10 + dz * this.modelviewInv.m20;
        float ny = dx * this.modelviewInv.m01 + dy * this.modelviewInv.m11 + dz * this.modelviewInv.m21;
        float nz = dx * this.modelviewInv.m02 + dy * this.modelviewInv.m12 + dz * this.modelviewInv.m22;
        float invn = 1.0f / PApplet.dist(0.0f, 0.0f, 0.0f, nx, ny, nz);
        this.lightNormal[3 * num + 0] = invn * nx;
        this.lightNormal[3 * num + 1] = invn * ny;
        this.lightNormal[3 * num + 2] = invn * nz;
    }

    protected void lightAmbient(int num, float r, float g, float b) {
        this.colorCalc(r, g, b);
        this.lightAmbient[3 * num + 0] = this.calcR;
        this.lightAmbient[3 * num + 1] = this.calcG;
        this.lightAmbient[3 * num + 2] = this.calcB;
    }

    protected void noLightAmbient(int num) {
        this.lightAmbient[3 * num + 0] = 0.0f;
        this.lightAmbient[3 * num + 1] = 0.0f;
        this.lightAmbient[3 * num + 2] = 0.0f;
    }

    protected void lightDiffuse(int num, float r, float g, float b) {
        this.colorCalc(r, g, b);
        this.lightDiffuse[3 * num + 0] = this.calcR;
        this.lightDiffuse[3 * num + 1] = this.calcG;
        this.lightDiffuse[3 * num + 2] = this.calcB;
    }

    protected void noLightDiffuse(int num) {
        this.lightDiffuse[3 * num + 0] = 0.0f;
        this.lightDiffuse[3 * num + 1] = 0.0f;
        this.lightDiffuse[3 * num + 2] = 0.0f;
    }

    protected void lightSpecular(int num, float r, float g, float b) {
        this.lightSpecular[3 * num + 0] = r;
        this.lightSpecular[3 * num + 1] = g;
        this.lightSpecular[3 * num + 2] = b;
    }

    protected void noLightSpecular(int num) {
        this.lightSpecular[3 * num + 0] = 0.0f;
        this.lightSpecular[3 * num + 1] = 0.0f;
        this.lightSpecular[3 * num + 2] = 0.0f;
    }

    protected void lightFalloff(int num, float c0, float c1, float c2) {
        this.lightFalloffCoefficients[3 * num + 0] = c0;
        this.lightFalloffCoefficients[3 * num + 1] = c1;
        this.lightFalloffCoefficients[3 * num + 2] = c2;
    }

    protected void noLightFalloff(int num) {
        this.lightFalloffCoefficients[3 * num + 0] = 1.0f;
        this.lightFalloffCoefficients[3 * num + 1] = 0.0f;
        this.lightFalloffCoefficients[3 * num + 2] = 0.0f;
    }

    protected void lightSpot(int num, float angle, float exponent) {
        this.lightSpotParameters[2 * num + 0] = Math.max(0.0f, PApplet.cos(angle));
        this.lightSpotParameters[2 * num + 1] = exponent;
    }

    protected void noLightSpot(int num) {
        this.lightSpotParameters[2 * num + 0] = 0.0f;
        this.lightSpotParameters[2 * num + 1] = 0.0f;
    }

    @Override
    protected void backgroundImpl(PImage image) {
        this.backgroundImpl();
        this.set(0, 0, image);
        if (this.parent.frameCount > 0) {
            this.clearColorBuffer = true;
        }
        this.backgroundA = 1.0f;
    }

    @Override
    protected void backgroundImpl() {
        this.flush();
        if (!this.hints[5]) {
            this.pgl.clearDepth(1.0f);
            this.pgl.clear(PGL.DEPTH_BUFFER_BIT);
        }
        this.pgl.clearColor(this.backgroundR, this.backgroundG, this.backgroundB, this.backgroundA);
        this.pgl.clear(PGL.COLOR_BUFFER_BIT);
        if (this.parent.frameCount > 0) {
            this.clearColorBuffer = true;
        }
    }

    protected void report(String where) {
        int err;
        if (!this.hints[4] && (err = this.pgl.getError()) != 0) {
            String errString = this.pgl.errorString(err);
            String msg = "OpenGL error " + err + " at " + where + ": " + errString;
            PGraphics.showWarning(msg);
        }
    }

    @Override
    public boolean isGL() {
        return true;
    }

    @Override
    public void loadPixels() {
        if (this.primarySurface && this.sized) {
            return;
        }
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        if (!this.setgetPixels) {
            this.flush();
        }
        this.allocatePixels();
        if (!this.setgetPixels) {
            this.readPixels();
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    protected void allocatePixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = PGL.allocateIntBuffer(this.pixels);
        }
    }

    protected void saveSurfaceToPixels() {
        this.allocatePixels();
        this.readPixels();
    }

    protected void restoreSurfaceFromPixels() {
        this.drawPixels(0, 0, this.width, this.height);
    }

    protected void readPixels() {
        this.beginPixelsOp(1);
        try {
            this.pgl.readPixelsImpl(0, 0, this.width, this.height, PGL.RGBA, PGL.UNSIGNED_BYTE, this.pixelBuffer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.endPixelsOp();
        try {
            PGL.getIntArray(this.pixelBuffer, this.pixels);
            PGL.nativeToJavaARGB(this.pixels, this.width, this.height);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    protected void drawPixels(int x, int y, int w, int h) {
        boolean needToDrawTex;
        int len = w * h;
        if (this.nativePixels == null || this.nativePixels.length < len) {
            this.nativePixels = new int[len];
            this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
        }
        try {
            if (x > 0 || y > 0 || w < this.width || h < this.height) {
                int offset0 = y * this.width + x;
                int offset1 = 0;
                int yc = y;
                while (yc < y + h) {
                    System.arraycopy(this.pixels, offset0, this.nativePixels, offset1, w);
                    offset0 += this.width;
                    offset1 += w;
                    ++yc;
                }
            } else {
                PApplet.arrayCopy(this.pixels, 0, this.nativePixels, 0, len);
            }
            PGL.javaToNativeARGB(this.nativePixels, w, h);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        PGL.putIntArray(this.nativePixelBuffer, this.nativePixels);
        if (this.primarySurface && !this.pgl.isFBOBacked()) {
            this.loadTextureImpl(2, false);
        }
        boolean bl = needToDrawTex = this.primarySurface && (!this.pgl.isFBOBacked() || this.pgl.isFBOBacked() && this.pgl.isMultisampled()) || this.offscreenMultisample;
        if (needToDrawTex) {
            int tw = PApplet.min(this.texture.glWidth - x, w);
            int th = PApplet.min(this.texture.glHeight - y, h);
            this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, x, y, tw, th, this.nativePixelBuffer);
            this.beginPixelsOp(2);
            this.drawTexture(x, y, w, h);
            this.endPixelsOp();
        } else {
            this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, x, this.height - (y + h), w, h, this.nativePixelBuffer);
        }
    }

    @Override
    public int get(int x, int y) {
        this.loadPixels();
        this.setgetPixels = true;
        return super.get(x, y);
    }

    @Override
    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        this.loadPixels();
        this.setgetPixels = true;
        super.getImpl(sourceX, sourceY, sourceWidth, sourceHeight, target, targetX, targetY);
    }

    @Override
    public void set(int x, int y, int argb) {
        this.loadPixels();
        this.setgetPixels = true;
        super.set(x, y, argb);
    }

    @Override
    protected void setImpl(PImage sourceImage, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int targetX, int targetY) {
        this.loadPixels();
        this.setgetPixels = true;
        super.setImpl(sourceImage, sourceX, sourceY, sourceWidth, sourceHeight, targetX, targetY);
    }

    public void loadTexture() {
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        this.flush();
        if (this.primarySurface) {
            if (this.pgl.isFBOBacked()) {
                this.pgl.syncBackTexture();
            } else {
                this.loadTextureImpl(2, false);
                if (this.nativePixels == null || this.nativePixels.length < this.width * this.height) {
                    this.nativePixels = new int[this.width * this.height];
                    this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
                }
                this.beginPixelsOp(1);
                try {
                    this.pgl.readPixelsImpl(0, 0, this.width, this.height, PGL.RGBA, PGL.UNSIGNED_BYTE, this.nativePixelBuffer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                this.endPixelsOp();
                this.texture.setNative(this.nativePixelBuffer, 0, 0, this.width, this.height);
            }
        } else if (this.offscreenMultisample) {
            this.multisampleFramebuffer.copyColor(this.offscreenFramebuffer);
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    public void updateTexture() {
        this.texture.updateTexels();
    }

    public void updateTexture(int x, int y, int w, int h) {
        this.texture.updateTexels(x, y, w, h);
    }

    public void updateDisplay() {
        this.flush();
        this.beginPixelsOp(2);
        this.drawTexture();
        this.endPixelsOp();
    }

    protected void loadTextureImpl(int sampling, boolean mipmap) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.texture == null || this.texture.contextIsOutdated()) {
            Texture.Parameters params = new Texture.Parameters(2, sampling, mipmap);
            this.texture = new Texture(this, this.width, this.height, params);
            this.texture.invertedY(true);
            this.texture.colorBuffer(true);
            this.setCache(this, this.texture);
        }
    }

    protected void createPTexture() {
        this.ptexture = new Texture(this, this.width, this.height, this.texture.getParameters());
        this.ptexture.invertedY(true);
        this.ptexture.colorBuffer(true);
    }

    protected void swapOffscreenTextures() {
        if (this.ptexture != null) {
            int temp = this.texture.glName;
            this.texture.glName = this.ptexture.glName;
            this.ptexture.glName = temp;
            this.offscreenFramebuffer.setColorBuffer(this.texture);
        }
    }

    protected void drawTexture() {
        this.pgl.disable(PGL.BLEND);
        this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, 0, 0, this.width, this.height);
        this.pgl.enable(PGL.BLEND);
    }

    protected void drawTexture(int x, int y, int w, int h) {
        this.pgl.disable(PGL.BLEND);
        this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, this.width, this.height, x, y, x + w, y + h, x, this.height - (y + h), x + w, this.height - y);
        this.pgl.enable(PGL.BLEND);
    }

    protected void drawPTexture() {
        if (this.ptexture != null) {
            this.pgl.disable(PGL.BLEND);
            this.pgl.drawTexture(this.ptexture.glTarget, this.ptexture.glName, this.ptexture.glWidth, this.ptexture.glHeight, 0, 0, this.width, this.height);
            this.pgl.enable(PGL.BLEND);
        }
    }

    @Override
    public void mask(PImage alpha) {
        if (alpha.width != this.width || alpha.height != this.height) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        if (ppg.maskShader == null) {
            ppg.maskShader = new PShader(this.parent, defTextureShaderVertURL, maskShaderFragURL);
        }
        ppg.maskShader.set("mask", alpha);
        this.filter(ppg.maskShader);
    }

    @Override
    public void filter(int kind) {
        PImage temp = this.get();
        temp.filter(kind);
        this.set(0, 0, temp);
    }

    @Override
    public void filter(int kind, float param) {
        PImage temp = this.get();
        temp.filter(kind, param);
        this.set(0, 0, temp);
    }

    @Override
    public void filter(PShader shader) {
        if (!shader.isPolyShader()) {
            PGraphics.showWarning(INVALID_FILTER_SHADER_ERROR);
            return;
        }
        boolean needEndDraw = false;
        if (this.primarySurface) {
            this.pgl.requestFBOLayer();
        } else if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        this.loadTexture();
        if (this.filterTexture == null || this.filterTexture.contextIsOutdated()) {
            this.filterTexture = new Texture(this, this.texture.width, this.texture.height, this.texture.getParameters());
            this.filterTexture.invertedY(true);
            this.filterImage = this.wrapTexture(this.filterTexture);
        }
        this.filterTexture.set(this.texture);
        this.pgl.depthMask(false);
        this.pgl.disable(PGL.DEPTH_TEST);
        this.begin2D();
        boolean prevLights = this.lights;
        this.lights = false;
        int prevTextureMode = this.textureMode;
        this.textureMode = 1;
        boolean prevStroke = this.stroke;
        this.stroke = false;
        int prevBlendMode = this.blendMode;
        this.blendMode(0);
        PShader prevShader = this.polyShader;
        this.polyShader = shader;
        this.beginShape(17);
        this.texture(this.filterImage);
        this.vertex(0.0f, 0.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, 0.0f, 1.0f);
        this.endShape();
        this.end2D();
        this.polyShader = prevShader;
        this.stroke = prevStroke;
        this.lights = prevLights;
        this.textureMode = prevTextureMode;
        this.blendMode(prevBlendMode);
        if (!this.hints[2]) {
            this.pgl.enable(PGL.DEPTH_TEST);
        }
        if (!this.hints[5]) {
            this.pgl.depthMask(true);
        }
        if (needEndDraw) {
            this.endDraw();
        }
    }

    @Override
    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (this.primarySurface) {
            this.pgl.requestFBOLayer();
        }
        this.loadTexture();
        if (this.filterTexture == null || this.filterTexture.contextIsOutdated()) {
            this.filterTexture = new Texture(this, this.texture.width, this.texture.height, this.texture.getParameters());
            this.filterTexture.invertedY(true);
            this.filterImage = this.wrapTexture(this.filterTexture);
        }
        this.filterTexture.put(this.texture, sx, this.height - (sy + sh), sw, this.height - sy);
        this.copy(this.filterImage, sx, sy, sw, sh, dx, dy, dw, dh);
    }

    @Override
    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        int texY1;
        int texY0;
        int scrY1;
        int scrY0;
        int scrX1;
        int scrX0;
        boolean needEndDraw = false;
        if (!this.drawing) {
            this.beginDraw();
            needEndDraw = true;
        }
        this.flush();
        Texture tex = this.getTexture(src);
        boolean invX = tex.invertedX();
        boolean invY = tex.invertedY();
        if (invX) {
            scrX0 = dx + dw;
            scrX1 = dx;
        } else {
            scrX0 = dx;
            scrX1 = dx + dw;
        }
        int texX0 = sx;
        int texX1 = sx + sw;
        if (invY) {
            scrY0 = this.height - (dy + dh);
            scrY1 = this.height - dy;
            texY0 = tex.height - (sy + sh);
            texY1 = tex.height - sy;
        } else {
            scrY0 = this.height - dy;
            scrY1 = this.height - (dy + dh);
            texY0 = sy;
            texY1 = sy + sh;
        }
        this.pgl.drawTexture(tex.glTarget, tex.glName, tex.glWidth, tex.glHeight, this.width, this.height, texX0, texY0, texX1, texY1, scrX0, scrY0, scrX1, scrY1);
        if (needEndDraw) {
            this.endDraw();
        }
    }

    @Override
    protected void blendModeImpl() {
        if (this.blendMode != this.lastBlendMode) {
            this.flush();
        }
        this.pgl.enable(PGL.BLEND);
        if (this.blendMode == 0) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.ONE, PGL.ZERO);
        } else if (this.blendMode == 1) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.SRC_ALPHA, PGL.ONE_MINUS_SRC_ALPHA);
        } else if (this.blendMode == 2) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.SRC_ALPHA, PGL.ONE);
        } else if (this.blendMode == 4) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_REVERSE_SUBTRACT);
                this.pgl.blendFunc(PGL.ONE, PGL.SRC_ALPHA);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "SUBTRACT");
            }
        } else if (this.blendMode == 8) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_MAX);
                this.pgl.blendFunc(PGL.SRC_ALPHA, PGL.DST_ALPHA);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "LIGHTEST");
            }
        } else if (this.blendMode == 16) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_MIN);
                this.pgl.blendFunc(PGL.SRC_ALPHA, PGL.DST_ALPHA);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "DARKEST");
            }
        } else if (this.blendMode == 64) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.ONE_MINUS_DST_COLOR, PGL.ONE_MINUS_SRC_COLOR);
        } else if (this.blendMode == 128) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.DST_COLOR, PGL.SRC_COLOR);
        } else if (this.blendMode == 256) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.ONE_MINUS_DST_COLOR, PGL.ONE);
        } else if (this.blendMode == 32) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "DIFFERENCE");
        } else if (this.blendMode == 512) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "OVERLAY");
        } else if (this.blendMode == 1024) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "HARD_LIGHT");
        } else if (this.blendMode == 2048) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "SOFT_LIGHT");
        } else if (this.blendMode == 4096) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "DODGE");
        } else if (this.blendMode == 8192) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "BURN");
        }
        this.lastBlendMode = this.blendMode;
    }

    public Texture getTexture() {
        return this.getTexture(true);
    }

    public Texture getTexture(boolean load) {
        if (load) {
            this.loadTexture();
        }
        return this.texture;
    }

    public Texture getTexture(PImage img) {
        Texture tex = (Texture)this.initCache(img);
        if (tex == null) {
            return null;
        }
        if (img.isModified() || img.isLoaded()) {
            if (img.width != tex.width || img.height != tex.height) {
                tex.init(img.width, img.height);
            }
            this.updateTexture(img, tex);
        }
        if (tex.hasBuffers()) {
            tex.bufferUpdate();
        }
        this.checkTexture(tex);
        return tex;
    }

    public FrameBuffer getFrameBuffer() {
        return this.getFrameBuffer(false);
    }

    public FrameBuffer getFrameBuffer(boolean multi) {
        if (multi) {
            return this.multisampleFramebuffer;
        }
        return this.offscreenFramebuffer;
    }

    protected Object initCache(PImage img) {
        if (!this.checkGLThread()) {
            return null;
        }
        Texture tex = (Texture)this.getCache(img);
        if ((tex == null || tex.contextIsOutdated()) && (tex = this.addTexture(img)) != null) {
            img.loadPixels();
            tex.set(img.pixels, img.format);
            img.setLoaded(false);
        }
        return tex;
    }

    protected void bindFrontTexture() {
        if (this.primarySurface) {
            this.pgl.bindFrontTexture();
        } else {
            if (this.ptexture == null) {
                this.createPTexture();
            }
            this.ptexture.bind();
        }
    }

    protected void unbindFrontTexture() {
        if (this.primarySurface) {
            this.pgl.unbindFrontTexture();
        } else {
            this.ptexture.unbind();
        }
    }

    protected Texture addTexture(PImage img) {
        Texture.Parameters params = new Texture.Parameters(2, this.textureSampling, this.getHint(-8), this.textureWrap);
        return this.addTexture(img, params);
    }

    protected Texture addTexture(PImage img, Texture.Parameters params) {
        if (img.width == 0 || img.height == 0) {
            return null;
        }
        if (img.parent == null) {
            img.parent = this.parent;
        }
        Texture tex = new Texture(this, img.width, img.height, params);
        this.setCache(img, tex);
        return tex;
    }

    protected void checkTexture(Texture tex) {
        if (!tex.colorBuffer() && tex.usingMipmaps == this.hints[8]) {
            if (this.hints[8]) {
                tex.usingMipmaps(false, this.textureSampling);
            } else {
                tex.usingMipmaps(true, this.textureSampling);
            }
        }
        if (tex.usingRepeat && this.textureWrap == 0 || !tex.usingRepeat && this.textureWrap == 1) {
            if (this.textureWrap == 0) {
                tex.usingRepeat(false);
            } else {
                tex.usingRepeat(true);
            }
        }
    }

    protected PImage wrapTexture(Texture tex) {
        PImage img = new PImage();
        img.parent = this.parent;
        img.width = tex.width;
        img.height = tex.height;
        img.format = 2;
        this.setCache(img, tex);
        return img;
    }

    protected void updateTexture(PImage img, Texture tex) {
        if (tex != null) {
            if (img.isModified()) {
                int x = img.getModifiedX1();
                int y = img.getModifiedY1();
                int w = img.getModifiedX2() - x;
                int h = img.getModifiedY2() - y;
                tex.set(img.pixels, x, y, w, h, img.format);
            } else if (img.isLoaded()) {
                tex.set(img.pixels, 0, 0, img.width, img.height, img.format);
            }
        }
        img.setModified(false);
        img.setLoaded(false);
    }

    protected void deleteSurfaceTextures() {
        if (this.texture != null) {
            this.texture.dispose();
        }
        if (this.ptexture != null) {
            this.ptexture.dispose();
        }
        if (this.filterTexture != null) {
            this.filterTexture.dispose();
        }
    }

    protected boolean checkGLThread() {
        if (this.pgl.threadIsCurrent()) {
            return true;
        }
        PGraphics.showWarning(OPENGL_THREAD_ERROR);
        return false;
    }

    @Override
    public void resize(int wide, int high) {
        PGraphics.showMethodWarning("resize");
    }

    protected void initPrimary() {
        this.pgl.initSurface(this.quality);
        if (this.texture != null) {
            this.removeCache(this);
            this.ptexture = null;
            this.texture = null;
        }
        this.initialized = true;
    }

    protected void beginOnscreenDraw() {
        this.pgl.beginDraw(this.clearColorBuffer);
        if (this.drawFramebuffer == null) {
            this.drawFramebuffer = new FrameBuffer(this, this.width, this.height, true);
        }
        this.drawFramebuffer.setFBO(this.pgl.getDrawFramebuffer());
        if (this.readFramebuffer == null) {
            this.readFramebuffer = new FrameBuffer(this, this.width, this.height, true);
        }
        this.readFramebuffer.setFBO(this.pgl.getReadFramebuffer());
        if (this.currentFramebuffer == null) {
            this.setFramebuffer(this.drawFramebuffer);
        }
        if (this.pgl.isFBOBacked()) {
            this.texture = this.pgl.wrapBackTexture(this.texture);
            this.ptexture = this.pgl.wrapFrontTexture(this.ptexture);
        }
    }

    protected void endOnscreenDraw() {
        this.pgl.endDraw(this.clearColorBuffer0);
    }

    protected void initOffscreen() {
        boolean packed;
        this.loadTextureImpl(this.textureSampling, false);
        if (this.offscreenFramebuffer != null) {
            this.offscreenFramebuffer.dispose();
        }
        if (this.multisampleFramebuffer != null) {
            this.multisampleFramebuffer.dispose();
        }
        boolean bl = packed = depthBits == 24 && stencilBits == 8 && packedDepthStencilSupported;
        if (fboMultisampleSupported && 1 < this.quality) {
            this.multisampleFramebuffer = new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, this.quality, 0, depthBits, stencilBits, packed, false);
            this.multisampleFramebuffer.clear();
            this.offscreenMultisample = true;
            this.offscreenFramebuffer = new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, 1, 1, 0, 0, false, false);
        } else {
            this.quality = 0;
            this.offscreenFramebuffer = new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, 1, 1, depthBits, stencilBits, packed, false);
            this.offscreenMultisample = false;
        }
        this.offscreenFramebuffer.setColorBuffer(this.texture);
        this.offscreenFramebuffer.clear();
        this.initialized = true;
    }

    protected void beginOffscreenDraw() {
        if (!this.initialized) {
            this.initOffscreen();
        } else {
            boolean outdatedMulti;
            boolean outdated = this.offscreenFramebuffer != null && this.offscreenFramebuffer.contextIsOutdated();
            boolean bl = outdatedMulti = this.multisampleFramebuffer != null && this.multisampleFramebuffer.contextIsOutdated();
            if (outdated || outdatedMulti) {
                this.restartPGL();
                this.initOffscreen();
            } else {
                this.swapOffscreenTextures();
            }
        }
        this.pushFramebuffer();
        if (this.offscreenMultisample) {
            this.setFramebuffer(this.multisampleFramebuffer);
        } else {
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.drawPTexture();
        if (this.clip) {
            this.pgl.enable(PGL.SCISSOR_TEST);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(PGL.SCISSOR_TEST);
        }
    }

    protected void endOffscreenDraw() {
        if (this.backgroundA == 1.0f) {
            this.pgl.colorMask(false, false, false, true);
            this.pgl.clearColor(0.0f, 0.0f, 0.0f, this.backgroundA);
            this.pgl.clear(PGL.COLOR_BUFFER_BIT);
            this.pgl.colorMask(true, true, true, true);
        }
        if (this.offscreenMultisample) {
            this.multisampleFramebuffer.copyColor(this.offscreenFramebuffer);
        }
        this.popFramebuffer();
        this.texture.updateTexels();
        this.getPrimaryPG().restoreGL();
    }

    protected void setViewport() {
        this.viewport.put(0, 0);
        this.viewport.put(1, 0);
        this.viewport.put(2, this.width);
        this.viewport.put(3, this.height);
        this.pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
    }

    protected void setDrawDefaults() {
        this.inGeo.clear();
        this.tessGeo.clear();
        this.texCache.clear();
        super.noTexture();
        this.blendModeImpl();
        if (this.hints[2]) {
            this.pgl.disable(PGL.DEPTH_TEST);
        } else {
            this.pgl.enable(PGL.DEPTH_TEST);
        }
        this.pgl.depthFunc(PGL.LEQUAL);
        this.flushMode = this.hints[6] ? 0 : 1;
        if (this.primarySurface) {
            this.pgl.getIntegerv(PGL.SAMPLES, intBuffer);
            int temp = intBuffer.get(0);
            if (this.quality != temp && 1 < temp && 1 < this.quality) {
                this.quality = temp;
            }
        }
        if (this.quality < 2) {
            this.pgl.disable(PGL.MULTISAMPLE);
        } else {
            this.pgl.enable(PGL.MULTISAMPLE);
        }
        this.pgl.disable(PGL.POLYGON_SMOOTH);
        if (this.sized) {
            if (this.primarySurface) {
                this.background(this.backgroundColor);
            } else {
                this.background(this.backgroundColor & 0xFFFFFF);
            }
            this.defaultPerspective();
            this.defaultCamera();
            this.sized = false;
        } else {
            this.modelview.set(this.camera);
            this.modelviewInv.set(this.cameraInv);
            this.updateProjmodelview();
        }
        if (this.is3D()) {
            this.noLights();
            this.lightFalloff(1.0f, 0.0f, 0.0f);
            this.lightSpecular(0.0f, 0.0f, 0.0f);
        }
        this.pgl.frontFace(PGL.CW);
        this.pgl.disable(PGL.CULL_FACE);
        this.pgl.activeTexture(PGL.TEXTURE0);
        this.normalZ = 0.0f;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        this.pgl.depthMask(true);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clear(PGL.DEPTH_BUFFER_BIT | PGL.STENCIL_BUFFER_BIT);
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.restoreSurface) {
            this.restoreSurfaceFromPixels();
            this.restoreSurface = false;
        }
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pixelsOp = 0;
        this.clearColorBuffer0 = this.clearColorBuffer;
        this.clearColorBuffer = false;
        this.modified = false;
        this.setgetPixels = false;
    }

    protected void getGLParameters() {
        OPENGL_VENDOR = this.pgl.getString(PGL.VENDOR);
        OPENGL_RENDERER = this.pgl.getString(PGL.RENDERER);
        OPENGL_VERSION = this.pgl.getString(PGL.VERSION);
        OPENGL_EXTENSIONS = this.pgl.getString(PGL.EXTENSIONS);
        GLSL_VERSION = this.pgl.getString(PGL.SHADING_LANGUAGE_VERSION);
        npotTexSupported = this.pgl.hasNpotTexSupport();
        autoMipmapGenSupported = this.pgl.hasAutoMipmapGenSupport();
        fboMultisampleSupported = this.pgl.hasFboMultisampleSupport();
        packedDepthStencilSupported = this.pgl.hasPackedDepthStencilSupport();
        anisoSamplingSupported = this.pgl.hasAnisoSamplingSupport();
        try {
            this.pgl.blendEquation(PGL.FUNC_ADD);
            blendEqSupported = true;
        }
        catch (Exception exception) {
            blendEqSupported = false;
        }
        depthBits = this.pgl.getDepthBits();
        stencilBits = this.pgl.getStencilBits();
        this.pgl.getIntegerv(PGL.MAX_TEXTURE_SIZE, intBuffer);
        maxTextureSize = intBuffer.get(0);
        this.pgl.getIntegerv(PGL.MAX_SAMPLES, intBuffer);
        maxSamples = intBuffer.get(0);
        if (anisoSamplingSupported) {
            this.pgl.getFloatv(PGL.MAX_TEXTURE_MAX_ANISOTROPY, floatBuffer);
            maxAnisoAmount = floatBuffer.get(0);
        }
        glParamsRead = true;
    }

    @Override
    public PShader loadShader(String fragFilename) {
        if (fragFilename == null || fragFilename.equals("")) {
            PGraphics.showWarning(MISSING_FRAGMENT_SHADER);
            return null;
        }
        int type = PShader.getShaderType(this.parent.loadStrings(fragFilename), 2);
        PShader shader = new PShader(this.parent);
        shader.setType(type);
        shader.setFragmentShader(fragFilename);
        if (type == 0) {
            String[] vertSource = this.pgl.loadVertexShader(defPointShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        } else if (type == 1) {
            String[] vertSource = this.pgl.loadVertexShader(defLineShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        } else if (type == 6) {
            String[] vertSource = this.pgl.loadVertexShader(defTexlightShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        } else if (type == 4) {
            String[] vertSource = this.pgl.loadVertexShader(defLightShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        } else if (type == 5) {
            String[] vertSource = this.pgl.loadVertexShader(defTextureShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        } else if (type == 3) {
            String[] vertSource = this.pgl.loadVertexShader(defColorShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        } else {
            String[] vertSource = this.pgl.loadVertexShader(defTextureShaderVertURL, 120);
            shader.setVertexShader(vertSource);
        }
        return shader;
    }

    @Override
    public PShader loadShader(String fragFilename, String vertFilename) {
        if (fragFilename == null || fragFilename.equals("")) {
            PGraphics.showWarning(MISSING_FRAGMENT_SHADER);
            return null;
        }
        if (fragFilename == null || fragFilename.equals("")) {
            PGraphics.showWarning(MISSING_VERTEX_SHADER);
            return null;
        }
        return new PShader(this.parent, vertFilename, fragFilename);
    }

    @Override
    public void shader(PShader shader) {
        this.flush();
        if (shader.isPolyShader()) {
            this.polyShader = shader;
        } else if (shader.isLineShader()) {
            this.lineShader = shader;
        } else if (shader.isPointShader()) {
            this.pointShader = shader;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    @Override
    public void shader(PShader shader, int kind) {
        this.shader(shader);
    }

    @Override
    public void resetShader() {
        this.resetShader(9);
    }

    @Override
    public void resetShader(int kind) {
        this.flush();
        if (kind == 9 || kind == 17 || kind == 20) {
            this.polyShader = null;
        } else if (kind == 5) {
            this.lineShader = null;
        } else if (kind == 3) {
            this.pointShader = null;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    protected void deleteDefaultShaders() {
        this.defColorShader = null;
        this.defTextureShader = null;
        this.defLightShader = null;
        this.defTexlightShader = null;
        this.defLineShader = null;
        this.defPointShader = null;
        this.maskShader = null;
    }

    protected PShader getPolyShader(boolean lit, boolean tex) {
        PShader shader;
        boolean useDefault;
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        boolean bl = useDefault = this.polyShader == null;
        if (this.polyShader != null) {
            this.polyShader.setRenderer(this);
            this.polyShader.loadAttributes();
            this.polyShader.loadUniforms();
        }
        if (lit) {
            if (tex) {
                if (useDefault || !this.polyShader.checkPolyType(6)) {
                    if (ppg.defTexlightShader == null) {
                        String[] vertSource = this.pgl.loadVertexShader(defTexlightShaderVertURL, 120);
                        String[] fragSource = this.pgl.loadFragmentShader(defTextureShaderFragURL, 120);
                        ppg.defTexlightShader = new PShader(this.parent, vertSource, fragSource);
                    }
                    shader = ppg.defTexlightShader;
                } else {
                    shader = this.polyShader;
                }
            } else if (useDefault || !this.polyShader.checkPolyType(4)) {
                if (ppg.defLightShader == null) {
                    String[] vertSource = this.pgl.loadVertexShader(defLightShaderVertURL, 120);
                    String[] fragSource = this.pgl.loadFragmentShader(defColorShaderFragURL, 120);
                    ppg.defLightShader = new PShader(this.parent, vertSource, fragSource);
                }
                shader = ppg.defLightShader;
            } else {
                shader = this.polyShader;
            }
        } else {
            if (this.polyShader != null && this.polyShader.accessLightAttribs()) {
                PGraphics.showWarning(SHADER_NEED_LIGHT_ATTRIBS);
                useDefault = true;
            }
            if (tex) {
                if (useDefault || !this.polyShader.checkPolyType(5)) {
                    if (ppg.defTextureShader == null) {
                        String[] vertSource = this.pgl.loadVertexShader(defTextureShaderVertURL, 120);
                        String[] fragSource = this.pgl.loadFragmentShader(defTextureShaderFragURL, 120);
                        ppg.defTextureShader = new PShader(this.parent, vertSource, fragSource);
                    }
                    shader = ppg.defTextureShader;
                } else {
                    shader = this.polyShader;
                }
            } else if (useDefault || !this.polyShader.checkPolyType(3)) {
                if (ppg.defColorShader == null) {
                    String[] vertSource = this.pgl.loadVertexShader(defColorShaderVertURL, 120);
                    String[] fragSource = this.pgl.loadFragmentShader(defColorShaderFragURL, 120);
                    ppg.defColorShader = new PShader(this.parent, vertSource, fragSource);
                }
                shader = ppg.defColorShader;
            } else {
                shader = this.polyShader;
            }
        }
        if (shader != this.polyShader) {
            shader.setRenderer(this);
            shader.loadAttributes();
            shader.loadUniforms();
        }
        return shader;
    }

    protected PShader getLineShader() {
        PShader shader;
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        if (this.lineShader == null) {
            if (ppg.defLineShader == null) {
                String[] vertSource = this.pgl.loadVertexShader(defLineShaderVertURL, 120);
                String[] fragSource = this.pgl.loadFragmentShader(defLineShaderFragURL, 120);
                ppg.defLineShader = new PShader(this.parent, vertSource, fragSource);
            }
            shader = ppg.defLineShader;
        } else {
            shader = this.lineShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected PShader getPointShader() {
        PShader shader;
        PGraphicsOpenGL ppg = this.getPrimaryPG();
        if (this.pointShader == null) {
            if (ppg.defPointShader == null) {
                String[] vertSource = this.pgl.loadVertexShader(defPointShaderVertURL, 120);
                String[] fragSource = this.pgl.loadFragmentShader(defPointShaderFragURL, 120);
                ppg.defPointShader = new PShader(this.parent, vertSource, fragSource);
            }
            shader = ppg.defPointShader;
        } else {
            shader = this.pointShader;
        }
        shader.setRenderer(this);
        shader.loadAttributes();
        shader.loadUniforms();
        return shader;
    }

    protected static int expandArraySize(int currSize, int newMinSize) {
        int newSize = currSize;
        while (newSize < newMinSize) {
            newSize <<= 1;
        }
        return newSize;
    }

    protected static InGeometry newInGeometry(PGraphicsOpenGL pg, int mode) {
        return new InGeometry(pg, mode);
    }

    protected static TessGeometry newTessGeometry(PGraphicsOpenGL pg, int mode) {
        return new TessGeometry(pg, mode);
    }

    protected static TexCache newTexCache(PGraphicsOpenGL pg) {
        return new TexCache(pg);
    }

    static /* synthetic */ float[] access$0() {
        return PGraphics.cosLUT;
    }

    static /* synthetic */ float[] access$1() {
        return PGraphics.sinLUT;
    }

    protected static class GLResource {
        int id;
        int context;

        GLResource(int id, int context) {
            this.id = id;
            this.context = context;
        }

        public boolean equals(Object obj) {
            GLResource other = (GLResource)obj;
            return other.id == this.id && other.context == this.context;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.id;
            result = 31 * result + this.context;
            return result;
        }
    }

    protected static class InGeometry {
        PGraphicsOpenGL pg;
        int renderMode;
        int vertexCount;
        int codeCount;
        int edgeCount;
        float[] vertices;
        int[] colors;
        float[] normals;
        float[] texcoords;
        int[] strokeColors;
        float[] strokeWeights;
        int[] codes;
        int[][] edges;
        int[] ambient;
        int[] specular;
        int[] emissive;
        float[] shininess;
        int fillColor;
        int strokeColor;
        float strokeWeight;
        int ambientColor;
        int specularColor;
        int emissiveColor;
        float shininessFactor;
        float normalX;
        float normalY;
        float normalZ;

        InGeometry(PGraphicsOpenGL pg, int mode) {
            this.pg = pg;
            this.renderMode = mode;
            this.allocate();
        }

        void clear() {
            this.vertexCount = 0;
            this.codeCount = 0;
            this.edgeCount = 0;
        }

        void clearEdges() {
            this.edgeCount = 0;
        }

        void allocate() {
            this.vertices = new float[3 * PGL.DEFAULT_IN_VERTICES];
            this.colors = new int[PGL.DEFAULT_IN_VERTICES];
            this.normals = new float[3 * PGL.DEFAULT_IN_VERTICES];
            this.texcoords = new float[2 * PGL.DEFAULT_IN_VERTICES];
            this.strokeColors = new int[PGL.DEFAULT_IN_VERTICES];
            this.strokeWeights = new float[PGL.DEFAULT_IN_VERTICES];
            this.ambient = new int[PGL.DEFAULT_IN_VERTICES];
            this.specular = new int[PGL.DEFAULT_IN_VERTICES];
            this.emissive = new int[PGL.DEFAULT_IN_VERTICES];
            this.shininess = new float[PGL.DEFAULT_IN_VERTICES];
            this.edges = new int[PGL.DEFAULT_IN_EDGES][3];
            this.clear();
        }

        void vertexCheck() {
            if (this.vertexCount == this.vertices.length / 3) {
                int newSize = this.vertexCount << 1;
                this.expandVertices(newSize);
                this.expandColors(newSize);
                this.expandNormals(newSize);
                this.expandTexCoords(newSize);
                this.expandStrokeColors(newSize);
                this.expandStrokeWeights(newSize);
                this.expandAmbient(newSize);
                this.expandSpecular(newSize);
                this.expandEmissive(newSize);
                this.expandShininess(newSize);
            }
        }

        void codeCheck() {
            if (this.codeCount == this.codes.length) {
                int newLen = this.codeCount << 1;
                this.expandCodes(newLen);
            }
        }

        void edgeCheck() {
            if (this.edgeCount == this.edges.length) {
                int newLen = this.edgeCount << 1;
                this.expandEdges(newLen);
            }
        }

        float getVertexX(int idx) {
            return this.vertices[3 * idx + 0];
        }

        float getVertexY(int idx) {
            return this.vertices[3 * idx + 1];
        }

        float getVertexZ(int idx) {
            return this.vertices[3 * idx + 2];
        }

        float getLastVertexX() {
            return this.vertices[3 * (this.vertexCount - 1) + 0];
        }

        float getLastVertexY() {
            return this.vertices[3 * (this.vertexCount - 1) + 1];
        }

        float getLastVertexZ() {
            return this.vertices[3 * (this.vertexCount - 1) + 2];
        }

        int getNumEdgeClosures() {
            int count = 0;
            int i = 0;
            while (i < this.edgeCount) {
                if (this.edges[i][2] == -1) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        int getNumEdgeVertices(boolean bevel) {
            int segVert = this.edgeCount;
            int bevVert = 0;
            if (bevel) {
                int i = 0;
                while (i < this.edgeCount) {
                    int[] edge = this.edges[i];
                    if (edge[2] == 0 || edge[2] == 1) {
                        ++bevVert;
                    }
                    if (edge[2] == -1) {
                        --segVert;
                    }
                    ++i;
                }
            } else {
                segVert -= this.getNumEdgeClosures();
            }
            return 4 * segVert + bevVert;
        }

        int getNumEdgeIndices(boolean bevel) {
            int segInd = this.edgeCount;
            int bevInd = 0;
            if (bevel) {
                int i = 0;
                while (i < this.edgeCount) {
                    int[] edge = this.edges[i];
                    if (edge[2] == 0 || edge[2] == 1) {
                        ++bevInd;
                    }
                    if (edge[2] == -1) {
                        --segInd;
                    }
                    ++i;
                }
            } else {
                segInd -= this.getNumEdgeClosures();
            }
            return 6 * (segInd + bevInd);
        }

        void getVertexMin(PVector v) {
            int i = 0;
            while (i < this.vertexCount) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.vertices[index++]);
                v.y = PApplet.min(v.y, this.vertices[index++]);
                v.z = PApplet.min(v.z, this.vertices[index]);
                ++i;
            }
        }

        void getVertexMax(PVector v) {
            int i = 0;
            while (i < this.vertexCount) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.vertices[index++]);
                v.y = PApplet.max(v.y, this.vertices[index++]);
                v.z = PApplet.max(v.z, this.vertices[index]);
                ++i;
            }
        }

        int getVertexSum(PVector v) {
            int i = 0;
            while (i < this.vertexCount) {
                int index = 4 * i;
                v.x += this.vertices[index++];
                v.y += this.vertices[index++];
                v.z += this.vertices[index];
                ++i;
            }
            return this.vertexCount;
        }

        void expandVertices(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.vertices, 0, temp, 0, 3 * this.vertexCount);
            this.vertices = temp;
        }

        void expandColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.colors, 0, temp, 0, this.vertexCount);
            this.colors = temp;
        }

        void expandNormals(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.normals, 0, temp, 0, 3 * this.vertexCount);
            this.normals = temp;
        }

        void expandTexCoords(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.texcoords, 0, temp, 0, 2 * this.vertexCount);
            this.texcoords = temp;
        }

        void expandStrokeColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.strokeColors, 0, temp, 0, this.vertexCount);
            this.strokeColors = temp;
        }

        void expandStrokeWeights(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.strokeWeights, 0, temp, 0, this.vertexCount);
            this.strokeWeights = temp;
        }

        void expandAmbient(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.ambient, 0, temp, 0, this.vertexCount);
            this.ambient = temp;
        }

        void expandSpecular(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.specular, 0, temp, 0, this.vertexCount);
            this.specular = temp;
        }

        void expandEmissive(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.emissive, 0, temp, 0, this.vertexCount);
            this.emissive = temp;
        }

        void expandShininess(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.shininess, 0, temp, 0, this.vertexCount);
            this.shininess = temp;
        }

        void expandCodes(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.codes, 0, temp, 0, this.codeCount);
            this.codes = temp;
        }

        void expandEdges(int n) {
            int[][] temp = new int[n][3];
            PApplet.arrayCopy(this.edges, 0, temp, 0, this.edgeCount);
            this.edges = temp;
        }

        void trim() {
            if (this.vertexCount > 0 && this.vertexCount < this.vertices.length / 3) {
                this.trimVertices();
                this.trimColors();
                this.trimNormals();
                this.trimTexCoords();
                this.trimStrokeColors();
                this.trimStrokeWeights();
                this.trimAmbient();
                this.trimSpecular();
                this.trimEmissive();
                this.trimShininess();
            }
            if (this.codeCount > 0 && this.codeCount < this.codes.length) {
                this.trimCodes();
            }
            if (this.edgeCount > 0 && this.edgeCount < this.edges.length) {
                this.trimEdges();
            }
        }

        void trimVertices() {
            float[] temp = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.vertices, 0, temp, 0, 3 * this.vertexCount);
            this.vertices = temp;
        }

        void trimColors() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.colors, 0, temp, 0, this.vertexCount);
            this.colors = temp;
        }

        void trimNormals() {
            float[] temp = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.normals, 0, temp, 0, 3 * this.vertexCount);
            this.normals = temp;
        }

        void trimTexCoords() {
            float[] temp = new float[2 * this.vertexCount];
            PApplet.arrayCopy(this.texcoords, 0, temp, 0, 2 * this.vertexCount);
            this.texcoords = temp;
        }

        void trimStrokeColors() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.strokeColors, 0, temp, 0, this.vertexCount);
            this.strokeColors = temp;
        }

        void trimStrokeWeights() {
            float[] temp = new float[this.vertexCount];
            PApplet.arrayCopy(this.strokeWeights, 0, temp, 0, this.vertexCount);
            this.strokeWeights = temp;
        }

        void trimAmbient() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.ambient, 0, temp, 0, this.vertexCount);
            this.ambient = temp;
        }

        void trimSpecular() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.specular, 0, temp, 0, this.vertexCount);
            this.specular = temp;
        }

        void trimEmissive() {
            int[] temp = new int[this.vertexCount];
            PApplet.arrayCopy(this.emissive, 0, temp, 0, this.vertexCount);
            this.emissive = temp;
        }

        void trimShininess() {
            float[] temp = new float[this.vertexCount];
            PApplet.arrayCopy(this.shininess, 0, temp, 0, this.vertexCount);
            this.shininess = temp;
        }

        void trimCodes() {
            int[] temp = new int[this.codeCount];
            PApplet.arrayCopy(this.codes, 0, temp, 0, this.codeCount);
            this.codes = temp;
        }

        void trimEdges() {
            int[][] temp = new int[this.edgeCount][3];
            PApplet.arrayCopy(this.edges, 0, temp, 0, this.edgeCount);
            this.edges = temp;
        }

        int addVertex(float x, float y, boolean brk) {
            return this.addVertex(x, y, 0, brk);
        }

        int addVertex(float x, float y, int code, boolean brk) {
            return this.addVertex(x, y, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code, brk);
        }

        int addVertex(float x, float y, float u, float v, boolean brk) {
            return this.addVertex(x, y, u, v, 0, brk);
        }

        int addVertex(float x, float y, float u, float v, int code, boolean brk) {
            return this.addVertex(x, y, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, u, v, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code, brk);
        }

        int addVertex(float x, float y, float z, boolean brk) {
            return this.addVertex(x, y, z, 0, brk);
        }

        int addVertex(float x, float y, float z, int code, boolean brk) {
            return this.addVertex(x, y, z, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code, brk);
        }

        int addVertex(float x, float y, float z, float u, float v, boolean brk) {
            return this.addVertex(x, y, z, u, v, 0, brk);
        }

        int addVertex(float x, float y, float z, float u, float v, int code, boolean brk) {
            return this.addVertex(x, y, z, this.fillColor, this.normalX, this.normalY, this.normalZ, u, v, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, code, brk);
        }

        int addVertex(float x, float y, float z, int fcolor, float nx, float ny, float nz, float u, float v, int scolor, float sweight, int am, int sp, int em, float shine, int code, boolean brk) {
            this.vertexCheck();
            int index = 3 * this.vertexCount;
            this.vertices[index++] = x;
            this.vertices[index++] = y;
            this.vertices[index] = z;
            this.colors[this.vertexCount] = PGL.javaToNativeARGB(fcolor);
            index = 3 * this.vertexCount;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
            index = 2 * this.vertexCount;
            this.texcoords[index++] = u;
            this.texcoords[index] = v;
            this.strokeColors[this.vertexCount] = PGL.javaToNativeARGB(scolor);
            this.strokeWeights[this.vertexCount] = sweight;
            this.ambient[this.vertexCount] = PGL.javaToNativeARGB(am);
            this.specular[this.vertexCount] = PGL.javaToNativeARGB(sp);
            this.emissive[this.vertexCount] = PGL.javaToNativeARGB(em);
            this.shininess[this.vertexCount] = shine;
            if (brk || code == 0 && this.codes != null || code == 1 || code == 2 || code == 3) {
                if (this.codes == null) {
                    this.codes = new int[PApplet.max(PGL.DEFAULT_IN_VERTICES, this.vertexCount)];
                    Arrays.fill(this.codes, 0, this.vertexCount, 0);
                    this.codeCount = this.vertexCount;
                }
                if (brk) {
                    this.codeCheck();
                    this.codes[this.codeCount] = 4;
                    ++this.codeCount;
                }
                if (code != -1) {
                    this.codeCheck();
                    this.codes[this.codeCount] = code;
                    ++this.codeCount;
                }
            }
            ++this.vertexCount;
            return this.vertexCount - 1;
        }

        public void addBezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean brk) {
            this.addVertex(x2, y2, z2, 1, brk);
            this.addVertex(x3, y3, z3, -1, false);
            this.addVertex(x4, y4, z4, -1, false);
        }

        public void addQuadraticVertex(float cx, float cy, float cz, float x3, float y3, float z3, boolean brk) {
            this.addVertex(cx, cy, cz, 2, brk);
            this.addVertex(x3, y3, z3, -1, false);
        }

        public void addCurveVertex(float x, float y, float z, boolean brk) {
            this.addVertex(x, y, z, 3, brk);
        }

        float[][] getVertexData() {
            float[][] data = new float[this.vertexCount][37];
            int i = 0;
            while (i < this.vertexCount) {
                float[] vert = data[i];
                vert[0] = this.vertices[3 * i + 0];
                vert[1] = this.vertices[3 * i + 1];
                vert[2] = this.vertices[3 * i + 2];
                vert[3] = (float)(this.colors[i] >> 16 & 0xFF) / 255.0f;
                vert[4] = (float)(this.colors[i] >> 8 & 0xFF) / 255.0f;
                vert[5] = (float)(this.colors[i] >> 0 & 0xFF) / 255.0f;
                vert[6] = (float)(this.colors[i] >> 24 & 0xFF) / 255.0f;
                vert[7] = this.texcoords[2 * i + 0];
                vert[8] = this.texcoords[2 * i + 1];
                vert[9] = this.normals[3 * i + 0];
                vert[10] = this.normals[3 * i + 1];
                vert[11] = this.normals[3 * i + 2];
                vert[13] = (float)(this.strokeColors[i] >> 16 & 0xFF) / 255.0f;
                vert[14] = (float)(this.strokeColors[i] >> 8 & 0xFF) / 255.0f;
                vert[15] = (float)(this.strokeColors[i] >> 0 & 0xFF) / 255.0f;
                vert[16] = (float)(this.strokeColors[i] >> 24 & 0xFF) / 255.0f;
                vert[17] = this.strokeWeights[i];
                ++i;
            }
            return data;
        }

        boolean hasBezierVertex() {
            int i = 0;
            while (i < this.codeCount) {
                if (this.codes[i] == 1) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean hasQuadraticVertex() {
            int i = 0;
            while (i < this.codeCount) {
                if (this.codes[i] == 2) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean hasCurveVertex() {
            int i = 0;
            while (i < this.codeCount) {
                if (this.codes[i] == 3) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        int addEdge(int i, int j, boolean start, boolean end) {
            this.edgeCheck();
            int[] edge = this.edges[this.edgeCount];
            edge[0] = i;
            edge[1] = j;
            edge[2] = (start ? 1 : 0) + 2 * (end ? 1 : 0);
            ++this.edgeCount;
            return this.edgeCount - 1;
        }

        int closeEdge(int i, int j) {
            this.edgeCheck();
            int[] edge = this.edges[this.edgeCount];
            edge[0] = i;
            edge[1] = j;
            edge[2] = -1;
            ++this.edgeCount;
            return this.edgeCount - 1;
        }

        void addTrianglesEdges() {
            int i = 0;
            while (i < this.vertexCount / 3) {
                int i0 = 3 * i + 0;
                int i1 = 3 * i + 1;
                int i2 = 3 * i + 2;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, false);
                this.closeEdge(i2, i0);
                ++i;
            }
        }

        void addTriangleFanEdges() {
            int i = 1;
            while (i < this.vertexCount - 1) {
                int i0 = 0;
                int i1 = i;
                int i2 = i + 1;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, false);
                this.closeEdge(i2, i0);
                ++i;
            }
        }

        void addTriangleStripEdges() {
            int i = 1;
            while (i < this.vertexCount - 1) {
                int i2;
                int i1;
                int i0 = i;
                if (i % 2 == 0) {
                    i1 = i - 1;
                    i2 = i + 1;
                } else {
                    i1 = i + 1;
                    i2 = i - 1;
                }
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i0, false, false);
                this.closeEdge(i2, i0);
                ++i;
            }
        }

        void addQuadsEdges() {
            int i = 0;
            while (i < this.vertexCount / 4) {
                int i0 = 4 * i + 0;
                int i1 = 4 * i + 1;
                int i2 = 4 * i + 2;
                int i3 = 4 * i + 3;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i3, false, false);
                this.addEdge(i3, i0, false, false);
                this.closeEdge(i3, i0);
                ++i;
            }
        }

        void addQuadStripEdges() {
            int qd = 1;
            while (qd < this.vertexCount / 2) {
                int i0 = 2 * (qd - 1);
                int i1 = 2 * (qd - 1) + 1;
                int i2 = 2 * qd + 1;
                int i3 = 2 * qd;
                this.addEdge(i0, i1, true, false);
                this.addEdge(i1, i2, false, false);
                this.addEdge(i2, i3, false, false);
                this.addEdge(i3, i0, false, true);
                this.closeEdge(i3, i0);
                ++qd;
            }
        }

        void calcTriangleNormal(int i0, int i1, int i2) {
            int index = 3 * i0;
            float x0 = this.vertices[index++];
            float y0 = this.vertices[index++];
            float z0 = this.vertices[index];
            index = 3 * i1;
            float x1 = this.vertices[index++];
            float y1 = this.vertices[index++];
            float z1 = this.vertices[index];
            index = 3 * i2;
            float x2 = this.vertices[index++];
            float y2 = this.vertices[index++];
            float z2 = this.vertices[index];
            float v12x = x2 - x1;
            float v12y = y2 - y1;
            float v12z = z2 - z1;
            float v10x = x0 - x1;
            float v10y = y0 - y1;
            float v10z = z0 - z1;
            float nx = v12y * v10z - v10y * v12z;
            float ny = v12z * v10x - v10z * v12x;
            float nz = v12x * v10y - v10x * v12y;
            float d = PApplet.sqrt(nx * nx + ny * ny + nz * nz);
            index = 3 * i0;
            this.normals[index++] = nx /= d;
            this.normals[index++] = ny /= d;
            this.normals[index] = nz /= d;
            index = 3 * i1;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
            index = 3 * i2;
            this.normals[index++] = nx;
            this.normals[index++] = ny;
            this.normals[index] = nz;
        }

        void calcTrianglesNormals() {
            int i = 0;
            while (i < this.vertexCount / 3) {
                int i0 = 3 * i + 0;
                int i1 = 3 * i + 1;
                int i2 = 3 * i + 2;
                this.calcTriangleNormal(i0, i1, i2);
                ++i;
            }
        }

        void calcTriangleFanNormals() {
            int i = 1;
            while (i < this.vertexCount - 1) {
                int i0 = 0;
                int i1 = i;
                int i2 = i + 1;
                this.calcTriangleNormal(i0, i1, i2);
                ++i;
            }
        }

        void calcTriangleStripNormals() {
            int i = 1;
            while (i < this.vertexCount - 1) {
                int i2;
                int i0;
                int i1 = i;
                if (i % 2 == 0) {
                    i0 = i + 1;
                    i2 = i - 1;
                } else {
                    i0 = i - 1;
                    i2 = i + 1;
                }
                this.calcTriangleNormal(i0, i1, i2);
                ++i;
            }
        }

        void calcQuadsNormals() {
            int i = 0;
            while (i < this.vertexCount / 4) {
                int i0 = 4 * i + 0;
                int i1 = 4 * i + 1;
                int i2 = 4 * i + 2;
                int i3 = 4 * i + 3;
                this.calcTriangleNormal(i0, i1, i2);
                this.calcTriangleNormal(i2, i3, i0);
                ++i;
            }
        }

        void calcQuadStripNormals() {
            int qd = 1;
            while (qd < this.vertexCount / 2) {
                int i0 = 2 * (qd - 1);
                int i1 = 2 * (qd - 1) + 1;
                int i2 = 2 * qd;
                int i3 = 2 * qd + 1;
                this.calcTriangleNormal(i0, i3, i1);
                this.calcTriangleNormal(i0, i2, i3);
                ++qd;
            }
        }

        void setMaterial(int fillColor, int strokeColor, float strokeWeight, int ambientColor, int specularColor, int emissiveColor, float shininessFactor) {
            this.fillColor = fillColor;
            this.strokeColor = strokeColor;
            this.strokeWeight = strokeWeight;
            this.ambientColor = ambientColor;
            this.specularColor = specularColor;
            this.emissiveColor = emissiveColor;
            this.shininessFactor = shininessFactor;
        }

        void setNormal(float normalX, float normalY, float normalZ) {
            this.normalX = normalX;
            this.normalY = normalY;
            this.normalZ = normalZ;
        }

        void addPoint(float x, float y, float z, boolean fill, boolean stroke) {
            this.addVertex(x, y, z, 0, true);
        }

        void addLine(float x1, float y1, float z1, float x2, float y2, float z2, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0, true);
            int idx2 = this.addVertex(x2, y2, z2, 0, false);
            if (stroke) {
                this.addEdge(idx1, idx2, true, true);
            }
        }

        void addTriangle(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, boolean fill, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0, true);
            int idx2 = this.addVertex(x2, y2, z2, 0, false);
            int idx3 = this.addVertex(x3, y3, z3, 0, false);
            if (stroke) {
                this.addEdge(idx1, idx2, true, false);
                this.addEdge(idx2, idx3, false, false);
                this.addEdge(idx3, idx1, false, false);
                this.closeEdge(idx3, idx1);
            }
        }

        void addQuad(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, boolean stroke) {
            int idx1 = this.addVertex(x1, y1, z1, 0.0f, 0.0f, 0, true);
            int idx2 = this.addVertex(x2, y2, z2, 1.0f, 0.0f, 0, false);
            int idx3 = this.addVertex(x3, y3, z3, 1.0f, 1.0f, 0, false);
            int idx4 = this.addVertex(x4, y4, z4, 0.0f, 1.0f, 0, false);
            if (stroke) {
                this.addEdge(idx1, idx2, true, false);
                this.addEdge(idx2, idx3, false, false);
                this.addEdge(idx3, idx4, false, false);
                this.addEdge(idx4, idx1, false, false);
                this.closeEdge(idx4, idx1);
            }
        }

        void addRect(float a, float b, float c, float d, boolean stroke) {
            this.addQuad(a, b, 0.0f, c, b, 0.0f, c, d, 0.0f, a, d, 0.0f, stroke);
        }

        void addRect(float a, float b, float c, float d, float tl, float tr, float br, float bl, boolean stroke) {
            if (PGraphicsOpenGL.nonZero(tr)) {
                this.addVertex(c - tr, b, 0, true);
                this.addQuadraticVertex(c, b, 0.0f, c, b + tr, 0.0f, false);
            } else {
                this.addVertex(c, b, 0, true);
            }
            if (PGraphicsOpenGL.nonZero(br)) {
                this.addVertex(c, d - br, 0, false);
                this.addQuadraticVertex(c, d, 0.0f, c - br, d, 0.0f, false);
            } else {
                this.addVertex(c, d, 0, false);
            }
            if (PGraphicsOpenGL.nonZero(bl)) {
                this.addVertex(a + bl, d, 0, false);
                this.addQuadraticVertex(a, d, 0.0f, a, d - bl, 0.0f, false);
            } else {
                this.addVertex(a, d, 0, false);
            }
            if (PGraphicsOpenGL.nonZero(tl)) {
                this.addVertex(a, b + tl, 0, false);
                this.addQuadraticVertex(a, b, 0.0f, a + tl, b, 0.0f, false);
            } else {
                this.addVertex(a, b, 0, false);
            }
        }

        void addEllipse(float x, float y, float w, float h, boolean fill, boolean stroke) {
            float radiusH = w / 2.0f;
            float radiusV = h / 2.0f;
            float centerX = x + radiusH;
            float centerY = y + radiusV;
            float sx1 = this.pg.screenX(x, y);
            float sy1 = this.pg.screenY(x, y);
            float sx2 = this.pg.screenX(x + w, y + h);
            float sy2 = this.pg.screenY(x + w, y + h);
            int accuracy = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * PApplet.dist(sx1, sy1, sx2, sy2) / 10.0f)));
            float inc = 720.0f / (float)accuracy;
            if (fill) {
                this.addVertex(centerX, centerY, 0, true);
            }
            int idx = 0;
            int pidx = 0;
            int idx0 = 0;
            float val = 0.0f;
            int i = 0;
            while (i < accuracy) {
                idx = this.addVertex(centerX + PGraphicsOpenGL.access$0()[(int)val] * radiusH, centerY + PGraphicsOpenGL.access$1()[(int)val] * radiusV, 0, i == 0 && !fill);
                val = (val + inc) % 720.0f;
                if (i > 0) {
                    if (stroke) {
                        this.addEdge(pidx, idx, i == 1, false);
                    }
                } else {
                    idx0 = idx;
                }
                pidx = idx;
                ++i;
            }
            this.addVertex(centerX + PGraphicsOpenGL.access$0()[0] * radiusH, centerY + PGraphicsOpenGL.access$1()[0] * radiusV, 0, false);
            if (stroke) {
                this.addEdge(idx, idx0, false, false);
                this.closeEdge(idx, idx0);
            }
        }

        void addArc(float x, float y, float w, float h, float start, float stop, boolean fill, boolean stroke, int arcMode) {
            int ii;
            float hr = w / 2.0f;
            float vr = h / 2.0f;
            float centerX = x + hr;
            float centerY = y + vr;
            int startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            int stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            int idx0 = this.addVertex(centerX, centerY, 0, true);
            int increment = 1;
            int pidx = 0;
            int idx = 0;
            int i = startLUT;
            while (i < stopLUT) {
                ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                idx = this.addVertex(centerX + PGraphicsOpenGL.access$0()[ii] * hr, centerY + PGraphicsOpenGL.access$1()[ii] * vr, 0, i == startLUT && !fill);
                if (stroke) {
                    if (arcMode == 3) {
                        this.addEdge(pidx, idx, i == startLUT, false);
                    } else if (startLUT < i) {
                        this.addEdge(pidx, idx, i == startLUT + 1, arcMode == 0 && i == stopLUT - 1);
                    }
                }
                pidx = idx;
                i += increment;
            }
            idx = this.addVertex(centerX + PGraphicsOpenGL.access$0()[stopLUT % 720] * hr, centerY + PGraphicsOpenGL.access$1()[stopLUT % 720] * vr, 0, false);
            if (stroke && arcMode == 3) {
                this.addEdge(idx, idx0, false, false);
                this.closeEdge(idx, idx0);
            }
            if (arcMode == 2 || arcMode == 1) {
                pidx = idx;
                i = startLUT;
                ii = i % 720;
                if (ii < 0) {
                    ii += 720;
                }
                idx = this.addVertex(centerX + PGraphicsOpenGL.access$0()[ii] * hr, centerY + PGraphicsOpenGL.access$1()[ii] * vr, 0, false);
                if (stroke && arcMode == 2) {
                    this.addEdge(pidx, idx, false, true);
                }
            }
        }

        void addBox(float w, float h, float d, boolean fill, boolean stroke) {
            float x1 = -w / 2.0f;
            float x2 = w / 2.0f;
            float y1 = -h / 2.0f;
            float y2 = h / 2.0f;
            float z1 = -d / 2.0f;
            float z2 = d / 2.0f;
            int idx1 = 0;
            int idx2 = 0;
            int idx3 = 0;
            int idx4 = 0;
            if (fill || stroke) {
                this.setNormal(0.0f, 0.0f, -1.0f);
                idx1 = this.addVertex(x1, y1, z1, 0.0f, 0.0f, 0, true);
                idx2 = this.addVertex(x2, y1, z1, 1.0f, 0.0f, 0, false);
                idx3 = this.addVertex(x2, y2, z1, 1.0f, 1.0f, 0, false);
                idx4 = this.addVertex(x1, y2, z1, 0.0f, 1.0f, 0, false);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(0.0f, 0.0f, 1.0f);
                idx1 = this.addVertex(x2, y1, z2, 0.0f, 0.0f, 0, false);
                idx2 = this.addVertex(x1, y1, z2, 1.0f, 0.0f, 0, false);
                idx3 = this.addVertex(x1, y2, z2, 1.0f, 1.0f, 0, false);
                idx4 = this.addVertex(x2, y2, z2, 0.0f, 1.0f, 0, false);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(1.0f, 0.0f, 0.0f);
                idx1 = this.addVertex(x2, y1, z1, 0.0f, 0.0f, 0, false);
                idx2 = this.addVertex(x2, y1, z2, 1.0f, 0.0f, 0, false);
                idx3 = this.addVertex(x2, y2, z2, 1.0f, 1.0f, 0, false);
                idx4 = this.addVertex(x2, y2, z1, 0.0f, 1.0f, 0, false);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(-1.0f, 0.0f, 0.0f);
                idx1 = this.addVertex(x1, y1, z2, 0.0f, 0.0f, 0, false);
                idx2 = this.addVertex(x1, y1, z1, 1.0f, 0.0f, 0, false);
                idx3 = this.addVertex(x1, y2, z1, 1.0f, 1.0f, 0, false);
                idx4 = this.addVertex(x1, y2, z2, 0.0f, 1.0f, 0, false);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(0.0f, -1.0f, 0.0f);
                idx1 = this.addVertex(x1, y1, z2, 0.0f, 0.0f, 0, false);
                idx2 = this.addVertex(x2, y1, z2, 1.0f, 0.0f, 0, false);
                idx3 = this.addVertex(x2, y1, z1, 1.0f, 1.0f, 0, false);
                idx4 = this.addVertex(x1, y1, z1, 0.0f, 1.0f, 0, false);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
                this.setNormal(0.0f, 1.0f, 0.0f);
                idx1 = this.addVertex(x1, y2, z1, 0.0f, 0.0f, 0, false);
                idx2 = this.addVertex(x2, y2, z1, 1.0f, 0.0f, 0, false);
                idx3 = this.addVertex(x2, y2, z2, 1.0f, 1.0f, 0, false);
                idx4 = this.addVertex(x1, y2, z2, 0.0f, 1.0f, 0, false);
                if (stroke) {
                    this.addEdge(idx1, idx2, true, false);
                    this.addEdge(idx2, idx3, false, false);
                    this.addEdge(idx3, idx4, false, false);
                    this.addEdge(idx4, idx1, false, false);
                    this.closeEdge(idx4, idx1);
                }
            }
        }

        int[] addSphere(float r, int detailU, int detailV, boolean fill, boolean stroke) {
            int i1;
            int i0;
            int nind = 3 * detailU + (6 * detailU + 3) * (detailV - 2) + 3 * detailU;
            int[] indices = new int[nind];
            int vertCount = 0;
            int indCount = 0;
            float du = 1.0f / (float)detailU;
            float dv = 1.0f / (float)detailV;
            float u = 1.0f;
            float v = 1.0f;
            int i = 0;
            while (i < detailU) {
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(0.0f, r, 0.0f, u, v, 0, true);
                u -= du;
                ++i;
            }
            int vert0 = vertCount = detailU;
            u = 1.0f;
            v -= dv;
            i = 0;
            while (i < detailU) {
                this.setNormal(this.pg.sphereX[i], this.pg.sphereY[i], this.pg.sphereZ[i]);
                this.addVertex(r * this.pg.sphereX[i], r * this.pg.sphereY[i], r * this.pg.sphereZ[i], u, v, 0, false);
                u -= du;
                ++i;
            }
            vertCount += detailU;
            int vert1 = vertCount++;
            this.setNormal(this.pg.sphereX[0], this.pg.sphereY[0], this.pg.sphereZ[0]);
            this.addVertex(r * this.pg.sphereX[0], r * this.pg.sphereY[0], r * this.pg.sphereZ[0], u, v, 0, false);
            i = 0;
            while (i < detailU) {
                int i12 = vert0 + i;
                i0 = vert0 + i - detailU;
                indices[3 * i + 0] = i12;
                indices[3 * i + 1] = i0;
                indices[3 * i + 2] = i12 + 1;
                this.addEdge(i0, i12, true, true);
                this.addEdge(i12, i12 + 1, true, true);
                ++i;
            }
            indCount += 3 * detailU;
            int offset = 0;
            int j = 2;
            while (j < detailV) {
                offset += detailU;
                vert0 = vertCount;
                u = 1.0f;
                v -= dv;
                int i2 = 0;
                while (i2 < detailU) {
                    int ioff = offset + i2;
                    this.setNormal(this.pg.sphereX[ioff], this.pg.sphereY[ioff], this.pg.sphereZ[ioff]);
                    this.addVertex(r * this.pg.sphereX[ioff], r * this.pg.sphereY[ioff], r * this.pg.sphereZ[ioff], u, v, 0, false);
                    u -= du;
                    ++i2;
                }
                vertCount += detailU;
                vert1 = vertCount++;
                this.setNormal(this.pg.sphereX[offset], this.pg.sphereY[offset], this.pg.sphereZ[offset]);
                this.addVertex(r * this.pg.sphereX[offset], r * this.pg.sphereY[offset], r * this.pg.sphereZ[offset], u, v, 0, false);
                i2 = 0;
                while (i2 < detailU) {
                    i1 = vert0 + i2;
                    int i02 = vert0 + i2 - detailU - 1;
                    indices[indCount + 6 * i2 + 0] = i1;
                    indices[indCount + 6 * i2 + 1] = i02;
                    indices[indCount + 6 * i2 + 2] = i02 + 1;
                    indices[indCount + 6 * i2 + 3] = i1;
                    indices[indCount + 6 * i2 + 4] = i02 + 1;
                    indices[indCount + 6 * i2 + 5] = i1 + 1;
                    this.addEdge(i02, i1, true, true);
                    this.addEdge(i1, i1 + 1, true, true);
                    this.addEdge(i02 + 1, i1, true, true);
                    ++i2;
                }
                indices[(indCount += 6 * detailU) + 0] = vert1;
                indices[indCount + 1] = vert1 - detailU;
                indices[indCount + 2] = vert1 - 1;
                indCount += 3;
                this.addEdge(vert1 - detailU, vert1 - 1, true, true);
                this.addEdge(vert1 - 1, vert1, true, true);
                ++j;
            }
            u = 1.0f;
            v = 0.0f;
            int i3 = 0;
            while (i3 < detailU) {
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(0.0f, -r, 0.0f, u, v, 0, false);
                u -= du;
                ++i3;
            }
            vertCount += detailU;
            i3 = 0;
            while (i3 < detailU) {
                i0 = vert0 + i3;
                i1 = vert0 + i3 + detailU + 1;
                indices[indCount + 3 * i3 + 0] = i0;
                indices[indCount + 3 * i3 + 1] = i1;
                indices[indCount + 3 * i3 + 2] = i0 + 1;
                this.addEdge(i0, i0 + 1, true, true);
                this.addEdge(i0, i1, true, true);
                ++i3;
            }
            indCount += 3 * detailU;
            return indices;
        }
    }

    protected static class IndexCache {
        int size;
        int[] indexCount;
        int[] indexOffset;
        int[] vertexCount;
        int[] vertexOffset;

        IndexCache() {
            this.allocate();
        }

        void allocate() {
            this.indexCount = new int[2];
            this.indexOffset = new int[2];
            this.vertexCount = new int[2];
            this.vertexOffset = new int[2];
            this.size = 0;
        }

        void clear() {
            this.size = 0;
        }

        int addNew() {
            this.arrayCheck();
            this.init(this.size);
            ++this.size;
            return this.size - 1;
        }

        int addNew(int index) {
            this.arrayCheck();
            this.indexCount[this.size] = this.indexCount[index];
            this.indexOffset[this.size] = this.indexOffset[index];
            this.vertexCount[this.size] = this.vertexCount[index];
            this.vertexOffset[this.size] = this.vertexOffset[index];
            ++this.size;
            return this.size - 1;
        }

        int getLast() {
            if (this.size == 0) {
                this.arrayCheck();
                this.init(0);
                this.size = 1;
            }
            return this.size - 1;
        }

        void incCounts(int index, int icount, int vcount) {
            int n = index;
            this.indexCount[n] = this.indexCount[n] + icount;
            int n2 = index;
            this.vertexCount[n2] = this.vertexCount[n2] + vcount;
        }

        void init(int n) {
            if (n > 0) {
                this.indexOffset[n] = this.indexOffset[n - 1] + this.indexCount[n - 1];
                this.vertexOffset[n] = this.vertexOffset[n - 1] + this.vertexCount[n - 1];
            } else {
                this.indexOffset[n] = 0;
                this.vertexOffset[n] = 0;
            }
            this.indexCount[n] = 0;
            this.vertexCount[n] = 0;
        }

        void arrayCheck() {
            if (this.size == this.indexCount.length) {
                int newSize = this.size << 1;
                this.expandIndexCount(newSize);
                this.expandIndexOffset(newSize);
                this.expandVertexCount(newSize);
                this.expandVertexOffset(newSize);
            }
        }

        void expandIndexCount(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.indexCount, 0, temp, 0, this.size);
            this.indexCount = temp;
        }

        void expandIndexOffset(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.indexOffset, 0, temp, 0, this.size);
            this.indexOffset = temp;
        }

        void expandVertexCount(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.vertexCount, 0, temp, 0, this.size);
            this.vertexCount = temp;
        }

        void expandVertexOffset(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.vertexOffset, 0, temp, 0, this.size);
            this.vertexOffset = temp;
        }
    }

    protected static class TessGeometry {
        int renderMode;
        PGraphicsOpenGL pg;
        int polyVertexCount;
        int firstPolyVertex;
        int lastPolyVertex;
        FloatBuffer polyVerticesBuffer;
        IntBuffer polyColorsBuffer;
        FloatBuffer polyNormalsBuffer;
        FloatBuffer polyTexCoordsBuffer;
        IntBuffer polyAmbientBuffer;
        IntBuffer polySpecularBuffer;
        IntBuffer polyEmissiveBuffer;
        FloatBuffer polyShininessBuffer;
        int polyIndexCount;
        int firstPolyIndex;
        int lastPolyIndex;
        ShortBuffer polyIndicesBuffer;
        IndexCache polyIndexCache = new IndexCache();
        int lineVertexCount;
        int firstLineVertex;
        int lastLineVertex;
        FloatBuffer lineVerticesBuffer;
        IntBuffer lineColorsBuffer;
        FloatBuffer lineDirectionsBuffer;
        int lineIndexCount;
        int firstLineIndex;
        int lastLineIndex;
        ShortBuffer lineIndicesBuffer;
        IndexCache lineIndexCache = new IndexCache();
        int pointVertexCount;
        int firstPointVertex;
        int lastPointVertex;
        FloatBuffer pointVerticesBuffer;
        IntBuffer pointColorsBuffer;
        FloatBuffer pointOffsetsBuffer;
        int pointIndexCount;
        int firstPointIndex;
        int lastPointIndex;
        ShortBuffer pointIndicesBuffer;
        IndexCache pointIndexCache = new IndexCache();
        float[] polyVertices;
        int[] polyColors;
        float[] polyNormals;
        float[] polyTexCoords;
        int[] polyAmbient;
        int[] polySpecular;
        int[] polyEmissive;
        float[] polyShininess;
        short[] polyIndices;
        float[] lineVertices;
        int[] lineColors;
        float[] lineDirections;
        short[] lineIndices;
        float[] pointVertices;
        int[] pointColors;
        float[] pointOffsets;
        short[] pointIndices;

        TessGeometry(PGraphicsOpenGL pg, int mode) {
            this.pg = pg;
            this.renderMode = mode;
            this.allocate();
        }

        void allocate() {
            this.polyVertices = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.polyColors = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polyNormals = new float[3 * PGL.DEFAULT_TESS_VERTICES];
            this.polyTexCoords = new float[2 * PGL.DEFAULT_TESS_VERTICES];
            this.polyAmbient = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polySpecular = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polyEmissive = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polyShininess = new float[PGL.DEFAULT_TESS_VERTICES];
            this.polyIndices = new short[PGL.DEFAULT_TESS_VERTICES];
            this.lineVertices = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.lineColors = new int[PGL.DEFAULT_TESS_VERTICES];
            this.lineDirections = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.lineIndices = new short[PGL.DEFAULT_TESS_VERTICES];
            this.pointVertices = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.pointColors = new int[PGL.DEFAULT_TESS_VERTICES];
            this.pointOffsets = new float[2 * PGL.DEFAULT_TESS_VERTICES];
            this.pointIndices = new short[PGL.DEFAULT_TESS_VERTICES];
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
            this.clear();
        }

        void clear() {
            this.polyVertexCount = 0;
            this.lastPolyVertex = 0;
            this.firstPolyVertex = 0;
            this.polyIndexCount = 0;
            this.lastPolyIndex = 0;
            this.firstPolyIndex = 0;
            this.lineVertexCount = 0;
            this.lastLineVertex = 0;
            this.firstLineVertex = 0;
            this.lineIndexCount = 0;
            this.lastLineIndex = 0;
            this.firstLineIndex = 0;
            this.pointVertexCount = 0;
            this.lastPointVertex = 0;
            this.firstPointVertex = 0;
            this.pointIndexCount = 0;
            this.lastPointIndex = 0;
            this.firstPointIndex = 0;
            this.polyIndexCache.clear();
            this.lineIndexCache.clear();
            this.pointIndexCache.clear();
        }

        void polyVertexCheck() {
            if (this.polyVertexCount == this.polyVertices.length / 4) {
                int newSize = this.polyVertexCount << 1;
                this.expandPolyVertices(newSize);
                this.expandPolyColors(newSize);
                this.expandPolyNormals(newSize);
                this.expandPolyTexCoords(newSize);
                this.expandPolyAmbient(newSize);
                this.expandPolySpecular(newSize);
                this.expandPolyEmissive(newSize);
                this.expandPolyShininess(newSize);
            }
            this.firstPolyVertex = this.polyVertexCount++;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyVertexCheck(int count) {
            int oldSize = this.polyVertices.length / 4;
            if (this.polyVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.polyVertexCount + count);
                this.expandPolyVertices(newSize);
                this.expandPolyColors(newSize);
                this.expandPolyNormals(newSize);
                this.expandPolyTexCoords(newSize);
                this.expandPolyAmbient(newSize);
                this.expandPolySpecular(newSize);
                this.expandPolyEmissive(newSize);
                this.expandPolyShininess(newSize);
            }
            this.firstPolyVertex = this.polyVertexCount;
            this.polyVertexCount += count;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyIndexCheck(int count) {
            int oldSize = this.polyIndices.length;
            if (this.polyIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.polyIndexCount + count);
                this.expandPolyIndices(newSize);
            }
            this.firstPolyIndex = this.polyIndexCount;
            this.polyIndexCount += count;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void polyIndexCheck() {
            if (this.polyIndexCount == this.polyIndices.length) {
                int newSize = this.polyIndexCount << 1;
                this.expandPolyIndices(newSize);
            }
            this.firstPolyIndex = this.polyIndexCount++;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void lineVertexCheck(int count) {
            int oldSize = this.lineVertices.length / 4;
            if (this.lineVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.lineVertexCount + count);
                this.expandLineVertices(newSize);
                this.expandLineColors(newSize);
                this.expandLineDirections(newSize);
            }
            this.firstLineVertex = this.lineVertexCount;
            this.lineVertexCount += count;
            this.lastLineVertex = this.lineVertexCount - 1;
        }

        void lineIndexCheck(int count) {
            int oldSize = this.lineIndices.length;
            if (this.lineIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.lineIndexCount + count);
                this.expandLineIndices(newSize);
            }
            this.firstLineIndex = this.lineIndexCount;
            this.lineIndexCount += count;
            this.lastLineIndex = this.lineIndexCount - 1;
        }

        void pointVertexCheck(int count) {
            int oldSize = this.pointVertices.length / 4;
            if (this.pointVertexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.pointVertexCount + count);
                this.expandPointVertices(newSize);
                this.expandPointColors(newSize);
                this.expandPointOffsets(newSize);
            }
            this.firstPointVertex = this.pointVertexCount;
            this.pointVertexCount += count;
            this.lastPointVertex = this.pointVertexCount - 1;
        }

        void pointIndexCheck(int count) {
            int oldSize = this.pointIndices.length;
            if (this.pointIndexCount + count > oldSize) {
                int newSize = PGraphicsOpenGL.expandArraySize(oldSize, this.pointIndexCount + count);
                this.expandPointIndices(newSize);
            }
            this.firstPointIndex = this.pointIndexCount;
            this.pointIndexCount += count;
            this.lastPointIndex = this.pointIndexCount - 1;
        }

        boolean isFull() {
            return PGL.FLUSH_VERTEX_COUNT <= this.polyVertexCount || PGL.FLUSH_VERTEX_COUNT <= this.lineVertexCount || PGL.FLUSH_VERTEX_COUNT <= this.pointVertexCount;
        }

        void getPolyVertexMin(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.polyVertices[index++]);
                v.y = PApplet.min(v.y, this.polyVertices[index++]);
                v.z = PApplet.min(v.z, this.polyVertices[index]);
                ++i;
            }
        }

        void getLineVertexMin(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.lineVertices[index++]);
                v.y = PApplet.min(v.y, this.lineVertices[index++]);
                v.z = PApplet.min(v.z, this.lineVertices[index]);
                ++i;
            }
        }

        void getPointVertexMin(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x = PApplet.min(v.x, this.pointVertices[index++]);
                v.y = PApplet.min(v.y, this.pointVertices[index++]);
                v.z = PApplet.min(v.z, this.pointVertices[index]);
                ++i;
            }
        }

        void getPolyVertexMax(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.polyVertices[index++]);
                v.y = PApplet.max(v.y, this.polyVertices[index++]);
                v.z = PApplet.max(v.z, this.polyVertices[index]);
                ++i;
            }
        }

        void getLineVertexMax(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.lineVertices[index++]);
                v.y = PApplet.max(v.y, this.lineVertices[index++]);
                v.z = PApplet.max(v.z, this.lineVertices[index]);
                ++i;
            }
        }

        void getPointVertexMax(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x = PApplet.max(v.x, this.pointVertices[index++]);
                v.y = PApplet.max(v.y, this.pointVertices[index++]);
                v.z = PApplet.max(v.z, this.pointVertices[index]);
                ++i;
            }
        }

        int getPolyVertexSum(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x += this.polyVertices[index++];
                v.y += this.polyVertices[index++];
                v.z += this.polyVertices[index];
                ++i;
            }
            return last - first + 1;
        }

        int getLineVertexSum(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x += this.lineVertices[index++];
                v.y += this.lineVertices[index++];
                v.z += this.lineVertices[index];
                ++i;
            }
            return last - first + 1;
        }

        int getPointVertexSum(PVector v, int first, int last) {
            int i = first;
            while (i <= last) {
                int index = 4 * i;
                v.x += this.pointVertices[index++];
                v.y += this.pointVertices[index++];
                v.z += this.pointVertices[index];
                ++i;
            }
            return last - first + 1;
        }

        protected void updatePolyVerticesBuffer() {
            this.updatePolyVerticesBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyVerticesBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyVerticesBuffer, this.polyVertices, 4 * offset, 4 * size);
        }

        protected void updatePolyColorsBuffer() {
            this.updatePolyColorsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyColorsBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polyColorsBuffer, this.polyColors, offset, size);
        }

        protected void updatePolyNormalsBuffer() {
            this.updatePolyNormalsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyNormalsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyNormalsBuffer, this.polyNormals, 3 * offset, 3 * size);
        }

        protected void updatePolyTexCoordsBuffer() {
            this.updatePolyTexCoordsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyTexCoordsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyTexCoordsBuffer, this.polyTexCoords, 2 * offset, 2 * size);
        }

        protected void updatePolyAmbientBuffer() {
            this.updatePolyAmbientBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyAmbientBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polyAmbientBuffer, this.polyAmbient, offset, size);
        }

        protected void updatePolySpecularBuffer() {
            this.updatePolySpecularBuffer(0, this.polyVertexCount);
        }

        protected void updatePolySpecularBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polySpecularBuffer, this.polySpecular, offset, size);
        }

        protected void updatePolyEmissiveBuffer() {
            this.updatePolyEmissiveBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyEmissiveBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.polyEmissiveBuffer, this.polyEmissive, offset, size);
        }

        protected void updatePolyShininessBuffer() {
            this.updatePolyShininessBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyShininessBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.polyShininessBuffer, this.polyShininess, offset, size);
        }

        protected void updatePolyIndicesBuffer() {
            this.updatePolyIndicesBuffer(0, this.polyIndexCount);
        }

        protected void updatePolyIndicesBuffer(int offset, int size) {
            PGL.updateShortBuffer(this.polyIndicesBuffer, this.polyIndices, offset, size);
        }

        protected void updateLineVerticesBuffer() {
            this.updateLineVerticesBuffer(0, this.lineVertexCount);
        }

        protected void updateLineVerticesBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.lineVerticesBuffer, this.lineVertices, 4 * offset, 4 * size);
        }

        protected void updateLineColorsBuffer() {
            this.updateLineColorsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineColorsBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.lineColorsBuffer, this.lineColors, offset, size);
        }

        protected void updateLineDirectionsBuffer() {
            this.updateLineDirectionsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineDirectionsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.lineDirectionsBuffer, this.lineDirections, 4 * offset, 4 * size);
        }

        protected void updateLineIndicesBuffer() {
            this.updateLineIndicesBuffer(0, this.lineIndexCount);
        }

        protected void updateLineIndicesBuffer(int offset, int size) {
            PGL.updateShortBuffer(this.lineIndicesBuffer, this.lineIndices, offset, size);
        }

        protected void updatePointVerticesBuffer() {
            this.updatePointVerticesBuffer(0, this.pointVertexCount);
        }

        protected void updatePointVerticesBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.pointVerticesBuffer, this.pointVertices, 4 * offset, 4 * size);
        }

        protected void updatePointColorsBuffer() {
            this.updatePointColorsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointColorsBuffer(int offset, int size) {
            PGL.updateIntBuffer(this.pointColorsBuffer, this.pointColors, offset, size);
        }

        protected void updatePointOffsetsBuffer() {
            this.updatePointOffsetsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointOffsetsBuffer(int offset, int size) {
            PGL.updateFloatBuffer(this.pointOffsetsBuffer, this.pointOffsets, 2 * offset, 2 * size);
        }

        protected void updatePointIndicesBuffer() {
            this.updatePointIndicesBuffer(0, this.pointIndexCount);
        }

        protected void updatePointIndicesBuffer(int offset, int size) {
            PGL.updateShortBuffer(this.pointIndicesBuffer, this.pointIndices, offset, size);
        }

        void expandPolyVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.polyVertices, 0, temp, 0, 4 * this.polyVertexCount);
            this.polyVertices = temp;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void expandPolyColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyColors, 0, temp, 0, this.polyVertexCount);
            this.polyColors = temp;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void expandPolyNormals(int n) {
            float[] temp = new float[3 * n];
            PApplet.arrayCopy(this.polyNormals, 0, temp, 0, 3 * this.polyVertexCount);
            this.polyNormals = temp;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void expandPolyTexCoords(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.polyTexCoords, 0, temp, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = temp;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void expandPolyAmbient(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyAmbient, 0, temp, 0, this.polyVertexCount);
            this.polyAmbient = temp;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void expandPolySpecular(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polySpecular, 0, temp, 0, this.polyVertexCount);
            this.polySpecular = temp;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void expandPolyEmissive(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.polyEmissive, 0, temp, 0, this.polyVertexCount);
            this.polyEmissive = temp;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void expandPolyShininess(int n) {
            float[] temp = new float[n];
            PApplet.arrayCopy(this.polyShininess, 0, temp, 0, this.polyVertexCount);
            this.polyShininess = temp;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void expandPolyIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.polyIndices, 0, temp, 0, this.polyIndexCount);
            this.polyIndices = temp;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void expandLineVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.lineVertices, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineVertices = temp;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void expandLineColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lineColors, 0, temp, 0, this.lineVertexCount);
            this.lineColors = temp;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void expandLineDirections(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.lineDirections, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineDirections = temp;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void expandLineIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.lineIndices, 0, temp, 0, this.lineIndexCount);
            this.lineIndices = temp;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void expandPointVertices(int n) {
            float[] temp = new float[4 * n];
            PApplet.arrayCopy(this.pointVertices, 0, temp, 0, 4 * this.pointVertexCount);
            this.pointVertices = temp;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void expandPointColors(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.pointColors, 0, temp, 0, this.pointVertexCount);
            this.pointColors = temp;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void expandPointOffsets(int n) {
            float[] temp = new float[2 * n];
            PApplet.arrayCopy(this.pointOffsets, 0, temp, 0, 2 * this.pointVertexCount);
            this.pointOffsets = temp;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void expandPointIndices(int n) {
            short[] temp = new short[n];
            PApplet.arrayCopy(this.pointIndices, 0, temp, 0, this.pointIndexCount);
            this.pointIndices = temp;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void trim() {
            if (this.polyVertexCount > 0 && this.polyVertexCount < this.polyVertices.length / 4) {
                this.trimPolyVertices();
                this.trimPolyColors();
                this.trimPolyNormals();
                this.trimPolyTexCoords();
                this.trimPolyAmbient();
                this.trimPolySpecular();
                this.trimPolyEmissive();
                this.trimPolyShininess();
            }
            if (this.polyIndexCount > 0 && this.polyIndexCount < this.polyIndices.length) {
                this.trimPolyIndices();
            }
            if (this.lineVertexCount > 0 && this.lineVertexCount < this.lineVertices.length / 4) {
                this.trimLineVertices();
                this.trimLineColors();
                this.trimLineDirections();
            }
            if (this.lineIndexCount > 0 && this.lineIndexCount < this.lineIndices.length) {
                this.trimLineIndices();
            }
            if (this.pointVertexCount > 0 && this.pointVertexCount < this.pointVertices.length / 4) {
                this.trimPointVertices();
                this.trimPointColors();
                this.trimPointOffsets();
            }
            if (this.pointIndexCount > 0 && this.pointIndexCount < this.pointIndices.length) {
                this.trimPointIndices();
            }
        }

        void trimPolyVertices() {
            float[] temp = new float[4 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyVertices, 0, temp, 0, 4 * this.polyVertexCount);
            this.polyVertices = temp;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void trimPolyColors() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyColors, 0, temp, 0, this.polyVertexCount);
            this.polyColors = temp;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void trimPolyNormals() {
            float[] temp = new float[3 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyNormals, 0, temp, 0, 3 * this.polyVertexCount);
            this.polyNormals = temp;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void trimPolyTexCoords() {
            float[] temp = new float[2 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyTexCoords, 0, temp, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = temp;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void trimPolyAmbient() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyAmbient, 0, temp, 0, this.polyVertexCount);
            this.polyAmbient = temp;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void trimPolySpecular() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polySpecular, 0, temp, 0, this.polyVertexCount);
            this.polySpecular = temp;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void trimPolyEmissive() {
            int[] temp = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyEmissive, 0, temp, 0, this.polyVertexCount);
            this.polyEmissive = temp;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void trimPolyShininess() {
            float[] temp = new float[this.polyVertexCount];
            PApplet.arrayCopy(this.polyShininess, 0, temp, 0, this.polyVertexCount);
            this.polyShininess = temp;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void trimPolyIndices() {
            short[] temp = new short[this.polyIndexCount];
            PApplet.arrayCopy(this.polyIndices, 0, temp, 0, this.polyIndexCount);
            this.polyIndices = temp;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void trimLineVertices() {
            float[] temp = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineVertices, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineVertices = temp;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void trimLineColors() {
            int[] temp = new int[this.lineVertexCount];
            PApplet.arrayCopy(this.lineColors, 0, temp, 0, this.lineVertexCount);
            this.lineColors = temp;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void trimLineDirections() {
            float[] temp = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineDirections, 0, temp, 0, 4 * this.lineVertexCount);
            this.lineDirections = temp;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void trimLineIndices() {
            short[] temp = new short[this.lineIndexCount];
            PApplet.arrayCopy(this.lineIndices, 0, temp, 0, this.lineIndexCount);
            this.lineIndices = temp;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void trimPointVertices() {
            float[] temp = new float[4 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointVertices, 0, temp, 0, 4 * this.pointVertexCount);
            this.pointVertices = temp;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void trimPointColors() {
            int[] temp = new int[this.pointVertexCount];
            PApplet.arrayCopy(this.pointColors, 0, temp, 0, this.pointVertexCount);
            this.pointColors = temp;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void trimPointOffsets() {
            float[] temp = new float[2 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointOffsets, 0, temp, 0, 2 * this.pointVertexCount);
            this.pointOffsets = temp;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void trimPointIndices() {
            short[] temp = new short[this.pointIndexCount];
            PApplet.arrayCopy(this.pointIndices, 0, temp, 0, this.pointIndexCount);
            this.pointIndices = temp;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void incPolyIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.polyIndices[n] = (short)(this.polyIndices[n] + inc);
            }
        }

        void incLineIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.lineIndices[n] = (short)(this.lineIndices[n] + inc);
            }
        }

        void incPointIndices(int first, int last, int inc) {
            int i = first;
            while (i <= last) {
                int n = i++;
                this.pointIndices[n] = (short)(this.pointIndices[n] + inc);
            }
        }

        void calcPolyNormal(int i0, int i1, int i2) {
            int index = 4 * i0;
            float x0 = this.polyVertices[index++];
            float y0 = this.polyVertices[index++];
            float z0 = this.polyVertices[index];
            index = 4 * i1;
            float x1 = this.polyVertices[index++];
            float y1 = this.polyVertices[index++];
            float z1 = this.polyVertices[index];
            index = 4 * i2;
            float x2 = this.polyVertices[index++];
            float y2 = this.polyVertices[index++];
            float z2 = this.polyVertices[index];
            float v12x = x2 - x1;
            float v12y = y2 - y1;
            float v12z = z2 - z1;
            float v10x = x0 - x1;
            float v10y = y0 - y1;
            float v10z = z0 - z1;
            float nx = v12y * v10z - v10y * v12z;
            float ny = v12z * v10x - v10z * v12x;
            float nz = v12x * v10y - v10x * v12y;
            float d = PApplet.sqrt(nx * nx + ny * ny + nz * nz);
            index = 3 * i0;
            this.polyNormals[index++] = nx /= d;
            this.polyNormals[index++] = ny /= d;
            this.polyNormals[index] = nz /= d;
            index = 3 * i1;
            this.polyNormals[index++] = nx;
            this.polyNormals[index++] = ny;
            this.polyNormals[index] = nz;
            index = 3 * i2;
            this.polyNormals[index++] = nx;
            this.polyNormals[index++] = ny;
            this.polyNormals[index] = nz;
        }

        void setPointVertex(int tessIdx, InGeometry in, int inIdx) {
            int index = 3 * inIdx;
            float x = in.vertices[index++];
            float y = in.vertices[index++];
            float z = in.vertices[index];
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D mm = this.pg.modelview;
                index = 4 * tessIdx;
                this.pointVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                this.pointVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                this.pointVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.pointVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
            } else {
                index = 4 * tessIdx;
                this.pointVertices[index++] = x;
                this.pointVertices[index++] = y;
                this.pointVertices[index++] = z;
                this.pointVertices[index] = 1.0f;
            }
            this.pointColors[tessIdx] = in.strokeColors[inIdx];
        }

        void setLineVertex(int tessIdx, float[] vertices, int inIdx0, int rgba) {
            int index = 3 * inIdx0;
            float x0 = vertices[index++];
            float y0 = vertices[index++];
            float z0 = vertices[index];
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D mm = this.pg.modelview;
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0 * mm.m00 + y0 * mm.m01 + z0 * mm.m02 + mm.m03;
                this.lineVertices[index++] = x0 * mm.m10 + y0 * mm.m11 + z0 * mm.m12 + mm.m13;
                this.lineVertices[index++] = x0 * mm.m20 + y0 * mm.m21 + z0 * mm.m22 + mm.m23;
                this.lineVertices[index] = x0 * mm.m30 + y0 * mm.m31 + z0 * mm.m32 + mm.m33;
            } else {
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0;
                this.lineVertices[index++] = y0;
                this.lineVertices[index++] = z0;
                this.lineVertices[index] = 1.0f;
            }
            this.lineColors[tessIdx] = rgba;
            index = 4 * tessIdx;
            this.lineDirections[index++] = 0.0f;
            this.lineDirections[index++] = 0.0f;
            this.lineDirections[index++] = 0.0f;
            this.lineDirections[index] = 0.0f;
        }

        void setLineVertex(int tessIdx, float[] vertices, int inIdx0, int inIdx1, int rgba, float weight) {
            int index = 3 * inIdx0;
            float x0 = vertices[index++];
            float y0 = vertices[index++];
            float z0 = vertices[index];
            index = 3 * inIdx1;
            float x1 = vertices[index++];
            float y1 = vertices[index++];
            float z1 = vertices[index];
            float dx = x1 - x0;
            float dy = y1 - y0;
            float dz = z1 - z0;
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D mm = this.pg.modelview;
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0 * mm.m00 + y0 * mm.m01 + z0 * mm.m02 + mm.m03;
                this.lineVertices[index++] = x0 * mm.m10 + y0 * mm.m11 + z0 * mm.m12 + mm.m13;
                this.lineVertices[index++] = x0 * mm.m20 + y0 * mm.m21 + z0 * mm.m22 + mm.m23;
                this.lineVertices[index] = x0 * mm.m30 + y0 * mm.m31 + z0 * mm.m32 + mm.m33;
                index = 4 * tessIdx;
                this.lineDirections[index++] = dx * mm.m00 + dy * mm.m01 + dz * mm.m02;
                this.lineDirections[index++] = dx * mm.m10 + dy * mm.m11 + dz * mm.m12;
                this.lineDirections[index] = dx * mm.m20 + dy * mm.m21 + dz * mm.m22;
            } else {
                index = 4 * tessIdx;
                this.lineVertices[index++] = x0;
                this.lineVertices[index++] = y0;
                this.lineVertices[index++] = z0;
                this.lineVertices[index] = 1.0f;
                index = 4 * tessIdx;
                this.lineDirections[index++] = dx;
                this.lineDirections[index++] = dy;
                this.lineDirections[index] = dz;
            }
            this.lineColors[tessIdx] = rgba;
            this.lineDirections[4 * tessIdx + 3] = weight;
        }

        void addPolyVertex(float x, float y, float z, int rgba, float nx, float ny, float nz, float u, float v, int am, int sp, int em, float shine, boolean clampXY) {
            this.polyVertexCheck();
            int tessIdx = this.polyVertexCount - 1;
            this.setPolyVertex(tessIdx, x, y, z, rgba, nx, ny, nz, u, v, am, sp, em, shine, clampXY);
        }

        void setPolyVertex(int tessIdx, float x, float y, float z, int rgba, boolean clampXY) {
            this.setPolyVertex(tessIdx, x, y, z, rgba, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, clampXY);
        }

        void setPolyVertex(int tessIdx, float x, float y, float z, int rgba, float nx, float ny, float nz, float u, float v, int am, int sp, int em, float shine, boolean clampXY) {
            int index;
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D mm = this.pg.modelview;
                PMatrix3D nm = this.pg.modelviewInv;
                index = 4 * tessIdx;
                if (clampXY) {
                    this.polyVertices[index++] = PApplet.ceil(x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03);
                    this.polyVertices[index++] = PApplet.ceil(x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13);
                } else {
                    this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                    this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                }
                this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                index = 3 * tessIdx;
                this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
            } else {
                index = 4 * tessIdx;
                this.polyVertices[index++] = x;
                this.polyVertices[index++] = y;
                this.polyVertices[index++] = z;
                this.polyVertices[index] = 1.0f;
                index = 3 * tessIdx;
                this.polyNormals[index++] = nx;
                this.polyNormals[index++] = ny;
                this.polyNormals[index] = nz;
            }
            this.polyColors[tessIdx] = rgba;
            index = 2 * tessIdx;
            this.polyTexCoords[index++] = u;
            this.polyTexCoords[index] = v;
            this.polyAmbient[tessIdx] = am;
            this.polySpecular[tessIdx] = sp;
            this.polyEmissive[tessIdx] = em;
            this.polyShininess[tessIdx] = shine;
        }

        void addPolyVertices(InGeometry in, boolean clampXY) {
            this.addPolyVertices(in, 0, in.vertexCount - 1, clampXY);
        }

        void addPolyVertex(InGeometry in, int i, boolean clampXY) {
            this.addPolyVertices(in, i, i, clampXY);
        }

        void addPolyVertices(InGeometry in, int i0, int i1, boolean clampXY) {
            int tessIdx;
            int index;
            int nvert = i1 - i0 + 1;
            this.polyVertexCheck(nvert);
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D mm = this.pg.modelview;
                PMatrix3D nm = this.pg.modelviewInv;
                int i = 0;
                while (i < nvert) {
                    int inIdx = i0 + i;
                    int tessIdx2 = this.firstPolyVertex + i;
                    index = 3 * inIdx;
                    float x = in.vertices[index++];
                    float y = in.vertices[index++];
                    float z = in.vertices[index];
                    index = 3 * inIdx;
                    float nx = in.normals[index++];
                    float ny = in.normals[index++];
                    float nz = in.normals[index];
                    index = 4 * tessIdx2;
                    if (clampXY) {
                        this.polyVertices[index++] = PApplet.ceil(x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03);
                        this.polyVertices[index++] = PApplet.ceil(x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13);
                    } else {
                        this.polyVertices[index++] = x * mm.m00 + y * mm.m01 + z * mm.m02 + mm.m03;
                        this.polyVertices[index++] = x * mm.m10 + y * mm.m11 + z * mm.m12 + mm.m13;
                    }
                    this.polyVertices[index++] = x * mm.m20 + y * mm.m21 + z * mm.m22 + mm.m23;
                    this.polyVertices[index] = x * mm.m30 + y * mm.m31 + z * mm.m32 + mm.m33;
                    index = 3 * tessIdx2;
                    this.polyNormals[index++] = nx * nm.m00 + ny * nm.m10 + nz * nm.m20;
                    this.polyNormals[index++] = nx * nm.m01 + ny * nm.m11 + nz * nm.m21;
                    this.polyNormals[index] = nx * nm.m02 + ny * nm.m12 + nz * nm.m22;
                    ++i;
                }
            } else if (nvert <= PGL.MIN_ARRAYCOPY_SIZE) {
                int i = 0;
                while (i < nvert) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    index = 3 * inIdx;
                    float x = in.vertices[index++];
                    float y = in.vertices[index++];
                    float z = in.vertices[index];
                    index = 3 * inIdx;
                    float nx = in.normals[index++];
                    float ny = in.normals[index++];
                    float nz = in.normals[index];
                    index = 4 * tessIdx;
                    this.polyVertices[index++] = x;
                    this.polyVertices[index++] = y;
                    this.polyVertices[index++] = z;
                    this.polyVertices[index] = 1.0f;
                    index = 3 * tessIdx;
                    this.polyNormals[index++] = nx;
                    this.polyNormals[index++] = ny;
                    this.polyNormals[index] = nz;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < nvert) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    PApplet.arrayCopy(in.vertices, 3 * inIdx, this.polyVertices, 4 * tessIdx, 3);
                    this.polyVertices[4 * tessIdx + 3] = 1.0f;
                    ++i;
                }
                PApplet.arrayCopy(in.normals, 3 * i0, this.polyNormals, 3 * this.firstPolyVertex, 3 * nvert);
            }
            if (nvert <= PGL.MIN_ARRAYCOPY_SIZE) {
                int i = 0;
                while (i < nvert) {
                    int inIdx = i0 + i;
                    tessIdx = this.firstPolyVertex + i;
                    index = 2 * inIdx;
                    float u = in.texcoords[index++];
                    float v = in.texcoords[index];
                    this.polyColors[tessIdx] = in.colors[inIdx];
                    index = 2 * tessIdx;
                    this.polyTexCoords[index++] = u;
                    this.polyTexCoords[index] = v;
                    this.polyAmbient[tessIdx] = in.ambient[inIdx];
                    this.polySpecular[tessIdx] = in.specular[inIdx];
                    this.polyEmissive[tessIdx] = in.emissive[inIdx];
                    this.polyShininess[tessIdx] = in.shininess[inIdx];
                    ++i;
                }
            } else {
                PApplet.arrayCopy(in.colors, i0, this.polyColors, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.texcoords, 2 * i0, this.polyTexCoords, 2 * this.firstPolyVertex, 2 * nvert);
                PApplet.arrayCopy(in.ambient, i0, this.polyAmbient, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.specular, i0, this.polySpecular, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.emissive, i0, this.polyEmissive, this.firstPolyVertex, nvert);
                PApplet.arrayCopy(in.shininess, i0, this.polyShininess, this.firstPolyVertex, nvert);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnPolyGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnPolyGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnLineGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnLineGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnLineGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnPointGeometry(PMatrix tr, int first, int last) {
            if (tr instanceof PMatrix2D) {
                this.applyMatrixOnPointGeometry((PMatrix2D)tr, first, last);
            } else if (tr instanceof PMatrix3D) {
                this.applyMatrixOnPointGeometry((PMatrix3D)tr, first, last);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                int i = first;
                while (i <= last) {
                    int index = 4 * i;
                    float x = this.polyVertices[index++];
                    float y = this.polyVertices[index];
                    index = 3 * i;
                    float nx = this.polyNormals[index++];
                    float ny = this.polyNormals[index];
                    index = 4 * i;
                    this.polyVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.polyVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    index = 3 * i;
                    this.polyNormals[index++] = nx * tr.m00 + ny * tr.m01;
                    this.polyNormals[index] = nx * tr.m10 + ny * tr.m11;
                    ++i;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                int i = first;
                while (i <= last) {
                    int index = 4 * i;
                    float x = this.lineVertices[index++];
                    float y = this.lineVertices[index];
                    index = 4 * i;
                    float xa = this.lineDirections[index++];
                    float ya = this.lineDirections[index];
                    float dx = xa - x;
                    float dy = ya - y;
                    index = 4 * i;
                    this.lineVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.lineVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    index = 4 * i;
                    this.lineDirections[index++] = dx * tr.m00 + dy * tr.m01;
                    this.lineDirections[index] = dx * tr.m10 + dy * tr.m11;
                    ++i;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix2D tr, int first, int last) {
            if (first < last) {
                int i = first;
                while (i <= last) {
                    int index = 4 * i;
                    float x = this.pointVertices[index++];
                    float y = this.pointVertices[index];
                    index = 4 * i;
                    this.pointVertices[index++] = x * tr.m00 + y * tr.m01 + tr.m02;
                    this.pointVertices[index] = x * tr.m10 + y * tr.m11 + tr.m12;
                    ++i;
                }
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                int i = first;
                while (i <= last) {
                    int index = 4 * i;
                    float x = this.polyVertices[index++];
                    float y = this.polyVertices[index++];
                    float z = this.polyVertices[index++];
                    float w = this.polyVertices[index];
                    index = 3 * i;
                    float nx = this.polyNormals[index++];
                    float ny = this.polyNormals[index++];
                    float nz = this.polyNormals[index];
                    index = 4 * i;
                    this.polyVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.polyVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.polyVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.polyVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    index = 3 * i;
                    this.polyNormals[index++] = nx * tr.m00 + ny * tr.m01 + nz * tr.m02;
                    this.polyNormals[index++] = nx * tr.m10 + ny * tr.m11 + nz * tr.m12;
                    this.polyNormals[index] = nx * tr.m20 + ny * tr.m21 + nz * tr.m22;
                    ++i;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                int i = first;
                while (i <= last) {
                    int index = 4 * i;
                    float x = this.lineVertices[index++];
                    float y = this.lineVertices[index++];
                    float z = this.lineVertices[index++];
                    float w = this.lineVertices[index];
                    index = 4 * i;
                    float xa = this.lineDirections[index++];
                    float ya = this.lineDirections[index++];
                    float za = this.lineDirections[index];
                    float dx = xa - x;
                    float dy = ya - y;
                    float dz = za - z;
                    index = 4 * i;
                    this.lineVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.lineVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.lineVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.lineVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    index = 4 * i;
                    this.lineDirections[index++] = dx * tr.m00 + dy * tr.m01 + dz * tr.m02;
                    this.lineDirections[index++] = dx * tr.m10 + dy * tr.m11 + dz * tr.m12;
                    this.lineDirections[index] = dx * tr.m20 + dy * tr.m21 + dz * tr.m22;
                    ++i;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix3D tr, int first, int last) {
            if (first < last) {
                int i = first;
                while (i <= last) {
                    int index = 4 * i;
                    float x = this.pointVertices[index++];
                    float y = this.pointVertices[index++];
                    float z = this.pointVertices[index++];
                    float w = this.pointVertices[index];
                    index = 4 * i;
                    this.pointVertices[index++] = x * tr.m00 + y * tr.m01 + z * tr.m02 + w * tr.m03;
                    this.pointVertices[index++] = x * tr.m10 + y * tr.m11 + z * tr.m12 + w * tr.m13;
                    this.pointVertices[index++] = x * tr.m20 + y * tr.m21 + z * tr.m22 + w * tr.m23;
                    this.pointVertices[index] = x * tr.m30 + y * tr.m31 + z * tr.m32 + w * tr.m33;
                    ++i;
                }
            }
        }
    }

    protected static class Tessellator {
        InGeometry in;
        TessGeometry tess;
        TexCache texCache;
        PImage prevTexImage;
        PImage newTexImage;
        int firstTexIndex;
        int firstTexCache;
        PGL.Tessellator gluTess;
        TessellatorCallback callback;
        boolean fill;
        boolean stroke;
        int strokeColor;
        float strokeWeight;
        int strokeJoin;
        int strokeCap;
        boolean accurate2DStrokes = true;
        PMatrix transform = null;
        float transformScale;
        boolean is2D = false;
        boolean is3D = true;
        protected PGraphicsOpenGL pg;
        int[] rawIndices = new int[512];
        int rawSize;
        int[] dupIndices;
        int dupCount;
        int firstPolyIndexCache;
        int lastPolyIndexCache;
        int firstLineIndexCache;
        int lastLineIndexCache;
        int firstPointIndexCache;
        int lastPointIndexCache;
        float[] strokeVertices;
        int[] strokeColors;
        float[] strokeWeights;
        int pathVertexCount;
        float[] pathVertices;
        int[] pathColors;
        float[] pathWeights;
        int beginPath;

        void initGluTess() {
            if (this.gluTess == null) {
                this.callback = new TessellatorCallback();
                this.gluTess = this.pg.pgl.createTessellator(this.callback);
            }
        }

        void setInGeometry(InGeometry in) {
            this.in = in;
            this.firstPolyIndexCache = -1;
            this.lastPolyIndexCache = -1;
            this.firstLineIndexCache = -1;
            this.lastLineIndexCache = -1;
            this.firstPointIndexCache = -1;
            this.lastPointIndexCache = -1;
        }

        void setTessGeometry(TessGeometry tess) {
            this.tess = tess;
        }

        void setFill(boolean fill) {
            this.fill = fill;
        }

        void setTexCache(TexCache texCache, PImage newTexImage) {
            this.texCache = texCache;
            this.newTexImage = newTexImage;
        }

        void setStroke(boolean stroke) {
            this.stroke = stroke;
        }

        void setStrokeColor(int color) {
            this.strokeColor = PGL.javaToNativeARGB(color);
        }

        void setStrokeWeight(float weight) {
            this.strokeWeight = weight;
        }

        void setStrokeCap(int strokeCap) {
            this.strokeCap = strokeCap;
        }

        void setStrokeJoin(int strokeJoin) {
            this.strokeJoin = strokeJoin;
        }

        void setAccurate2DStrokes(boolean accurate) {
            this.accurate2DStrokes = accurate;
        }

        protected void setRenderer(PGraphicsOpenGL pg) {
            this.pg = pg;
        }

        void set3D(boolean value) {
            if (value) {
                this.is2D = false;
                this.is3D = true;
            } else {
                this.is2D = true;
                this.is3D = false;
            }
        }

        void setTransform(PMatrix transform) {
            this.transform = transform;
            this.transformScale = -1.0f;
        }

        void resetCurveVertexCount() {
            this.pg.curveVertexCount = 0;
        }

        void tessellatePoints() {
            if (this.strokeCap == 2) {
                this.tessellateRoundPoints();
            } else {
                this.tessellateSquarePoints();
            }
        }

        void tessellateRoundPoints() {
            int nInVert = this.in.vertexCount;
            if (this.stroke && 1 <= nInVert) {
                int nPtVert = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * this.strokeWeight / 10.0f))) + 1;
                if (PGL.MAX_VERTEX_INDEX1 <= nPtVert) {
                    throw new RuntimeException("Error in point tessellation.");
                }
                this.updateTex();
                int nvertTot = nPtVert * nInVert;
                int nindTot = 3 * (nPtVert - 1) * nInVert;
                if (this.is3D) {
                    this.tessellateRoundPoints3D(nvertTot, nindTot, nPtVert);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateRoundPoints2D(nvertTot, nindTot, nPtVert);
                    this.endNoTex();
                }
            }
        }

        void tessellateRoundPoints3D(int nvertTot, int nindTot, int nPtVert) {
            int index;
            int perim = nPtVert - 1;
            this.tess.pointVertexCheck(nvertTot);
            this.tess.pointIndexCheck(nindTot);
            int vertIdx = this.tess.firstPointVertex;
            int attribIdx = this.tess.firstPointVertex;
            int indIdx = this.tess.firstPointIndex;
            IndexCache cache = this.tess.pointIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int i = 0;
            while (i < this.in.vertexCount) {
                int count = cache.vertexCount[index];
                if (PGL.MAX_VERTEX_INDEX1 <= count + nPtVert) {
                    index = cache.addNew();
                    count = 0;
                }
                int k = 0;
                while (k < nPtVert) {
                    this.tess.setPointVertex(vertIdx, this.in, i);
                    ++vertIdx;
                    ++k;
                }
                this.tess.pointOffsets[2 * attribIdx + 0] = 0.0f;
                this.tess.pointOffsets[2 * attribIdx + 1] = 0.0f;
                ++attribIdx;
                float val = 0.0f;
                float inc = 720.0f / (float)perim;
                int k2 = 0;
                while (k2 < perim) {
                    this.tess.pointOffsets[2 * attribIdx + 0] = 0.5f * PGraphicsOpenGL.access$0()[(int)val] * this.strokeWeight;
                    this.tess.pointOffsets[2 * attribIdx + 1] = 0.5f * PGraphicsOpenGL.access$1()[(int)val] * this.strokeWeight;
                    val = (val + inc) % 720.0f;
                    ++attribIdx;
                    ++k2;
                }
                k2 = 1;
                while (k2 < nPtVert - 1) {
                    this.tess.pointIndices[indIdx++] = (short)(count + 0);
                    this.tess.pointIndices[indIdx++] = (short)(count + k2);
                    this.tess.pointIndices[indIdx++] = (short)(count + k2 + 1);
                    ++k2;
                }
                this.tess.pointIndices[indIdx++] = (short)(count + 0);
                this.tess.pointIndices[indIdx++] = (short)(count + 1);
                this.tess.pointIndices[indIdx++] = (short)(count + nPtVert - 1);
                cache.incCounts(index, 3 * (nPtVert - 1), nPtVert);
                ++i;
            }
            this.lastPointIndexCache = index;
        }

        void tessellateRoundPoints2D(int nvertTot, int nindTot, int nPtVert) {
            int index;
            int perim = nPtVert - 1;
            this.tess.polyVertexCheck(nvertTot);
            this.tess.polyIndexCheck(nindTot);
            int vertIdx = this.tess.firstPolyVertex;
            int indIdx = this.tess.firstPolyIndex;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int i = 0;
            while (i < this.in.vertexCount) {
                int count = cache.vertexCount[index];
                if (PGL.MAX_VERTEX_INDEX1 <= count + nPtVert) {
                    index = cache.addNew();
                    count = 0;
                }
                float x0 = this.in.vertices[3 * i + 0];
                float y0 = this.in.vertices[3 * i + 1];
                int rgba = this.in.strokeColors[i];
                float val = 0.0f;
                float inc = 720.0f / (float)perim;
                this.tess.setPolyVertex(vertIdx, x0, y0, 0.0f, rgba, false);
                ++vertIdx;
                int k = 0;
                while (k < perim) {
                    this.tess.setPolyVertex(vertIdx, x0 + 0.5f * PGraphicsOpenGL.access$0()[(int)val] * this.strokeWeight, y0 + 0.5f * PGraphicsOpenGL.access$1()[(int)val] * this.strokeWeight, 0.0f, rgba, false);
                    ++vertIdx;
                    val = (val + inc) % 720.0f;
                    ++k;
                }
                k = 1;
                while (k < nPtVert - 1) {
                    this.tess.polyIndices[indIdx++] = (short)(count + 0);
                    this.tess.polyIndices[indIdx++] = (short)(count + k);
                    this.tess.polyIndices[indIdx++] = (short)(count + k + 1);
                    ++k;
                }
                this.tess.polyIndices[indIdx++] = (short)(count + 0);
                this.tess.polyIndices[indIdx++] = (short)(count + 1);
                this.tess.polyIndices[indIdx++] = (short)(count + nPtVert - 1);
                cache.incCounts(index, 3 * (nPtVert - 1), nPtVert);
                ++i;
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = index;
        }

        void tessellateSquarePoints() {
            int nInVert = this.in.vertexCount;
            if (this.stroke && 1 <= nInVert) {
                this.updateTex();
                int quadCount = nInVert;
                int nvertTot = 5 * quadCount;
                int nindTot = 12 * quadCount;
                if (this.is3D) {
                    this.tessellateSquarePoints3D(nvertTot, nindTot);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateSquarePoints2D(nvertTot, nindTot);
                    this.endNoTex();
                }
            }
        }

        void tessellateSquarePoints3D(int nvertTot, int nindTot) {
            int index;
            this.tess.pointVertexCheck(nvertTot);
            this.tess.pointIndexCheck(nindTot);
            int vertIdx = this.tess.firstPointVertex;
            int attribIdx = this.tess.firstPointVertex;
            int indIdx = this.tess.firstPointIndex;
            IndexCache cache = this.tess.pointIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int i = 0;
            while (i < this.in.vertexCount) {
                int count = cache.vertexCount[index];
                int nvert = 5;
                if (PGL.MAX_VERTEX_INDEX1 <= count + nvert) {
                    index = cache.addNew();
                    count = 0;
                }
                int k = 0;
                while (k < nvert) {
                    this.tess.setPointVertex(vertIdx, this.in, i);
                    ++vertIdx;
                    ++k;
                }
                this.tess.pointOffsets[2 * attribIdx + 0] = 0.0f;
                this.tess.pointOffsets[2 * attribIdx + 1] = 0.0f;
                ++attribIdx;
                k = 0;
                while (k < 4) {
                    this.tess.pointOffsets[2 * attribIdx + 0] = 0.5f * QUAD_POINT_SIGNS[k][0] * this.strokeWeight;
                    this.tess.pointOffsets[2 * attribIdx + 1] = 0.5f * QUAD_POINT_SIGNS[k][1] * this.strokeWeight;
                    ++attribIdx;
                    ++k;
                }
                k = 1;
                while (k < nvert - 1) {
                    this.tess.pointIndices[indIdx++] = (short)(count + 0);
                    this.tess.pointIndices[indIdx++] = (short)(count + k);
                    this.tess.pointIndices[indIdx++] = (short)(count + k + 1);
                    ++k;
                }
                this.tess.pointIndices[indIdx++] = (short)(count + 0);
                this.tess.pointIndices[indIdx++] = (short)(count + 1);
                this.tess.pointIndices[indIdx++] = (short)(count + nvert - 1);
                cache.incCounts(index, 12, 5);
                ++i;
            }
            this.lastPointIndexCache = index;
        }

        void tessellateSquarePoints2D(int nvertTot, int nindTot) {
            int index;
            this.tess.polyVertexCheck(nvertTot);
            this.tess.polyIndexCheck(nindTot);
            boolean clamp = this.clampSquarePoints2D();
            int vertIdx = this.tess.firstPolyVertex;
            int indIdx = this.tess.firstPolyIndex;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPointIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int i = 0;
            while (i < this.in.vertexCount) {
                int count = cache.vertexCount[index];
                int nvert = 5;
                if (PGL.MAX_VERTEX_INDEX1 <= count + nvert) {
                    index = cache.addNew();
                    count = 0;
                }
                float x0 = this.in.vertices[3 * i + 0];
                float y0 = this.in.vertices[3 * i + 1];
                int rgba = this.in.strokeColors[i];
                this.tess.setPolyVertex(vertIdx, x0, y0, 0.0f, rgba, clamp);
                ++vertIdx;
                int k = 0;
                while (k < nvert - 1) {
                    this.tess.setPolyVertex(vertIdx, x0 + 0.5f * QUAD_POINT_SIGNS[k][0] * this.strokeWeight, y0 + 0.5f * QUAD_POINT_SIGNS[k][1] * this.strokeWeight, 0.0f, rgba, clamp);
                    ++vertIdx;
                    ++k;
                }
                k = 1;
                while (k < nvert - 1) {
                    this.tess.polyIndices[indIdx++] = (short)(count + 0);
                    this.tess.polyIndices[indIdx++] = (short)(count + k);
                    this.tess.polyIndices[indIdx++] = (short)(count + k + 1);
                    ++k;
                }
                this.tess.polyIndices[indIdx++] = (short)(count + 0);
                this.tess.polyIndices[indIdx++] = (short)(count + 1);
                this.tess.polyIndices[indIdx++] = (short)(count + nvert - 1);
                cache.incCounts(index, 12, 5);
                ++i;
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = index;
        }

        boolean clamp2D() {
            return this.is2D && this.tess.renderMode == 0 && PGraphicsOpenGL.zero(this.pg.modelview.m01) && PGraphicsOpenGL.zero(this.pg.modelview.m10);
        }

        boolean clampSquarePoints2D() {
            return this.clamp2D();
        }

        void tessellateLines() {
            int nInVert = this.in.vertexCount;
            if (this.stroke && 2 <= nInVert) {
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                this.updateTex();
                int lineCount = nInVert / 2;
                if (this.is3D) {
                    this.tessellateLines3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLines2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLines3D(int lineCount) {
            int index;
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int ln = 0;
            while (ln < lineCount) {
                int i0 = 2 * ln + 0;
                int i1 = 2 * ln + 1;
                index = this.addLineSegment3D(i0, i1, index, null, false);
                ++ln;
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLines2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                boolean clamp = this.clampLines2D(lineCount);
                int ln = 0;
                while (ln < lineCount) {
                    int i0 = 2 * ln + 0;
                    int i1 = 2 * ln + 1;
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                    ++ln;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                int ln = 0;
                while (ln < lineCount) {
                    int i0 = 2 * ln + 0;
                    int i1 = 2 * ln + 1;
                    path.moveTo(this.in.vertices[3 * i0 + 0], this.in.vertices[3 * i0 + 1], this.in.strokeColors[i0]);
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                    ++ln;
                }
                this.tessellateLinePath(path);
            }
        }

        boolean clampLines2D(int lineCount) {
            boolean res = this.clamp2D();
            if (res) {
                int ln = 0;
                while (ln < lineCount) {
                    int i0 = 2 * ln + 0;
                    int i1 = 2 * ln + 1;
                    res = this.segmentIsAxisAligned(i0, i1);
                    if (!res) break;
                    ++ln;
                }
            }
            return res;
        }

        void tessellateLineStrip() {
            int nInVert = this.in.vertexCount;
            if (this.stroke && 2 <= nInVert) {
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                this.updateTex();
                int lineCount = nInVert - 1;
                if (this.is3D) {
                    this.tessellateLineStrip3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineStrip2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineStrip3D(int lineCount) {
            int index;
            int nBevelTr = this.noCapsJoins() ? 0 : lineCount - 1;
            int nvert = lineCount * 4 + nBevelTr;
            int nind = lineCount * 2 * 3 + nBevelTr * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int i0 = 0;
            short[] lastInd = new short[]{-1, -1};
            int ln = 0;
            while (ln < lineCount) {
                int i1 = ln + 1;
                index = nBevelTr > 0 ? this.addLineSegment3D(i0, i1, index, lastInd, false) : this.addLineSegment3D(i0, i1, index, null, false);
                i0 = i1;
                ++ln;
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLineStrip2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                int i0 = 0;
                boolean clamp = this.clampLineStrip2D(lineCount);
                int ln = 0;
                while (ln < lineCount) {
                    int i1 = ln + 1;
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                    i0 = i1;
                    ++ln;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                path.moveTo(this.in.vertices[0], this.in.vertices[1], this.in.strokeColors[0]);
                int ln = 0;
                while (ln < lineCount) {
                    int i1 = ln + 1;
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                    ++ln;
                }
                this.tessellateLinePath(path);
            }
        }

        boolean clampLineStrip2D(int lineCount) {
            boolean res = this.clamp2D();
            if (res) {
                int ln = 0;
                while (ln < lineCount) {
                    res = this.segmentIsAxisAligned(0, ln + 1);
                    if (!res) break;
                    ++ln;
                }
            }
            return res;
        }

        void tessellateLineLoop() {
            int nInVert = this.in.vertexCount;
            if (this.stroke && 2 <= nInVert) {
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                this.updateTex();
                int lineCount = nInVert;
                if (this.is3D) {
                    this.tessellateLineLoop3D(lineCount);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineLoop2D(lineCount);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineLoop3D(int lineCount) {
            int index;
            int nBevelTr = this.noCapsJoins() ? 0 : lineCount;
            int nvert = lineCount * 4 + nBevelTr;
            int nind = lineCount * 2 * 3 + nBevelTr * 2 * 3;
            this.tess.lineVertexCheck(nvert);
            this.tess.lineIndexCheck(nind);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int i0 = 0;
            short[] lastInd = new short[]{-1, -1};
            short firstInd = -1;
            int ln = 0;
            while (ln < lineCount - 1) {
                int i1 = ln + 1;
                if (nBevelTr > 0) {
                    index = this.addLineSegment3D(i0, i1, index, lastInd, false);
                    if (ln == 0) {
                        firstInd = (short)(lastInd[0] - 2);
                    }
                } else {
                    index = this.addLineSegment3D(i0, i1, index, null, false);
                }
                i0 = i1;
                ++ln;
            }
            index = this.addLineSegment3D(0, this.in.vertexCount - 1, index, lastInd, false);
            if (nBevelTr > 0) {
                index = this.addBevel3D(0, index, lastInd, firstInd, false);
            }
            this.lastLineIndexCache = index;
        }

        void tessellateLineLoop2D(int lineCount) {
            int nvert = lineCount * 4;
            int nind = lineCount * 2 * 3;
            if (this.noCapsJoins(nvert)) {
                int index;
                this.tess.polyVertexCheck(nvert);
                this.tess.polyIndexCheck(nind);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                int i0 = 0;
                boolean clamp = this.clampLineLoop2D(lineCount);
                int ln = 0;
                while (ln < lineCount - 1) {
                    int i1 = ln + 1;
                    index = this.addLineSegment2D(i0, i1, index, false, clamp);
                    i0 = i1;
                    ++ln;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = (index = this.addLineSegment2D(0, this.in.vertexCount - 1, index, false, clamp));
            } else {
                LinePath path = new LinePath(1);
                path.moveTo(this.in.vertices[0], this.in.vertices[1], this.in.strokeColors[0]);
                int ln = 0;
                while (ln < lineCount - 1) {
                    int i1 = ln + 1;
                    path.lineTo(this.in.vertices[3 * i1 + 0], this.in.vertices[3 * i1 + 1], this.in.strokeColors[i1]);
                    ++ln;
                }
                path.closePath();
                this.tessellateLinePath(path);
            }
        }

        boolean clampLineLoop2D(int lineCount) {
            boolean res = this.clamp2D();
            if (res) {
                int ln = 0;
                while (ln < lineCount) {
                    res = this.segmentIsAxisAligned(0, ln + 1);
                    if (!res) break;
                    ++ln;
                }
            }
            return res;
        }

        void tessellateEdges() {
            if (this.stroke) {
                if (this.in.edgeCount == 0) {
                    return;
                }
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                if (this.is3D) {
                    this.tessellateEdges3D();
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateEdges2D();
                    this.endNoTex();
                }
            }
        }

        void tessellateEdges3D() {
            int index;
            boolean bevel = !this.noCapsJoins();
            int nInVert = this.in.getNumEdgeVertices(bevel);
            int nInInd = this.in.getNumEdgeIndices(bevel);
            this.tess.lineVertexCheck(nInVert);
            this.tess.lineIndexCheck(nInInd);
            this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            short[] lastInd = new short[]{-1, -1};
            short firstInd = -1;
            int i = 0;
            while (i <= this.in.edgeCount - 1) {
                int[] edge = this.in.edges[i];
                int i0 = edge[0];
                int i1 = edge[1];
                if (bevel) {
                    if (edge[2] == -1) {
                        index = this.addBevel3D(edge[1], index, lastInd, firstInd, false);
                        lastInd[1] = -1;
                        lastInd[0] = -1;
                    } else {
                        index = this.addLineSegment3D(i0, i1, index, lastInd, false);
                        if (edge[2] == 1) {
                            firstInd = (short)(lastInd[0] - 2);
                        }
                        if (edge[2] == 2 || edge[2] == 3) {
                            lastInd[1] = -1;
                            lastInd[0] = -1;
                        }
                    }
                } else if (edge[2] != -1) {
                    index = this.addLineSegment3D(i0, i1, index, null, false);
                }
                ++i;
            }
            this.lastLineIndexCache = index;
        }

        void tessellateEdges2D() {
            int nInVert = this.in.getNumEdgeVertices(false);
            if (this.noCapsJoins(nInVert)) {
                int index;
                int nInInd = this.in.getNumEdgeIndices(false);
                this.tess.polyVertexCheck(nInVert);
                this.tess.polyIndexCheck(nInInd);
                this.firstLineIndexCache = index = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = index;
                }
                boolean clamp = this.clampEdges2D();
                int i = 0;
                while (i <= this.in.edgeCount - 1) {
                    int[] edge = this.in.edges[i];
                    if (edge[2] != -1) {
                        int i0 = edge[0];
                        int i1 = edge[1];
                        index = this.addLineSegment2D(i0, i1, index, false, clamp);
                    }
                    ++i;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = index;
            } else {
                LinePath path = new LinePath(1);
                int i = 0;
                while (i <= this.in.edgeCount - 1) {
                    int[] edge = this.in.edges[i];
                    int i0 = edge[0];
                    int i1 = edge[1];
                    switch (edge[2]) {
                        case 0: {
                            path.lineTo(this.strokeVertices[3 * i1 + 0], this.strokeVertices[3 * i1 + 1], this.strokeColors[i1]);
                            break;
                        }
                        case 1: {
                            path.moveTo(this.strokeVertices[3 * i0 + 0], this.strokeVertices[3 * i0 + 1], this.strokeColors[i0]);
                            path.lineTo(this.strokeVertices[3 * i1 + 0], this.strokeVertices[3 * i1 + 1], this.strokeColors[i1]);
                            break;
                        }
                        case 2: {
                            path.lineTo(this.strokeVertices[3 * i1 + 0], this.strokeVertices[3 * i1 + 1], this.strokeColors[i1]);
                            path.moveTo(this.strokeVertices[3 * i1 + 0], this.strokeVertices[3 * i1 + 1], this.strokeColors[i1]);
                            break;
                        }
                        case 3: {
                            path.moveTo(this.strokeVertices[3 * i0 + 0], this.strokeVertices[3 * i0 + 1], this.strokeColors[i0]);
                            path.lineTo(this.strokeVertices[3 * i1 + 0], this.strokeVertices[3 * i1 + 1], this.strokeColors[i1]);
                            path.moveTo(this.strokeVertices[3 * i1 + 0], this.strokeVertices[3 * i1 + 1], this.strokeColors[i1]);
                            break;
                        }
                        case -1: {
                            path.closePath();
                        }
                    }
                    ++i;
                }
                this.tessellateLinePath(path);
            }
        }

        boolean clampEdges2D() {
            boolean res = this.clamp2D();
            if (res) {
                int i = 0;
                while (i <= this.in.edgeCount - 1) {
                    int i1;
                    int i0;
                    int[] edge = this.in.edges[i];
                    if (edge[2] != -1 && !(res = this.segmentIsAxisAligned(this.strokeVertices, i0 = edge[0], i1 = edge[1]))) break;
                    ++i;
                }
            }
            return res;
        }

        int addLineSegment3D(int i0, int i1, int index, short[] lastInd, boolean constStroke) {
            IndexCache cache = this.tess.lineIndexCache;
            int count = cache.vertexCount[index];
            boolean addBevel = lastInd != null && -1 < lastInd[0] && -1 < lastInd[1];
            boolean newCache = false;
            if (PGL.MAX_VERTEX_INDEX1 <= count + 4 + (addBevel ? 1 : 0)) {
                index = cache.addNew();
                count = 0;
                newCache = true;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int color = constStroke ? this.strokeColor : this.strokeColors[i0];
            int color0 = color;
            float weight = constStroke ? this.strokeWeight : this.strokeWeights[i0];
            this.tess.setLineVertex(vidx++, this.strokeVertices, i0, i1, color, (weight *= this.transformScale()) / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 0);
            this.tess.setLineVertex(vidx++, this.strokeVertices, i0, i1, color, -weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 1);
            color = constStroke ? this.strokeColor : this.strokeColors[i1];
            weight = constStroke ? this.strokeWeight : this.strokeWeights[i1];
            this.tess.setLineVertex(vidx++, this.strokeVertices, i1, i0, color, -(weight *= this.transformScale()) / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 2);
            this.tess.lineIndices[iidx++] = (short)(count + 2);
            this.tess.lineIndices[iidx++] = (short)(count + 1);
            this.tess.setLineVertex(vidx++, this.strokeVertices, i1, i0, color, weight / 2.0f);
            this.tess.lineIndices[iidx++] = (short)(count + 3);
            cache.incCounts(index, 6, 4);
            if (lastInd != null) {
                if (-1 < lastInd[0] && -1 < lastInd[1]) {
                    this.tess.setLineVertex(vidx, this.strokeVertices, i0, color0);
                    if (newCache) {
                        PGraphics.showWarning(PGraphicsOpenGL.TOO_LONG_STROKE_PATH_ERROR);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = (short)(count + 1);
                        this.tess.lineIndices[iidx] = (short)(count + 1);
                    } else {
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = lastInd[0];
                        this.tess.lineIndices[iidx++] = (short)(count + 0);
                        this.tess.lineIndices[iidx++] = (short)(count + 4);
                        this.tess.lineIndices[iidx++] = lastInd[1];
                        this.tess.lineIndices[iidx] = (short)(count + 1);
                    }
                    cache.incCounts(index, 6, 1);
                }
                lastInd[0] = (short)(count + 2);
                lastInd[1] = (short)(count + 3);
            }
            return index;
        }

        int addBevel3D(int i0, int index, short[] lastInd, short firstInd, boolean constStroke) {
            int color0;
            IndexCache cache = this.tess.lineIndexCache;
            int count = cache.vertexCount[index];
            boolean addBevel = lastInd != null && -1 < lastInd[0] && -1 < lastInd[1];
            boolean newCache = false;
            if (PGL.MAX_VERTEX_INDEX1 <= count + (addBevel ? 1 : 0)) {
                index = cache.addNew();
                count = 0;
                newCache = true;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int n = color0 = constStroke ? this.strokeColor : this.strokeColors[i0];
            if (lastInd != null && -1 < lastInd[0] && -1 < lastInd[1]) {
                this.tess.setLineVertex(vidx, this.strokeVertices, i0, color0);
                if (newCache) {
                    PGraphics.showWarning(PGraphicsOpenGL.TOO_LONG_STROKE_PATH_ERROR);
                } else {
                    this.tess.lineIndices[iidx++] = (short)(count + 0);
                    this.tess.lineIndices[iidx++] = lastInd[0];
                    this.tess.lineIndices[iidx++] = (short)(firstInd + 0);
                    this.tess.lineIndices[iidx++] = (short)(count + 0);
                    this.tess.lineIndices[iidx++] = lastInd[1];
                    this.tess.lineIndices[iidx] = (short)(firstInd + 1);
                }
                cache.incCounts(index, 6, 1);
            }
            return index;
        }

        int addLineSegment2D(int i0, int i1, int index, boolean constStroke, boolean clamp) {
            float ybc;
            float xbc;
            float yac;
            float xac;
            float weight;
            IndexCache cache = this.tess.polyIndexCache;
            int count = cache.vertexCount[index];
            if (PGL.MAX_VERTEX_INDEX1 <= count + 4) {
                index = cache.addNew();
                count = 0;
            }
            int iidx = cache.indexOffset[index] + cache.indexCount[index];
            int vidx = cache.vertexOffset[index] + cache.vertexCount[index];
            int color = constStroke ? this.strokeColor : this.strokeColors[i0];
            float f = weight = constStroke ? this.strokeWeight : this.strokeWeights[i0];
            if (this.subPixelStroke(weight)) {
                clamp = false;
            }
            float x0 = this.strokeVertices[3 * i0 + 0];
            float y0 = this.strokeVertices[3 * i0 + 1];
            float x1 = this.strokeVertices[3 * i1 + 0];
            float y1 = this.strokeVertices[3 * i1 + 1];
            float dirx = x1 - x0;
            float diry = y1 - y0;
            float llen = PApplet.sqrt(dirx * dirx + diry * diry);
            float normx = 0.0f;
            float normy = 0.0f;
            float dirdx = 0.0f;
            float dirdy = 0.0f;
            if (PGraphicsOpenGL.nonZero(llen)) {
                normx = -diry / llen;
                normy = dirx / llen;
                dirdx = dirx / llen * PApplet.min(0.75f, weight / 2.0f);
                dirdy = diry / llen * PApplet.min(0.75f, weight / 2.0f);
            }
            float normdx = normx * weight / 2.0f;
            float normdy = normy * weight / 2.0f;
            this.tess.setPolyVertex(vidx++, x0 + normdx - dirdx, y0 + normdy - dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 0);
            this.tess.setPolyVertex(vidx++, x0 - normdx - dirdx, y0 - normdy - dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 1);
            if (clamp) {
                xac = this.tess.polyVertices[4 * (vidx - 2) + 0];
                yac = this.tess.polyVertices[4 * (vidx - 2) + 1];
                xbc = this.tess.polyVertices[4 * (vidx - 1) + 0];
                ybc = this.tess.polyVertices[4 * (vidx - 1) + 1];
                if (PGraphicsOpenGL.same(xac, xbc) && PGraphicsOpenGL.same(yac, ybc)) {
                    this.unclampLine2D(vidx - 2, x0 + normdx - dirdx, y0 + normdy - dirdy);
                    this.unclampLine2D(vidx - 1, x0 - normdx - dirdx, y0 - normdy - dirdy);
                }
            }
            if (!constStroke) {
                color = this.strokeColors[i1];
                weight = this.strokeWeights[i1];
                normdx = normx * weight / 2.0f;
                normdy = normy * weight / 2.0f;
                if (this.subPixelStroke(weight)) {
                    clamp = false;
                }
            }
            this.tess.setPolyVertex(vidx++, x1 - normdx + dirdx, y1 - normdy + dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 2);
            this.tess.polyIndices[iidx++] = (short)(count + 2);
            this.tess.polyIndices[iidx++] = (short)(count + 0);
            this.tess.setPolyVertex(vidx++, x1 + normdx + dirdx, y1 + normdy + dirdy, 0.0f, color, clamp);
            this.tess.polyIndices[iidx++] = (short)(count + 3);
            if (clamp) {
                xac = this.tess.polyVertices[4 * (vidx - 2) + 0];
                yac = this.tess.polyVertices[4 * (vidx - 2) + 1];
                xbc = this.tess.polyVertices[4 * (vidx - 1) + 0];
                ybc = this.tess.polyVertices[4 * (vidx - 1) + 1];
                if (PGraphicsOpenGL.same(xac, xbc) && PGraphicsOpenGL.same(yac, ybc)) {
                    this.unclampLine2D(vidx - 2, x1 - normdx + dirdx, y1 - normdy + dirdy);
                    this.unclampLine2D(vidx - 1, x1 + normdx + dirdx, y1 + normdy + dirdy);
                }
            }
            cache.incCounts(index, 6, 4);
            return index;
        }

        void unclampLine2D(int tessIdx, float x, float y) {
            PMatrix3D mm = this.pg.modelview;
            int index = 4 * tessIdx;
            this.tess.polyVertices[index++] = x * mm.m00 + y * mm.m01 + mm.m03;
            this.tess.polyVertices[index++] = x * mm.m10 + y * mm.m11 + mm.m13;
        }

        boolean noCapsJoins(int nInVert) {
            if (!this.accurate2DStrokes) {
                return true;
            }
            if (PGL.MAX_CAPS_JOINS_LENGTH <= nInVert) {
                return true;
            }
            return this.noCapsJoins();
        }

        boolean subPixelStroke(float weight) {
            float sw = this.transformScale() * weight;
            return PApplet.abs(sw - (float)((int)sw)) > 0.0f;
        }

        boolean noCapsJoins() {
            return this.tess.renderMode == 0 && this.transformScale() * this.strokeWeight < PGL.MIN_CAPS_JOINS_WEIGHT;
        }

        float transformScale() {
            if (-1.0f < this.transformScale) {
                return this.transformScale;
            }
            float factor = 1.0f;
            if (this.transform != null) {
                if (this.transform instanceof PMatrix2D) {
                    PMatrix2D tr = (PMatrix2D)this.transform;
                    float areaScaleFactor = Math.abs(tr.m00 * tr.m11 - tr.m01 * tr.m10);
                    factor = (float)Math.sqrt(areaScaleFactor);
                } else if (this.transform instanceof PMatrix3D) {
                    PMatrix3D tr = (PMatrix3D)this.transform;
                    float volumeScaleFactor = Math.abs(tr.m00 * (tr.m11 * tr.m22 - tr.m12 * tr.m21) + tr.m01 * (tr.m12 * tr.m20 - tr.m10 * tr.m22) + tr.m02 * (tr.m10 * tr.m21 - tr.m11 * tr.m20));
                    factor = (float)Math.pow(volumeScaleFactor, 0.3333333432674408);
                }
            }
            this.transformScale = factor;
            return this.transformScale;
        }

        boolean segmentIsAxisAligned(int i0, int i1) {
            return PGraphicsOpenGL.zero(this.in.vertices[3 * i0 + 0] - this.in.vertices[3 * i1 + 0]) || PGraphicsOpenGL.zero(this.in.vertices[3 * i0 + 1] - this.in.vertices[3 * i1 + 1]);
        }

        boolean segmentIsAxisAligned(float[] vertices, int i0, int i1) {
            return PGraphicsOpenGL.zero(vertices[3 * i0 + 0] - vertices[3 * i1 + 0]) || PGraphicsOpenGL.zero(vertices[3 * i0 + 1] - vertices[3 * i1 + 1]);
        }

        void tessellateTriangles() {
            this.beginTex();
            int nTri = this.in.vertexCount / 3;
            if (this.fill && 1 <= nTri) {
                int nInInd = 3 * nTri;
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampTriangles();
                int i = 0;
                while (i < 3 * nTri) {
                    this.rawIndices[idx++] = i++;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangles() {
            boolean res = this.clamp2D();
            if (res) {
                int nTri = this.in.vertexCount / 3;
                int i = 0;
                while (i < nTri) {
                    int i0 = 3 * i + 0;
                    int i1 = 3 * i + 1;
                    int i2 = 3 * i + 2;
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                    ++i;
                }
            }
            return res;
        }

        void tessellateTriangles(int[] indices) {
            this.beginTex();
            int nInVert = this.in.vertexCount;
            if (this.fill && 3 <= nInVert) {
                int nInInd = indices.length;
                this.setRawSize(nInInd);
                PApplet.arrayCopy(indices, this.rawIndices, nInInd);
                boolean clamp = this.clampTriangles(indices);
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangles(int[] indices) {
            boolean res = this.clamp2D();
            if (res) {
                int nTri = indices.length;
                int i = 0;
                while (i < nTri) {
                    int i0 = indices[3 * i + 0];
                    int i1 = indices[3 * i + 1];
                    int i2 = indices[3 * i + 2];
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                    ++i;
                }
            }
            return res;
        }

        void tessellateTriangleFan() {
            this.beginTex();
            int nInVert = this.in.vertexCount;
            if (this.fill && 3 <= nInVert) {
                int nInInd = 3 * (nInVert - 2);
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampTriangleFan();
                int i = 1;
                while (i < this.in.vertexCount - 1) {
                    this.rawIndices[idx++] = 0;
                    this.rawIndices[idx++] = i;
                    this.rawIndices[idx++] = i + 1;
                    ++i;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangleFan() {
            boolean res = this.clamp2D();
            if (res) {
                int i = 1;
                while (i < this.in.vertexCount - 1) {
                    int i0 = 0;
                    int i1 = i;
                    int i2 = i + 1;
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                    ++i;
                }
            }
            return res;
        }

        void tessellateTriangleStrip() {
            this.beginTex();
            int nInVert = this.in.vertexCount;
            if (this.fill && 3 <= nInVert) {
                int nInInd = 3 * (nInVert - 2);
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampTriangleStrip();
                int i = 1;
                while (i < this.in.vertexCount - 1) {
                    this.rawIndices[idx++] = i;
                    if (i % 2 == 0) {
                        this.rawIndices[idx++] = i - 1;
                        this.rawIndices[idx++] = i + 1;
                    } else {
                        this.rawIndices[idx++] = i + 1;
                        this.rawIndices[idx++] = i - 1;
                    }
                    ++i;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangleStrip() {
            boolean res = this.clamp2D();
            if (res) {
                int i = 1;
                while (i < this.in.vertexCount - 1) {
                    int i2;
                    int i1;
                    int i0 = i;
                    if (i % 2 == 0) {
                        i1 = i - 1;
                        i2 = i + 1;
                    } else {
                        i1 = i + 1;
                        i2 = i - 1;
                    }
                    int count = 0;
                    if (this.segmentIsAxisAligned(i0, i1)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i0, i2)) {
                        ++count;
                    }
                    if (this.segmentIsAxisAligned(i1, i2)) {
                        ++count;
                    }
                    boolean bl = res = 1 < count;
                    if (!res) break;
                    ++i;
                }
            }
            return res;
        }

        void tessellateQuads() {
            this.beginTex();
            int quadCount = this.in.vertexCount / 4;
            if (this.fill && 1 <= quadCount) {
                int nInInd = 6 * quadCount;
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampQuads(quadCount);
                int qd = 0;
                while (qd < quadCount) {
                    int i0 = 4 * qd + 0;
                    int i1 = 4 * qd + 1;
                    int i2 = 4 * qd + 2;
                    int i3 = 4 * qd + 3;
                    this.rawIndices[idx++] = i0;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i3;
                    this.rawIndices[idx++] = i0;
                    ++qd;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampQuads(int quadCount) {
            boolean res = this.clamp2D();
            if (res) {
                int qd = 0;
                while (qd < quadCount) {
                    int i0 = 4 * qd + 0;
                    int i1 = 4 * qd + 1;
                    int i2 = 4 * qd + 2;
                    int i3 = 4 * qd + 3;
                    boolean bl = res = this.segmentIsAxisAligned(i0, i1) && this.segmentIsAxisAligned(i1, i2) && this.segmentIsAxisAligned(i2, i3);
                    if (!res) break;
                    ++qd;
                }
            }
            return res;
        }

        void tessellateQuadStrip() {
            this.beginTex();
            int quadCount = this.in.vertexCount / 2 - 1;
            if (this.fill && 1 <= quadCount) {
                int nInInd = 6 * quadCount;
                this.setRawSize(nInInd);
                int idx = 0;
                boolean clamp = this.clampQuadStrip(quadCount);
                int qd = 1;
                while (qd < quadCount + 1) {
                    int i0 = 2 * (qd - 1);
                    int i1 = 2 * (qd - 1) + 1;
                    int i2 = 2 * qd + 1;
                    int i3 = 2 * qd;
                    this.rawIndices[idx++] = i0;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i3;
                    this.rawIndices[idx++] = i1;
                    this.rawIndices[idx++] = i2;
                    this.rawIndices[idx++] = i3;
                    ++qd;
                }
                this.splitRawIndices(clamp);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampQuadStrip(int quadCount) {
            boolean res = this.clamp2D();
            if (res) {
                int qd = 1;
                while (qd < quadCount + 1) {
                    int i0 = 2 * (qd - 1);
                    int i1 = 2 * (qd - 1) + 1;
                    int i2 = 2 * qd + 1;
                    int i3 = 2 * qd;
                    boolean bl = res = this.segmentIsAxisAligned(i0, i1) && this.segmentIsAxisAligned(i1, i2) && this.segmentIsAxisAligned(i2, i3);
                    if (!res) break;
                    ++qd;
                }
            }
            return res;
        }

        void splitRawIndices(boolean clamp) {
            int index;
            this.tess.polyIndexCheck(this.rawSize);
            int offset = this.tess.firstPolyIndex;
            int inInd0 = 0;
            int inInd1 = 0;
            int inMaxVert0 = 0;
            int inMaxVert1 = 0;
            int inMaxVertRef = inMaxVert0;
            int inMaxVertRel = -1;
            this.dupCount = 0;
            IndexCache cache = this.tess.polyIndexCache;
            this.firstPolyIndexCache = index = this.in.renderMode == 1 ? cache.addNew() : cache.getLast();
            int trCount = this.rawSize / 3;
            int tr = 0;
            while (tr < trCount) {
                int ri2;
                int ri1;
                int ri0;
                if (index == -1) {
                    index = cache.addNew();
                }
                int i0 = this.rawIndices[3 * tr + 0];
                int i1 = this.rawIndices[3 * tr + 1];
                int i2 = this.rawIndices[3 * tr + 2];
                int ii0 = i0 - inMaxVertRef;
                int ii1 = i1 - inMaxVertRef;
                int ii2 = i2 - inMaxVertRef;
                int count = cache.vertexCount[index];
                if (ii0 < 0) {
                    this.addDupIndex(ii0);
                    ri0 = ii0;
                } else {
                    ri0 = count + ii0;
                }
                if (ii1 < 0) {
                    this.addDupIndex(ii1);
                    ri1 = ii1;
                } else {
                    ri1 = count + ii1;
                }
                if (ii2 < 0) {
                    this.addDupIndex(ii2);
                    ri2 = ii2;
                } else {
                    ri2 = count + ii2;
                }
                this.tess.polyIndices[offset + 3 * tr + 0] = (short)ri0;
                this.tess.polyIndices[offset + 3 * tr + 1] = (short)ri1;
                this.tess.polyIndices[offset + 3 * tr + 2] = (short)ri2;
                inInd1 = 3 * tr + 2;
                inMaxVert1 = PApplet.max(inMaxVert1, PApplet.max(i0, i1, i2));
                inMaxVert0 = PApplet.min(inMaxVert0, PApplet.min(i0, i1, i2));
                inMaxVertRel = PApplet.max(inMaxVertRel, PApplet.max(ri0, ri1, ri2));
                if (PGL.MAX_VERTEX_INDEX1 - 3 <= inMaxVertRel + this.dupCount && inMaxVertRel + this.dupCount < PGL.MAX_VERTEX_INDEX1 || tr == trCount - 1) {
                    int nondupCount = 0;
                    if (this.dupCount > 0) {
                        int i = inInd0;
                        while (i <= inInd1) {
                            short ri = this.tess.polyIndices[offset + i];
                            if (ri < 0) {
                                this.tess.polyIndices[offset + i] = (short)(inMaxVertRel + 1 + this.dupIndexPos(ri));
                            }
                            ++i;
                        }
                        if (inMaxVertRef <= inMaxVert1) {
                            this.tess.addPolyVertices(this.in, inMaxVertRef, inMaxVert1, clamp);
                            nondupCount = inMaxVert1 - inMaxVertRef + 1;
                        }
                        i = 0;
                        while (i < this.dupCount) {
                            this.tess.addPolyVertex(this.in, this.dupIndices[i] + inMaxVertRef, clamp);
                            ++i;
                        }
                    } else {
                        this.tess.addPolyVertices(this.in, inMaxVert0, inMaxVert1, clamp);
                        nondupCount = inMaxVert1 - inMaxVert0 + 1;
                    }
                    cache.incCounts(index, inInd1 - inInd0 + 1, nondupCount + this.dupCount);
                    this.lastPolyIndexCache = index;
                    index = -1;
                    inMaxVertRel = -1;
                    inMaxVert0 = inMaxVertRef = inMaxVert1 + 1;
                    inInd0 = inInd1 + 1;
                    if (this.dupIndices != null) {
                        Arrays.fill(this.dupIndices, 0, this.dupCount, 0);
                    }
                    this.dupCount = 0;
                }
                ++tr;
            }
        }

        void addDupIndex(int idx) {
            int i;
            if (this.dupIndices == null) {
                this.dupIndices = new int[16];
            }
            if (this.dupIndices.length == this.dupCount) {
                int n = this.dupCount << 1;
                int[] temp = new int[n];
                PApplet.arrayCopy(this.dupIndices, 0, temp, 0, this.dupCount);
                this.dupIndices = temp;
            }
            if (idx < this.dupIndices[0]) {
                i = this.dupCount;
                while (i > 0) {
                    this.dupIndices[i] = this.dupIndices[i - 1];
                    --i;
                }
                this.dupIndices[0] = idx;
                ++this.dupCount;
            } else if (this.dupIndices[this.dupCount - 1] < idx) {
                this.dupIndices[this.dupCount] = idx;
                ++this.dupCount;
            } else {
                i = 0;
                while (i < this.dupCount - 1) {
                    if (this.dupIndices[i] == idx) break;
                    if (this.dupIndices[i] < idx && idx < this.dupIndices[i + 1]) {
                        int j = this.dupCount;
                        while (j > i + 1) {
                            this.dupIndices[j] = this.dupIndices[j - 1];
                            --j;
                        }
                        this.dupIndices[i + 1] = idx;
                        ++this.dupCount;
                        break;
                    }
                    ++i;
                }
            }
        }

        int dupIndexPos(int idx) {
            int i = 0;
            while (i < this.dupCount) {
                if (this.dupIndices[i] == idx) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        void setRawSize(int size) {
            int size0 = this.rawIndices.length;
            if (size0 < size) {
                int size1 = PGraphicsOpenGL.expandArraySize(size0, size);
                this.expandRawIndices(size1);
            }
            this.rawSize = size;
        }

        void expandRawIndices(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.rawIndices, 0, temp, 0, this.rawSize);
            this.rawIndices = temp;
        }

        void beginTex() {
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void beginNoTex() {
            this.newTexImage = null;
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endNoTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void updateTex() {
            this.beginTex();
            this.endTex();
        }

        void setFirstTexIndex(int firstIndex, int firstCache) {
            if (this.texCache != null) {
                this.firstTexIndex = firstIndex;
                this.firstTexCache = PApplet.max(0, firstCache);
            }
        }

        void setLastTexIndex(int lastIndex, int lastCache) {
            if (this.texCache != null) {
                if (this.prevTexImage != this.newTexImage || this.texCache.size == 0) {
                    this.texCache.addTexture(this.newTexImage, this.firstTexIndex, this.firstTexCache, lastIndex, lastCache);
                } else {
                    this.texCache.setLastIndex(lastIndex, lastCache);
                }
            }
            this.prevTexImage = this.newTexImage;
        }

        void tessellatePolygon(boolean solid, boolean closed, boolean calcNormals) {
            this.beginTex();
            int nInVert = this.in.vertexCount;
            if (3 <= nInVert) {
                this.firstPolyIndexCache = -1;
                this.initGluTess();
                boolean clamp = this.clampPolygon();
                this.callback.init(this.in.renderMode == 1, false, calcNormals, clamp);
                if (this.fill) {
                    this.gluTess.beginPolygon();
                    if (solid) {
                        this.gluTess.setWindingRule(PGL.TESS_WINDING_NONZERO);
                    } else {
                        this.gluTess.setWindingRule(PGL.TESS_WINDING_ODD);
                    }
                    this.gluTess.beginContour();
                }
                if (this.stroke) {
                    this.beginPolygonStroke();
                    this.beginStrokePath();
                }
                int i = 0;
                int c = 0;
                while (i < this.in.vertexCount) {
                    int code = 0;
                    boolean brk = false;
                    if (this.in.codes != null && c < this.in.codeCount && (code = this.in.codes[c++]) == 4 && c < this.in.codeCount) {
                        brk = true;
                        code = this.in.codes[c++];
                    }
                    if (brk) {
                        if (this.stroke) {
                            this.endStrokePath(closed);
                            this.beginStrokePath();
                        }
                        if (this.fill) {
                            this.gluTess.endContour();
                            this.gluTess.beginContour();
                        }
                    }
                    if (code == 1) {
                        this.addBezierVertex(i);
                        i += 3;
                        continue;
                    }
                    if (code == 2) {
                        this.addQuadraticVertex(i);
                        i += 2;
                        continue;
                    }
                    if (code == 3) {
                        this.addCurveVertex(i);
                        ++i;
                        continue;
                    }
                    this.addVertex(i);
                    ++i;
                }
                if (this.stroke) {
                    this.endStrokePath(closed);
                    this.endPolygonStroke();
                }
                if (this.fill) {
                    this.gluTess.endContour();
                    this.gluTess.endPolygon();
                }
            }
            this.endTex();
            if (this.stroke) {
                this.tessellateStrokePath();
            }
        }

        void addBezierVertex(int i) {
            this.pg.curveVertexCount = 0;
            this.pg.bezierInitCheck();
            this.pg.bezierVertexCheck(20, i);
            PMatrix3D draw = this.pg.bezierDrawMatrix;
            int i1 = i - 1;
            float x1 = this.in.vertices[3 * i1 + 0];
            float y1 = this.in.vertices[3 * i1 + 1];
            float z1 = this.in.vertices[3 * i1 + 2];
            int strokeColor = 0;
            float strokeWeight = 0.0f;
            if (this.stroke) {
                strokeColor = this.in.strokeColors[i];
                strokeWeight = this.in.strokeWeights[i];
            }
            int fcol = 0;
            int fa = 0;
            int fr = 0;
            int fg = 0;
            int fb = 0;
            int acol = 0;
            int aa = 0;
            int ar = 0;
            int ag = 0;
            int ab = 0;
            int scol = 0;
            int sa = 0;
            int sr = 0;
            int sg = 0;
            int sb = 0;
            int ecol = 0;
            int ea = 0;
            int er = 0;
            int eg = 0;
            int eb = 0;
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            float u = 0.0f;
            float v = 0.0f;
            float sh = 0.0f;
            if (this.fill) {
                fcol = this.in.colors[i];
                fa = fcol >> 24 & 0xFF;
                fr = fcol >> 16 & 0xFF;
                fg = fcol >> 8 & 0xFF;
                fb = fcol >> 0 & 0xFF;
                acol = this.in.ambient[i];
                aa = acol >> 24 & 0xFF;
                ar = acol >> 16 & 0xFF;
                ag = acol >> 8 & 0xFF;
                ab = acol >> 0 & 0xFF;
                scol = this.in.specular[i];
                sa = scol >> 24 & 0xFF;
                sr = scol >> 16 & 0xFF;
                sg = scol >> 8 & 0xFF;
                sb = scol >> 0 & 0xFF;
                ecol = this.in.emissive[i];
                ea = ecol >> 24 & 0xFF;
                er = ecol >> 16 & 0xFF;
                eg = ecol >> 8 & 0xFF;
                eb = ecol >> 0 & 0xFF;
                nx = this.in.normals[3 * i + 0];
                ny = this.in.normals[3 * i + 1];
                nz = this.in.normals[3 * i + 2];
                u = this.in.texcoords[2 * i + 0];
                v = this.in.texcoords[2 * i + 1];
                sh = this.in.shininess[i];
            }
            float x2 = this.in.vertices[3 * i + 0];
            float y2 = this.in.vertices[3 * i + 1];
            float z2 = this.in.vertices[3 * i + 2];
            float x3 = this.in.vertices[3 * (i + 1) + 0];
            float y3 = this.in.vertices[3 * (i + 1) + 1];
            float z3 = this.in.vertices[3 * (i + 1) + 2];
            float x4 = this.in.vertices[3 * (i + 2) + 0];
            float y4 = this.in.vertices[3 * (i + 2) + 1];
            float z4 = this.in.vertices[3 * (i + 2) + 2];
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            int j = 0;
            while (j < this.pg.bezierDetail) {
                x1 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                y1 += yplot1;
                yplot1 += yplot2;
                yplot2 += yplot3;
                z1 += zplot1;
                zplot1 += zplot2;
                zplot2 += zplot3;
                if (this.fill) {
                    double[] vertex = new double[]{x1, y1, z1, fa, fr, fg, fb, nx, ny, nz, u, v, aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, sh};
                    this.gluTess.addVertex(vertex);
                }
                if (this.stroke) {
                    this.addStrokeVertex(x1, y1, z1, strokeColor, strokeWeight);
                }
                ++j;
            }
        }

        void addQuadraticVertex(int i) {
            this.pg.curveVertexCount = 0;
            this.pg.bezierInitCheck();
            this.pg.bezierVertexCheck(this.pg.shape, i);
            PMatrix3D draw = this.pg.bezierDrawMatrix;
            int i1 = i - 1;
            float x1 = this.in.vertices[3 * i1 + 0];
            float y1 = this.in.vertices[3 * i1 + 1];
            float z1 = this.in.vertices[3 * i1 + 2];
            int strokeColor = 0;
            float strokeWeight = 0.0f;
            if (this.stroke) {
                strokeColor = this.in.strokeColors[i];
                strokeWeight = this.in.strokeWeights[i];
            }
            int fcol = 0;
            int fa = 0;
            int fr = 0;
            int fg = 0;
            int fb = 0;
            int acol = 0;
            int aa = 0;
            int ar = 0;
            int ag = 0;
            int ab = 0;
            int scol = 0;
            int sa = 0;
            int sr = 0;
            int sg = 0;
            int sb = 0;
            int ecol = 0;
            int ea = 0;
            int er = 0;
            int eg = 0;
            int eb = 0;
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            float u = 0.0f;
            float v = 0.0f;
            float sh = 0.0f;
            if (this.fill) {
                fcol = this.in.colors[i];
                fa = fcol >> 24 & 0xFF;
                fr = fcol >> 16 & 0xFF;
                fg = fcol >> 8 & 0xFF;
                fb = fcol >> 0 & 0xFF;
                acol = this.in.ambient[i];
                aa = acol >> 24 & 0xFF;
                ar = acol >> 16 & 0xFF;
                ag = acol >> 8 & 0xFF;
                ab = acol >> 0 & 0xFF;
                scol = this.in.specular[i];
                sa = scol >> 24 & 0xFF;
                sr = scol >> 16 & 0xFF;
                sg = scol >> 8 & 0xFF;
                sb = scol >> 0 & 0xFF;
                ecol = this.in.emissive[i];
                ea = ecol >> 24 & 0xFF;
                er = ecol >> 16 & 0xFF;
                eg = ecol >> 8 & 0xFF;
                eb = ecol >> 0 & 0xFF;
                nx = this.in.normals[3 * i + 0];
                ny = this.in.normals[3 * i + 1];
                nz = this.in.normals[3 * i + 2];
                u = this.in.texcoords[2 * i + 0];
                v = this.in.texcoords[2 * i + 1];
                sh = this.in.shininess[i];
            }
            float cx = this.in.vertices[3 * i + 0];
            float cy = this.in.vertices[3 * i + 1];
            float cz = this.in.vertices[3 * i + 2];
            float x = this.in.vertices[3 * (i + 1) + 0];
            float y = this.in.vertices[3 * (i + 1) + 1];
            float z = this.in.vertices[3 * (i + 1) + 2];
            float x2 = x1 + (cx - x1) * 2.0f / 3.0f;
            float y2 = y1 + (cy - y1) * 2.0f / 3.0f;
            float z2 = z1 + (cz - z1) * 2.0f / 3.0f;
            float x3 = x + (cx - x) * 2.0f / 3.0f;
            float y3 = y + (cy - y) * 2.0f / 3.0f;
            float z3 = z + (cz - z) * 2.0f / 3.0f;
            float x4 = x;
            float y4 = y;
            float z4 = z;
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            int j = 0;
            while (j < this.pg.bezierDetail) {
                x1 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                y1 += yplot1;
                yplot1 += yplot2;
                yplot2 += yplot3;
                z1 += zplot1;
                zplot1 += zplot2;
                zplot2 += zplot3;
                if (this.fill) {
                    double[] vertex = new double[]{x1, y1, z1, fa, fr, fg, fb, nx, ny, nz, u, v, aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, sh};
                    this.gluTess.addVertex(vertex);
                }
                if (this.stroke) {
                    this.addStrokeVertex(x1, y1, z1, strokeColor, strokeWeight);
                }
                ++j;
            }
        }

        void addCurveVertex(int i) {
            this.pg.curveVertexCheck(20);
            float[] vertex = this.pg.curveVertices[this.pg.curveVertexCount];
            vertex[0] = this.in.vertices[3 * i + 0];
            vertex[1] = this.in.vertices[3 * i + 1];
            vertex[2] = this.in.vertices[3 * i + 2];
            PGraphicsOpenGL pGraphicsOpenGL = this.pg;
            pGraphicsOpenGL.curveVertexCount = pGraphicsOpenGL.curveVertexCount + 1;
            if (this.pg.curveVertexCount > 3) {
                float[] v1 = this.pg.curveVertices[this.pg.curveVertexCount - 4];
                float[] v2 = this.pg.curveVertices[this.pg.curveVertexCount - 3];
                float[] v3 = this.pg.curveVertices[this.pg.curveVertexCount - 2];
                float[] v4 = this.pg.curveVertices[this.pg.curveVertexCount - 1];
                this.addCurveVertexSegment(i, v1[0], v1[1], v1[2], v2[0], v2[1], v2[2], v3[0], v3[1], v3[2], v4[0], v4[1], v4[2]);
            }
        }

        void addCurveVertexSegment(int i, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
            int strokeColor = 0;
            float strokeWeight = 0.0f;
            if (this.stroke) {
                strokeColor = this.in.strokeColors[i];
                strokeWeight = this.in.strokeWeights[i];
            }
            int fcol = 0;
            int fa = 0;
            int fr = 0;
            int fg = 0;
            int fb = 0;
            int acol = 0;
            int aa = 0;
            int ar = 0;
            int ag = 0;
            int ab = 0;
            int scol = 0;
            int sa = 0;
            int sr = 0;
            int sg = 0;
            int sb = 0;
            int ecol = 0;
            int ea = 0;
            int er = 0;
            int eg = 0;
            int eb = 0;
            float nx = 0.0f;
            float ny = 0.0f;
            float nz = 0.0f;
            float u = 0.0f;
            float v = 0.0f;
            float sh = 0.0f;
            if (this.fill) {
                fcol = this.in.colors[i];
                fa = fcol >> 24 & 0xFF;
                fr = fcol >> 16 & 0xFF;
                fg = fcol >> 8 & 0xFF;
                fb = fcol >> 0 & 0xFF;
                acol = this.in.ambient[i];
                aa = acol >> 24 & 0xFF;
                ar = acol >> 16 & 0xFF;
                ag = acol >> 8 & 0xFF;
                ab = acol >> 0 & 0xFF;
                scol = this.in.specular[i];
                sa = scol >> 24 & 0xFF;
                sr = scol >> 16 & 0xFF;
                sg = scol >> 8 & 0xFF;
                sb = scol >> 0 & 0xFF;
                ecol = this.in.emissive[i];
                ea = ecol >> 24 & 0xFF;
                er = ecol >> 16 & 0xFF;
                eg = ecol >> 8 & 0xFF;
                eb = ecol >> 0 & 0xFF;
                nx = this.in.normals[3 * i + 0];
                ny = this.in.normals[3 * i + 1];
                nz = this.in.normals[3 * i + 2];
                u = this.in.texcoords[2 * i + 0];
                v = this.in.texcoords[2 * i + 1];
                sh = this.in.shininess[i];
            }
            float x = x2;
            float y = y2;
            float z = z2;
            PMatrix3D draw = this.pg.curveDrawMatrix;
            float xplot1 = draw.m10 * x1 + draw.m11 * x2 + draw.m12 * x3 + draw.m13 * x4;
            float xplot2 = draw.m20 * x1 + draw.m21 * x2 + draw.m22 * x3 + draw.m23 * x4;
            float xplot3 = draw.m30 * x1 + draw.m31 * x2 + draw.m32 * x3 + draw.m33 * x4;
            float yplot1 = draw.m10 * y1 + draw.m11 * y2 + draw.m12 * y3 + draw.m13 * y4;
            float yplot2 = draw.m20 * y1 + draw.m21 * y2 + draw.m22 * y3 + draw.m23 * y4;
            float yplot3 = draw.m30 * y1 + draw.m31 * y2 + draw.m32 * y3 + draw.m33 * y4;
            float zplot1 = draw.m10 * z1 + draw.m11 * z2 + draw.m12 * z3 + draw.m13 * z4;
            float zplot2 = draw.m20 * z1 + draw.m21 * z2 + draw.m22 * z3 + draw.m23 * z4;
            float zplot3 = draw.m30 * z1 + draw.m31 * z2 + draw.m32 * z3 + draw.m33 * z4;
            if (this.fill) {
                double[] vertex0 = new double[]{x, y, z, fa, fr, fg, fb, nx, ny, nz, u, v, aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, sh};
                this.gluTess.addVertex(vertex0);
            }
            if (this.stroke) {
                this.addStrokeVertex(x, y, z, strokeColor, strokeWeight);
            }
            int j = 0;
            while (j < this.pg.curveDetail) {
                x += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                y += yplot1;
                yplot1 += yplot2;
                yplot2 += yplot3;
                z += zplot1;
                zplot1 += zplot2;
                zplot2 += zplot3;
                if (this.fill) {
                    double[] vertex1 = new double[]{x, y, z, fa, fr, fg, fb, nx, ny, nz, u, v, aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, sh};
                    this.gluTess.addVertex(vertex1);
                }
                if (this.stroke) {
                    this.addStrokeVertex(x, y, z, strokeColor, strokeWeight);
                }
                ++j;
            }
        }

        void addVertex(int i) {
            this.pg.curveVertexCount = 0;
            float x = this.in.vertices[3 * i + 0];
            float y = this.in.vertices[3 * i + 1];
            float z = this.in.vertices[3 * i + 2];
            int strokeColor = 0;
            float strokeWeight = 0.0f;
            if (this.stroke) {
                strokeColor = this.in.strokeColors[i];
                strokeWeight = this.in.strokeWeights[i];
            }
            if (this.fill) {
                int fcol = this.in.colors[i];
                int fa = fcol >> 24 & 0xFF;
                int fr = fcol >> 16 & 0xFF;
                int fg = fcol >> 8 & 0xFF;
                int fb = fcol >> 0 & 0xFF;
                int acol = this.in.ambient[i];
                int aa = acol >> 24 & 0xFF;
                int ar = acol >> 16 & 0xFF;
                int ag = acol >> 8 & 0xFF;
                int ab = acol >> 0 & 0xFF;
                int scol = this.in.specular[i];
                int sa = scol >> 24 & 0xFF;
                int sr = scol >> 16 & 0xFF;
                int sg = scol >> 8 & 0xFF;
                int sb = scol >> 0 & 0xFF;
                int ecol = this.in.emissive[i];
                int ea = ecol >> 24 & 0xFF;
                int er = ecol >> 16 & 0xFF;
                int eg = ecol >> 8 & 0xFF;
                int eb = ecol >> 0 & 0xFF;
                float nx = this.in.normals[3 * i + 0];
                float ny = this.in.normals[3 * i + 1];
                float nz = this.in.normals[3 * i + 2];
                float u = this.in.texcoords[2 * i + 0];
                float v = this.in.texcoords[2 * i + 1];
                float sh = this.in.shininess[i];
                double[] vertex = new double[]{x, y, z, fa, fr, fg, fb, nx, ny, nz, u, v, aa, ar, ag, ab, sa, sr, sg, sb, ea, er, eg, eb, sh};
                this.gluTess.addVertex(vertex);
            }
            if (this.stroke) {
                this.addStrokeVertex(x, y, z, strokeColor, strokeWeight);
            }
        }

        void beginPolygonStroke() {
            this.pathVertexCount = 0;
            if (this.pathVertices == null) {
                this.pathVertices = new float[3 * PGL.DEFAULT_IN_VERTICES];
                this.pathColors = new int[PGL.DEFAULT_IN_VERTICES];
                this.pathWeights = new float[PGL.DEFAULT_IN_VERTICES];
            }
        }

        void endPolygonStroke() {
        }

        void beginStrokePath() {
            this.beginPath = this.pathVertexCount;
        }

        void endStrokePath(boolean closed) {
            int idx = this.pathVertexCount;
            if (this.beginPath + 1 < idx) {
                boolean begin = this.beginPath == idx - 2;
                boolean end = begin || !closed;
                this.in.addEdge(idx - 2, idx - 1, begin, end);
                if (!end) {
                    this.in.addEdge(idx - 1, this.beginPath, false, false);
                    this.in.closeEdge(idx - 1, this.beginPath);
                }
            }
        }

        void addStrokeVertex(float x, float y, float z, int c, float w) {
            int idx = this.pathVertexCount;
            if (this.beginPath + 1 < idx) {
                this.in.addEdge(idx - 2, idx - 1, this.beginPath == idx - 2, false);
            }
            if (this.pathVertexCount == this.pathVertices.length / 3) {
                int newSize = this.pathVertexCount << 1;
                float[] vtemp = new float[3 * newSize];
                PApplet.arrayCopy(this.pathVertices, 0, vtemp, 0, 3 * this.pathVertexCount);
                this.pathVertices = vtemp;
                int[] ctemp = new int[newSize];
                PApplet.arrayCopy(this.pathColors, 0, ctemp, 0, this.pathVertexCount);
                this.pathColors = ctemp;
                float[] wtemp = new float[newSize];
                PApplet.arrayCopy(this.pathWeights, 0, wtemp, 0, this.pathVertexCount);
                this.pathWeights = wtemp;
            }
            this.pathVertices[3 * idx + 0] = x;
            this.pathVertices[3 * idx + 1] = y;
            this.pathVertices[3 * idx + 2] = z;
            this.pathColors[idx] = c;
            this.pathWeights[idx] = w;
            ++this.pathVertexCount;
        }

        void tessellateStrokePath() {
            if (this.in.edgeCount == 0) {
                return;
            }
            this.strokeVertices = this.pathVertices;
            this.strokeColors = this.pathColors;
            this.strokeWeights = this.pathWeights;
            if (this.is3D) {
                this.tessellateEdges3D();
            } else if (this.is2D) {
                this.beginNoTex();
                this.tessellateEdges2D();
                this.endNoTex();
            }
        }

        boolean clampPolygon() {
            return false;
        }

        public void tessellateLinePath(LinePath path) {
            int cap;
            this.initGluTess();
            boolean clamp = this.clampLinePath();
            this.callback.init(this.in.renderMode == 1, true, false, clamp);
            int n = this.strokeCap == 2 ? 1 : (cap = this.strokeCap == 4 ? 2 : 0);
            int join = this.strokeJoin == 2 ? 1 : (this.strokeJoin == 32 ? 2 : 0);
            LinePath strokedPath = LinePath.createStrokedPath(path, this.strokeWeight, cap, join);
            this.gluTess.beginPolygon();
            float[] coords = new float[6];
            LinePath.PathIterator iter = strokedPath.getPathIterator();
            int rule = iter.getWindingRule();
            switch (rule) {
                case 0: {
                    this.gluTess.setWindingRule(PGL.TESS_WINDING_ODD);
                    break;
                }
                case 1: {
                    this.gluTess.setWindingRule(PGL.TESS_WINDING_NONZERO);
                }
            }
            while (!iter.isDone()) {
                switch (iter.currentSegment(coords)) {
                    case 0: {
                        this.gluTess.beginContour();
                    }
                    case 1: {
                        double[] vertex = new double[]{coords[0], coords[1], 0.0, coords[2], coords[3], coords[4], coords[5], 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        this.gluTess.addVertex(vertex);
                        break;
                    }
                    case 2: {
                        this.gluTess.endContour();
                    }
                }
                iter.next();
            }
            this.gluTess.endPolygon();
        }

        boolean clampLinePath() {
            return this.clamp2D() && this.strokeCap == 4 && this.strokeJoin == 32 && !this.subPixelStroke(this.strokeWeight);
        }

        protected class TessellatorCallback
        implements PGL.TessellatorCallback {
            boolean calcNormals;
            boolean strokeTess;
            boolean clampXY;
            IndexCache cache;
            int cacheIndex;
            int vertFirst;
            int vertCount;
            int vertOffset;
            int primitive;

            protected TessellatorCallback() {
            }

            public void init(boolean addCache, boolean strokeTess, boolean calcNorm, boolean clampXY) {
                this.strokeTess = strokeTess;
                this.calcNormals = calcNorm;
                this.clampXY = clampXY;
                this.cache = Tessellator.this.tess.polyIndexCache;
                if (addCache) {
                    this.cache.addNew();
                }
            }

            @Override
            public void begin(int type) {
                this.cacheIndex = this.cache.getLast();
                if (Tessellator.this.firstPolyIndexCache == -1) {
                    Tessellator.this.firstPolyIndexCache = this.cacheIndex;
                }
                if (this.strokeTess && Tessellator.this.firstLineIndexCache == -1) {
                    Tessellator.this.firstLineIndexCache = this.cacheIndex;
                }
                this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                this.vertOffset = this.cache.vertexOffset[this.cacheIndex];
                this.vertCount = 0;
                if (type == PGL.TRIANGLE_FAN) {
                    this.primitive = 11;
                } else if (type == PGL.TRIANGLE_STRIP) {
                    this.primitive = 10;
                } else if (type == PGL.TRIANGLES) {
                    this.primitive = 9;
                }
            }

            @Override
            public void end() {
                if (PGL.MAX_VERTEX_INDEX1 <= this.vertFirst + this.vertCount) {
                    this.cacheIndex = this.cache.addNew();
                    this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                    this.vertOffset = this.cache.vertexOffset[this.cacheIndex];
                }
                int indCount = 0;
                switch (this.primitive) {
                    case 11: {
                        indCount = 3 * (this.vertCount - 2);
                        int i = 1;
                        while (i < this.vertCount - 1) {
                            this.addIndex(0);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (this.calcNormals) {
                                this.calcTriNormal(0, i, i + 1);
                            }
                            ++i;
                        }
                        break;
                    }
                    case 10: {
                        indCount = 3 * (this.vertCount - 2);
                        int i = 1;
                        while (i < this.vertCount - 1) {
                            if (i % 2 == 0) {
                                this.addIndex(i + 1);
                                this.addIndex(i);
                                this.addIndex(i - 1);
                                if (this.calcNormals) {
                                    this.calcTriNormal(i + 1, i, i - 1);
                                }
                            } else {
                                this.addIndex(i - 1);
                                this.addIndex(i);
                                this.addIndex(i + 1);
                                if (this.calcNormals) {
                                    this.calcTriNormal(i - 1, i, i + 1);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case 9: {
                        indCount = this.vertCount;
                        int i = 0;
                        while (i < this.vertCount) {
                            this.addIndex(i);
                            ++i;
                        }
                        if (!this.calcNormals) break;
                        int tr = 0;
                        while (tr < this.vertCount / 3) {
                            int i0 = 3 * tr + 0;
                            int i1 = 3 * tr + 1;
                            int i2 = 3 * tr + 2;
                            this.calcTriNormal(i0, i1, i2);
                            ++tr;
                        }
                        break;
                    }
                }
                this.cache.incCounts(this.cacheIndex, indCount, this.vertCount);
                Tessellator.this.lastPolyIndexCache = this.cacheIndex;
                if (this.strokeTess) {
                    Tessellator.this.lastLineIndexCache = this.cacheIndex;
                }
            }

            protected void addIndex(int tessIdx) {
                Tessellator.this.tess.polyIndexCheck();
                Tessellator.this.tess.polyIndices[Tessellator.this.tess.polyIndexCount - 1] = (short)(this.vertFirst + tessIdx);
            }

            protected void calcTriNormal(int tessIdx0, int tessIdx1, int tessIdx2) {
                Tessellator.this.tess.calcPolyNormal(this.vertFirst + this.vertOffset + tessIdx0, this.vertFirst + this.vertOffset + tessIdx1, this.vertFirst + this.vertOffset + tessIdx2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void vertex(Object data) {
                if (!(data instanceof double[])) throw new RuntimeException("TessCallback vertex() data not understood");
                double[] d = (double[])data;
                int l = d.length;
                if (l < 25) {
                    throw new RuntimeException("TessCallback vertex() data is not of length 25");
                }
                if (this.vertCount >= PGL.MAX_VERTEX_INDEX1) throw new RuntimeException("The tessellator is generating too many vertices, reduce complexity of shape.");
                int fcolor = (int)d[3] << 24 | (int)d[4] << 16 | (int)d[5] << 8 | (int)d[6];
                int acolor = (int)d[12] << 24 | (int)d[13] << 16 | (int)d[14] << 8 | (int)d[15];
                int scolor = (int)d[16] << 24 | (int)d[17] << 16 | (int)d[18] << 8 | (int)d[19];
                int ecolor = (int)d[20] << 24 | (int)d[21] << 16 | (int)d[22] << 8 | (int)d[23];
                Tessellator.this.tess.addPolyVertex((float)d[0], (float)d[1], (float)d[2], fcolor, (float)d[7], (float)d[8], (float)d[9], (float)d[10], (float)d[11], acolor, scolor, ecolor, (float)d[24], this.clampXY);
                ++this.vertCount;
            }

            @Override
            public void error(int errnum) {
                String estring = Tessellator.this.pg.pgl.tessError(errnum);
                PGraphics.showWarning(PGraphicsOpenGL.TESSELLATION_ERROR, estring);
            }

            @Override
            public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
                double[] vertex = new double[33];
                vertex[0] = coords[0];
                vertex[1] = coords[1];
                vertex[2] = coords[2];
                int i = 3;
                while (i < 25) {
                    vertex[i] = 0.0;
                    int j = 0;
                    while (j < 4) {
                        double[] vertData = (double[])data[j];
                        if (vertData != null) {
                            int n = i;
                            vertex[n] = vertex[n] + (double)weight[j] * vertData[i];
                        }
                        ++j;
                    }
                    ++i;
                }
                double sum = vertex[7] * vertex[7] + vertex[8] * vertex[8] + vertex[9] * vertex[9];
                double len = Math.sqrt(sum);
                vertex[7] = vertex[7] / len;
                vertex[8] = vertex[8] / len;
                vertex[9] = vertex[9] / len;
                outData[0] = vertex;
            }
        }
    }

    protected static class TexCache {
        PGraphicsOpenGL pg;
        int size;
        PImage[] textures;
        int[] firstIndex;
        int[] lastIndex;
        int[] firstCache;
        int[] lastCache;
        boolean hasTextures;

        TexCache(PGraphicsOpenGL pg) {
            this.pg = pg;
            this.allocate();
        }

        void allocate() {
            this.textures = new PImage[PGL.DEFAULT_IN_TEXTURES];
            this.firstIndex = new int[PGL.DEFAULT_IN_TEXTURES];
            this.lastIndex = new int[PGL.DEFAULT_IN_TEXTURES];
            this.firstCache = new int[PGL.DEFAULT_IN_TEXTURES];
            this.lastCache = new int[PGL.DEFAULT_IN_TEXTURES];
            this.size = 0;
            this.hasTextures = false;
        }

        void clear() {
            Arrays.fill(this.textures, 0, this.size, null);
            this.size = 0;
            this.hasTextures = false;
        }

        boolean containsTexture(PImage img) {
            int i = 0;
            while (i < this.size) {
                if (this.textures[i] == img) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        PImage getTextureImage(int i) {
            return this.textures[i];
        }

        Texture getTexture(int i) {
            PImage img = this.textures[i];
            Texture tex = null;
            if (img != null) {
                tex = this.pg.getTexture(img);
            }
            return tex;
        }

        void addTexture(PImage img, int firsti, int firstb, int lasti, int lastb) {
            this.arrayCheck();
            this.textures[this.size] = img;
            this.firstIndex[this.size] = firsti;
            this.lastIndex[this.size] = lasti;
            this.firstCache[this.size] = firstb;
            this.lastCache[this.size] = lastb;
            this.hasTextures |= img != null;
            ++this.size;
        }

        void setLastIndex(int lasti, int lastb) {
            this.lastIndex[this.size - 1] = lasti;
            this.lastCache[this.size - 1] = lastb;
        }

        void arrayCheck() {
            if (this.size == this.textures.length) {
                int newSize = this.size << 1;
                this.expandTextures(newSize);
                this.expandFirstIndex(newSize);
                this.expandLastIndex(newSize);
                this.expandFirstCache(newSize);
                this.expandLastCache(newSize);
            }
        }

        void expandTextures(int n) {
            PImage[] temp = new PImage[n];
            PApplet.arrayCopy(this.textures, 0, temp, 0, this.size);
            this.textures = temp;
        }

        void expandFirstIndex(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.firstIndex, 0, temp, 0, this.size);
            this.firstIndex = temp;
        }

        void expandLastIndex(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lastIndex, 0, temp, 0, this.size);
            this.lastIndex = temp;
        }

        void expandFirstCache(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.firstCache, 0, temp, 0, this.size);
            this.firstCache = temp;
        }

        void expandLastCache(int n) {
            int[] temp = new int[n];
            PApplet.arrayCopy(this.lastCache, 0, temp, 0, this.size);
            this.lastCache = temp;
        }
    }

    class Triangle {
        int i0;
        int i1;
        int i2;
        PImage tex;
        float dist;

        Triangle(int i0, int i1, int i2, PImage tex, float dist) {
            this.i0 = i0;
            this.i1 = i1;
            this.i2 = i2;
            this.tex = tex;
            this.dist = dist;
        }
    }
}

