/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Set;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsFileAttributeViews {
    WindowsFileAttributeViews() {
    }

    static Basic createBasicView(WindowsPath windowsPath, boolean bl) {
        return new Basic(windowsPath, bl);
    }

    static Dos createDosView(WindowsPath windowsPath, boolean bl) {
        return new Dos(windowsPath, bl);
    }

    private static class Basic
    extends AbstractBasicFileAttributeView {
        final WindowsPath file;
        final boolean followLinks;

        Basic(WindowsPath windowsPath, boolean bl) {
            this.file = windowsPath;
            this.followLinks = bl;
        }

        @Override
        public WindowsFileAttributes readAttributes() throws IOException {
            this.file.checkRead();
            try {
                return WindowsFileAttributes.get(this.file, this.followLinks);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(this.file);
                return null;
            }
        }

        private long adjustForFatEpoch(long l) {
            if (l != -1L && l < 119600064000000000L) {
                return 119600064000000000L;
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFileTimes(long l, long l2, long l3) throws IOException {
            long l4 = -1L;
            try {
                int n = 0x2000000;
                if (!this.followLinks && this.file.getFileSystem().supportsLinks()) {
                    n |= 0x200000;
                }
                l4 = WindowsNativeDispatcher.CreateFile(this.file.getPathForWin32Calls(), 256, 7, 3, n);
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(this.file);
            }
            try {
                WindowsNativeDispatcher.SetFileTime(l4, l, l2, l3);
            }
            catch (WindowsException windowsException) {
                Object var9_8;
                if (this.followLinks && windowsException.lastError() == 87) {
                    try {
                        if (WindowsFileStore.create(this.file).type().equals("FAT")) {
                            WindowsNativeDispatcher.SetFileTime(l4, this.adjustForFatEpoch(l), this.adjustForFatEpoch(l2), this.adjustForFatEpoch(l3));
                            var9_8 = null;
                        }
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (WindowsException windowsException2) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (var9_8 != null) {
                    var9_8.rethrowAsIOException(this.file);
                }
            }
            finally {
                WindowsNativeDispatcher.CloseHandle(l4);
            }
        }

        @Override
        public void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
            if (fileTime == null && fileTime2 == null && fileTime3 == null) {
                return;
            }
            this.file.checkWrite();
            long l = fileTime3 == null ? -1L : WindowsFileAttributes.toWindowsTime(fileTime3);
            long l2 = fileTime2 == null ? -1L : WindowsFileAttributes.toWindowsTime(fileTime2);
            long l3 = fileTime == null ? -1L : WindowsFileAttributes.toWindowsTime(fileTime);
            this.setFileTimes(l, l2, l3);
        }
    }

    static class Dos
    extends Basic
    implements DosFileAttributeView {
        private static final String READONLY_NAME = "readonly";
        private static final String ARCHIVE_NAME = "archive";
        private static final String SYSTEM_NAME = "system";
        private static final String HIDDEN_NAME = "hidden";
        private static final String ATTRIBUTES_NAME = "attributes";
        static final Set<String> dosAttributeNames = Util.newSet(basicAttributeNames, new String[]{"readonly", "archive", "system", "hidden", "attributes"});

        Dos(WindowsPath windowsPath, boolean bl) {
            super(windowsPath, bl);
        }

        @Override
        public String name() {
            return "dos";
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            if (string.equals(READONLY_NAME)) {
                this.setReadOnly((Boolean)object);
                return;
            }
            if (string.equals(ARCHIVE_NAME)) {
                this.setArchive((Boolean)object);
                return;
            }
            if (string.equals(SYSTEM_NAME)) {
                this.setSystem((Boolean)object);
                return;
            }
            if (string.equals(HIDDEN_NAME)) {
                this.setHidden((Boolean)object);
                return;
            }
            super.setAttribute(string, object);
        }

        @Override
        public Map<String, Object> readAttributes(String[] stringArray) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(dosAttributeNames, stringArray);
            DosFileAttributes dosFileAttributes = this.readAttributes();
            this.addRequestedBasicAttributes(dosFileAttributes, attributesBuilder);
            if (attributesBuilder.match(READONLY_NAME)) {
                attributesBuilder.add(READONLY_NAME, ((WindowsFileAttributes)dosFileAttributes).isReadOnly());
            }
            if (attributesBuilder.match(ARCHIVE_NAME)) {
                attributesBuilder.add(ARCHIVE_NAME, ((WindowsFileAttributes)dosFileAttributes).isArchive());
            }
            if (attributesBuilder.match(SYSTEM_NAME)) {
                attributesBuilder.add(SYSTEM_NAME, ((WindowsFileAttributes)dosFileAttributes).isSystem());
            }
            if (attributesBuilder.match(HIDDEN_NAME)) {
                attributesBuilder.add(HIDDEN_NAME, ((WindowsFileAttributes)dosFileAttributes).isHidden());
            }
            if (attributesBuilder.match(ATTRIBUTES_NAME)) {
                attributesBuilder.add(ATTRIBUTES_NAME, ((WindowsFileAttributes)dosFileAttributes).attributes());
            }
            return attributesBuilder.unmodifiableMap();
        }

        private void updateAttributes(int n, boolean bl) throws IOException {
            this.file.checkWrite();
            String string = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
            try {
                int n2;
                int n3 = n2 = WindowsNativeDispatcher.GetFileAttributes(string);
                n3 = bl ? (n3 |= n) : (n3 &= ~n);
                if (n3 != n2) {
                    WindowsNativeDispatcher.SetFileAttributes(string, n3);
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(this.file);
            }
        }

        @Override
        public void setReadOnly(boolean bl) throws IOException {
            this.updateAttributes(1, bl);
        }

        @Override
        public void setHidden(boolean bl) throws IOException {
            this.updateAttributes(2, bl);
        }

        @Override
        public void setArchive(boolean bl) throws IOException {
            this.updateAttributes(32, bl);
        }

        @Override
        public void setSystem(boolean bl) throws IOException {
            this.updateAttributes(4, bl);
        }

        void setAttributes(WindowsFileAttributes windowsFileAttributes) throws IOException {
            int n = 0;
            if (windowsFileAttributes.isReadOnly()) {
                n |= 1;
            }
            if (windowsFileAttributes.isHidden()) {
                n |= 2;
            }
            if (windowsFileAttributes.isArchive()) {
                n |= 0x20;
            }
            if (windowsFileAttributes.isSystem()) {
                n |= 4;
            }
            this.updateAttributes(n, true);
            this.setFileTimes(WindowsFileAttributes.toWindowsTime(windowsFileAttributes.creationTime()), WindowsFileAttributes.toWindowsTime(windowsFileAttributes.lastModifiedTime()), WindowsFileAttributes.toWindowsTime(windowsFileAttributes.lastAccessTime()));
        }
    }
}

