/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import java.util.Arrays;

public class Delay
extends UGen {
    public UGen.UGenInput audio = this.addAudio();
    public UGen.UGenInput delTime;
    public UGen.UGenInput delAmp;
    private float maxDelayTime;
    private double[] delayBuffer;
    private int delayBufferFrames;
    private int iBufferOut;
    private boolean feedBackOn;
    private boolean passAudioOn;

    public Delay() {
        this(0.25f, 0.5f, false, true);
    }

    public Delay(float f) {
        this(f, 0.5f, false, true);
    }

    public Delay(float f, float f2) {
        this(f, f2, false, true);
    }

    public Delay(float f, float f2, boolean bl) {
        this(f, f2, bl, true);
    }

    public Delay(float f, float f2, boolean bl, boolean bl2) {
        this.maxDelayTime = f;
        this.delTime = this.addControl(f);
        this.delAmp = this.addControl(f2);
        this.feedBackOn = bl;
        this.passAudioOn = bl2;
        this.iBufferOut = 0;
    }

    @Override
    protected void sampleRateChanged() {
        this.allocateDelayBuffer();
    }

    @Override
    protected void channelCountChanged() {
        this.allocateDelayBuffer();
    }

    void allocateDelayBuffer() {
        this.delayBufferFrames = (int)(this.maxDelayTime * this.sampleRate());
        this.delayBuffer = new double[this.delayBufferFrames * this.audio.channelCount()];
        this.iBufferOut = 0;
    }

    public void setDelTime(float f) {
        this.delTime.setLastValue(f);
    }

    public void setDelAmp(float f) {
        this.delAmp.setLastValue(f);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (this.delayBuffer == null || this.delayBuffer.length == 0) {
            Arrays.fill(fArray, 0.0f);
            return;
        }
        int n = (int)(this.delTime.getLastValue() * this.sampleRate());
        int n2 = this.channelCount();
        for (int i = 0; i < n2; ++i) {
            float f = this.audio.getLastValues()[i];
            int n3 = this.iBufferOut * n2 + i;
            float f2 = this.delAmp.getLastValue() * (float)this.delayBuffer[n3];
            this.delayBuffer[n3] = 0.0;
            int n4 = (this.iBufferOut + n) % this.delayBufferFrames;
            int n5 = n4 * n2 + i;
            this.delayBuffer[n5] = f;
            if (this.feedBackOn) {
                int n6 = n5;
                this.delayBuffer[n6] = this.delayBuffer[n6] + (double)f2;
            }
            if (this.passAudioOn) {
                f2 += f;
            }
            fArray[i] = f2;
        }
        this.iBufferOut = (this.iBufferOut + 1) % this.delayBufferFrames;
    }
}

