import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 
import java.io.PrintStream; 
import java.io.OutputStream; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class i_want_to_evolve extends PApplet {

/* 

* * * * * * * * * * * * * * * * * * * * * * * *
*
* I Want To Evolve
* by Primitive
*
* Designed resolution 1280x720
*
* First presented at Graffathon 2015
* http://www.graffathon.fi
*
* T-101   - code, music
* bracket - graphics
* 
* Very special thanks to urs/mercury, codice/dahlia,
* and the organizers of Graffathon for massive support
*
* http://primitive.be
* http://www.t-101.org
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

*/






int CANVAS_WIDTH = 1280;
int CANVAS_HEIGHT = 720;

Moonlander moonlander;

PShader mandelbrotshader;
PFont mono;
PImage overlayimg;
PImage primitivelogo;
PImage evolvelogo;
PImage endimg;

ArrayList<String> greetGroups = new ArrayList<String>();
ArrayList<GreetObject> greetObjects = new ArrayList<GreetObject>();
String greetsStartRow = "290";

float x,y,z;

public void setup() {

  // disable console output
  System.out.println("I Want To Evolve\n2015 Primitive"); // will be printed
  System.setErr(new PrintStream(new OutputStream() {
      public void write(int b) {
      }
  }));

  // init screen
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  frameRate(60);
  background(0,0,0);

  // load font
  mono = loadFont("CenturyGothic-72.vlw");
  textFont(mono);
  textAlign(CENTER, CENTER);

  // init mandelbrot shader
  mandelbrotshader = loadShader("mandelbrot.glsl");
  mandelbrotshader.set("iResolution", (float)CANVAS_WIDTH, (float)CANVAS_HEIGHT);
  
  // load graphics
  overlayimg = loadImage("overlay1.png");
  primitivelogo = loadImage("primitivelogo_alpha.png");
  evolvelogo = loadImage("primitive-iwanttoevolve.png");
  endimg = loadImage("primitive_axelogo.png");
  
  // init music
  moonlander = Moonlander.initWithSoundtrack(this, "T-101_-_Vitae_Novel_Two.mp3", 101, 8);
  moonlander.start();

  // setup variables
  x = CANVAS_WIDTH/2;
  y = CANVAS_HEIGHT/2;
  z = 0;
  
  greetGroups.add("accession");
  greetGroups.add("alpha design");
  greetGroups.add("beyond force");
  greetGroups.add("boozoholics");
  greetGroups.add("brainstorm");
  greetGroups.add("byterapers");
  greetGroups.add("cncd");
  greetGroups.add("coma");
  greetGroups.add("dahlia");
  greetGroups.add("damones");
  greetGroups.add("darklite");
  greetGroups.add("dekadence");
  greetGroups.add("extend");
  greetGroups.add("finnish gold");
  greetGroups.add("HiRMU");
  greetGroups.add("jumalauta");
  greetGroups.add("mercury");
  greetGroups.add("peisik");
  greetGroups.add("rno");
  greetGroups.add("spaceballs");
  greetGroups.add("teurasporsaat");
  greetGroups.add("TRSi");
  greetGroups.add("\u00fcmlaut design");
  greetGroups.add("wide load");
}


public void draw() {
  moonlander.update();

  clear();
  background(0);

  // Initial Strobe
  if ((int)moonlander.getCurrentRow() > Integer.parseInt("000", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("120", 16)) {
      strobe();
  }

  // Graffathon text
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("120", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("180", 16)) {
      graffathon();
  }

  // Primitive logo
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("180", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("1C0", 16)) {
      primitiveLogo();
  }
  
  // I Want To Evolve logo
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("1C0", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("200", 16)) {
      evolveLogo();
  }
  
  // Cubes, cross
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("200", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("250", 16)) {
      cubes1();
  }
  
  // Cubes, orbit
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("250", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("280", 16)) {
      cubes2();
  }
  
  // Greetings
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("280", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("480", 16)) {
      greetings();
  }
  
  // Mandelbrot
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("480", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("580", 16)) {
      mandelbrot(); 
  }

  // Credits
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("580", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("600", 16)) {
      credits(); 
  }

  // Final logo
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("600", 16)
    && (int)moonlander.getCurrentRow() < Integer.parseInt("650", 16)) {
      endLogo(); 
  }
}

public void overlay() {
    image(overlayimg, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
}

public void strobe() {
  background((int)moonlander.getValue("strobe_white"));
  overlay();
}

public void graffathon() {
  background((int)moonlander.getValue("strobe_white"));
  fill((int)moonlander.getValue("imageFade"));
  text("GRAFFATHON\n2015", CANVAS_WIDTH/2, CANVAS_HEIGHT/2);
  overlay();
}

public void primitiveLogo() {
  background((int)moonlander.getValue("strobe_white"));
  tint(255,(int)moonlander.getValue("imageFade"));
  image(primitivelogo, 0 ,0+sin(millis()*0.0005f)*20, CANVAS_WIDTH, CANVAS_HEIGHT);
  tint(255,255);
  overlay();
}

public void evolveLogo() {
  background((int)moonlander.getValue("strobe_white"));
  tint(255,(int)moonlander.getValue("imageFade"));
  image(evolvelogo, 0 ,0, CANVAS_WIDTH, CANVAS_HEIGHT);
  tint(255,255);
  overlay();
}

public void cubes1() {
  background((int)moonlander.getValue("strobe_white"));
  hint(ENABLE_DEPTH_TEST);
  fill((int)moonlander.getValue("imageFade"));
  if ((int)moonlander.getCurrentRow() >= Integer.parseInt("220", 16)) {
    pushMatrix();
    translate(x,y,z);
    rectMode(CENTER);
    rotateZ(0+(millis()*0.001f));
    rotateX(0+(millis()*0.001f));
    box(CANVAS_HEIGHT/6);
    translate(-CANVAS_HEIGHT/6,0);
    box(CANVAS_HEIGHT/6);
    translate((CANVAS_HEIGHT/6)*2,0);
    box(CANVAS_HEIGHT/6);
    translate(-CANVAS_HEIGHT/6,-CANVAS_HEIGHT/6,0);
    box(CANVAS_HEIGHT/6);
    translate(0,(CANVAS_HEIGHT/6)*2,0);
    box(CANVAS_HEIGHT/6);
    translate(0,-CANVAS_HEIGHT/6,-CANVAS_HEIGHT/6);
    box(CANVAS_HEIGHT/6);
    translate(0,0,(CANVAS_HEIGHT/6)*2);
    box(CANVAS_HEIGHT/6);
    popMatrix();
    hint(DISABLE_DEPTH_TEST);
  }
  overlay();
}

public void cubes2() {
  hint(ENABLE_DEPTH_TEST);
  fill((int)moonlander.getValue("imageFade"));
  pushMatrix();
  translate(x,y,z);
  rectMode(CENTER);
  translate(0,0,0);
  rotateZ(0+(millis()*0.001f));
  rotateX(0+(millis()*0.001f));
  sphereDetail(5, 128);
  strokeWeight(1);
  sphere(CANVAS_HEIGHT/6);
  translate(CANVAS_HEIGHT/3,0,0);
  rotateZ(0+(millis()*0.001f));
  rotateX(0+(millis()*0.001f));
  strokeWeight(2);
  box(CANVAS_HEIGHT/10);
  popMatrix();
  hint(DISABLE_DEPTH_TEST);
  overlay();
}

public void cubes3() {
  hint(ENABLE_DEPTH_TEST);
  for (int i = 0; i < 12; i++) {
    fill((int)moonlander.getValue("imageFade"));
    pushMatrix();  
    translate(x+100,y+100,z);
    box(50);
    
    popMatrix();
    rotateX(360/10);
  }
    hint(DISABLE_DEPTH_TEST);
    overlay();
}

float deltaTime = 0;
int lastTime = 0;


public void greetings() {
  int currentTime = millis();
  deltaTime = (float)(currentTime - lastTime) / 1000;
  lastTime = currentTime;
  
  if ((int)moonlander.getValue("greetingsCounter") > greetObjects.size()) {
    GreetObject greetObject = new GreetObject(greetGroups.get((int)moonlander.getValue("greetingsCounter")-1));
    greetObjects.add(greetObject);
  }

  for (int i = 0; i < greetObjects.size(); i++) {
    greetObjects.get(i).x += deltaTime * (float)CANVAS_WIDTH/6.0f;
    greetObjects.get(i).draw();
    
  }
  overlay();
}

class GreetObject {   

  String greetText;
  float x,y;
  
  GreetObject(String name) {
    x = -CANVAS_WIDTH / 2;
    
    float min = CANVAS_HEIGHT/9 - (float)CANVAS_HEIGHT/2.0f;
    float max = (float)CANVAS_HEIGHT/2.0f - CANVAS_HEIGHT/9;
    y = (int)min + (int)(Math.random() * ((max - min) + 1.0f));
    
    if (greetGroups.size() > 0) {
      greetText = name;
    }
  }
  
  public void draw() {
    pushMatrix();
    translate(CANVAS_WIDTH/2,CANVAS_HEIGHT/2);
    pushMatrix();
    rotate(PI);
      fill((int)64 + (int)(Math.random() * ((255 - 64) + 1.0f)) + sin(millis() * 0.005f)*60);
    text(greetText, x-200,y);
    popMatrix();
    popMatrix();
  }
  
}

public void mandelbrot() {
  shader(mandelbrotshader);
  mandelbrotshader.set("iGlobalTime", (float)moonlander.getCurrentTime());
  mandelbrotshader.set("texture", overlayimg);
  textureMode(NORMAL);
  image(overlayimg, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
}

public void credits() {
  resetShader();
  background((int)moonlander.getValue("strobe_white"));
  
  fill((int)moonlander.getValue("imageFade"));
  
  if (moonlander.getCurrentRow() < 1472) {
    text("T-101\ncode ^ music", CANVAS_WIDTH/2, CANVAS_HEIGHT/2);
  } else {
    textSize(36);
    text("featuring", CANVAS_WIDTH/2, CANVAS_HEIGHT/4);
    textSize(72);
    text("BRACKET\ngfx", CANVAS_WIDTH/2, CANVAS_HEIGHT/2);
  }
  overlay();
}

public void endLogo() {
  background((int)moonlander.getValue("strobe_white"));
  tint(255,(int)moonlander.getValue("imageFade"));
  image(endimg, 0 ,0, CANVAS_WIDTH, CANVAS_HEIGHT);
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "i_want_to_evolve" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
