/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.spi.CurrencyNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.logging.PlatformLogger;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private final transient int numericCode;
    private static HashMap<String, Currency> instances = new HashMap(7);
    private static HashSet<Currency> available;
    static int formatVersion;
    static int dataVersion;
    static int[] mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static int[] scOldCurrenciesNumericCode;
    static int[] scNewCurrenciesNumericCode;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    static int[] otherCurrenciesNumericCode;
    private static final int MAGIC_NUMBER = 1131770436;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 128;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 96;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 128;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 128;
    private static final int NUMERIC_CODE_MASK = 261888;
    private static final int NUMERIC_CODE_SHIFT = 8;
    private static final int VALID_FORMAT_VERSION = 1;
    private static final int SYMBOL = 0;
    private static final int DISPLAYNAME = 1;

    private Currency(String string, int n, int n2) {
        this.currencyCode = string;
        this.defaultFractionDigits = n;
        this.numericCode = n2;
    }

    public static Currency getInstance(String string) {
        return Currency.getInstance(string, Integer.MIN_VALUE, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Currency getInstance(String string, int n, int n2) {
        HashMap<String, Currency> hashMap = instances;
        synchronized (hashMap) {
            Currency currency = instances.get(string);
            if (currency != null) {
                return currency;
            }
            if (n == Integer.MIN_VALUE) {
                char c;
                if (string.length() != 3) {
                    throw new IllegalArgumentException();
                }
                char c2 = string.charAt(0);
                int n3 = Currency.getMainTableEntry(c2, c = string.charAt(1));
                if ((n3 & 0x80) == 0 && n3 != 127 && string.charAt(2) - 65 == (n3 & 0x1F)) {
                    n = (n3 & 0x60) >> 5;
                    n2 = (n3 & 0x3FF00) >> 8;
                } else {
                    if (string.charAt(2) == '-') {
                        throw new IllegalArgumentException();
                    }
                    int n4 = otherCurrencies.indexOf(string);
                    if (n4 == -1) {
                        throw new IllegalArgumentException();
                    }
                    n = otherCurrenciesDFD[n4 / 4];
                    n2 = otherCurrenciesNumericCode[n4 / 4];
                }
            }
            currency = new Currency(string, n, n2);
            instances.put(string, currency);
            return currency;
        }
    }

    public static Currency getInstance(Locale locale) {
        char c;
        String string = locale.getCountry();
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException();
        }
        char c2 = string.charAt(0);
        int n = Currency.getMainTableEntry(c2, c = string.charAt(1));
        if ((n & 0x80) == 0 && n != 127) {
            char c3 = (char)((n & 0x1F) + 65);
            int n2 = (n & 0x60) >> 5;
            int n3 = (n & 0x3FF00) >> 8;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(c3);
            return Currency.getInstance(stringBuffer.toString(), n2, n3);
        }
        if (n == 127) {
            throw new IllegalArgumentException();
        }
        if (n == 128) {
            return null;
        }
        int n4 = (n & 0x1F) - 1;
        if (scCutOverTimes[n4] == Long.MAX_VALUE || System.currentTimeMillis() < scCutOverTimes[n4]) {
            return Currency.getInstance(scOldCurrencies[n4], scOldCurrenciesDFD[n4], scOldCurrenciesNumericCode[n4]);
        }
        return Currency.getInstance(scNewCurrencies[n4], scNewCurrenciesDFD[n4], scNewCurrenciesNumericCode[n4]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Currency> getAvailableCurrencies() {
        Object object = Currency.class;
        synchronized (Currency.class) {
            if (available == null) {
                available = new HashSet(256);
                for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                    for (char c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
                        int n = Currency.getMainTableEntry(c, c2);
                        if ((n & 0x80) != 0 || n == 127) continue;
                        char c3 = (char)((n & 0x1F) + 65);
                        int n2 = (n & 0x60) >> 5;
                        int n3 = (n & 0x3FF00) >> 8;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(c);
                        stringBuilder.append(c2);
                        stringBuilder.append(c3);
                        available.add(Currency.getInstance(stringBuilder.toString(), n2, n3));
                    }
                }
                StringTokenizer stringTokenizer = new StringTokenizer(otherCurrencies, "-");
                while (stringTokenizer.hasMoreElements()) {
                    available.add(Currency.getInstance((String)stringTokenizer.nextElement()));
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = (Set)available.clone();
            return object;
        }
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getSymbol(Locale locale) {
        try {
            Object object;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (localeServiceProviderPool.hasProviders() && (object = localeServiceProviderPool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, (OpenListResourceBundle)null, this.currencyCode, 0)) != null) {
                return object;
            }
            object = LocaleData.getCurrencyNames(locale);
            return ((ResourceBundle)object).getString(this.currencyCode);
        }
        catch (MissingResourceException missingResourceException) {
            return this.currencyCode;
        }
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        try {
            OpenListResourceBundle openListResourceBundle = LocaleData.getCurrencyNames(locale);
            String string = null;
            String string2 = this.currencyCode.toLowerCase(Locale.ROOT);
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                string = localeServiceProviderPool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, string2, openListResourceBundle, this.currencyCode, 1);
            }
            if (string == null) {
                string = openListResourceBundle.getString(string2);
            }
            if (string != null) {
                return string;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.currencyCode;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable[(c - 65) * 26 + (c2 - 65)];
    }

    private static void setMainTableEntry(char c, char c2, int n) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw new IllegalArgumentException();
        }
        Currency.mainTable[(c - 65) * 26 + (c2 - 65)] = n;
    }

    private static int[] readIntArray(DataInputStream dataInputStream, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    private static long[] readLongArray(DataInputStream dataInputStream, int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = dataInputStream.readLong();
        }
        return lArray;
    }

    private static String[] readStringArray(DataInputStream dataInputStream, int n) throws IOException {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }

    private static void replaceCurrencyData(Pattern pattern, String string, String string2) {
        int n;
        if (string.length() != 2) {
            String string3 = "The entry in currency.properties for " + string + " is ignored because of the invalid country code.";
            Currency.info(string3, null);
            return;
        }
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.find()) {
            String string4 = "The entry in currency.properties for " + string + " is ignored because the value format is not recognized.";
            Currency.info(string4, null);
            return;
        }
        String string5 = matcher.group(1);
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = Integer.parseInt(matcher.group(3));
        int n4 = n2 << 8;
        for (n = 0; n < scOldCurrencies.length && !scOldCurrencies[n].equals(string5); ++n) {
        }
        n4 = n == scOldCurrencies.length ? (n4 |= n3 << 5 | string5.charAt(2) - 65) : (n4 |= 0x80 | n + 1);
        Currency.setMainTableEntry(string.charAt(0), string.charAt(1), n4);
    }

    private static void info(String string, Throwable throwable) {
        PlatformLogger platformLogger = PlatformLogger.getLogger("java.util.Currency");
        if (platformLogger.isLoggable(800)) {
            if (throwable != null) {
                platformLogger.info(string, throwable);
            } else {
                platformLogger.info(string);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block19: {
                    Object object;
                    Object object2;
                    String string = System.getProperty("java.home");
                    try {
                        object2 = string + File.separator + "lib" + File.separator + "currency.data";
                        object = new DataInputStream(new BufferedInputStream(new FileInputStream((String)object2)));
                        if (((DataInputStream)object).readInt() != 1131770436) {
                            throw new InternalError("Currency data is possibly corrupted");
                        }
                        formatVersion = ((DataInputStream)object).readInt();
                        if (formatVersion != 1) {
                            throw new InternalError("Currency data format is incorrect");
                        }
                        dataVersion = ((DataInputStream)object).readInt();
                        mainTable = Currency.readIntArray((DataInputStream)object, 676);
                        int n = ((DataInputStream)object).readInt();
                        scCutOverTimes = Currency.readLongArray((DataInputStream)object, n);
                        scOldCurrencies = Currency.readStringArray((DataInputStream)object, n);
                        scNewCurrencies = Currency.readStringArray((DataInputStream)object, n);
                        scOldCurrenciesDFD = Currency.readIntArray((DataInputStream)object, n);
                        scNewCurrenciesDFD = Currency.readIntArray((DataInputStream)object, n);
                        scOldCurrenciesNumericCode = Currency.readIntArray((DataInputStream)object, n);
                        scNewCurrenciesNumericCode = Currency.readIntArray((DataInputStream)object, n);
                        int n2 = ((DataInputStream)object).readInt();
                        otherCurrencies = ((DataInputStream)object).readUTF();
                        otherCurrenciesDFD = Currency.readIntArray((DataInputStream)object, n2);
                        otherCurrenciesNumericCode = Currency.readIntArray((DataInputStream)object, n2);
                        ((FilterInputStream)object).close();
                    }
                    catch (IOException iOException) {
                        InternalError internalError = new InternalError();
                        internalError.initCause(iOException);
                        throw internalError;
                    }
                    try {
                        object2 = new File(string + File.separator + "lib" + File.separator + "currency.properties");
                        if (!((File)object2).exists()) break block19;
                        object = new Properties();
                        Serializable serializable = null;
                        try (Object object3 = new FileReader((File)object2);){
                            ((Properties)object).load((Reader)object3);
                        }
                        catch (Throwable throwable) {
                            serializable = throwable;
                            throw throwable;
                        }
                        object3 = ((Properties)object).stringPropertyNames();
                        serializable = Pattern.compile("([A-Z]{3})\\s*,\\s*(\\d{3})\\s*,\\s*([0-3])");
                        Iterator iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            Currency.replaceCurrencyData((Pattern)serializable, string2.toUpperCase(Locale.ROOT), ((Properties)object).getProperty(string2).toUpperCase(Locale.ROOT));
                        }
                    }
                    catch (IOException iOException) {
                        Currency.info("currency.properties is ignored because of an IOException", iOException);
                    }
                }
                return null;
            }
        });
    }

    private static class CurrencyNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CurrencyNameProvider, String> {
        private static final CurrencyNameGetter INSTANCE = new CurrencyNameGetter();

        private CurrencyNameGetter() {
        }

        @Override
        public String getObject(CurrencyNameProvider currencyNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 1);
            int n = (Integer)objectArray[0];
            switch (n) {
                case 0: {
                    return currencyNameProvider.getSymbol(string, locale);
                }
                case 1: {
                    return currencyNameProvider.getDisplayName(string, locale);
                }
            }
            assert (false);
            return null;
        }
    }
}

