
struct VSOutput
{
	float4 PositionCS : SV_POSITION;
	float2 TexCoord : texcoord0;
};

cbuffer PSConstants : register(b0)
{
	float2 Resolution : packoffset(c2.x);
};

float mod(float x, float y) { return x - y * floor(x/y); }
float2 mod(float2 x, float2 y) { return x - y * floor(x/y); }
float3 mod(float3 x, float3 y) { return x - y * floor(x/y); }
float4 mod(float4 x, float4 y) { return x - y * floor(x/y); }

void rotate(inout float2 v, float angle)
{
	float cs = cos(angle);
	float ss = sin(angle);
	v = mul(float2x2(cs,ss,-ss,cs),v);
}

/******************************************************
NOIZE!!!
*******************************************************/

// husky noise - by musk
// -----------
// the hash functions generate a random value between [0,1] for each input value
// they are deterministic (same input produces same output, regardless the number of calls)
// there are some limitations, due to float precision
// works well the range [-100,100] with 0.001 precision near 0
// hash function prototypes:
//   float hash(float x);  float hash(float2 x);  float hash(float3 x);  float hash(float4 x);
// noise functions return a random value for each unit in space
// using the hash functions, they have been calibrated to work well in the [-10000, 10000] range
// nearest noise (blocky noise), prototypes:
//   float nnoise(float x);  float nnoise(float2 x);  float nnoise(float3 x); float nnoise(float4 x);
// linear noise (linear interpolation), prototypes:
//   float lnoise(float x);  float lnoise(float2 x);  float lnoise(float3 x);  float lnoise(float4 x); 
// smooth noise (using smoothstep), prototypes:
//   float snoise(float x);  float snoise(float2 x);  float snoise(float3 x);  float snoise(float4 x)
#define _HASH(X) frac(X*X*13.7412+X*117.123147-111.512577)
float hash(float x){ return _HASH(_HASH(x)); }
float hash(float2 x){ return _HASH(dot(float2(_HASH(x.x), _HASH(x.y)), float2(27.7153, 1.7173))); }
float hash(float3 x){ return _HASH(dot(float3(_HASH(x.x), _HASH(x.y), _HASH(x.z)), float3(13.7153, 27.7153, 1.7173))); }
float hash(float4 x){ return _HASH(dot(float4(_HASH(x.x), _HASH(x.y), _HASH(x.z), _HASH(x.w)), float4(0.13719, 1.7173, 13.7153, 27.7153))); }
#define _NNOISE_T(T) float nnoise(T x){return hash((x-frac(x))*0.00390625);};
_NNOISE_T(float)_NNOISE_T(float2)_NNOISE_T(float3)_NNOISE_T(float4)
#define _HMIX(A,B,Y,Z) Z(hash(A*0.00390625), hash(B*0.00390625),Y)
#define _NOISE1_T(N,F) float N(float x){float f=frac(x),a=x-f,b=a+1;return _HMIX(a,b,f,F);};
#define _NOISE2_T(N,F) float N(float2 x){float2 f=frac(x),a=x-f,b=a+1;return F(_HMIX(a,float2(b.x,a.y),f.x,F),_HMIX(float2(a.x,b.y),b,f.x,F),f.y);};           
#define _NOISE3_T(N,F) float N(float3 x){float3 f=frac(x),a=x-f,b=a+1;return F(F(_HMIX(float3(a.x,a.y,a.z),float3(b.x,a.y,a.z),f.x,F),_HMIX(float3(a.x,b.y,a.z),float3(b.x,b.y,a.z),f.x,F),f.y),F(_HMIX(float3(a.x,a.y,b.z),float3(b.x,a.y,b.z),f.x,F), _HMIX(float3(a.x,b.y,b.z),float3(b.x,b.y,b.z),f.x,F),f.y),f.z);};
#define _NOISE4_T(N,F) float N(float4 x){float4 f=frac(x),a=x-f,b=a+1;return F(F(F(_HMIX(float4(a.x,a.y,a.z,a.w),float4(b.x,a.y,a.z,a.w),f.x,F),_HMIX(float4(a.x,b.y,a.z,a.w),float4(b.x,b.y,a.z,a.w),f.x,F),f.y),F(_HMIX(float4(a.x,a.y,b.z,a.w),float4(b.x,a.y,b.z,a.w),f.x,F), _HMIX(float4(a.x,b.y,b.z,a.w),float4(b.x,b.y,b.z,a.w),f.x,F),f.y),f.z),F(F(_HMIX(float4(a.x,a.y,a.z,b.w),float4(b.x,a.y,a.z,b.w),f.x,F),_HMIX(float4(a.x,b.y,a.z,b.w),float4(b.x,b.y,a.z,b.w),f.x,F),f.y),F(_HMIX(float4(a.x,a.y,b.z,b.w),float4(b.x,a.y,b.z,b.w),f.x,F),_HMIX(float4(a.x,b.y,b.z,b.w),float4(b.x,b.y,b.z,b.w),f.x,F),f.y),f.z),f.w);};
#define _NOISEX_T(N,F) _NOISE1_T(N,F) _NOISE2_T(N,F) _NOISE3_T(N,F) _NOISE4_T(N,F)
float slerp(float a, float b, float x){ return lerp(a, b, smoothstep(0, 1, x)); }
_NOISEX_T(lnoise, lerp);
_NOISEX_T(snoise, slerp);
