
#include <shadercommon.hlsli>

float4 p(VSOutput input) : SV_TARGET
{
	float2 uv = input.TexCoord;
	uv -= 0.5;
	//uv /= float2(16 / 9, 1.5);
	uv /= float2(Resolution.y / Resolution.x, 1);
	
	float2 polar = float2(atan2(uv.y,uv.x), length(uv.xy));
	float circle = saturate((.25-polar.y)*Resolution.x*.5);
	circle = min(circle, saturate((polar.y - .2)*Resolution.x*.5));
	float slicer = saturate((polar.x/355.0*113.0*.5+.5 - normalizedTime)*Resolution.x*.5*polar.y*6.0f);
	float timer = min(circle,slicer);

	return float4(backgroundColor + timer, 1);
}