
#include <shadercommon.hlsli>


float dfColors(float3 pos)
{
	float3 opos = pos;
	pos.xz = mod(pos.xz+2,4)-2;
	pos.y+=animTime*16-16-.5 + nnoise(opos.xz*.25+.5)*16;
	return min(length(pos)-.5,2);
}


float dfWater(float3 pos)
{
	float dfc = dfColors(pos)+.1;
	return 1-pos.y - 1.0/(1.0+dfc*dfc*4.0);
}


float df(float3 pos){
	return min(dfWater(pos),dfColors(pos));
}

float3 nf(float3 p){
    float2 e = float2(.0,.001);
    float c = df(p);
    return normalize(float3(df(p-e.yxx)-df(p+e.yxx),df(p-e.xyx)-df(p+e.xyx),df(p-e.xxy)-df(p+e.xxy)));
}

/*
float dfSphere(float3 pos)
{
	
	return 
	max(length(pos) - 1,
		-(length(pos-float3(.5,0,0)) - .7));
}

float dfPlane(float3 pos)
{
	return 1-pos.y;
}

float df(float3 pos)
{
	//return min(dfPlane(pos),dfSphere(pos));
	pos = mod(pos+2, 4)-2;
	return dfSphere(pos);
}

float3 nf(float3 pos)
{
	float2 e = float2(.0,.001);
	return normalize(float3(
		df(pos+e.yxx) - df(pos-e.yxx),
		df(pos+e.xyx) - df(pos-e.xyx),
		df(pos+e.xxy) - df(pos-e.xxy)
	));
}
*/

float ambientShading(float3 pos)
{
	float3 normal = nf(pos);
	return (
		((df(pos-normal*.7)/.7)*.5+.5) +
		((df(pos-normal*1.4)/1.4)*.5+.5) +
		((df(pos-normal*4.4)/4.4)*.5+.5)
		)*.33;
}

float4 p(VSOutput input) : SV_TARGET
{
	float2 uv = input.TexCoord;
	uv -= 0.5;
	//uv /= float2(16 / 9, 1.5);
	uv /= float2(Resolution.y / Resolution.x, 1);

	float t = time;
	
	float3 p = cameraPosition;
    float luv = length(uv);
    float3 dir = normalize(float3(uv.xy,1.0));
    
	rotate(dir.yz, cameraRX);
	rotate(dir.xz, cameraRY);
	
    float3 lightp = normalize(sin(p*.1))*5.0 + dir*15.0;
    
    p+=dir*hash(uv)*.1;
    float it;
	float total = 0;
    float dist;
    for(float i=0.0; i<100.0; i+=1.){
    	dist = df(p);
		total += dist;
        p+=dist*dir;
        it = i;
        if (dist<.01 || dist > 1000.0){
        	break;
        }
    }
    
    float3 d2 = normalize(lightp-p);
    float td = .01;
    float3 p2 = p+d2*(td+td*hash(uv));
    float occlusion = 1.0;
    float mtd = distance(lightp,p);
    
	float fog = 1.0 / (1.0 + total*.05);
	float4 background = float4((pow(1-abs(dir.y),4)+snoise(dir*4)) * float3(.4,.4,.4) * .1,1);
	
	if (dist<.1)
	{
		if (dfColors(p)<=dfWater(p))
		{
			float fresnel = dot(nf(p),dir)*.8 +.2;
			//fresnel = pow(fresnel,2)+.5;
			return lerp(
				background,
				fresnel*float4(nnoise(p.xz*.25+.5),nnoise(p.xz*.25+10.5),nnoise(p.xz*.25+4.5),1)*10,
				fog);
		}
		else
		{
			float diffuse = dot(nf(p),-d2)*.5+.5;
			float3 lcolor = float3(.4,.4,.4)*.15;
			float3 color= diffuse*lcolor/(1.0+mtd*mtd*.0005)*8.0*occlusion+lcolor/(1.0+mtd*mtd*.0005)*.5;
			color += (1-lcolor)*(td*.001+occlusion+it/200.0)*.5;
			color *= 1.0 - length(uv)*.5;
			if (dist<.1)
				color *= ambientShading(p);
			color = max(0,color-length(uv)*.05);
			return lerp(background, float4(color*.2,1)*fog, fog);
		}
	}
	else
	{
		return background;
	}
    
	//color += pow(max(0,dfCutter(p)+1.0f),100.0);
	
	//color = lerp(color,float3(1.1,1.1,1.2)*color / (color + 1),1.1);
	
    //color = nf(p)*.5+.5;
}