/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class NVSampleLocations {
    public static final int GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = 37693;
    public static final int GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = 37694;
    public static final int GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = 37695;
    public static final int GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = 37696;
    public static final int GL_SAMPLE_LOCATION_NV = 36432;
    public static final int GL_PROGRAMMABLE_SAMPLE_LOCATION_NV = 37697;
    public static final int GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = 37698;
    public static final int GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = 37699;
    public final long FramebufferSampleLocationsfvNV;
    public final long NamedFramebufferSampleLocationsfvNV;
    public final long ResolveDepthValuesNV;

    public NVSampleLocations(FunctionProvider provider) {
        this.FramebufferSampleLocationsfvNV = provider.getFunctionAddress("glFramebufferSampleLocationsfvNV");
        this.NamedFramebufferSampleLocationsfvNV = provider.getFunctionAddress("glNamedFramebufferSampleLocationsfvNV");
        this.ResolveDepthValuesNV = provider.getFunctionAddress("glResolveDepthValuesNV");
    }

    public static NVSampleLocations getInstance() {
        return GL.getCapabilities().__NVSampleLocations;
    }

    static NVSampleLocations create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_sample_locations")) {
            return null;
        }
        NVSampleLocations funcs = new NVSampleLocations(provider);
        boolean supported = Checks.checkFunctions(funcs.FramebufferSampleLocationsfvNV, funcs.NamedFramebufferSampleLocationsfvNV, funcs.ResolveDepthValuesNV);
        return GL.checkExtension("GL_NV_sample_locations", funcs, supported);
    }

    public static native void nglFramebufferSampleLocationsfvNV(int var0, int var1, int var2, long var3, long var5);

    public static void nglFramebufferSampleLocationsfvNV(int target, int start, int count, long v) {
        long __functionAddress = NVSampleLocations.getInstance().FramebufferSampleLocationsfvNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVSampleLocations.nglFramebufferSampleLocationsfvNV(target, start, count, v, __functionAddress);
    }

    public static void glFramebufferSampleLocationsfvNV(int target, int start, int count, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 2);
        }
        NVSampleLocations.nglFramebufferSampleLocationsfvNV(target, start, count, MemoryUtil.memAddress(v));
    }

    public static void glFramebufferSampleLocationsfvNV(int target, int start, FloatBuffer v) {
        NVSampleLocations.nglFramebufferSampleLocationsfvNV(target, start, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void nglNamedFramebufferSampleLocationsfvNV(int var0, int var1, int var2, long var3, long var5);

    public static void nglNamedFramebufferSampleLocationsfvNV(int framebuffer, int start, int count, long v) {
        long __functionAddress = NVSampleLocations.getInstance().NamedFramebufferSampleLocationsfvNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVSampleLocations.nglNamedFramebufferSampleLocationsfvNV(framebuffer, start, count, v, __functionAddress);
    }

    public static void glNamedFramebufferSampleLocationsfvNV(int framebuffer, int start, int count, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 2);
        }
        NVSampleLocations.nglNamedFramebufferSampleLocationsfvNV(framebuffer, start, count, MemoryUtil.memAddress(v));
    }

    public static void glNamedFramebufferSampleLocationsfvNV(int framebuffer, int start, FloatBuffer v) {
        NVSampleLocations.nglNamedFramebufferSampleLocationsfvNV(framebuffer, start, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void nglResolveDepthValuesNV(long var0);

    public static void glResolveDepthValuesNV() {
        long __functionAddress = NVSampleLocations.getInstance().ResolveDepthValuesNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVSampleLocations.nglResolveDepthValuesNV(__functionAddress);
    }
}

