/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class EXTMigrateMemobject {
    public static final int CL_MIGRATE_MEM_OBJECT_HOST_EXT = 1;
    public static final int CL_COMMAND_MIGRATE_MEM_OBJECT_EXT = 16448;
    public final long EnqueueMigrateMemObjectEXT;

    public EXTMigrateMemobject(FunctionProvider provider) {
        this.EnqueueMigrateMemObjectEXT = provider.getFunctionAddress("clEnqueueMigrateMemObjectEXT");
    }

    public static EXTMigrateMemobject getInstance() {
        return CL.getICD().__EXTMigrateMemobject;
    }

    static EXTMigrateMemobject create(FunctionProvider provider) {
        EXTMigrateMemobject funcs = new EXTMigrateMemobject(provider);
        boolean supported = Checks.checkFunctions(funcs.EnqueueMigrateMemObjectEXT);
        return supported ? funcs : null;
    }

    public static native int nclEnqueueMigrateMemObjectEXT(long var0, int var2, long var3, long var5, int var7, long var8, long var10, long var12);

    public static int nclEnqueueMigrateMemObjectEXT(long command_queue, int num_mem_objects, long mem_objects, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = EXTMigrateMemobject.getInstance().EnqueueMigrateMemObjectEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return EXTMigrateMemobject.nclEnqueueMigrateMemObjectEXT(command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueMigrateMemObjectEXT(long command_queue, int num_mem_objects, ByteBuffer mem_objects, long flags, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_mem_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return EXTMigrateMemobject.nclEnqueueMigrateMemObjectEXT(command_queue, num_mem_objects, MemoryUtil.memAddress(mem_objects), flags, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMigrateMemObjectEXT(long command_queue, PointerBuffer mem_objects, long flags, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return EXTMigrateMemobject.nclEnqueueMigrateMemObjectEXT(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), flags, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

