/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.Utilities;
import GLEngine.Vector3f;
import java.nio.FloatBuffer;

public class Matrix4f {
    public static final int SIZE = 16;
    public float[] elements = new float[16];

    public static Matrix4f identity() {
        Matrix4f matrix = new Matrix4f();
        matrix.elements[0] = 1.0f;
        matrix.elements[5] = 1.0f;
        matrix.elements[10] = 1.0f;
        matrix.elements[15] = 1.0f;
        return matrix;
    }

    public static Matrix4f translate(Vector3f vector) {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[3] = vector.x;
        matrix.elements[7] = vector.y;
        matrix.elements[11] = vector.z;
        return matrix;
    }

    public static Matrix4f orthoProjection(float right, float left, float top, float bot, float near, float far) {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[0] = 2.0f / (right - left);
        matrix.elements[3] = -(right + left) / (right - left);
        matrix.elements[5] = 2.0f / (top - bot);
        matrix.elements[7] = -(top + bot) / (top - bot);
        matrix.elements[10] = -2.0f / (far - near);
        matrix.elements[11] = -(far + near) / (far - near);
        return matrix;
    }

    public static Matrix4f rotateX(float angle) {
        Matrix4f matrix = Matrix4f.identity();
        angle = (float)Math.toRadians(angle);
        matrix.elements[5] = (float)Math.cos(angle);
        matrix.elements[6] = -((float)Math.sin(angle));
        matrix.elements[9] = (float)Math.sin(angle);
        matrix.elements[10] = (float)Math.cos(angle);
        return matrix;
    }

    public static Matrix4f scale(float scale) {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[0] = scale;
        matrix.elements[5] = scale;
        matrix.elements[10] = scale;
        return matrix;
    }

    public static Matrix4f scaleX(float scale) {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[0] = scale;
        return matrix;
    }

    public static Matrix4f scaleY(float scale) {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[5] = scale;
        return matrix;
    }

    public static Matrix4f scaleZ(float scale) {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[10] = scale;
        return matrix;
    }

    public static Matrix4f rotateY(float angle) {
        Matrix4f matrix = Matrix4f.identity();
        angle = (float)Math.toRadians(angle);
        matrix.elements[0] = (float)Math.cos(angle);
        matrix.elements[2] = (float)Math.sin(angle);
        matrix.elements[8] = -((float)Math.sin(angle));
        matrix.elements[10] = (float)Math.cos(angle);
        return matrix;
    }

    public static Matrix4f rotateZ(float angle) {
        Matrix4f matrix = Matrix4f.identity();
        angle = (float)Math.toRadians(angle);
        matrix.elements[0] = (float)Math.cos(angle);
        matrix.elements[1] = -((float)Math.sin(angle));
        matrix.elements[4] = (float)Math.sin(angle);
        matrix.elements[5] = (float)Math.cos(angle);
        return matrix;
    }

    public static Matrix4f perspective(float fov, float aspect, float znear, float zfar) {
        Matrix4f matrix = new Matrix4f();
        fov = (float)Math.toRadians(fov);
        matrix.elements[0] = fov / aspect;
        matrix.elements[5] = fov;
        matrix.elements[10] = (zfar + znear) / (znear - zfar);
        matrix.elements[11] = 2.0f * zfar * znear / (znear - zfar);
        matrix.elements[14] = -1.0f;
        return matrix;
    }

    public static Matrix4f rotate(float angle) {
        Matrix4f matrix = Matrix4f.identity();
        float r = (float)Math.toRadians(angle);
        float cos = (float)Math.cos(r);
        float sin = (float)Math.sin(r);
        matrix.elements[0] = cos;
        matrix.elements[1] = sin;
        matrix.elements[4] = -sin;
        matrix.elements[5] = cos;
        return matrix;
    }

    public static Matrix4f bias() {
        Matrix4f matrix = Matrix4f.identity();
        matrix.elements[0] = 0.5f;
        matrix.elements[5] = 0.5f;
        matrix.elements[10] = 0.5f;
        matrix.elements[3] = 0.5f;
        matrix.elements[7] = 0.5f;
        matrix.elements[11] = 0.5f;
        return matrix;
    }

    public static Matrix4f lookAt(Vector3f eye, Vector3f center, Vector3f up) {
        Matrix4f matrix = Matrix4f.identity();
        Vector3f f = center.subtract(eye);
        f = f.normalized();
        up = up.normalized();
        Vector3f s = f.cross(up);
        Vector3f u = s.cross(f);
        matrix.elements[0] = s.x;
        matrix.elements[1] = s.y;
        matrix.elements[2] = s.z;
        matrix.elements[4] = u.x;
        matrix.elements[5] = u.y;
        matrix.elements[6] = u.z;
        matrix.elements[8] = -f.x;
        matrix.elements[9] = -f.y;
        matrix.elements[10] = -f.z;
        Matrix4f trans = Matrix4f.translate(eye.multiply(-1.0f));
        return matrix.multiply(trans);
    }

    public Matrix4f multiply(Matrix4f matrix) {
        Matrix4f result = new Matrix4f();
        int x = 0;
        while (x < 4) {
            int y = 0;
            while (y < 4) {
                float sum = 0.0f;
                int k = 0;
                while (k < 4) {
                    sum += this.elements[k + y * 4] * matrix.elements[x + k * 4];
                    ++k;
                }
                result.elements[x + y * 4] = sum;
                ++y;
            }
            ++x;
        }
        return result;
    }

    public FloatBuffer toFloatBuffer() {
        return Utilities.createFloatBuffer(this.elements);
    }
}

