#include "parameters.h"
#include "synth.hpp"

/** Destroy information to map outer song data to smaller data type. */
#define OUTER_SONG_DATA_DIVISOR 5

/** \brief Inner song data structure format.
 * 
 * 3 values per event.
 * 0: Eventnum.
 * 1: Channel.
 * 2: Note / controlnum.
 */
static uint8_t g_song_data_inner[] =
{
  2,9,0,
  4,9,59,
  0,9,36,
  0,9,36,
  0,9,39,
  0,9,39,
  0,9,45,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  0,9,45,
  2,9,0,
  0,9,36,
  0,9,36,
  0,9,39,
  0,9,39,
  0,9,45,
  2,9,0,
  2,9,0,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  2,9,0,
  4,9,59,
  0,9,45,
  4,9,59,
  0,2,92,
  0,2,92,
  2,9,0,
  4,9,59,
  0,9,36,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,9,36,
  0,2,92,
  0,9,39,
  0,2,92,
  0,2,92,
  0,2,92,
  0,9,39,
  0,2,92,
  0,9,45,
  0,2,92,
  2,9,0,
  2,9,0,
  0,2,92,
  2,9,0,
  0,2,92,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  0,9,45,
  0,2,92,
  2,9,0,
  0,9,36,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,5,27,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,9,36,
  0,2,92,
  0,2,92,
  0,9,39,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,2,92,
  0,9,39,
  0,2,92,
  0,9,45,
  0,2,92,
  0,1,31,
  0,2,92,
  2,9,0,
  0,2,92,
  0,5,27,
  2,9,0,
  0,6,92,
  2,9,0,
  0,6,92,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  4,9,59,
  0,6,92,
  2,9,0,
  4,9,59,
  0,6,92,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  0,6,92,
  4,9,59,
  2,9,0,
  2,9,0,
  0,6,92,
  2,9,0,
  4,9,59,
  0,9,45,
  4,9,59,
  0,4,75,
  2,9,0,
  4,9,59,
  0,9,36,
  0,4,75,
  0,4,75,
  0,4,75,
  0,1,31,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,9,36,
  0,4,75,
  0,9,39,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,4,75,
  0,9,39,
  0,4,75,
  0,9,45,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,4,75,
  2,9,0,
  2,9,0,
  0,4,75,
  2,9,0,
  2,9,0,
  0,4,75,
  2,9,0,
  2,9,0,
  2,9,0,
  0,4,75,
  2,9,0,
  2,9,0,
  0,3,30,
  0,4,75,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  0,4,75,
  0,3,30,
  0,4,75,
  2,9,0,
  2,9,0,
  2,9,0,
  0,4,75,
  0,3,30,
  0,4,75,
  0,9,45,
  0,4,75,
  2,9,0,
  0,4,75,
  0,9,36,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,9,36,
  0,9,39,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,9,39,
  0,9,45,
  0,4,75,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  0,3,30,
  0,4,75,
  2,9,0,
  2,9,0,
  0,4,75,
  2,9,0,
  4,9,59,
  2,9,0,
  0,4,75,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  4,9,59,
  0,4,75,
  2,9,0,
  4,9,59,
  2,9,0,
  0,3,30,
  4,9,59,
  0,4,75,
  2,9,0,
  2,9,0,
  4,9,59,
  2,9,0,
  4,9,59,
  2,9,0,
  2,9,0,
  0,3,30,
  4,9,59,
  0,4,75,
  0,4,75,
  2,9,0,
  2,9,0,
  2,9,0,
  4,9,59,
  0,3,30,
  0,4,75,
  0,4,75,
  0,9,45,
  4,9,59,
  0,4,75,
  0,6,95,
  4,9,42,
  2,9,0,
  4,9,59,
  0,4,75,
  0,9,36,
  0,6,95,
  0,3,30,
  0,4,75,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,6,95,
  4,9,42,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,4,75,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,6,95,
  4,9,42,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,6,95,
  0,6,95,
  0,3,30,
  0,6,95,
  4,9,42,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,3,30,
  0,6,95,
  0,6,95,
  0,6,95,
  4,9,42,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,6,95,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,6,95,
  4,9,42,
  0,6,95,
  0,3,30,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,3,30,
  0,6,95,
  4,9,42,
  0,6,95,
  0,6,95,
  0,6,95,
  0,9,36,
  0,4,75,
  0,6,95,
  4,9,42,
  0,9,39,
  0,6,95,
  0,4,75,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,6,95,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,4,75,
  0,5,22,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,6,95,
  0,6,95,
  0,4,75,
  0,3,30,
  0,6,95,
  4,9,42,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,3,30,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,9,39,
  0,4,75,
  0,6,95,
  4,9,42,
  0,9,45,
  0,6,95,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,3,30,
  0,6,95,
  0,6,95,
  0,4,75,
  0,6,95,
  0,6,95,
  0,3,30,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  2,9,0,
  0,6,95,
  0,6,95,
  2,9,0,
  0,4,75,
  0,6,95,
  4,9,42,
  2,9,0,
  0,6,95,
  2,9,0,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  2,9,0,
  0,6,95,
  4,9,42,
  2,9,0,
  0,6,95,
  2,9,0,
  0,4,75,
  0,6,95,
  4,9,42,
  2,9,0,
  0,6,95,
  2,9,0,
  0,3,30,
  0,4,75,
  0,6,95,
  2,9,0,
  0,6,95,
  2,9,0,
  2,9,0,
  0,6,95,
  4,9,42,
  2,9,0,
  0,6,95,
  2,9,0,
  0,4,75,
  0,3,30,
  0,4,75,
  0,6,95,
  2,9,0,
  0,6,95,
  2,9,0,
  2,9,0,
  0,4,75,
  0,3,30,
  0,4,75,
  0,6,95,
  4,9,42,
  0,6,95,
  0,9,45,
  0,4,75,
  2,9,0,
  0,4,75,
  0,3,30,
  4,9,42,
  2,9,0,
  4,9,59,
  0,4,75,
  0,4,75,
  0,9,36,
  0,5,22,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,4,75,
  0,3,30,
  0,4,75,
  4,9,42,
  0,4,75,
  0,4,75,
  0,4,75,
  4,9,42,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  4,9,42,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  4,9,42,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,9,36,
  4,9,42,
  0,9,39,
  0,4,75,
  0,4,75,
  0,4,75,
  4,9,42,
  0,3,30,
  0,4,75,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,4,75,
  0,4,75,
  0,4,75,
  4,9,42,
  0,4,75,
  0,3,30,
  0,4,75,
  4,9,42,
  0,4,75,
  0,3,30,
  0,4,75,
  0,4,75,
  0,9,39,
  4,9,42,
  0,9,45,
  0,4,75,
  0,4,75,
  0,3,30,
  4,9,42,
  0,4,75,
  0,3,30,
  0,4,75,
  4,9,42,
  2,9,0,
  0,4,75,
  2,9,0,
  4,9,42,
  0,4,75,
  2,9,0,
  2,9,0,
  4,9,42,
  2,9,0,
  4,9,42,
  0,4,75,
  2,9,0,
  2,9,0,
  0,3,30,
  4,9,42,
  0,4,75,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  2,9,0,
  0,3,30,
  4,9,42,
  0,4,75,
  0,4,75,
  2,9,0,
  2,9,0,
  0,0,64,
  0,0,57,
  0,3,30,
  0,4,75,
  0,4,75,
  2,9,0,
  2,9,0,
  2,9,0,
  4,9,42,
  0,4,75,
  0,9,45,
  0,9,36,
  0,3,30,
  2,9,0,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,57,
  0,0,64,
  0,0,65,
  0,0,60,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,60,
  0,0,65,
  0,9,36,
  0,0,69,
  0,0,62,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,62,
  0,0,69,
  0,9,36,
  0,0,57,
  0,0,64,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,57,
  0,0,64,
  0,0,42,
  0,0,60,
  0,0,65,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,65,
  0,0,69,
  0,0,60,
  0,0,62,
  0,9,36,
  0,5,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,71,
  0,0,69,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,62,
  0,0,71,
  0,0,57,
  0,0,64,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,5,36,
  0,5,37,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,0,42,
  0,0,57,
  0,0,64,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,9,36,
  0,5,37,
  0,9,36,
  0,9,36,
  0,5,58,
  4,5,59,
  0,5,48,
  0,5,44,
  0,5,41,
  4,5,59,
  4,5,59,
  4,5,59,
  0,5,66,
  0,5,61,
  0,5,58,
  0,5,59,
  0,5,70,
  0,5,49,
  0,5,48,
  0,5,61,
  0,5,70,
  0,5,66,
  0,5,59,
  0,5,49,
  0,5,44,
  0,5,41,
  0,5,37,
  0,5,38,
  0,5,39,
  0,5,39,
  0,5,38,
  4,7,59,
  0,7,126,
  0,7,22,
  0,7,121,
  0,7,37,
  0,5,37,
  0,7,110,
  0,7,102,
  0,7,110,
  0,7,121,
  0,7,63,
  0,7,106,
  0,7,102,
  0,7,42,
  0,7,63,
  0,7,126,
  0,7,106,
  0,7,22,
  0,7,42,
  0,7,37,
  0,0,36,
  0,8,36,
  0,8,36,
  0,0,36,
  0,0,39,
  0,8,39,
  0,0,39,
  0,8,39,
  0,0,43,
  0,8,43,
  0,8,43,
  0,0,43,
  0,0,36,
  0,8,36,
  0,0,36,
  0,8,36
};

/** \brief Outer song data structure format.
 * 
 * 2 values per event.
 * 0: Time.
 * 1: Velocity / value.
 */
static uint16_t g_song_data_outer[] =
{
  1920/OUTER_SONG_DATA_DIVISOR,8192,
  1923/OUTER_SONG_DATA_DIVISOR,12496,
  1950/OUTER_SONG_DATA_DIVISOR,54,
  9440/OUTER_SONG_DATA_DIVISOR,0,
  9600/OUTER_SONG_DATA_DIVISOR,56,
  13280/OUTER_SONG_DATA_DIVISOR,0,
  13440/OUTER_SONG_DATA_DIVISOR,56,
  14987/OUTER_SONG_DATA_DIVISOR,7926,
  15197/OUTER_SONG_DATA_DIVISOR,7662,
  15401/OUTER_SONG_DATA_DIVISOR,7134,
  15580/OUTER_SONG_DATA_DIVISOR,6605,
  15720/OUTER_SONG_DATA_DIVISOR,6077,
  15851/OUTER_SONG_DATA_DIVISOR,5548,
  15989/OUTER_SONG_DATA_DIVISOR,5020,
  16134/OUTER_SONG_DATA_DIVISOR,4491,
  16259/OUTER_SONG_DATA_DIVISOR,3963,
  16361/OUTER_SONG_DATA_DIVISOR,3434,
  16457/OUTER_SONG_DATA_DIVISOR,2906,
  16543/OUTER_SONG_DATA_DIVISOR,2378,
  16659/OUTER_SONG_DATA_DIVISOR,1849,
  16763/OUTER_SONG_DATA_DIVISOR,1321,
  16841/OUTER_SONG_DATA_DIVISOR,792,
  16880/OUTER_SONG_DATA_DIVISOR,264,
  16920/OUTER_SONG_DATA_DIVISOR,0,
  17120/OUTER_SONG_DATA_DIVISOR,0,
  17280/OUTER_SONG_DATA_DIVISOR,8192,
  17310/OUTER_SONG_DATA_DIVISOR,54,
  24800/OUTER_SONG_DATA_DIVISOR,0,
  24960/OUTER_SONG_DATA_DIVISOR,56,
  28640/OUTER_SONG_DATA_DIVISOR,0,
  28800/OUTER_SONG_DATA_DIVISOR,68,
  30347/OUTER_SONG_DATA_DIVISOR,7926,
  30557/OUTER_SONG_DATA_DIVISOR,7662,
  30761/OUTER_SONG_DATA_DIVISOR,7134,
  30880/OUTER_SONG_DATA_DIVISOR,12218,
  30940/OUTER_SONG_DATA_DIVISOR,6605,
  31040/OUTER_SONG_DATA_DIVISOR,8330,
  31080/OUTER_SONG_DATA_DIVISOR,6077,
  31200/OUTER_SONG_DATA_DIVISOR,12496,
  31211/OUTER_SONG_DATA_DIVISOR,5548,
  31349/OUTER_SONG_DATA_DIVISOR,5020,
  31360/OUTER_SONG_DATA_DIVISOR,8053,
  31494/OUTER_SONG_DATA_DIVISOR,4491,
  31520/OUTER_SONG_DATA_DIVISOR,12773,
  31619/OUTER_SONG_DATA_DIVISOR,3963,
  31680/OUTER_SONG_DATA_DIVISOR,8608,
  31721/OUTER_SONG_DATA_DIVISOR,3434,
  31817/OUTER_SONG_DATA_DIVISOR,2906,
  31840/OUTER_SONG_DATA_DIVISOR,12496,
  31903/OUTER_SONG_DATA_DIVISOR,2378,
  32000/OUTER_SONG_DATA_DIVISOR,8053,
  32019/OUTER_SONG_DATA_DIVISOR,1849,
  32123/OUTER_SONG_DATA_DIVISOR,1321,
  32160/OUTER_SONG_DATA_DIVISOR,12773,
  32201/OUTER_SONG_DATA_DIVISOR,792,
  32240/OUTER_SONG_DATA_DIVISOR,264,
  32280/OUTER_SONG_DATA_DIVISOR,0,
  32320/OUTER_SONG_DATA_DIVISOR,9163,
  32480/OUTER_SONG_DATA_DIVISOR,0,
  32483/OUTER_SONG_DATA_DIVISOR,12496,
  32640/OUTER_SONG_DATA_DIVISOR,56,
  32640/OUTER_SONG_DATA_DIVISOR,56,
  32640/OUTER_SONG_DATA_DIVISOR,8192,
  32643/OUTER_SONG_DATA_DIVISOR,12496,
  32670/OUTER_SONG_DATA_DIVISOR,54,
  32760/OUTER_SONG_DATA_DIVISOR,0,
  32760/OUTER_SONG_DATA_DIVISOR,0,
  34560/OUTER_SONG_DATA_DIVISOR,56,
  34680/OUTER_SONG_DATA_DIVISOR,0,
  36480/OUTER_SONG_DATA_DIVISOR,56,
  36600/OUTER_SONG_DATA_DIVISOR,0,
  38400/OUTER_SONG_DATA_DIVISOR,56,
  38520/OUTER_SONG_DATA_DIVISOR,0,
  40160/OUTER_SONG_DATA_DIVISOR,0,
  40320/OUTER_SONG_DATA_DIVISOR,56,
  40320/OUTER_SONG_DATA_DIVISOR,56,
  40440/OUTER_SONG_DATA_DIVISOR,0,
  42240/OUTER_SONG_DATA_DIVISOR,56,
  42360/OUTER_SONG_DATA_DIVISOR,0,
  44000/OUTER_SONG_DATA_DIVISOR,0,
  44160/OUTER_SONG_DATA_DIVISOR,56,
  44160/OUTER_SONG_DATA_DIVISOR,56,
  44280/OUTER_SONG_DATA_DIVISOR,0,
  45707/OUTER_SONG_DATA_DIVISOR,7926,
  45917/OUTER_SONG_DATA_DIVISOR,7662,
  46080/OUTER_SONG_DATA_DIVISOR,56,
  46121/OUTER_SONG_DATA_DIVISOR,7134,
  46200/OUTER_SONG_DATA_DIVISOR,0,
  46300/OUTER_SONG_DATA_DIVISOR,6605,
  46440/OUTER_SONG_DATA_DIVISOR,6077,
  46571/OUTER_SONG_DATA_DIVISOR,5548,
  46709/OUTER_SONG_DATA_DIVISOR,5020,
  46854/OUTER_SONG_DATA_DIVISOR,4491,
  46979/OUTER_SONG_DATA_DIVISOR,3963,
  47081/OUTER_SONG_DATA_DIVISOR,3434,
  47177/OUTER_SONG_DATA_DIVISOR,2906,
  47263/OUTER_SONG_DATA_DIVISOR,2378,
  47379/OUTER_SONG_DATA_DIVISOR,1849,
  47483/OUTER_SONG_DATA_DIVISOR,1321,
  47561/OUTER_SONG_DATA_DIVISOR,792,
  47600/OUTER_SONG_DATA_DIVISOR,264,
  47640/OUTER_SONG_DATA_DIVISOR,0,
  47840/OUTER_SONG_DATA_DIVISOR,0,
  48000/OUTER_SONG_DATA_DIVISOR,56,
  48000/OUTER_SONG_DATA_DIVISOR,8192,
  48030/OUTER_SONG_DATA_DIVISOR,54,
  48120/OUTER_SONG_DATA_DIVISOR,0,
  49440/OUTER_SONG_DATA_DIVISOR,56,
  49560/OUTER_SONG_DATA_DIVISOR,0,
  50880/OUTER_SONG_DATA_DIVISOR,56,
  51000/OUTER_SONG_DATA_DIVISOR,0,
  51600/OUTER_SONG_DATA_DIVISOR,68,
  51840/OUTER_SONG_DATA_DIVISOR,56,
  51960/OUTER_SONG_DATA_DIVISOR,0,
  53280/OUTER_SONG_DATA_DIVISOR,56,
  53400/OUTER_SONG_DATA_DIVISOR,0,
  54720/OUTER_SONG_DATA_DIVISOR,56,
  54720/OUTER_SONG_DATA_DIVISOR,56,
  54840/OUTER_SONG_DATA_DIVISOR,0,
  54840/OUTER_SONG_DATA_DIVISOR,0,
  55520/OUTER_SONG_DATA_DIVISOR,0,
  55680/OUTER_SONG_DATA_DIVISOR,56,
  55680/OUTER_SONG_DATA_DIVISOR,56,
  55680/OUTER_SONG_DATA_DIVISOR,56,
  55800/OUTER_SONG_DATA_DIVISOR,0,
  55800/OUTER_SONG_DATA_DIVISOR,0,
  57120/OUTER_SONG_DATA_DIVISOR,56,
  57240/OUTER_SONG_DATA_DIVISOR,0,
  58560/OUTER_SONG_DATA_DIVISOR,56,
  58680/OUTER_SONG_DATA_DIVISOR,0,
  59360/OUTER_SONG_DATA_DIVISOR,0,
  59520/OUTER_SONG_DATA_DIVISOR,56,
  59520/OUTER_SONG_DATA_DIVISOR,68,
  59640/OUTER_SONG_DATA_DIVISOR,0,
  60480/OUTER_SONG_DATA_DIVISOR,56,
  60960/OUTER_SONG_DATA_DIVISOR,56,
  61067/OUTER_SONG_DATA_DIVISOR,7926,
  61080/OUTER_SONG_DATA_DIVISOR,0,
  61200/OUTER_SONG_DATA_DIVISOR,0,
  61277/OUTER_SONG_DATA_DIVISOR,7662,
  61440/OUTER_SONG_DATA_DIVISOR,56,
  61481/OUTER_SONG_DATA_DIVISOR,7134,
  61560/OUTER_SONG_DATA_DIVISOR,0,
  61600/OUTER_SONG_DATA_DIVISOR,12218,
  61660/OUTER_SONG_DATA_DIVISOR,6605,
  61760/OUTER_SONG_DATA_DIVISOR,8330,
  61800/OUTER_SONG_DATA_DIVISOR,6077,
  61920/OUTER_SONG_DATA_DIVISOR,12496,
  61931/OUTER_SONG_DATA_DIVISOR,5548,
  62069/OUTER_SONG_DATA_DIVISOR,5020,
  62080/OUTER_SONG_DATA_DIVISOR,8053,
  62160/OUTER_SONG_DATA_DIVISOR,56,
  62214/OUTER_SONG_DATA_DIVISOR,4491,
  62240/OUTER_SONG_DATA_DIVISOR,12773,
  62280/OUTER_SONG_DATA_DIVISOR,0,
  62339/OUTER_SONG_DATA_DIVISOR,3963,
  62400/OUTER_SONG_DATA_DIVISOR,8608,
  62441/OUTER_SONG_DATA_DIVISOR,3434,
  62537/OUTER_SONG_DATA_DIVISOR,2906,
  62560/OUTER_SONG_DATA_DIVISOR,12496,
  62623/OUTER_SONG_DATA_DIVISOR,2378,
  62720/OUTER_SONG_DATA_DIVISOR,8053,
  62739/OUTER_SONG_DATA_DIVISOR,1849,
  62843/OUTER_SONG_DATA_DIVISOR,1321,
  62880/OUTER_SONG_DATA_DIVISOR,56,
  62883/OUTER_SONG_DATA_DIVISOR,12773,
  62921/OUTER_SONG_DATA_DIVISOR,792,
  62960/OUTER_SONG_DATA_DIVISOR,264,
  63000/OUTER_SONG_DATA_DIVISOR,0,
  63000/OUTER_SONG_DATA_DIVISOR,0,
  63040/OUTER_SONG_DATA_DIVISOR,9163,
  63200/OUTER_SONG_DATA_DIVISOR,0,
  63203/OUTER_SONG_DATA_DIVISOR,12496,
  63360/OUTER_SONG_DATA_DIVISOR,56,
  63360/OUTER_SONG_DATA_DIVISOR,8192,
  63363/OUTER_SONG_DATA_DIVISOR,12496,
  63390/OUTER_SONG_DATA_DIVISOR,54,
  63600/OUTER_SONG_DATA_DIVISOR,0,
  63600/OUTER_SONG_DATA_DIVISOR,56,
  63840/OUTER_SONG_DATA_DIVISOR,0,
  64320/OUTER_SONG_DATA_DIVISOR,0,
  64320/OUTER_SONG_DATA_DIVISOR,65,
  64320/OUTER_SONG_DATA_DIVISOR,56,
  64560/OUTER_SONG_DATA_DIVISOR,0,
  64800/OUTER_SONG_DATA_DIVISOR,0,
  64800/OUTER_SONG_DATA_DIVISOR,56,
  65040/OUTER_SONG_DATA_DIVISOR,0,
  65040/OUTER_SONG_DATA_DIVISOR,56,
  65280/OUTER_SONG_DATA_DIVISOR,0,
  65760/OUTER_SONG_DATA_DIVISOR,56,
  66240/OUTER_SONG_DATA_DIVISOR,80,
  66480/OUTER_SONG_DATA_DIVISOR,0,
  66720/OUTER_SONG_DATA_DIVISOR,0,
  67200/OUTER_SONG_DATA_DIVISOR,56,
  67440/OUTER_SONG_DATA_DIVISOR,0,
  67440/OUTER_SONG_DATA_DIVISOR,56,
  67680/OUTER_SONG_DATA_DIVISOR,0,
  68160/OUTER_SONG_DATA_DIVISOR,80,
  68160/OUTER_SONG_DATA_DIVISOR,56,
  68400/OUTER_SONG_DATA_DIVISOR,0,
  68640/OUTER_SONG_DATA_DIVISOR,0,
  68640/OUTER_SONG_DATA_DIVISOR,56,
  68880/OUTER_SONG_DATA_DIVISOR,0,
  68880/OUTER_SONG_DATA_DIVISOR,56,
  69120/OUTER_SONG_DATA_DIVISOR,0,
  69600/OUTER_SONG_DATA_DIVISOR,56,
  70080/OUTER_SONG_DATA_DIVISOR,75,
  70320/OUTER_SONG_DATA_DIVISOR,0,
  70560/OUTER_SONG_DATA_DIVISOR,0,
  70880/OUTER_SONG_DATA_DIVISOR,0,
  71040/OUTER_SONG_DATA_DIVISOR,56,
  71040/OUTER_SONG_DATA_DIVISOR,56,
  71280/OUTER_SONG_DATA_DIVISOR,0,
  71280/OUTER_SONG_DATA_DIVISOR,56,
  71520/OUTER_SONG_DATA_DIVISOR,0,
  72000/OUTER_SONG_DATA_DIVISOR,64,
  72000/OUTER_SONG_DATA_DIVISOR,56,
  72240/OUTER_SONG_DATA_DIVISOR,0,
  72480/OUTER_SONG_DATA_DIVISOR,0,
  72480/OUTER_SONG_DATA_DIVISOR,56,
  72720/OUTER_SONG_DATA_DIVISOR,0,
  72720/OUTER_SONG_DATA_DIVISOR,56,
  72960/OUTER_SONG_DATA_DIVISOR,0,
  73440/OUTER_SONG_DATA_DIVISOR,56,
  73920/OUTER_SONG_DATA_DIVISOR,0,
  73920/OUTER_SONG_DATA_DIVISOR,77,
  74160/OUTER_SONG_DATA_DIVISOR,56,
  74400/OUTER_SONG_DATA_DIVISOR,0,
  74640/OUTER_SONG_DATA_DIVISOR,0,
  74720/OUTER_SONG_DATA_DIVISOR,0,
  74880/OUTER_SONG_DATA_DIVISOR,56,
  74880/OUTER_SONG_DATA_DIVISOR,56,
  75360/OUTER_SONG_DATA_DIVISOR,0,
  75600/OUTER_SONG_DATA_DIVISOR,56,
  75840/OUTER_SONG_DATA_DIVISOR,67,
  76080/OUTER_SONG_DATA_DIVISOR,0,
  76320/OUTER_SONG_DATA_DIVISOR,0,
  76320/OUTER_SONG_DATA_DIVISOR,56,
  76427/OUTER_SONG_DATA_DIVISOR,7926,
  76637/OUTER_SONG_DATA_DIVISOR,7662,
  76800/OUTER_SONG_DATA_DIVISOR,0,
  76841/OUTER_SONG_DATA_DIVISOR,7134,
  77020/OUTER_SONG_DATA_DIVISOR,6605,
  77040/OUTER_SONG_DATA_DIVISOR,56,
  77160/OUTER_SONG_DATA_DIVISOR,6077,
  77291/OUTER_SONG_DATA_DIVISOR,5548,
  77429/OUTER_SONG_DATA_DIVISOR,5020,
  77520/OUTER_SONG_DATA_DIVISOR,0,
  77574/OUTER_SONG_DATA_DIVISOR,4491,
  77699/OUTER_SONG_DATA_DIVISOR,3963,
  77760/OUTER_SONG_DATA_DIVISOR,71,
  77760/OUTER_SONG_DATA_DIVISOR,56,
  77801/OUTER_SONG_DATA_DIVISOR,3434,
  77897/OUTER_SONG_DATA_DIVISOR,2906,
  77983/OUTER_SONG_DATA_DIVISOR,2378,
  78099/OUTER_SONG_DATA_DIVISOR,1849,
  78203/OUTER_SONG_DATA_DIVISOR,1321,
  78240/OUTER_SONG_DATA_DIVISOR,0,
  78240/OUTER_SONG_DATA_DIVISOR,0,
  78240/OUTER_SONG_DATA_DIVISOR,56,
  78281/OUTER_SONG_DATA_DIVISOR,792,
  78320/OUTER_SONG_DATA_DIVISOR,264,
  78360/OUTER_SONG_DATA_DIVISOR,0,
  78480/OUTER_SONG_DATA_DIVISOR,0,
  78480/OUTER_SONG_DATA_DIVISOR,56,
  78480/OUTER_SONG_DATA_DIVISOR,56,
  78560/OUTER_SONG_DATA_DIVISOR,0,
  78720/OUTER_SONG_DATA_DIVISOR,0,
  78720/OUTER_SONG_DATA_DIVISOR,8192,
  78721/OUTER_SONG_DATA_DIVISOR,56,
  78750/OUTER_SONG_DATA_DIVISOR,54,
  78960/OUTER_SONG_DATA_DIVISOR,0,
  78961/OUTER_SONG_DATA_DIVISOR,0,
  78961/OUTER_SONG_DATA_DIVISOR,56,
  79201/OUTER_SONG_DATA_DIVISOR,0,
  79680/OUTER_SONG_DATA_DIVISOR,65,
  79681/OUTER_SONG_DATA_DIVISOR,56,
  79921/OUTER_SONG_DATA_DIVISOR,0,
  80160/OUTER_SONG_DATA_DIVISOR,0,
  80161/OUTER_SONG_DATA_DIVISOR,56,
  80401/OUTER_SONG_DATA_DIVISOR,0,
  80401/OUTER_SONG_DATA_DIVISOR,56,
  80641/OUTER_SONG_DATA_DIVISOR,0,
  81121/OUTER_SONG_DATA_DIVISOR,56,
  81600/OUTER_SONG_DATA_DIVISOR,80,
  81841/OUTER_SONG_DATA_DIVISOR,0,
  82080/OUTER_SONG_DATA_DIVISOR,0,
  82561/OUTER_SONG_DATA_DIVISOR,56,
  82801/OUTER_SONG_DATA_DIVISOR,0,
  82801/OUTER_SONG_DATA_DIVISOR,56,
  83041/OUTER_SONG_DATA_DIVISOR,0,
  83520/OUTER_SONG_DATA_DIVISOR,80,
  83521/OUTER_SONG_DATA_DIVISOR,56,
  83761/OUTER_SONG_DATA_DIVISOR,0,
  84000/OUTER_SONG_DATA_DIVISOR,0,
  84001/OUTER_SONG_DATA_DIVISOR,56,
  84241/OUTER_SONG_DATA_DIVISOR,0,
  84241/OUTER_SONG_DATA_DIVISOR,56,
  84481/OUTER_SONG_DATA_DIVISOR,0,
  84961/OUTER_SONG_DATA_DIVISOR,56,
  85440/OUTER_SONG_DATA_DIVISOR,75,
  85681/OUTER_SONG_DATA_DIVISOR,0,
  85920/OUTER_SONG_DATA_DIVISOR,0,
  86240/OUTER_SONG_DATA_DIVISOR,0,
  86400/OUTER_SONG_DATA_DIVISOR,56,
  86401/OUTER_SONG_DATA_DIVISOR,56,
  86641/OUTER_SONG_DATA_DIVISOR,0,
  86641/OUTER_SONG_DATA_DIVISOR,56,
  86881/OUTER_SONG_DATA_DIVISOR,0,
  87360/OUTER_SONG_DATA_DIVISOR,64,
  87361/OUTER_SONG_DATA_DIVISOR,56,
  87601/OUTER_SONG_DATA_DIVISOR,0,
  87840/OUTER_SONG_DATA_DIVISOR,0,
  87841/OUTER_SONG_DATA_DIVISOR,56,
  88081/OUTER_SONG_DATA_DIVISOR,0,
  88081/OUTER_SONG_DATA_DIVISOR,56,
  88321/OUTER_SONG_DATA_DIVISOR,0,
  88801/OUTER_SONG_DATA_DIVISOR,56,
  89280/OUTER_SONG_DATA_DIVISOR,77,
  89281/OUTER_SONG_DATA_DIVISOR,0,
  89521/OUTER_SONG_DATA_DIVISOR,56,
  89760/OUTER_SONG_DATA_DIVISOR,0,
  90001/OUTER_SONG_DATA_DIVISOR,0,
  90080/OUTER_SONG_DATA_DIVISOR,0,
  90240/OUTER_SONG_DATA_DIVISOR,68,
  90241/OUTER_SONG_DATA_DIVISOR,56,
  90721/OUTER_SONG_DATA_DIVISOR,0,
  90961/OUTER_SONG_DATA_DIVISOR,56,
  91200/OUTER_SONG_DATA_DIVISOR,67,
  91441/OUTER_SONG_DATA_DIVISOR,0,
  91680/OUTER_SONG_DATA_DIVISOR,0,
  91681/OUTER_SONG_DATA_DIVISOR,56,
  91787/OUTER_SONG_DATA_DIVISOR,7926,
  91997/OUTER_SONG_DATA_DIVISOR,7662,
  92161/OUTER_SONG_DATA_DIVISOR,0,
  92201/OUTER_SONG_DATA_DIVISOR,7134,
  92320/OUTER_SONG_DATA_DIVISOR,12218,
  92380/OUTER_SONG_DATA_DIVISOR,6605,
  92401/OUTER_SONG_DATA_DIVISOR,56,
  92480/OUTER_SONG_DATA_DIVISOR,8330,
  92520/OUTER_SONG_DATA_DIVISOR,6077,
  92640/OUTER_SONG_DATA_DIVISOR,12496,
  92651/OUTER_SONG_DATA_DIVISOR,5548,
  92789/OUTER_SONG_DATA_DIVISOR,5020,
  92800/OUTER_SONG_DATA_DIVISOR,8053,
  92881/OUTER_SONG_DATA_DIVISOR,0,
  92934/OUTER_SONG_DATA_DIVISOR,4491,
  92960/OUTER_SONG_DATA_DIVISOR,12773,
  93059/OUTER_SONG_DATA_DIVISOR,3963,
  93120/OUTER_SONG_DATA_DIVISOR,71,
  93123/OUTER_SONG_DATA_DIVISOR,8608,
  93123/OUTER_SONG_DATA_DIVISOR,56,
  93161/OUTER_SONG_DATA_DIVISOR,3434,
  93257/OUTER_SONG_DATA_DIVISOR,2906,
  93280/OUTER_SONG_DATA_DIVISOR,12496,
  93343/OUTER_SONG_DATA_DIVISOR,2378,
  93440/OUTER_SONG_DATA_DIVISOR,8053,
  93459/OUTER_SONG_DATA_DIVISOR,1849,
  93563/OUTER_SONG_DATA_DIVISOR,1321,
  93600/OUTER_SONG_DATA_DIVISOR,0,
  93603/OUTER_SONG_DATA_DIVISOR,12773,
  93603/OUTER_SONG_DATA_DIVISOR,0,
  93603/OUTER_SONG_DATA_DIVISOR,56,
  93643/OUTER_SONG_DATA_DIVISOR,792,
  93682/OUTER_SONG_DATA_DIVISOR,264,
  93722/OUTER_SONG_DATA_DIVISOR,0,
  93762/OUTER_SONG_DATA_DIVISOR,9163,
  93842/OUTER_SONG_DATA_DIVISOR,56,
  93843/OUTER_SONG_DATA_DIVISOR,0,
  93843/OUTER_SONG_DATA_DIVISOR,56,
  93922/OUTER_SONG_DATA_DIVISOR,0,
  93925/OUTER_SONG_DATA_DIVISOR,12496,
  94082/OUTER_SONG_DATA_DIVISOR,56,
  94082/OUTER_SONG_DATA_DIVISOR,55,
  94085/OUTER_SONG_DATA_DIVISOR,2838,
  94085/OUTER_SONG_DATA_DIVISOR,8192,
  94088/OUTER_SONG_DATA_DIVISOR,12496,
  94088/OUTER_SONG_DATA_DIVISOR,0,
  94117/OUTER_SONG_DATA_DIVISOR,54,
  94147/OUTER_SONG_DATA_DIVISOR,0,
  94327/OUTER_SONG_DATA_DIVISOR,0,
  94327/OUTER_SONG_DATA_DIVISOR,0,
  94327/OUTER_SONG_DATA_DIVISOR,56,
  94327/OUTER_SONG_DATA_DIVISOR,55,
  94387/OUTER_SONG_DATA_DIVISOR,0,
  94567/OUTER_SONG_DATA_DIVISOR,0,
  94567/OUTER_SONG_DATA_DIVISOR,55,
  94627/OUTER_SONG_DATA_DIVISOR,0,
  94807/OUTER_SONG_DATA_DIVISOR,55,
  94810/OUTER_SONG_DATA_DIVISOR,4644,
  94867/OUTER_SONG_DATA_DIVISOR,0,
  95047/OUTER_SONG_DATA_DIVISOR,65,
  95047/OUTER_SONG_DATA_DIVISOR,56,
  95047/OUTER_SONG_DATA_DIVISOR,55,
  95107/OUTER_SONG_DATA_DIVISOR,0,
  95287/OUTER_SONG_DATA_DIVISOR,0,
  95287/OUTER_SONG_DATA_DIVISOR,55,
  95407/OUTER_SONG_DATA_DIVISOR,0,
  95527/OUTER_SONG_DATA_DIVISOR,0,
  95527/OUTER_SONG_DATA_DIVISOR,56,
  95527/OUTER_SONG_DATA_DIVISOR,55,
  95530/OUTER_SONG_DATA_DIVISOR,5805,
  95587/OUTER_SONG_DATA_DIVISOR,0,
  95767/OUTER_SONG_DATA_DIVISOR,0,
  95767/OUTER_SONG_DATA_DIVISOR,56,
  95767/OUTER_SONG_DATA_DIVISOR,55,
  95827/OUTER_SONG_DATA_DIVISOR,0,
  96007/OUTER_SONG_DATA_DIVISOR,0,
  96007/OUTER_SONG_DATA_DIVISOR,55,
  96067/OUTER_SONG_DATA_DIVISOR,0,
  96247/OUTER_SONG_DATA_DIVISOR,55,
  96250/OUTER_SONG_DATA_DIVISOR,7482,
  96307/OUTER_SONG_DATA_DIVISOR,0,
  96487/OUTER_SONG_DATA_DIVISOR,56,
  96487/OUTER_SONG_DATA_DIVISOR,55,
  96547/OUTER_SONG_DATA_DIVISOR,0,
  96727/OUTER_SONG_DATA_DIVISOR,55,
  96787/OUTER_SONG_DATA_DIVISOR,0,
  96967/OUTER_SONG_DATA_DIVISOR,80,
  96967/OUTER_SONG_DATA_DIVISOR,55,
  96970/OUTER_SONG_DATA_DIVISOR,5547,
  97027/OUTER_SONG_DATA_DIVISOR,0,
  97207/OUTER_SONG_DATA_DIVISOR,0,
  97207/OUTER_SONG_DATA_DIVISOR,55,
  97327/OUTER_SONG_DATA_DIVISOR,0,
  97447/OUTER_SONG_DATA_DIVISOR,0,
  97447/OUTER_SONG_DATA_DIVISOR,55,
  97507/OUTER_SONG_DATA_DIVISOR,0,
  97687/OUTER_SONG_DATA_DIVISOR,55,
  97690/OUTER_SONG_DATA_DIVISOR,2709,
  97747/OUTER_SONG_DATA_DIVISOR,0,
  97927/OUTER_SONG_DATA_DIVISOR,56,
  97927/OUTER_SONG_DATA_DIVISOR,55,
  97987/OUTER_SONG_DATA_DIVISOR,0,
  98167/OUTER_SONG_DATA_DIVISOR,0,
  98167/OUTER_SONG_DATA_DIVISOR,56,
  98167/OUTER_SONG_DATA_DIVISOR,55,
  98227/OUTER_SONG_DATA_DIVISOR,0,
  98407/OUTER_SONG_DATA_DIVISOR,0,
  98407/OUTER_SONG_DATA_DIVISOR,55,
  98410/OUTER_SONG_DATA_DIVISOR,3225,
  98467/OUTER_SONG_DATA_DIVISOR,0,
  98647/OUTER_SONG_DATA_DIVISOR,55,
  98707/OUTER_SONG_DATA_DIVISOR,0,
  98887/OUTER_SONG_DATA_DIVISOR,80,
  98887/OUTER_SONG_DATA_DIVISOR,56,
  98887/OUTER_SONG_DATA_DIVISOR,55,
  98947/OUTER_SONG_DATA_DIVISOR,0,
  99127/OUTER_SONG_DATA_DIVISOR,0,
  99127/OUTER_SONG_DATA_DIVISOR,55,
  99130/OUTER_SONG_DATA_DIVISOR,5289,
  99247/OUTER_SONG_DATA_DIVISOR,0,
  99367/OUTER_SONG_DATA_DIVISOR,0,
  99367/OUTER_SONG_DATA_DIVISOR,56,
  99367/OUTER_SONG_DATA_DIVISOR,55,
  99427/OUTER_SONG_DATA_DIVISOR,0,
  99607/OUTER_SONG_DATA_DIVISOR,0,
  99607/OUTER_SONG_DATA_DIVISOR,56,
  99607/OUTER_SONG_DATA_DIVISOR,55,
  99667/OUTER_SONG_DATA_DIVISOR,0,
  99847/OUTER_SONG_DATA_DIVISOR,0,
  99847/OUTER_SONG_DATA_DIVISOR,55,
  99850/OUTER_SONG_DATA_DIVISOR,6192,
  99907/OUTER_SONG_DATA_DIVISOR,0,
  100087/OUTER_SONG_DATA_DIVISOR,55,
  100147/OUTER_SONG_DATA_DIVISOR,0,
  100327/OUTER_SONG_DATA_DIVISOR,56,
  100327/OUTER_SONG_DATA_DIVISOR,55,
  100387/OUTER_SONG_DATA_DIVISOR,0,
  100567/OUTER_SONG_DATA_DIVISOR,55,
  100570/OUTER_SONG_DATA_DIVISOR,4773,
  100627/OUTER_SONG_DATA_DIVISOR,0,
  100807/OUTER_SONG_DATA_DIVISOR,75,
  100807/OUTER_SONG_DATA_DIVISOR,55,
  100867/OUTER_SONG_DATA_DIVISOR,0,
  101047/OUTER_SONG_DATA_DIVISOR,0,
  101047/OUTER_SONG_DATA_DIVISOR,55,
  101167/OUTER_SONG_DATA_DIVISOR,0,
  101287/OUTER_SONG_DATA_DIVISOR,0,
  101287/OUTER_SONG_DATA_DIVISOR,55,
  101290/OUTER_SONG_DATA_DIVISOR,2580,
  101347/OUTER_SONG_DATA_DIVISOR,0,
  101527/OUTER_SONG_DATA_DIVISOR,55,
  101587/OUTER_SONG_DATA_DIVISOR,0,
  101607/OUTER_SONG_DATA_DIVISOR,0,
  101767/OUTER_SONG_DATA_DIVISOR,56,
  101767/OUTER_SONG_DATA_DIVISOR,55,
  101770/OUTER_SONG_DATA_DIVISOR,3483,
  101770/OUTER_SONG_DATA_DIVISOR,56,
  101827/OUTER_SONG_DATA_DIVISOR,0,
  102007/OUTER_SONG_DATA_DIVISOR,0,
  102007/OUTER_SONG_DATA_DIVISOR,56,
  102007/OUTER_SONG_DATA_DIVISOR,55,
  102067/OUTER_SONG_DATA_DIVISOR,0,
  102247/OUTER_SONG_DATA_DIVISOR,0,
  102247/OUTER_SONG_DATA_DIVISOR,55,
  102250/OUTER_SONG_DATA_DIVISOR,5547,
  102307/OUTER_SONG_DATA_DIVISOR,0,
  102487/OUTER_SONG_DATA_DIVISOR,55,
  102547/OUTER_SONG_DATA_DIVISOR,0,
  102727/OUTER_SONG_DATA_DIVISOR,64,
  102727/OUTER_SONG_DATA_DIVISOR,56,
  102727/OUTER_SONG_DATA_DIVISOR,55,
  102787/OUTER_SONG_DATA_DIVISOR,0,
  102967/OUTER_SONG_DATA_DIVISOR,0,
  102967/OUTER_SONG_DATA_DIVISOR,55,
  102970/OUTER_SONG_DATA_DIVISOR,7740,
  103087/OUTER_SONG_DATA_DIVISOR,0,
  103207/OUTER_SONG_DATA_DIVISOR,0,
  103207/OUTER_SONG_DATA_DIVISOR,56,
  103207/OUTER_SONG_DATA_DIVISOR,55,
  103267/OUTER_SONG_DATA_DIVISOR,0,
  103447/OUTER_SONG_DATA_DIVISOR,0,
  103447/OUTER_SONG_DATA_DIVISOR,56,
  103447/OUTER_SONG_DATA_DIVISOR,92,
  103447/OUTER_SONG_DATA_DIVISOR,55,
  103507/OUTER_SONG_DATA_DIVISOR,0,
  103687/OUTER_SONG_DATA_DIVISOR,0,
  103687/OUTER_SONG_DATA_DIVISOR,55,
  103690/OUTER_SONG_DATA_DIVISOR,8901,
  103747/OUTER_SONG_DATA_DIVISOR,0,
  103927/OUTER_SONG_DATA_DIVISOR,55,
  103987/OUTER_SONG_DATA_DIVISOR,0,
  104167/OUTER_SONG_DATA_DIVISOR,56,
  104167/OUTER_SONG_DATA_DIVISOR,55,
  104227/OUTER_SONG_DATA_DIVISOR,0,
  104407/OUTER_SONG_DATA_DIVISOR,55,
  104467/OUTER_SONG_DATA_DIVISOR,0,
  104647/OUTER_SONG_DATA_DIVISOR,0,
  104647/OUTER_SONG_DATA_DIVISOR,77,
  104647/OUTER_SONG_DATA_DIVISOR,55,
  104650/OUTER_SONG_DATA_DIVISOR,10191,
  104707/OUTER_SONG_DATA_DIVISOR,0,
  104887/OUTER_SONG_DATA_DIVISOR,56,
  104887/OUTER_SONG_DATA_DIVISOR,55,
  105007/OUTER_SONG_DATA_DIVISOR,0,
  105127/OUTER_SONG_DATA_DIVISOR,0,
  105127/OUTER_SONG_DATA_DIVISOR,55,
  105187/OUTER_SONG_DATA_DIVISOR,0,
  105367/OUTER_SONG_DATA_DIVISOR,0,
  105367/OUTER_SONG_DATA_DIVISOR,55,
  105427/OUTER_SONG_DATA_DIVISOR,0,
  105447/OUTER_SONG_DATA_DIVISOR,0,
  105607/OUTER_SONG_DATA_DIVISOR,56,
  105607/OUTER_SONG_DATA_DIVISOR,55,
  105610/OUTER_SONG_DATA_DIVISOR,11868,
  105610/OUTER_SONG_DATA_DIVISOR,56,
  105667/OUTER_SONG_DATA_DIVISOR,0,
  105847/OUTER_SONG_DATA_DIVISOR,55,
  105907/OUTER_SONG_DATA_DIVISOR,0,
  106087/OUTER_SONG_DATA_DIVISOR,0,
  106087/OUTER_SONG_DATA_DIVISOR,55,
  106147/OUTER_SONG_DATA_DIVISOR,0,
  106327/OUTER_SONG_DATA_DIVISOR,56,
  106327/OUTER_SONG_DATA_DIVISOR,55,
  106330/OUTER_SONG_DATA_DIVISOR,9719,
  106387/OUTER_SONG_DATA_DIVISOR,0,
  106567/OUTER_SONG_DATA_DIVISOR,67,
  106567/OUTER_SONG_DATA_DIVISOR,55,
  106627/OUTER_SONG_DATA_DIVISOR,0,
  106807/OUTER_SONG_DATA_DIVISOR,0,
  106807/OUTER_SONG_DATA_DIVISOR,55,
  106927/OUTER_SONG_DATA_DIVISOR,0,
  107047/OUTER_SONG_DATA_DIVISOR,0,
  107047/OUTER_SONG_DATA_DIVISOR,56,
  107047/OUTER_SONG_DATA_DIVISOR,55,
  107050/OUTER_SONG_DATA_DIVISOR,7775,
  107107/OUTER_SONG_DATA_DIVISOR,0,
  107154/OUTER_SONG_DATA_DIVISOR,7926,
  107287/OUTER_SONG_DATA_DIVISOR,55,
  107347/OUTER_SONG_DATA_DIVISOR,0,
  107364/OUTER_SONG_DATA_DIVISOR,7662,
  107527/OUTER_SONG_DATA_DIVISOR,0,
  107527/OUTER_SONG_DATA_DIVISOR,55,
  107530/OUTER_SONG_DATA_DIVISOR,5276,
  107568/OUTER_SONG_DATA_DIVISOR,7134,
  107587/OUTER_SONG_DATA_DIVISOR,0,
  107747/OUTER_SONG_DATA_DIVISOR,6605,
  107767/OUTER_SONG_DATA_DIVISOR,56,
  107767/OUTER_SONG_DATA_DIVISOR,55,
  107770/OUTER_SONG_DATA_DIVISOR,4998,
  107827/OUTER_SONG_DATA_DIVISOR,0,
  107887/OUTER_SONG_DATA_DIVISOR,6077,
  108007/OUTER_SONG_DATA_DIVISOR,55,
  108010/OUTER_SONG_DATA_DIVISOR,3610,
  108018/OUTER_SONG_DATA_DIVISOR,5548,
  108067/OUTER_SONG_DATA_DIVISOR,0,
  108156/OUTER_SONG_DATA_DIVISOR,5020,
  108247/OUTER_SONG_DATA_DIVISOR,0,
  108247/OUTER_SONG_DATA_DIVISOR,55,
  108250/OUTER_SONG_DATA_DIVISOR,3332,
  108301/OUTER_SONG_DATA_DIVISOR,4491,
  108307/OUTER_SONG_DATA_DIVISOR,0,
  108426/OUTER_SONG_DATA_DIVISOR,3963,
  108487/OUTER_SONG_DATA_DIVISOR,71,
  108487/OUTER_SONG_DATA_DIVISOR,56,
  108487/OUTER_SONG_DATA_DIVISOR,55,
  108528/OUTER_SONG_DATA_DIVISOR,3434,
  108547/OUTER_SONG_DATA_DIVISOR,0,
  108624/OUTER_SONG_DATA_DIVISOR,2906,
  108710/OUTER_SONG_DATA_DIVISOR,2378,
  108727/OUTER_SONG_DATA_DIVISOR,55,
  108730/OUTER_SONG_DATA_DIVISOR,1111,
  108826/OUTER_SONG_DATA_DIVISOR,1849,
  108847/OUTER_SONG_DATA_DIVISOR,0,
  108930/OUTER_SONG_DATA_DIVISOR,1321,
  108967/OUTER_SONG_DATA_DIVISOR,0,
  108967/OUTER_SONG_DATA_DIVISOR,0,
  108967/OUTER_SONG_DATA_DIVISOR,56,
  108967/OUTER_SONG_DATA_DIVISOR,55,
  109008/OUTER_SONG_DATA_DIVISOR,792,
  109027/OUTER_SONG_DATA_DIVISOR,0,
  109047/OUTER_SONG_DATA_DIVISOR,264,
  109087/OUTER_SONG_DATA_DIVISOR,0,
  109207/OUTER_SONG_DATA_DIVISOR,0,
  109207/OUTER_SONG_DATA_DIVISOR,56,
  109207/OUTER_SONG_DATA_DIVISOR,56,
  109207/OUTER_SONG_DATA_DIVISOR,55,
  109210/OUTER_SONG_DATA_DIVISOR,278,
  109267/OUTER_SONG_DATA_DIVISOR,0,
  109287/OUTER_SONG_DATA_DIVISOR,0,
  109447/OUTER_SONG_DATA_DIVISOR,0,
  109447/OUTER_SONG_DATA_DIVISOR,8192,
  109448/OUTER_SONG_DATA_DIVISOR,56,
  109687/OUTER_SONG_DATA_DIVISOR,0,
  109690/OUTER_SONG_DATA_DIVISOR,2838,
  109690/OUTER_SONG_DATA_DIVISOR,8192,
  109693/OUTER_SONG_DATA_DIVISOR,12496,
  109693/OUTER_SONG_DATA_DIVISOR,0,
  109693/OUTER_SONG_DATA_DIVISOR,56,
  109722/OUTER_SONG_DATA_DIVISOR,54,
  109932/OUTER_SONG_DATA_DIVISOR,0,
  109933/OUTER_SONG_DATA_DIVISOR,0,
  110412/OUTER_SONG_DATA_DIVISOR,65,
  110415/OUTER_SONG_DATA_DIVISOR,4644,
  110415/OUTER_SONG_DATA_DIVISOR,56,
  110653/OUTER_SONG_DATA_DIVISOR,0,
  110892/OUTER_SONG_DATA_DIVISOR,0,
  110893/OUTER_SONG_DATA_DIVISOR,56,
  111132/OUTER_SONG_DATA_DIVISOR,5805,
  111133/OUTER_SONG_DATA_DIVISOR,0,
  111133/OUTER_SONG_DATA_DIVISOR,56,
  111373/OUTER_SONG_DATA_DIVISOR,0,
  111852/OUTER_SONG_DATA_DIVISOR,7482,
  111853/OUTER_SONG_DATA_DIVISOR,56,
  112332/OUTER_SONG_DATA_DIVISOR,80,
  112572/OUTER_SONG_DATA_DIVISOR,5547,
  112573/OUTER_SONG_DATA_DIVISOR,0,
  112812/OUTER_SONG_DATA_DIVISOR,0,
  113292/OUTER_SONG_DATA_DIVISOR,2709,
  113293/OUTER_SONG_DATA_DIVISOR,56,
  113533/OUTER_SONG_DATA_DIVISOR,0,
  113533/OUTER_SONG_DATA_DIVISOR,56,
  113773/OUTER_SONG_DATA_DIVISOR,0,
  114012/OUTER_SONG_DATA_DIVISOR,3225,
  114252/OUTER_SONG_DATA_DIVISOR,80,
  114253/OUTER_SONG_DATA_DIVISOR,56,
  114493/OUTER_SONG_DATA_DIVISOR,0,
  114732/OUTER_SONG_DATA_DIVISOR,0,
  114735/OUTER_SONG_DATA_DIVISOR,5289,
  114735/OUTER_SONG_DATA_DIVISOR,56,
  114973/OUTER_SONG_DATA_DIVISOR,0,
  114973/OUTER_SONG_DATA_DIVISOR,56,
  115213/OUTER_SONG_DATA_DIVISOR,0,
  115452/OUTER_SONG_DATA_DIVISOR,6192,
  115693/OUTER_SONG_DATA_DIVISOR,56,
  116172/OUTER_SONG_DATA_DIVISOR,75,
  116175/OUTER_SONG_DATA_DIVISOR,4773,
  116413/OUTER_SONG_DATA_DIVISOR,0,
  116652/OUTER_SONG_DATA_DIVISOR,0,
  116892/OUTER_SONG_DATA_DIVISOR,2580,
  117133/OUTER_SONG_DATA_DIVISOR,56,
  117212/OUTER_SONG_DATA_DIVISOR,0,
  117372/OUTER_SONG_DATA_DIVISOR,3483,
  117372/OUTER_SONG_DATA_DIVISOR,56,
  117373/OUTER_SONG_DATA_DIVISOR,0,
  117373/OUTER_SONG_DATA_DIVISOR,56,
  117613/OUTER_SONG_DATA_DIVISOR,0,
  117852/OUTER_SONG_DATA_DIVISOR,5547,
  118092/OUTER_SONG_DATA_DIVISOR,64,
  118093/OUTER_SONG_DATA_DIVISOR,56,
  118333/OUTER_SONG_DATA_DIVISOR,0,
  118572/OUTER_SONG_DATA_DIVISOR,0,
  118575/OUTER_SONG_DATA_DIVISOR,7740,
  118575/OUTER_SONG_DATA_DIVISOR,56,
  118813/OUTER_SONG_DATA_DIVISOR,0,
  118813/OUTER_SONG_DATA_DIVISOR,56,
  119053/OUTER_SONG_DATA_DIVISOR,0,
  119292/OUTER_SONG_DATA_DIVISOR,8901,
  119533/OUTER_SONG_DATA_DIVISOR,56,
  120012/OUTER_SONG_DATA_DIVISOR,77,
  120013/OUTER_SONG_DATA_DIVISOR,0,
  120252/OUTER_SONG_DATA_DIVISOR,10191,
  120253/OUTER_SONG_DATA_DIVISOR,56,
  120492/OUTER_SONG_DATA_DIVISOR,0,
  120733/OUTER_SONG_DATA_DIVISOR,0,
  120973/OUTER_SONG_DATA_DIVISOR,56,
  121052/OUTER_SONG_DATA_DIVISOR,0,
  121212/OUTER_SONG_DATA_DIVISOR,11868,
  121212/OUTER_SONG_DATA_DIVISOR,56,
  121453/OUTER_SONG_DATA_DIVISOR,0,
  121693/OUTER_SONG_DATA_DIVISOR,56,
  121932/OUTER_SONG_DATA_DIVISOR,67,
  121935/OUTER_SONG_DATA_DIVISOR,9719,
  122173/OUTER_SONG_DATA_DIVISOR,0,
  122412/OUTER_SONG_DATA_DIVISOR,0,
  122413/OUTER_SONG_DATA_DIVISOR,56,
  122652/OUTER_SONG_DATA_DIVISOR,7775,
  122759/OUTER_SONG_DATA_DIVISOR,7926,
  122893/OUTER_SONG_DATA_DIVISOR,0,
  122969/OUTER_SONG_DATA_DIVISOR,7662,
  123132/OUTER_SONG_DATA_DIVISOR,5276,
  123133/OUTER_SONG_DATA_DIVISOR,56,
  123173/OUTER_SONG_DATA_DIVISOR,7134,
  123352/OUTER_SONG_DATA_DIVISOR,6605,
  123372/OUTER_SONG_DATA_DIVISOR,4998,
  123492/OUTER_SONG_DATA_DIVISOR,6077,
  123612/OUTER_SONG_DATA_DIVISOR,3610,
  123613/OUTER_SONG_DATA_DIVISOR,0,
  123623/OUTER_SONG_DATA_DIVISOR,5548,
  123761/OUTER_SONG_DATA_DIVISOR,5020,
  123852/OUTER_SONG_DATA_DIVISOR,71,
  123855/OUTER_SONG_DATA_DIVISOR,3332,
  123855/OUTER_SONG_DATA_DIVISOR,56,
  123906/OUTER_SONG_DATA_DIVISOR,4491,
  124031/OUTER_SONG_DATA_DIVISOR,3963,
  124133/OUTER_SONG_DATA_DIVISOR,3434,
  124229/OUTER_SONG_DATA_DIVISOR,2906,
  124315/OUTER_SONG_DATA_DIVISOR,2378,
  124332/OUTER_SONG_DATA_DIVISOR,0,
  124335/OUTER_SONG_DATA_DIVISOR,1111,
  124335/OUTER_SONG_DATA_DIVISOR,0,
  124335/OUTER_SONG_DATA_DIVISOR,56,
  124433/OUTER_SONG_DATA_DIVISOR,1849,
  124537/OUTER_SONG_DATA_DIVISOR,1321,
  124574/OUTER_SONG_DATA_DIVISOR,56,
  124574/OUTER_SONG_DATA_DIVISOR,52,
  124574/OUTER_SONG_DATA_DIVISOR,56,
  124575/OUTER_SONG_DATA_DIVISOR,0,
  124575/OUTER_SONG_DATA_DIVISOR,56,
  124615/OUTER_SONG_DATA_DIVISOR,792,
  124654/OUTER_SONG_DATA_DIVISOR,264,
  124694/OUTER_SONG_DATA_DIVISOR,0,
  124814/OUTER_SONG_DATA_DIVISOR,278,
  124815/OUTER_SONG_DATA_DIVISOR,0,
  124894/OUTER_SONG_DATA_DIVISOR,0,
  124934/OUTER_SONG_DATA_DIVISOR,51,
  125054/OUTER_SONG_DATA_DIVISOR,0,
  125054/OUTER_SONG_DATA_DIVISOR,8192,
  125414/OUTER_SONG_DATA_DIVISOR,0,
  125654/OUTER_SONG_DATA_DIVISOR,55,
  126374/OUTER_SONG_DATA_DIVISOR,0,
  126854/OUTER_SONG_DATA_DIVISOR,73,
  127222/OUTER_SONG_DATA_DIVISOR,0,
  127574/OUTER_SONG_DATA_DIVISOR,65,
  128303/OUTER_SONG_DATA_DIVISOR,0,
  128774/OUTER_SONG_DATA_DIVISOR,80,
  129215/OUTER_SONG_DATA_DIVISOR,0,
  129494/OUTER_SONG_DATA_DIVISOR,72,
  130277/OUTER_SONG_DATA_DIVISOR,0,
  130694/OUTER_SONG_DATA_DIVISOR,81,
  131163/OUTER_SONG_DATA_DIVISOR,0,
  131414/OUTER_SONG_DATA_DIVISOR,73,
  131899/OUTER_SONG_DATA_DIVISOR,0,
  131943/OUTER_SONG_DATA_DIVISOR,0,
  132254/OUTER_SONG_DATA_DIVISOR,63,
  132254/OUTER_SONG_DATA_DIVISOR,52,
  132292/OUTER_SONG_DATA_DIVISOR,0,
  132614/OUTER_SONG_DATA_DIVISOR,82,
  133050/OUTER_SONG_DATA_DIVISOR,0,
  133334/OUTER_SONG_DATA_DIVISOR,80,
  134274/OUTER_SONG_DATA_DIVISOR,0,
  134536/OUTER_SONG_DATA_DIVISOR,81,
  135028/OUTER_SONG_DATA_DIVISOR,0,
  135247/OUTER_SONG_DATA_DIVISOR,82,
  135767/OUTER_SONG_DATA_DIVISOR,0,
  135881/OUTER_SONG_DATA_DIVISOR,0,
  136090/OUTER_SONG_DATA_DIVISOR,0,
  136094/OUTER_SONG_DATA_DIVISOR,52,
  136094/OUTER_SONG_DATA_DIVISOR,25,
  136454/OUTER_SONG_DATA_DIVISOR,82,
  136933/OUTER_SONG_DATA_DIVISOR,0,
  137174/OUTER_SONG_DATA_DIVISOR,82,
  138041/OUTER_SONG_DATA_DIVISOR,0,
  138374/OUTER_SONG_DATA_DIVISOR,83,
  138844/OUTER_SONG_DATA_DIVISOR,0,
  139094/OUTER_SONG_DATA_DIVISOR,83,
  139710/OUTER_SONG_DATA_DIVISOR,0,
  139719/OUTER_SONG_DATA_DIVISOR,0,
  139927/OUTER_SONG_DATA_DIVISOR,0,
  139934/OUTER_SONG_DATA_DIVISOR,14,
  139934/OUTER_SONG_DATA_DIVISOR,56,
  140307/OUTER_SONG_DATA_DIVISOR,83,
  140745/OUTER_SONG_DATA_DIVISOR,0,
  141014/OUTER_SONG_DATA_DIVISOR,82,
  141928/OUTER_SONG_DATA_DIVISOR,0,
  142214/OUTER_SONG_DATA_DIVISOR,81,
  142706/OUTER_SONG_DATA_DIVISOR,0,
  142934/OUTER_SONG_DATA_DIVISOR,80,
  143847/OUTER_SONG_DATA_DIVISOR,0,
  144132/OUTER_SONG_DATA_DIVISOR,66,
  144615/OUTER_SONG_DATA_DIVISOR,0,
  144854/OUTER_SONG_DATA_DIVISOR,73,
  145792/OUTER_SONG_DATA_DIVISOR,0,
  146046/OUTER_SONG_DATA_DIVISOR,82,
  146500/OUTER_SONG_DATA_DIVISOR,0,
  146726/OUTER_SONG_DATA_DIVISOR,83,
  147232/OUTER_SONG_DATA_DIVISOR,0,
  147276/OUTER_SONG_DATA_DIVISOR,0,
  147324/OUTER_SONG_DATA_DIVISOR,1,
  147614/OUTER_SONG_DATA_DIVISOR,45,
  147614/OUTER_SONG_DATA_DIVISOR,56,
  147773/OUTER_SONG_DATA_DIVISOR,0,
  147974/OUTER_SONG_DATA_DIVISOR,103,
  148357/OUTER_SONG_DATA_DIVISOR,0,
  148694/OUTER_SONG_DATA_DIVISOR,83,
  149705/OUTER_SONG_DATA_DIVISOR,0,
  149894/OUTER_SONG_DATA_DIVISOR,90,
  150356/OUTER_SONG_DATA_DIVISOR,0,
  150614/OUTER_SONG_DATA_DIVISOR,82,
  151124/OUTER_SONG_DATA_DIVISOR,0,
  151166/OUTER_SONG_DATA_DIVISOR,25,
  151257/OUTER_SONG_DATA_DIVISOR,0,
  151454/OUTER_SONG_DATA_DIVISOR,55,
  151522/OUTER_SONG_DATA_DIVISOR,0,
  151694/OUTER_SONG_DATA_DIVISOR,62,
  151814/OUTER_SONG_DATA_DIVISOR,83,
  152268/OUTER_SONG_DATA_DIVISOR,0,
  152534/OUTER_SONG_DATA_DIVISOR,73,
  153092/OUTER_SONG_DATA_DIVISOR,8,
  153288/OUTER_SONG_DATA_DIVISOR,0,
  153433/OUTER_SONG_DATA_DIVISOR,0,
  153734/OUTER_SONG_DATA_DIVISOR,90,
  154186/OUTER_SONG_DATA_DIVISOR,0,
  154454/OUTER_SONG_DATA_DIVISOR,82,
  154928/OUTER_SONG_DATA_DIVISOR,0,
  154961/OUTER_SONG_DATA_DIVISOR,0,
  155294/OUTER_SONG_DATA_DIVISOR,24,
  155294/OUTER_SONG_DATA_DIVISOR,55,
  155368/OUTER_SONG_DATA_DIVISOR,0,
  155654/OUTER_SONG_DATA_DIVISOR,83,
  156118/OUTER_SONG_DATA_DIVISOR,0,
  156374/OUTER_SONG_DATA_DIVISOR,73,
  157259/OUTER_SONG_DATA_DIVISOR,0,
  157574/OUTER_SONG_DATA_DIVISOR,90,
  157958/OUTER_SONG_DATA_DIVISOR,0,
  158294/OUTER_SONG_DATA_DIVISOR,90,
  159189/OUTER_SONG_DATA_DIVISOR,0,
  159374/OUTER_SONG_DATA_DIVISOR,0,
  159374/OUTER_SONG_DATA_DIVISOR,90,
  159494/OUTER_SONG_DATA_DIVISOR,90,
  159923/OUTER_SONG_DATA_DIVISOR,0,
  160214/OUTER_SONG_DATA_DIVISOR,90,
  161102/OUTER_SONG_DATA_DIVISOR,0,
  161414/OUTER_SONG_DATA_DIVISOR,83,
  161853/OUTER_SONG_DATA_DIVISOR,0,
  162134/OUTER_SONG_DATA_DIVISOR,72,
  162458/OUTER_SONG_DATA_DIVISOR,0,
  162520/OUTER_SONG_DATA_DIVISOR,0,
  162530/OUTER_SONG_DATA_DIVISOR,0,
  163165/OUTER_SONG_DATA_DIVISOR,0,
  163334/OUTER_SONG_DATA_DIVISOR,90,
  163734/OUTER_SONG_DATA_DIVISOR,0,
  164054/OUTER_SONG_DATA_DIVISOR,90,
  164858/OUTER_SONG_DATA_DIVISOR,0,
  165254/OUTER_SONG_DATA_DIVISOR,90,
  165697/OUTER_SONG_DATA_DIVISOR,0,
  165974/OUTER_SONG_DATA_DIVISOR,84,
  166886/OUTER_SONG_DATA_DIVISOR,0,
  167111/OUTER_SONG_DATA_DIVISOR,0,
  167174/OUTER_SONG_DATA_DIVISOR,103,
  169045/OUTER_SONG_DATA_DIVISOR,0,
  169689/OUTER_SONG_DATA_DIVISOR,82,
  169694/OUTER_SONG_DATA_DIVISOR,4998,
  169699/OUTER_SONG_DATA_DIVISOR,65,
  169701/OUTER_SONG_DATA_DIVISOR,66,
  169703/OUTER_SONG_DATA_DIVISOR,72,
  172814/OUTER_SONG_DATA_DIVISOR,6109,
  177614/OUTER_SONG_DATA_DIVISOR,8330,
  180494/OUTER_SONG_DATA_DIVISOR,9441,
  180959/OUTER_SONG_DATA_DIVISOR,63,
  183329/OUTER_SONG_DATA_DIVISOR,1,
  185241/OUTER_SONG_DATA_DIVISOR,0,
  185497/OUTER_SONG_DATA_DIVISOR,72,
  185851/OUTER_SONG_DATA_DIVISOR,24,
  185940/OUTER_SONG_DATA_DIVISOR,1,
  186014/OUTER_SONG_DATA_DIVISOR,0,
  186308/OUTER_SONG_DATA_DIVISOR,0,
  190094/OUTER_SONG_DATA_DIVISOR,0,
  190094/OUTER_SONG_DATA_DIVISOR,0,
  190094/OUTER_SONG_DATA_DIVISOR,0,
  190274/OUTER_SONG_DATA_DIVISOR,0,
  190634/OUTER_SONG_DATA_DIVISOR,0,
  190994/OUTER_SONG_DATA_DIVISOR,0,
  199694/OUTER_SONG_DATA_DIVISOR,95,
  203534/OUTER_SONG_DATA_DIVISOR,95,
  207374/OUTER_SONG_DATA_DIVISOR,95,
  216014/OUTER_SONG_DATA_DIVISOR,0,
  216014/OUTER_SONG_DATA_DIVISOR,0,
  216017/OUTER_SONG_DATA_DIVISOR,16383,
  216017/OUTER_SONG_DATA_DIVISOR,127,
  216017/OUTER_SONG_DATA_DIVISOR,127,
  216017/OUTER_SONG_DATA_DIVISOR,127,
  216017/OUTER_SONG_DATA_DIVISOR,127,
  216071/OUTER_SONG_DATA_DIVISOR,0,
  216494/OUTER_SONG_DATA_DIVISOR,127,
  216734/OUTER_SONG_DATA_DIVISOR,127,
  216854/OUTER_SONG_DATA_DIVISOR,0,
  216974/OUTER_SONG_DATA_DIVISOR,0,
  217934/OUTER_SONG_DATA_DIVISOR,127,
  218414/OUTER_SONG_DATA_DIVISOR,127,
  219614/OUTER_SONG_DATA_DIVISOR,0,
  220574/OUTER_SONG_DATA_DIVISOR,127,
  220814/OUTER_SONG_DATA_DIVISOR,0,
  221774/OUTER_SONG_DATA_DIVISOR,0,
  224174/OUTER_SONG_DATA_DIVISOR,0,
  224654/OUTER_SONG_DATA_DIVISOR,0,
  226334/OUTER_SONG_DATA_DIVISOR,0,
  227534/OUTER_SONG_DATA_DIVISOR,0,
  228499/OUTER_SONG_DATA_DIVISOR,54,
  228499/OUTER_SONG_DATA_DIVISOR,54,
  237134/OUTER_SONG_DATA_DIVISOR,0,
  237134/OUTER_SONG_DATA_DIVISOR,0,
  239815/OUTER_SONG_DATA_DIVISOR,55,
  239815/OUTER_SONG_DATA_DIVISOR,55,
  248654/OUTER_SONG_DATA_DIVISOR,0,
  248783/OUTER_SONG_DATA_DIVISOR,0,
  251440/OUTER_SONG_DATA_DIVISOR,66,
  251440/OUTER_SONG_DATA_DIVISOR,66,
  259929/OUTER_SONG_DATA_DIVISOR,0,
  260174/OUTER_SONG_DATA_DIVISOR,0,
  262571/OUTER_SONG_DATA_DIVISOR,63,
  262571/OUTER_SONG_DATA_DIVISOR,63,
  280334/OUTER_SONG_DATA_DIVISOR,0,
  284133/OUTER_SONG_DATA_DIVISOR,0
};

static int hh_channel_params[k_num_synth_params]=
{
  19660,
  65535,
  31060,
  34815,
  24575,
  35156,
  19660,
  65535,
  36522,
  24916,
  39935,
  40618,
  26214,
  32822,
  32767,
  65535,
  32767,
  0,
  0,
  32793,
  32767,
  49151,
  57343,
  33450,
  32767,
  65535,
  32767,
  49151,
  8191,
  27647,
  32767,
  65535,
  32767,
  49151,
  16383,
  18773,
  32767,
  0,
  0,
  0,
  0,
  13107,
  35156,
  0,
  7167,
  65535,
  32767,
  32767,
  39321,
  44372,
  65535,
  0,
  43007,
  24916,
  36522,
  65,
  6553,
  29695,
  13107,
  65535,
  6553,
  0,
  0,
  0,
  0,
  0,
  4778,
  26964,
  12629,
  0,
  32767,
  26214,
  0,
  0,
  0,
  65535,
  0,
  65535,
  65535
};

static int hhdelay_channel_params[k_num_synth_params]=
{
  19660,
  65535,
  31060,
  34815,
  24575,
  35155,
  19660,
  65535,
  36522,
  24916,
  39935,
  40618,
  26214,
  32821,
  32767,
  65535,
  32767,
  0,
  0,
  32792,
  32767,
  49151,
  57343,
  33450,
  32767,
  65535,
  32767,
  49151,
  8191,
  27647,
  32767,
  65535,
  32767,
  49151,
  16383,
  18773,
  32767,
  0,
  0,
  0,
  0,
  13107,
  35155,
  0,
  7167,
  65535,
  32767,
  32767,
  39321,
  44371,
  65535,
  0,
  43007,
  24916,
  36522,
  64,
  6553,
  29695,
  13107,
  46761,
  6553,
  0,
  0,
  0,
  0,
  0,
  4777,
  26964,
  12628,
  0,
  40958,
  39321,
  11263,
  8191,
  20821,
  65535,
  0,
  65535,
  65535
};

static int bd2_channel_params[k_num_synth_params]=
{
  13107,
  9433,
  32767,
  23210,
  38911,
  0,
  26214,
  32985,
  32767,
  21844,
  32767,
  0,
  0,
  9557,
  32767,
  63145,
  32767,
  0,
  0,
  32780,
  32767,
  49151,
  65535,
  0,
  0,
  32793,
  32767,
  49151,
  65535,
  0,
  0,
  32806,
  32767,
  49151,
  65535,
  0,
  46761,
  0,
  4095,
  0,
  0,
  0,
  5119,
  0,
  5460,
  41642,
  32439,
  34506,
  65535,
  2046,
  340,
  8191,
  48468,
  28166,
  32767,
  65,
  10580,
  32426,
  10035,
  53588,
  7236,
  0,
  0,
  0,
  0,
  131,
  12970,
  17748,
  1023,
  0,
  32767,
  0,
  2729,
  8191,
  20479,
  65535,
  0,
  65535,
  65535
};

static int sd_channel_params[k_num_synth_params]=
{
  58981,
  17626,
  32767,
  19250,
  32767,
  0,
  26214,
  32985,
  32767,
  50857,
  32767,
  0,
  32767,
  32426,
  32767,
  17407,
  32767,
  0,
  32767,
  49833,
  32767,
  49151,
  8191,
  65535,
  0,
  32793,
  32767,
  49151,
  8191,
  0,
  0,
  32806,
  32767,
  49151,
  16383,
  0,
  65535,
  0,
  6485,
  0,
  0,
  0,
  5119,
  9215,
  42324,
  32767,
  38228,
  40618,
  13107,
  9898,
  0,
  0,
  32767,
  32767,
  32767,
  65,
  17817,
  3413,
  10376,
  21708,
  6553,
  0,
  0,
  0,
  0,
  0,
  10444,
  53247,
  14062,
  0,
  26282,
  26214,
  6143,
  4095,
  29012,
  65535,
  0,
  54953,
  65535
};

static int fx_channel_params[k_num_synth_params]=
{
  32767,
  32985,
  32767,
  14472,
  4437,
  44031,
  32767,
  32985,
  35156,
  6143,
  61439,
  0,
  32767,
  32822,
  29695,
  23892,
  57001,
  0,
  0,
  32780,
  32767,
  49151,
  57343,
  26282,
  0,
  32793,
  32767,
  49151,
  32767,
  11946,
  0,
  32806,
  32767,
  49151,
  40959,
  1365,
  65535,
  27306,
  6826,
  0,
  0,
  0,
  60073,
  0,
  51540,
  32767,
  32767,
  32767,
  39321,
  10581,
  65535,
  0,
  32767,
  32767,
  32767,
  0,
  6553,
  32767,
  13107,
  45601,
  14062,
  0,
  0,
  0,
  0,
  32215,
  5461,
  0,
  0,
  0,
  32767,
  26214,
  4437,
  16383,
  51199,
  65535,
  0,
  65535,
  65535
};

static int pad_channel_params[k_num_synth_params]=
{
  6553,
  32985,
  27305,
  45873,
  32767,
  0,
  19660,
  32985,
  36863,
  39251,
  27988,
  54271,
  32767,
  25994,
  32767,
  21503,
  60073,
  0,
  0,
  0,
  32767,
  49151,
  32767,
  0,
  0,
  3766,
  32767,
  49151,
  49151,
  4437,
  58981,
  19455,
  17065,
  49151,
  57343,
  17749,
  32767,
  0,
  0,
  0,
  0,
  0,
  27647,
  0,
  0,
  32767,
  32767,
  35498,
  26214,
  16042,
  14130,
  11946,
  32767,
  32767,
  35498,
  4843,
  22254,
  32767,
  65535,
  33654,
  15427,
  0,
  0,
  0,
  0,
  23681,
  7371,
  60292,
  63896,
  0,
  35839,
  26214,
  16383,
  7167,
  40275,
  40959,
  6485,
  60755,
  54953
};

static int jyrina_channel_params[k_num_synth_params]=
{
  58981,
  25940,
  21503,
  65535,
  29012,
  43690,
  0,
  24916,
  37887,
  65535,
  29695,
  38911,
  32767,
  38624,
  32767,
  13311,
  32767,
  0,
  26214,
  41642,
  32767,
  49151,
  57343,
  65535,
  32767,
  33450,
  32767,
  49151,
  0,
  65535,
  32767,
  33108,
  32767,
  49151,
  8191,
  62463,
  44372,
  0,
  64511,
  6826,
  56660,
  26214,
  3071,
  1023,
  0,
  32767,
  32767,
  32767,
  39321,
  2730,
  61097,
  0,
  32767,
  32767,
  32767,
  65,
  6553,
  32767,
  13107,
  52428,
  11332,
  65535,
  0,
  0,
  0,
  5802,
  6143,
  65535,
  22527,
  0,
  32767,
  0,
  0,
  0,
  0,
  65535,
  0,
  65535,
  65535
};

static int jyrinadelay_channel_params[k_num_synth_params]=
{
  58981,
  25940,
  21503,
  65535,
  29012,
  43690,
  0,
  24916,
  37887,
  65535,
  29695,
  38911,
  32767,
  38624,
  32767,
  13311,
  32767,
  0,
  26214,
  41642,
  32767,
  49151,
  57343,
  65535,
  32767,
  33450,
  32767,
  49151,
  0,
  65535,
  32767,
  33108,
  32767,
  49151,
  8191,
  62463,
  44372,
  0,
  64511,
  6826,
  56660,
  26214,
  3071,
  1023,
  0,
  32767,
  32767,
  32767,
  39321,
  2730,
  61097,
  0,
  32767,
  32767,
  32767,
  65,
  6553,
  32767,
  13107,
  52428,
  11332,
  65535,
  0,
  0,
  0,
  5802,
  6143,
  65535,
  22527,
  0,
  32767,
  0,
  13311,
  6826,
  47444,
  28330,
  2730,
  65535,
  65535
};

static int sustbass_channel_params[k_num_synth_params]=
{
  6553,
  32985,
  29489,
  34815,
  0,
  0,
  6553,
  32985,
  36044,
  33791,
  0,
  0,
  6553,
  25940,
  32767,
  65535,
  0,
  0,
  0,
  32780,
  0,
  49151,
  0,
  0,
  0,
  32793,
  37887,
  49151,
  40959,
  341,
  0,
  0,
  0,
  32767,
  49151,
  3412,
  32767,
  0,
  0,
  0,
  0,
  0,
  10238,
  22185,
  56319,
  32767,
  32767,
  32767,
  39321,
  14335,
  62121,
  25258,
  32767,
  32767,
  32767,
  0,
  0,
  62462,
  65535,
  54202,
  22254,
  65535,
  0,
  0,
  0,
  11053,
  3276,
  57220,
  63896,
  0,
  32767,
  26214,
  5119,
  1706,
  40618,
  65535,
  17749,
  65535,
  65535
};

static int bass_channel_params[k_num_synth_params]=
{
  6553,
  32644,
  36863,
  33928,
  32767,
  0,
  6553,
  32985,
  30036,
  33450,
  32767,
  0,
  13107,
  25995,
  33450,
  65535,
  17407,
  0,
  58981,
  5119,
  16383,
  49151,
  49151,
  2389,
  0,
  32793,
  32767,
  49151,
  65535,
  0,
  0,
  32806,
  32767,
  49151,
  65535,
  0,
  32767,
  0,
  0,
  0,
  0,
  0,
  8874,
  6143,
  0,
  44713,
  34815,
  37887,
  52428,
  11946,
  14335,
  0,
  34474,
  32767,
  32767,
  65,
  6212,
  9898,
  8874,
  57889,
  6553,
  65535,
  0,
  0,
  0,
  131,
  3276,
  60292,
  36249,
  0,
  32767,
  0,
  0,
  0,
  0,
  65535,
  0,
  65535,
  26282
};

