#version 110
uniform float range;
uniform vec2 resolution;
uniform sampler2D texture;
uniform sampler2D diffuse;
uniform sampler2D normals;
uniform float ambient;
uniform float strength;
void main()
{
     vec2 coord = gl_TexCoord[0].xy;
     vec4 skytexture = texture2D(texture, coord);
     float intensity = 1.0 - min(skytexture.b, skytexture.a) * 256.0 / range;
     //if (intensity < 0)
     //    intensity = 0;
         intensity *= strength;
         //intensity += 2.6;
         //intensity = clamp(intensity, 0, 1);
         intensity = max(intensity, 0.0);
         intensity += ambient;
     vec2 screencoord = gl_FragCoord.xy;
          screencoord.y = resolution.y - screencoord.y;
          screencoord /= resolution;
     vec4 diffusecolor = texture2D(diffuse, screencoord);
     vec4 normalscolor = texture2D(normals, screencoord);
     vec3 normalsvector = 1.0 - 2.0 * normalscolor.xyz;
          normalsvector *= vec3(1,-1,1);
          normalsvector.z= 1.0 - cos(normalsvector.x) - cos(normalsvector.y);
          normalsvector  = normalize(normalsvector);
     vec3 lightvector = normalize(vec3(0,1,-.5));
     float normalspass = max(dot(normalsvector, lightvector), 0.0);
     float lightpass = normalspass * intensity;
     vec4 colorpass = vec4(diffusecolor.rgb * lightpass, diffusecolor.a);
     gl_FragColor = colorpass;
}