var scene4 = new Scene();
scene4.cameraStart = {x: 0, y: 0, z: 1000}
scene4.init = function() {
    if (this.inited)
        return

    this.group = new THREE.Object3D;
    this.material = new THREE.MeshLambertMaterial( { color: 0x666666, emissive: 0xff0000, ambient: 0x000000, shading: THREE.SmoothShading} );
    this.material2 = new THREE.MeshLambertMaterial( { color: 0x666666, emissive: 0xff0000, ambient: 0x000000, shading: THREE.SmoothShading} );
    this.sphereGeometry = new THREE.SphereGeometry(1,16,16);
    this.cubeGeometry = new THREE.CubeGeometry(2,2,2);

    for (var i = 0; i < 500; i++) {
      var cube;
      if (i % 2 == 0) {
        cube = new THREE.Mesh(this.cubeGeometry, this.material);
      } else {
        cube = new THREE.Mesh(this.sphereGeometry, this.material2);
      }
      cube.position.z = (i + 10) * 2;
      this.group.add(cube);
    };
    this.scene.add(this.group);

    this.ambientLight = new THREE.AmbientLight(0x202020);
    this.scene.add(this.ambientLight);

    this.directionalLight = new THREE.DirectionalLight(0xffffff, 1);
    this.directionalLight.position.set(1,1,1).normalize();
    this.scene.add(this.directionalLight);

    this.addedTor = false;
    this.addedHkan = false;

    this.inited = true;
};

scene4.addCredzTor = function() {
    if (this.addedTor == false) {
        this.tor = new THREE.Sprite(scene1.createSpriteMat('Code & GFX:', '210'));
        this.tor.scale.set( 10, 10, 1 ); // CHANGED
        this.tor.position.set(-25, 0, 0);
        this.scene.add(this.tor);


        this.tor2 = new THREE.Sprite(scene1.createSpriteMat('_tor', '500'));
        this.tor2.scale.set( 10, 10, 1 ); // CHANGED
        this.tor2.position.set(-25, -3, 0);
        this.scene.add(this.tor2);
        this.addedTor = true;
    };

};

scene4.addCredzHkan = function() {
    if (this.addedHkan == false) {
        this.scene.remove(this.tor);
        this.scene.remove(this.tor2);
        this.hkan = new THREE.Sprite(scene1.createSpriteMat('Music:', '210'));
        this.hkan.scale.set( 10, 10, 1 ); // CHANGED
        this.hkan.position.set(-25, 0, 0);
        this.scene.add(this.hkan);

        this.hkan2 = new THREE.Sprite(scene1.createSpriteMat('djhkan', '500'));
        this.hkan2.scale.set( 10, 10, 1 ); // CHANGED
        this.hkan2.position.set(-25, -3, 0);
        this.scene.add(this.hkan2);
        this.addedHkan = true;
    };

};

scene4.render = function(row) {
    effects.RGBShift.uniforms[ 'amount' ].value = 0.0015;
    for (var i = 0; i < this.group.children.length; i++) {
      var cube = this.group.children[i];
      cube.position.y = Math.sin(cube.position.z + (row / 5)) * 20;
      cube.rotation.x += 0.01;
      cube.rotation.y += 0.01;
      cube.scale.x = Math.cos(row / 10) * 2;
      cube.scale.y = Math.cos(row / 10) * 2;
      cube.scale.z = Math.cos(row / 10) * 2;
    };
    // this.camera.rotation.y = THREE.Math.degToRad(Math.sin(row / 100) * 20);
    // this.camera.position.x = Math.sin(row / 10) * 5;
    // this.camera.position.y = Math.sin(row / 10) * 5;
    // this.camera.position.z -= 0.3;
    this.camera.position.x = this.tracks.cX.getValue(row);
    this.camera.position.y = this.tracks.cY.getValue(row);
    this.camera.position.z = this.tracks.cZ.getValue(row);

    this.camera.rotation.y = THREE.Math.degToRad(this.tracks.crY.getValue(row));
    this.camera.rotation.x = THREE.Math.degToRad(this.tracks.crX.getValue(row));
    this.camera.rotation.z = THREE.Math.degToRad(this.tracks.crZ.getValue(row));

    this.material.emissive.setHSL( 0.5, 1, 1 * ( 0.5 + 0.5 * Math.cos( 35 * row / 20 ) ) );
    this.material2.emissive.setHSL( 0.06, 1, 1 * ( 0.5 + 0.5 * Math.cos( 35 * row / 40 ) ) );
    /*group.traverse(function(cube) {
    });*/

    this.directionalLight.position.z = camera.position.z + 100;
    this.directionalLight.position.x = Math.sin(row / 100) * 10;
    
    if (row > 1444) {
        this.addCredzTor();
        this.tor.position.z = this.camera.position.z - 30;
        this.tor2.position.z = this.camera.position.z - 30;
    }
    if (row > 1504) {
        this.addCredzHkan();
        this.hkan.position.z = this.camera.position.z - 30;
        this.hkan2.position.z = this.camera.position.z - 30;
    }

    if (row > 1564 && this.addedHkan) {
        this.scene.remove(this.hkan);
        this.scene.remove(this.hkan2);
    }
};
