// var fontHelper = function(size) {
//     console.log(window.innerWidth / size);
// }
// fontHelper(60);


var camera = new THREE.PerspectiveCamera( 50, window.innerWidth / window.innerHeight, 0.1, 1000 );
var renderer = new THREE.WebGLRenderer({ alpha: true });
renderer.setSize( window.innerWidth, window.innerHeight );
document.body.appendChild( renderer.domElement );
renderer.setClearColor(0x202020);

// JsRocket tracks
var tracks = {}

var effects = {
    FXAA: new THREE.ShaderPass( THREE.FXAAShader ),
    RGBShift: new THREE.ShaderPass(THREE.RGBShiftShader),
    Vignette: new THREE.ShaderPass(THREE.VignetteShader),
    Film: new THREE.ShaderPass(THREE.FilmShader),
    Focus: new THREE.ShaderPass(THREE.FocusShader),
    BlinkShader: new THREE.ShaderPass(THREE.BlinkShader),
};
effects.FXAA.uniforms[ 'resolution' ].value = new THREE.Vector2(1 / window.innerWidth, 1 / window.innerHeight);
effects.Focus.uniforms[ 'screenWidth' ].value = window.innerWidth;
effects.Focus.uniforms[ 'screenHeight' ].value = window.innerHeight;

effects.RGBShift.uniforms[ 'amount' ].value = 0.0000;
effects.Film.uniforms['grayscale'].value = 0;
effects.Film.uniforms['nIntensity'].value = 0.2;

// Set up the scenemanager
var managerOptions = {
    camera: camera,
    renderer: renderer,
    startScene: scene1,
    effects: effects
};
var manager = new SceneManager(managerOptions);
manager.add(scene2);
manager.add(scene4);
manager.add(scene3);


var BPM = 127,
    ROWS_PER_BEAT = 8,
    ROW_RATE = BPM / 60 * ROWS_PER_BEAT;

var demoMode = true, //Set to true for preview
    syncDevice = new JSRocket.SyncDevice(),
    _row = 0,
    _previousIntRow,
    audio = new Audio();

prepareSync();

function prepareSync() {

    if (demoMode) {
        syncDevice.setConfig({'rocketXML':'rocket.rocket'});
        syncDevice.init("demo");
    } else {
        //syncDevice.setConfig({'socketURL':'ws://192.168.0.100:1338'});
        syncDevice.init();
    }

    syncDevice.on('ready', onSyncReady);
    syncDevice.on('update', onSyncUpdate);
    syncDevice.on('play', onPlay);
    syncDevice.on('pause', onPause);
}

function onSyncReady() {
    // Blinking
    tracks.blink = syncDevice.getTrack('blink');
    // Camera Pos
    tracks.cX = syncDevice.getTrack('cX');
    tracks.cY = syncDevice.getTrack('cY');
    tracks.cZ = syncDevice.getTrack('cZ');
    // Camera rotation
    tracks.crX = syncDevice.getTrack('crX');
    tracks.crY = syncDevice.getTrack('crY');
    tracks.crZ = syncDevice.getTrack('crZ');
    // Misc
    tracks.misc = syncDevice.getTrack('misc');

    manager.tracks = tracks;
    prepareAudio();
}

function prepareAudio() {
    audio.src = "assets/music_newest.ogg";
    audio.load();
    audio.preload = true;
    audio.addEventListener('canplay', onAudioReady);
    audio.volume = 1;
}

function onAudioReady() {
    if(demoMode) {
        console.log('WHAT');
        var load = document.getElementById('loading');
        load.style.display = 'none';
        var playBtn = document.createElement('button');
        playBtn.addEventListener('click', function(){
            document.body.style.cursor = "none"
            if (renderer.domElement.requestFullscreen) {
              renderer.domElement.requestFullscreen();
            } else if (renderer.domElement.msRequestFullscreen) {
              renderer.domElement.msRequestFullscreen();
            } else if (renderer.domElement.mozRequestFullScreen) {
              renderer.domElement.mozRequestFullScreen();
            } else if (renderer.domElement.webkitRequestFullscreen) {
              renderer.domElement.webkitRequestFullscreen();
            }
            onWindowResize();

            this.style.display = 'none';
            render();
            audio.play();
        });
        playBtn.textContent = 'Play!';
        document.body.appendChild(playBtn);

    } else {
        var load = document.getElementById('loading');
        load.style.display = 'none';
        audio.pause();
        audio.currentTime = _row / ROW_RATE;
    }
}

function onSyncUpdate(row) {

    if (!isNaN(row)) {
        _row = row;
    }
    render();
}

function onPlay() {

    audio.currentTime = _row / ROW_RATE;
    audio.play();
    render();
}

function onPause() {

    _row = audio.currentTime * ROW_RATE;
    window.cancelAnimationFrame(render, document);
    audio.pause();
}

function render() {

    if(audio.paused === false) {
        //otherwise we may jump into a point in the audio where there's
        //no timeframe, resulting in Rocket setting row 2 and we report
        //row 1 back - thus Rocket spasming out
        _row = audio.currentTime * ROW_RATE;

        // this informs Rocket where we are
        syncDevice.update(_row);
    }
    effects.Film.uniforms['time'].value = audio.currentTime;
    effects.BlinkShader.uniforms['amount'].value = tracks.blink.getValue(_row);

    // Scene switching
    if (_row >= 250) {
        manager.set(1);
    }
    if (_row >= 1080) {
        manager.set(2);
    }
    if (_row >= 1588) {
        manager.set(3);
    }
    if (_row >= 1839 && _row >= 1840) {
        audio.volume = tracks.misc.getValue(_row);
    }

    manager.render(_row);
    if((demoMode === true)  || (audio.paused === false))
        window.requestAnimationFrame(render, document);
    else
        window.cancelAnimationFrame(render, document);
}

window.addEventListener( 'resize', onWindowResize, false );

function onWindowResize(){
    effects.Focus.uniforms[ 'screenWidth' ].value = window.innerWidth;
    effects.Focus.uniforms[ 'screenHeight' ].value = window.innerHeight;
    effects.FXAA.uniforms[ 'resolution' ].value = new THREE.Vector2(1 / window.innerWidth, 1 / window.innerHeight);

    camera.aspect = window.innerWidth / window.innerHeight;
    camera.updateProjectionMatrix();

    renderer.setSize( window.innerWidth, window.innerHeight );
    manager.composer.setSize( window.innerWidth, window.innerHeight );
}