function Scene() {
    this.scene = new THREE.Scene();
    this.shown = false;
    this.inited = false;
}
Scene.prototype = {
    setFromManager: function(manager) {
        this.camera = manager.camera;
        this.effects = manager.effects;
        this.tracks = manager.tracks;
    }
};


function SceneManager(opts) {
    var self = this;
    this.camera = opts.camera;
    this.renderer = opts.renderer;
    this.startScene = opts.startScene;

    // JsRocket
    this.tracks = opts.tracks;

    // EffectComposer
    this.effects = opts.effects;
    this.composer = new THREE.EffectComposer(this.renderer);
    this.renderPass = new THREE.RenderPass(this.startScene.scene, this.camera);
    this.composer.addPass(this.renderPass);

    var effectKeys = Object.keys(this.effects);
    effectKeys.forEach(function(key){
        var last = effectKeys[effectKeys.length - 1];
        var effect = this.effects[key];
        // Render the last effect to screen
        if (key == last)
            effect.renderToScreen = true;

        self.composer.addPass(effect);
    });

    this.current = -1;
    this.scenes = [this.startScene];

    this.set(0);
    this.scenes[this.current].setFromManager(this);
    this.scenes[this.current].init();
}

SceneManager.prototype = {
    add: function(scene) {
        console.log('ADDING SCENE');
        scene.setFromManager(this);
        scene.init();
        this.scenes.push(scene);
    },
    render: function(row) {
        this.scenes[this.current].tracks = this.tracks;
        this.scenes[this.current].setFromManager(this);
        this.scenes[this.current].render(row);
        this.composer.render();
    },
    set: function(scene) {
        // Show scene if not current or already shown
        if (this.current !== scene && this.scenes[scene].shown == false) {
            console.log('switching scene to',scene);
            this.current = scene;
            this.renderPass.scene = this.scenes[this.current].scene;
            this.camera.position.x = this.scenes[this.current].cameraStart.x;
            this.camera.position.y = this.scenes[this.current].cameraStart.y;
            this.camera.position.z = this.scenes[this.current].cameraStart.z;
            this.scenes[this.current].shown = true;
        }
    }
}
